/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.bson.BsonDecoder;
import de.caluga.morphium.driver.bson.BsonEncoder;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32C;

public class OpMsg
extends WireProtocolMessage {
    public static final int OP_CODE = 2013;
    public static final int CHECKSUM_PRESENT = 1;
    public static final int MORE_TO_COME = 2;
    public static final int EXHAUST_ALLOWED = 65536;
    private Map<String, Object> firstDoc;
    private Map<String, List<Map<String, Object>>> documents;
    private int flags;

    public void addDoc(String seqId, Map<String, Object> o) {
        if (this.documents == null) {
            this.documents = new LinkedHashMap<String, List<Map<String, Object>>>();
        }
        this.documents.putIfAbsent(seqId, new ArrayList());
        this.documents.get(seqId).add(o);
    }

    public Map<String, Object> getFirstDoc() {
        return this.firstDoc;
    }

    public OpMsg setFirstDoc(Map<String, Object> o) {
        this.firstDoc = o;
        return this;
    }

    public int getFlags() {
        return this.flags;
    }

    public OpMsg setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    @Override
    public void parsePayload(byte[] bytes, int offset) throws IOException {
        this.flags = OpMsg.readInt(bytes, offset);
        int idx = offset + 4;
        int len = bytes.length;
        if ((this.getFlags() & 1) != 0) {
            len = bytes.length - 4;
        }
        while (idx < len) {
            byte section = bytes[idx];
            ++idx;
            if (section == 0) {
                Doc result = new Doc();
                int l = BsonDecoder.decodeDocumentIn(result, bytes, idx);
                this.firstDoc = result;
                idx += l;
                continue;
            }
            if (section == 1) {
                int size = OpMsg.readInt(bytes, idx);
                String seqId = OpMsg.readString(bytes, idx + 4);
                int strLen = OpMsg.strLen(bytes, idx + 4);
                int i = 0;
                while (4 + strLen + i < size) {
                    Doc doc = new Doc();
                    i += BsonDecoder.decodeDocumentIn(doc, bytes, idx + 4 + strLen + i);
                    this.addDoc(seqId, doc);
                }
                idx += 4 + strLen + i;
                continue;
            }
            throw new RuntimeException("wrong section ID " + section);
        }
        if ((this.getFlags() & 1) != 0) {
            int crc = OpMsg.readInt(bytes, idx);
            CRC32C c = new CRC32C();
            c.update(bytes, 0, bytes.length - 4);
            assert (crc == (int)c.getValue());
        }
    }

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(this.flags, out);
        out.write(0);
        byte[] d = BsonEncoder.encodeDocument(this.firstDoc);
        out.write(d);
        if (this.documents != null) {
            for (String seqId : this.documents.keySet()) {
                ByteArrayOutputStream sectionOut = new ByteArrayOutputStream();
                this.writeString(seqId, sectionOut);
                for (Map<String, Object> doc : this.documents.get(seqId)) {
                    sectionOut.write(BsonEncoder.encodeDocument(doc));
                }
                byte[] section = sectionOut.toByteArray();
                this.writeInt(section.length, out);
            }
        }
        byte[] ret = out.toByteArray();
        if ((this.getFlags() & 1) != 0) {
            CRC32C crc = new CRC32C();
            crc.update(ret);
            this.writeInt((int)crc.getValue(), out);
            ret = out.toByteArray();
        }
        return ret;
    }

    @Override
    public int getOpCode() {
        return WireProtocolMessage.OpCode.OP_MSG.opCode;
    }

    public boolean hasCursor() {
        return this.firstDoc != null && this.firstDoc.containsKey("cursor");
    }
}

