/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.GetMoreMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMongoConnectionCursor
extends MorphiumCursor {
    private final boolean multithreaddedAccess;
    private final MongoConnection connection;
    private Logger log = LoggerFactory.getLogger(SingleMongoConnectionCursor.class);
    private int internalIndex = 0;
    private int index = 0;

    public SingleMongoConnectionCursor(MongoConnection drv, int batchSize, boolean multithreaddedAccess, OpMsg reply) throws MorphiumDriverException {
        this.connection = drv;
        this.multithreaddedAccess = multithreaddedAccess;
        Long cursorId = null;
        Doc cursor = (Doc)reply.getFirstDoc().get("cursor");
        if (cursor == null) {
            throw new MorphiumDriverException("No cursor returned: " + reply.getFirstDoc().get("code") + "  Message: " + reply.getFirstDoc().get("errmsg"));
        }
        if (cursor.get("id") != null) {
            cursorId = (Long)cursor.get("id");
        }
        this.setCursorId(cursorId);
        String[] ns = ((String)cursor.get("ns")).split("\\.");
        this.setDb(ns[0]);
        if (ns.length > 1) {
            this.setCollection(ns[1]);
        }
        if (cursor.get("firstBatch") != null) {
            this.setBatch((List)cursor.get("firstBatch"));
        } else if (cursor.get("nextBatch") != null) {
            this.setBatch((List)cursor.get("nextBatch"));
        } else {
            this.log.warn("No result returned");
            this.setBatch(Collections.emptyList());
        }
        this.setBatchSize(batchSize);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return this;
    }

    @Override
    public int getCursor() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        if (this.getBatch() == null || this.getBatch().isEmpty()) {
            return false;
        }
        if (this.internalIndex < this.getBatch().size()) {
            return true;
        }
        if (this.getCursorId() != 0L) {
            try {
                this.getNextIteration();
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
            return this.getBatch() != null && !this.getBatch().isEmpty();
        }
        return false;
    }

    private void getNextIteration() throws MorphiumDriverException {
        List<Map<String, Object>> batch = this.nextIteration();
        this.internalIndex = 0;
        if (this.multithreaddedAccess && batch != null) {
            this.setBatch(Collections.synchronizedList(batch));
        } else {
            this.setBatch(batch);
        }
    }

    @Override
    public Map<String, Object> next() {
        if (this.getBatch() == null || this.getBatch().isEmpty()) {
            return null;
        }
        if (this.getBatch().size() <= this.internalIndex) {
            try {
                this.getNextIteration();
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
            if (this.getBatch() == null || this.getBatch().isEmpty()) {
                return null;
            }
        }
        ++this.index;
        return this.getBatch().get(this.internalIndex++);
    }

    @Override
    public void close() {
        try {
            this.getConnection().closeIteration(this);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int available() {
        return this.getBatch().size() - this.internalIndex;
    }

    @Override
    public MongoConnection getConnection() {
        return this.connection;
    }

    private List<Map<String, Object>> nextIteration() throws MorphiumDriverException {
        if (this.getCursorId() == 0L) {
            return null;
        }
        GetMoreMongoCommand more = ((GetMoreMongoCommand)((GetMoreMongoCommand)new GetMoreMongoCommand(this.connection).setCursorId(this.getCursorId()).setDb(this.getDb())).setColl(this.getCollection())).setBatchSize(this.getBatchSize());
        try {
            MorphiumCursor reply = more.execute();
            this.setCursorId(reply.getCursorId());
            return reply.getBatch();
        }
        catch (MorphiumDriverException e) {
            this.log.error("Error ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> getAll() throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        while (this.hasNext()) {
            ret.addAll(this.getBatch());
            this.internalIndex = this.getBatch().size();
        }
        return ret;
    }

    @Override
    public void ahead(int jump) throws MorphiumDriverException {
        this.internalIndex += jump;
        this.index += jump;
        while (this.getBatch() != null && this.internalIndex >= this.getBatch().size()) {
            int diff = this.internalIndex - this.getBatch().size();
            this.getNextIteration();
            this.internalIndex = diff;
        }
    }

    @Override
    public void back(int jump) throws MorphiumDriverException {
        this.internalIndex -= jump;
        this.index -= jump;
        if (this.internalIndex < 0) {
            throw new IllegalArgumentException("cannot jump back over batch boundaries!");
        }
    }
}

