/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.MorphiumDriverOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkCallHelper<T> {
    private final Logger logger = LoggerFactory.getLogger(NetworkCallHelper.class);

    public T doCall(MorphiumDriverOperation r, int maxRetry, int sleep) throws MorphiumDriverException {
        for (int i = 0; i < maxRetry; ++i) {
            try {
                return (T)r.execute();
            }
            catch (Exception e) {
                this.handleNetworkError(maxRetry, i, sleep, e);
                continue;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNetworkError(int max, int i, int sleep, Throwable e) throws MorphiumDriverException {
        this.logger.info("Handling network error..." + e.getClass().getName());
        if (!(e instanceof MorphiumDriverNetworkException)) {
            if (!(e instanceof MorphiumDriverException)) throw new MorphiumDriverException("internal error", e);
            throw (MorphiumDriverException)e;
        }
        if (i + 1 >= max) {
            this.logger.info("no retries left - re-throwing exception");
            throw new MorphiumDriverNetworkException("Network error error", e);
        }
        this.logger.warn("Retry because of network error: " + e.getMessage());
        try {
            Thread.sleep(sleep);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

