/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.bson.BsonEncoder;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.MorphiumTransactionContextImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DriverBase
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(DriverBase.class);
    private volatile AtomicInteger rqid = new AtomicInteger(1000);
    private int maxWait = 1000;
    private boolean keepAlive = true;
    private int soTimeout = 1000;
    private int maxBsonObjectSize;
    private int maxMessageSize = 0x1000000;
    private int maxWriteBatchSize = 1000;
    private ReadPreference defaultRP = ReadPreference.primary();
    private boolean replicaSet = false;
    private String replicaSetName = null;
    private int retriesOnNetworkError = 5;
    private int sleepBetweenRetries = 100;
    private boolean defaultJ = false;
    private int localThreshold = 0;
    private int heartbeatConnectionTimeout = 1000;
    private List<String> hostSeed;
    private int heartbeatSocketTimeout = 1000;
    private int heartbeatFrequency = 2000;
    private boolean useSSL = false;
    private int maxBlockingThreadsMultiplier = 5;
    private int defaultW = 1;
    private int connectionTimeout = 1000;
    private int maxConnectionIdleTime = 100000;
    private int maxConnectionLifetime = 600000;
    private int minConnectionsPerHost = 1;
    private int maxConnectionsPerHost = 100;
    private int defaultWriteTimeout = 10000;
    private boolean slaveOk = true;
    private int batchSize = 100;
    private boolean retryReads = false;
    private boolean retryWrites = true;
    private int readTimeout = 30000;
    private ThreadLocal<MorphiumTransactionContext> transactionContext = new ThreadLocal();
    private String authDb = null;
    private String user;
    private String password;

    @Override
    public void setConnectionUrl(String connectionUrl) throws MalformedURLException {
        URL u = new URL(connectionUrl);
        if (!u.getProtocol().equals("mongodb")) {
            throw new MalformedURLException("unsupported protocol: " + u.getProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listCollections(String db, String regex) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getPrimaryConnection(null);
        try {
            ListCollectionsCommand cmd = new ListCollectionsCommand(primaryConnection);
            ((ListCollectionsCommand)cmd.setDb(db)).setNameOnly(true);
            if (regex != null) {
                cmd.setFilter(Doc.of("name", Pattern.compile(regex)));
            }
            List<Map<String, Object>> lst = cmd.execute();
            ArrayList<String> colNames = new ArrayList<String>();
            for (Map<String, Object> doc : lst) {
                String name = doc.get("name").toString();
                colNames.add(name);
            }
            ArrayList<String> arrayList = colNames;
            return arrayList;
        }
        finally {
            primaryConnection.release();
        }
    }

    @Override
    public void setHostSeed(String ... hosts) {
        this.hostSeed = new ArrayList<String>();
        for (String h : hosts) {
            this.hostSeed.add(h);
        }
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public MorphiumDriver setRetriesOnNetworkError(int r) {
        this.retriesOnNetworkError = r;
        return this;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenRetries;
    }

    @Override
    public MorphiumDriver setSleepBetweenErrorRetries(int s) {
        this.sleepBetweenRetries = s;
        return this;
    }

    @Override
    public void setCredentials(String db, String login, String pwd) {
        this.authDb = db;
        this.user = login;
        this.password = pwd;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnectionsPerHost;
    }

    public String getAuthDb() {
        return this.authDb;
    }

    public DriverBase setAuthDb(String authDb) {
        this.authDb = authDb;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public DriverBase setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DriverBase setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public MorphiumDriver setMaxConnections(int maxConnections) {
        this.maxConnectionsPerHost = maxConnections;
        return this;
    }

    @Override
    public int getMinConnections() {
        return 1;
    }

    @Override
    public MorphiumDriver setMinConnections(int minConnections) {
        this.minConnectionsPerHost = minConnections;
        return this;
    }

    @Override
    public boolean isRetryReads() {
        return this.retryReads;
    }

    @Override
    public MorphiumDriver setRetryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    @Override
    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    @Override
    public MorphiumDriver setRetryWrites(boolean retryWrites) {
        this.retryWrites = retryWrites;
        return this;
    }

    public String getUuidRepresentation() {
        return BsonEncoder.UUIDRepresentation.STANDARD.name();
    }

    public void setUuidRepresentation(String uuidRepresentation) {
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public int getMinConnectionsPerHost() {
        return this.minConnectionsPerHost;
    }

    @Override
    public void setMinConnectionsPerHost(int minConnectionsPerHost) {
        this.minConnectionsPerHost = minConnectionsPerHost;
    }

    @Override
    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    @Override
    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    @Override
    public boolean isReplicaset() {
        return this.replicaSet;
    }

    @Override
    public List<String> listDatabases() throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        MongoConnection primaryConnection = this.getPrimaryConnection(null);
        ListDatabasesCommand cmd = new ListDatabasesCommand(primaryConnection);
        int msg = primaryConnection.sendCommand(cmd);
        Map<String, Object> res = primaryConnection.readSingleAnswer(msg);
        ArrayList<String> ret = new ArrayList<String>();
        if (res.get("databases") != null) {
            List lst = (List)res.get("databases");
            for (Map db : lst) {
                if (db.get("name") != null) {
                    ret.add(db.get("name").toString());
                    continue;
                }
                this.log.error("No DB Name for this entry...");
            }
        }
        return ret;
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        List<String> ret = this.listCollections(db, null);
        for (String c : ret) {
            if (!c.equals(collection)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getHostSeed() {
        if (this.hostSeed == null) {
            return null;
        }
        return this.hostSeed;
    }

    @Override
    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    @Override
    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    @Override
    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    @Override
    public void setMaxBsonObjectSize(int maxBsonObjectSize) {
        this.maxBsonObjectSize = maxBsonObjectSize;
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    @Override
    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    @Override
    public boolean isReplicaSet() {
        return this.replicaSet;
    }

    @Override
    public void setReplicaSet(boolean replicaSet) {
        this.replicaSet = replicaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        Class<DriverBase> clazz = DriverBase.class;
        synchronized (DriverBase.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rqid.incrementAndGet();
        }
    }

    @Override
    public boolean getDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.defaultWriteTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.defaultWriteTimeout = wt;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWait;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWait = maxWaitTime;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public void setHostSeed(List<String> hosts) {
        this.hostSeed = hosts;
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    public Maximums getMaximums() {
        Maximums max = new Maximums();
        max.setMaxBsonSize(this.maxBsonObjectSize);
        max.setMaxMessageSize(this.maxMessageSize);
        max.setMaxWriteBatchSize(this.maxWriteBatchSize);
        return max;
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return this.defaultRP;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
        this.defaultRP = rp;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
        this.batchSize = defaultBatchSize;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    public int getLocalThreshold() {
        return this.localThreshold;
    }

    public void setLocalThreshold(int thr) {
        this.localThreshold = thr;
    }

    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    @Override
    public MorphiumTransactionContext startTransaction(boolean autoCommit) {
        if (this.transactionContext.get() != null) {
            throw new IllegalArgumentException("Transaction in progress");
        }
        MorphiumTransactionContextImpl ctx = new MorphiumTransactionContextImpl();
        ctx.setLsid(UUID.randomUUID());
        ctx.setTxnNumber(Long.valueOf(this.getNextId()));
        this.transactionContext.set(ctx);
        return ctx;
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.transactionContext.get();
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        if (this.transactionContext.get() != null) {
            throw new IllegalArgumentException("Transaction already in progress!");
        }
        if (!(ctx instanceof MorphiumTransactionContextImpl)) {
            throw new IllegalArgumentException("Transaction context of wrong type!");
        }
        this.transactionContext.set((MorphiumTransactionContextImpl)ctx);
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.transactionContext.get() != null;
    }

    protected void clearTransactionContext() {
        this.transactionContext.remove();
    }

    @Override
    public abstract void watch(WatchCommand var1) throws MorphiumDriverException;

    @Override
    public abstract boolean isCapped(String var1, String var2) throws MorphiumDriverException;
}

