/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.mongodb;

import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.MorphiumDriverOperation;
import de.caluga.morphium.driver.MorphiumId;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.LoggerFactory;

public class DriverHelper {
    public static <V> V doCall(MorphiumDriverOperation<V> r, int maxRetry, int sleep) throws MorphiumDriverException {
        Exception lastException = null;
        for (int i = 0; i < maxRetry; ++i) {
            try {
                V ret = r.execute();
                if (i > 0) {
                    if (lastException == null) {
                        LoggerFactory.getLogger(DriverHelper.class).debug("recovered from error without exception");
                    } else {
                        LoggerFactory.getLogger(DriverHelper.class).debug("recovered from error: " + lastException.getMessage());
                    }
                }
                return ret;
            }
            catch (IllegalStateException ret) {
                continue;
            }
            catch (Exception e) {
                lastException = e;
                DriverHelper.handleNetworkError(maxRetry, i, sleep, e);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleNetworkError(int max, int i, int sleep, Throwable e) throws MorphiumDriverException {
        LoggerFactory.getLogger(DriverHelper.class).debug("Handling network error..." + e.getClass().getName());
        if (e.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
            throw new MorphiumDriverException("Validation error", e);
        }
        if (e.getClass().getName().contains("DuplicateKeyException")) {
            throw new MorphiumDriverException("Duplicate Key", e);
        }
        if (!e.getClass().getName().contains("MongoExecutionTimeoutException") && !e.getClass().getName().contains("MorphiumDriverNetworkException") && !e.getClass().getName().contains("MongoTimeoutException") && !e.getClass().getName().contains("MongoSocketReadTimeoutException") && !e.getClass().getName().contains("MongoWaitQueueFullException") && !e.getClass().getName().contains("MongoWriteConcernException") && !e.getClass().getName().contains("MongoSocketReadException") && !e.getClass().getName().contains("MongoSocketOpenException") && !e.getClass().getName().contains("MongoSocketClosedException") && !e.getClass().getName().contains("MongoSocketException") && !e.getClass().getName().contains("MongoNotPrimaryException") && !e.getClass().getName().contains("MongoInterruptedException") && !e.getClass().getName().contains("MongoNodeIsRecoveringException") && (e.getMessage() == null || !e.getMessage().equals("can't find a master") && !e.getMessage().startsWith("No replica set members available in") && !e.getMessage().equals("not talking to master and retries used up")) && (!e.getClass().getName().contains("WriteConcernException") || e.getMessage() == null || !e.getMessage().contains("not master")) && !e.getClass().getName().contains("MongoException")) throw new MorphiumDriverException("internal error: " + e.getMessage(), e);
        if (i + 1 < max) {
            LoggerFactory.getLogger(DriverHelper.class).warn("Retry because of network error: " + e.getMessage());
            try {
                Thread.sleep(sleep);
                return;
            }
            catch (InterruptedException interruptedException) {}
            return;
        } else {
            LoggerFactory.getLogger(DriverHelper.class).info("no retries left - re-throwing exception");
            throw new MorphiumDriverNetworkException("Network error error: " + e.getMessage(), e);
        }
    }

    public static void replaceBsonValues(List<Doc> in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        for (Map map : in) {
            DriverHelper.replaceMorphiumIdByObjectId(map);
        }
    }

    public static void replaceBsonValues(Doc m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry entry : m.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof MorphiumId) {
                    entry.setValue(new ObjectId(value.toString()));
                    continue;
                }
                if (value instanceof MorphiumReference) {
                    entry.setValue(new ObjectId(((MorphiumReference)value).getId().toString()));
                    continue;
                }
                if (value instanceof List) {
                    DriverHelper.replaceMorphiumIdByObjectIdInList((List)value);
                    continue;
                }
                if (value != null && value.getClass().isArray()) {
                    DriverHelper.replaceMorphiumIdByObjectIdInArray(value);
                    continue;
                }
                if (value instanceof Map) {
                    DriverHelper.replaceMorphiumIdByObjectId((Doc)value);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                entry.setValue(DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)value));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DriverHelper.class).error("Error replacing mongoid", (Throwable)e);
        }
    }

    public static void replaceBsonValuesIdInList(List<Object> in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        for (int i = 0; i < in.size(); ++i) {
            Object element = in.get(i);
            if (element instanceof MorphiumId) {
                in.set(i, new ObjectId(element.toString()));
                continue;
            }
            if (element instanceof MorphiumReference) {
                in.set(i, new ObjectId(((MorphiumReference)element).getId().toString()));
                continue;
            }
            if (element instanceof List) {
                DriverHelper.replaceMorphiumIdByObjectIdInList((List)element);
                continue;
            }
            if (element != null && element.getClass().isArray()) {
                DriverHelper.replaceMorphiumIdByObjectIdInArray(element);
                continue;
            }
            if (element instanceof Map) {
                DriverHelper.replaceMorphiumIdByObjectId((Doc)element);
                continue;
            }
            if (!(element instanceof Collection)) continue;
            in.set(i, DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)element));
        }
    }

    public static void replaceBsonValuesInArray(Object o) {
        if (o == null) {
            return;
        }
        for (int i = 0; i < Array.getLength(o); ++i) {
            Object arrayElement = Array.get(o, i);
            if (arrayElement instanceof MorphiumId) {
                Array.set(o, i, new ObjectId(arrayElement.toString()));
                continue;
            }
            if (arrayElement instanceof MorphiumReference) {
                Array.set(o, i, new ObjectId(((MorphiumReference)arrayElement).getId().toString()));
                continue;
            }
            if (arrayElement instanceof List) {
                DriverHelper.replaceMorphiumIdByObjectIdInList((List)arrayElement);
                continue;
            }
            if (arrayElement != null && arrayElement.getClass().isArray()) {
                DriverHelper.replaceMorphiumIdByObjectIdInArray(arrayElement);
                continue;
            }
            if (arrayElement instanceof Map) {
                DriverHelper.replaceMorphiumIdByObjectId((Doc)arrayElement);
                continue;
            }
            if (!(arrayElement instanceof Collection)) continue;
            Array.set(o, i, DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)arrayElement));
        }
    }

    public static Collection<Object> replaceBsonValuesInCollection(Collection<Object> collection) {
        boolean needToReplace = false;
        for (Object iv : collection) {
            if (!(iv instanceof MorphiumId) && !(iv instanceof MorphiumReference)) continue;
            needToReplace = true;
            break;
        }
        if (needToReplace) {
            ArrayList<Object> copyOfIterable = new ArrayList<Object>(collection);
            DriverHelper.replaceMorphiumIdByObjectIdInList(copyOfIterable);
            return copyOfIterable;
        }
        return collection;
    }

    public static void replaceMorphiumIdByObjectId(List<Map<String, Object>> in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        for (Map<String, Object> map : in) {
            DriverHelper.replaceMorphiumIdByObjectId(map);
        }
    }

    public static void replaceMorphiumIdByObjectId(Map<String, Object> m) {
        if (m == null || m.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry<String, Object> e : m.entrySet()) {
                Object value = e.getValue();
                if (value instanceof MorphiumId) {
                    e.setValue(new ObjectId(value.toString()));
                    continue;
                }
                if (value instanceof MorphiumReference) {
                    e.setValue(new ObjectId(((MorphiumReference)value).getId().toString()));
                    continue;
                }
                if (value instanceof List) {
                    DriverHelper.replaceMorphiumIdByObjectIdInList((List)value);
                    continue;
                }
                if (value != null && value.getClass().isArray()) {
                    DriverHelper.replaceMorphiumIdByObjectIdInArray(value);
                    continue;
                }
                if (value instanceof Map) {
                    DriverHelper.replaceMorphiumIdByObjectId((Doc)value);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                e.setValue(DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)value));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DriverHelper.class).error("Error replacing mongoid", (Throwable)e);
        }
    }

    public static void replaceMorphiumIdByObjectIdInList(List<Object> in) {
        if (in == null || in.isEmpty()) {
            return;
        }
        for (int i = 0; i < in.size(); ++i) {
            Object element = in.get(i);
            if (element instanceof MorphiumId) {
                in.set(i, new ObjectId(element.toString()));
                continue;
            }
            if (element instanceof MorphiumReference) {
                in.set(i, new ObjectId(((MorphiumReference)element).getId().toString()));
                continue;
            }
            if (element instanceof List) {
                DriverHelper.replaceMorphiumIdByObjectIdInList((List)element);
                continue;
            }
            if (element != null && element.getClass().isArray()) {
                DriverHelper.replaceMorphiumIdByObjectIdInArray(element);
                continue;
            }
            if (element instanceof Map) {
                DriverHelper.replaceMorphiumIdByObjectId((Doc)element);
                continue;
            }
            if (!(element instanceof Collection)) continue;
            in.set(i, DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)element));
        }
    }

    public static void replaceMorphiumIdByObjectIdInArray(Object o) {
        if (o == null) {
            return;
        }
        for (int i = 0; i < Array.getLength(o); ++i) {
            Object arrayElement = Array.get(o, i);
            if (arrayElement instanceof MorphiumId) {
                Array.set(o, i, new ObjectId(arrayElement.toString()));
                continue;
            }
            if (arrayElement instanceof MorphiumReference) {
                Array.set(o, i, new ObjectId(((MorphiumReference)arrayElement).getId().toString()));
                continue;
            }
            if (arrayElement instanceof List) {
                DriverHelper.replaceMorphiumIdByObjectIdInList((List)arrayElement);
                continue;
            }
            if (arrayElement != null && arrayElement.getClass().isArray()) {
                DriverHelper.replaceMorphiumIdByObjectIdInArray(arrayElement);
                continue;
            }
            if (arrayElement instanceof Map) {
                DriverHelper.replaceMorphiumIdByObjectId((Doc)arrayElement);
                continue;
            }
            if (!(arrayElement instanceof Collection)) continue;
            Array.set(o, i, DriverHelper.replaceMorphiumIdByObjectIdInCollection((Collection)arrayElement));
        }
    }

    public static Collection<Object> replaceMorphiumIdByObjectIdInCollection(Collection<Object> collection) {
        boolean needToReplace = false;
        for (Object iv : collection) {
            if (!(iv instanceof MorphiumId) && !(iv instanceof MorphiumReference)) continue;
            needToReplace = true;
            break;
        }
        if (needToReplace) {
            ArrayList<Object> copyOfIterable = new ArrayList<Object>(collection);
            DriverHelper.replaceMorphiumIdByObjectIdInList(copyOfIterable);
            return copyOfIterable;
        }
        return collection;
    }
}

