/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.driver.MorphiumId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public static boolean matchesQuery(Map<String, Object> query, Map<String, Object> toCheck) {
        if (query.isEmpty()) {
            return true;
        }
        if (query.containsKey("$where")) {
            System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            engine.getContext().setAttribute("obj", toCheck, 100);
            engine.getContext().setAttribute("this", toCheck, 100);
            try {
                Object result = engine.eval((String)query.get("$where"));
                if (result == null || result.equals(Boolean.FALSE)) {
                    return false;
                }
            }
            catch (ScriptException e) {
                throw new RuntimeException("Scripting error", e);
            }
        }
        Iterator<String> iterator = query.keySet().iterator();
        block63: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "$and": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (QueryHelper.matchesQuery(q, toCheck)) continue;
                        return false;
                    }
                    return true;
                }
                case "$or": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck)) continue;
                        return true;
                    }
                    return false;
                }
                case "$not": {
                    return !QueryHelper.matchesQuery((Map)query.get(key), toCheck);
                }
                case "$nor": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck)) continue;
                        return false;
                    }
                    return true;
                }
                case "$expr": {
                    Expr expr = Expr.parse(query.get(key));
                    Object result = expr.evaluate(toCheck);
                    if (result instanceof Expr) {
                        result = ((Expr)result).evaluate(toCheck);
                    }
                    return Boolean.TRUE.equals(result);
                }
            }
            if (query.get(key) instanceof Map) {
                Map q = (Map)query.get(key);
                String k = (String)q.keySet().iterator().next();
                if (key.equals("$expr")) {
                    Object e = Expr.parse(q);
                    return Boolean.TRUE.equals(((Expr)e).evaluate(toCheck));
                }
                switch (k) {
                    case "$eq": {
                        if (toCheck.get(key) == null && q.get(k) == null) {
                            return true;
                        }
                        if (toCheck.get(key) != null && q.get(k) == null) {
                            return false;
                        }
                        if (toCheck.get(key) == null && q.get(k) != null) {
                            return false;
                        }
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) == 0;
                    }
                    case "$lt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) < 0;
                    }
                    case "$lte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) <= 0;
                    }
                    case "$gt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) > 0;
                    }
                    case "$gte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) >= 0;
                    }
                    case "$mod": {
                        Number n = (Number)toCheck.get(key);
                        List arr = (List)q.get(k);
                        int div = (Integer)arr.get(0);
                        int rem = (Integer)arr.get(1);
                        return n.intValue() % div == rem;
                    }
                    case "$ne": {
                        boolean contains = false;
                        if (toCheck.get(key) instanceof List) {
                            List chk = Collections.synchronizedList(new CopyOnWriteArrayList((List)toCheck.get(key)));
                            for (Object o : chk) {
                                if (o == null || q.get(k) == null || !o.equals(q.get(k))) continue;
                                contains = true;
                                break;
                            }
                            return !contains;
                        }
                        if (toCheck.get(key) == null && q.get(k) != null) {
                            return true;
                        }
                        if (toCheck.get(key) == null && q.get(k) == null) {
                            return false;
                        }
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) != 0;
                    }
                    case "$exists": {
                        boolean exists = toCheck.containsKey(key);
                        if (q.get(k).equals(Boolean.TRUE) || q.get(k).equals("true") || q.get(k).equals(1)) {
                            return exists;
                        }
                        return !exists;
                    }
                    case "$nin": {
                        boolean found = false;
                        block68: for (Object v : (List)q.get(k)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (toCheck.get(key) == null) {
                                if (v != null) continue;
                                found = true;
                                continue;
                            }
                            if (toCheck.get(key).equals(v)) {
                                found = true;
                            }
                            if (!(toCheck.get(key) instanceof List)) continue;
                            for (Object v2 : (List)toCheck.get(key)) {
                                if (!v2.equals(v)) continue;
                                found = true;
                                continue block68;
                            }
                        }
                        return !found;
                    }
                    case "$in": {
                        for (Object v : (List)q.get(k)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (toCheck.get(key) == null && v == null) {
                                return true;
                            }
                            if (toCheck.get(key) != null && toCheck.get(key).equals(v)) {
                                return true;
                            }
                            if (toCheck.get(key) == null || !(toCheck.get(key) instanceof List)) continue;
                            for (Object v2 : (List)toCheck.get(key)) {
                                if (!v2.equals(v)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    case "$comment": {
                        continue block63;
                    }
                    case "$expr": {
                        Expr e = (Expr)q.get(k);
                        Object ev = e.evaluate(toCheck);
                        return ev != null && (ev.equals(Boolean.TRUE) || ev.equals(1) || ev.equals("true"));
                    }
                    case "$regex": {
                        Object valtoCheck = null;
                        if (key.contains(".")) {
                            String[] b = key.split("\\.");
                            Map val = toCheck;
                            for (int i = 0; i < b.length; ++i) {
                                String el = b[i];
                                Object candidate = val.get(el);
                                if (candidate == null) {
                                    return false;
                                }
                                if (!(candidate instanceof Map) && i < b.length - 1) {
                                    return false;
                                }
                                if (i < b.length - 1) {
                                    val = (Map)candidate;
                                }
                                if (i != b.length - 1) continue;
                                valtoCheck = candidate;
                            }
                        } else {
                            valtoCheck = toCheck.get(key);
                        }
                        int opts = 0;
                        if (q.containsKey("$options")) {
                            String opt = q.get("$options").toString().toLowerCase();
                            if (opt.contains("i")) {
                                opts |= 2;
                            }
                            if (opt.contains("m")) {
                                opts |= 8;
                            }
                            if (opt.contains("s")) {
                                opts |= 0x20;
                            }
                            if (opt.contains("x")) {
                                log.warn("There is no proper equivalent for the 'x' option in mongodb!");
                            }
                        }
                        if (valtoCheck == null) {
                            return false;
                        }
                        Object regex = q.get("$regex").toString();
                        if (!((String)regex).startsWith("^")) {
                            regex = ".*" + (String)regex;
                        }
                        Pattern p = Pattern.compile((String)regex, opts);
                        return p.matcher(valtoCheck.toString()).matches();
                    }
                    case "$jsonSchema": 
                    case "$type": 
                    case "$text": 
                    case "$geoIntersects": 
                    case "$geoWithin": 
                    case "$near": 
                    case "$nearSphere": 
                    case "$all": 
                    case "$elemMatch": 
                    case "$size": 
                    case "$bitsAllClear": 
                    case "$bitsAllSet": 
                    case "$bitsAnyClear": 
                    case "$bitsAnySet": {
                        log.warn("Unsupported op " + k + " for in memory driver");
                        break;
                    }
                    case "$options": {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown Operator " + k);
                    }
                }
                continue;
            }
            if (key.contains(".")) {
                String[] path = key.split("\\.");
                Map current = toCheck;
                Object value = null;
                for (String k : path) {
                    if (current.get(k) == null) {
                        return query.get(key) == null;
                    }
                    if (Map.class.isAssignableFrom(current.get(k).getClass())) {
                        current = (Map)current.get(k);
                        continue;
                    }
                    value = current.get(k);
                }
                return value.equals(query.get(key));
            }
            if (toCheck.get(key) == null && query.get(key) == null) {
                return true;
            }
            if (toCheck.get(key) == null && query.get(key) != null) {
                return false;
            }
            assert (query.size() == 1);
            if (toCheck.get(key) instanceof MorphiumId || toCheck.get(key) instanceof ObjectId) {
                return toCheck.get(key).toString().equals(query.get(key).toString());
            }
            return toCheck.get(key).equals(query.get(key));
        }
        return false;
    }
}

