/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WriteMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

public class StoreMongoCommand
extends WriteMongoCommand<StoreMongoCommand> {
    private List<Map<String, Object>> docs;

    public StoreMongoCommand(MongoConnection d) {
        super(d);
    }

    public List<Map<String, Object>> getDocs() {
        return this.docs;
    }

    public StoreMongoCommand setDocs(List<Map<String, Object>> docs) {
        this.docs = docs;
        return this;
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        UpdateMongoCommand updateSettings = this.getUpdateMongoCommand();
        Map<String, Object> result = updateSettings.execute();
        return result;
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        UpdateMongoCommand updateSettings = this.getUpdateMongoCommand();
        return updateSettings.executeAsync();
    }

    private UpdateMongoCommand getUpdateMongoCommand() {
        ArrayList<Map<String, Object>> opsLst = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> o : this.getDocs()) {
            o.putIfAbsent("_id", new ObjectId());
            LinkedHashMap<String, Serializable> up = new LinkedHashMap<String, Serializable>();
            up.put("q", Doc.of("_id", o.get("_id")));
            up.put("u", Doc.of("$set", o));
            up.put("upsert", Boolean.valueOf(true));
            up.put("multi", Boolean.valueOf(false));
            up.put("collation", null);
            opsLst.add(up);
        }
        UpdateMongoCommand updateSettings = (UpdateMongoCommand)((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(this.getConnection()).setDb(this.getDb())).setColl(this.getColl())).setUpdates(opsLst).setWriteConcern(this.getWriteConcern());
        this.setMetaData(updateSettings.getMetaData());
        return updateSettings;
    }

    @Override
    public String getCommandName() {
        return null;
    }
}

