/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class MongoCommand<T extends MongoCommand> {
    @Transient
    private static AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(false);
    private String $db;
    private String coll;
    private String comment;
    private Map<String, Object> metaData;
    @Transient
    private MongoConnection connection;
    @Transient
    private int retriesOnNetworkError = 2;
    @Transient
    private int sleepBetweenErrorRetries = 100;
    @Transient
    private int defaultBatchSize = 100;
    private Doc $readPreference = Doc.of("mode", "primaryPreferred");

    public MongoCommand(MongoConnection c) {
        this.connection = c;
    }

    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    public MongoCommand<T> setRetriesOnNetworkError(int retriesOnNetworkError) {
        this.retriesOnNetworkError = retriesOnNetworkError;
        return this;
    }

    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenErrorRetries;
    }

    public MongoCommand<T> setSleepBetweenErrorRetries(int sleepBetweenErrorRetries) {
        this.sleepBetweenErrorRetries = sleepBetweenErrorRetries;
        return this;
    }

    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public MongoCommand<T> setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
        return this;
    }

    public MongoConnection getConnection() {
        return this.connection;
    }

    public MongoCommand<T> setConnection(MongoConnection connection) {
        this.connection = connection;
        return this;
    }

    public String getDb() {
        return this.$db;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public MongoCommand<T> setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return this;
    }

    public MongoCommand<T> setMetaData(String key, Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
        return this;
    }

    public T setDb(String db) {
        this.$db = db;
        return (T)this;
    }

    public String getColl() {
        return this.coll;
    }

    public T setColl(String coll) {
        this.coll = coll;
        return (T)this;
    }

    public String getComment() {
        return this.comment;
    }

    public T setComment(String c) {
        this.comment = c;
        return (T)this;
    }

    public T fromMap(Map<String, Object> m) {
        this.setColl("" + m.get(this.getCommandName()));
        for (Field f : an.getAllFields(this.getClass())) {
            if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || f.getName().equals("metaData") || f.getName().equals("readPreference") || f.getName().equals("connection") || f.getName().equals("coll") || DriverTailableIterationCallback.class.isAssignableFrom(f.getType()) || AsyncOperationCallback.class.isAssignableFrom(f.getType())) continue;
            String n = f.getName();
            if (n.equals("newFlag")) {
                n = "new";
            }
            f.setAccessible(true);
            try {
                Object v = m.get(n);
                if (v == null) continue;
                Class<?> targetType = f.getType();
                if (targetType.isEnum()) {
                    Object en = Enum.valueOf(f.getType(), v.toString());
                    v = en;
                }
                if (v == null) continue;
                f.set(this, v);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (T)this;
    }

    public Map<String, Object> asMap() {
        Doc map = new Doc();
        map.put(this.getCommandName(), this.getColl());
        for (Field f : an.getAllFields(this.getClass())) {
            if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class) || f.getName().equals("metaData") || f.getName().equals("readPreference") || f.getName().equals("connection") || f.getName().equals("coll") || DriverTailableIterationCallback.class.isAssignableFrom(f.getType()) || AsyncOperationCallback.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            try {
                String n;
                Object v = f.get(this);
                if (v instanceof Enum) {
                    v = v.toString();
                }
                if ((n = f.getName()).equals("newFlag")) {
                    n = "new";
                }
                if (v == null) continue;
                map.put(n, v);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public void clear() {
        for (Field f : an.getAllFields(this.getClass())) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                f.set(this, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public abstract String getCommandName();

    public int executeAsync() throws MorphiumDriverException {
        MongoConnection driver = this.getConnection();
        if (driver == null) {
            throw new IllegalArgumentException("you need to set the driver!");
        }
        return (Integer)new NetworkCallHelper().doCall(() -> {
            int result = this.getConnection().sendCommand(this);
            this.setMetaData("duration", 0);
            this.setMetaData("server", this.connection.getConnectedTo() + ":" + this.connection.getConnectedToPort());
            return result;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }
}

