/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ListIndexesCommand
extends MongoCommand<ListIndexesCommand> {
    public ListIndexesCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public String getCommandName() {
        return "listIndexes";
    }

    public List<IndexDescription> execute() throws MorphiumDriverException {
        int msg = this.getConnection().sendCommand(this);
        MorphiumCursor crs = this.getConnection().getAnswerFor(msg, this.getDefaultBatchSize());
        ArrayList<IndexDescription> lst = new ArrayList<IndexDescription>();
        while (crs.hasNext()) {
            Object next = crs.next();
            if (next.get("ok") != null && next.get("ok").equals(0.0)) continue;
            IndexDescription idx = IndexDescription.fromMap((Map<String, Object>)next);
            if (idx.getKey().containsKey("_ftsx") && idx.getKey().get("_fts").equals("text")) {
                Map<String, Object> weights = idx.getWeights();
                Doc m = Doc.of();
                for (String k : weights.keySet()) {
                    m.put(k, "text");
                }
                idx.setKey(m);
            }
            lst.add(idx);
        }
        return lst;
    }
}

