/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.Map;

public class HelloCommand
extends MongoCommand<HelloCommand> {
    private String saslSupportedMechs;
    private Boolean helloOk = true;
    private boolean includeClient = true;
    private Boolean loadBalanced;
    @Transient
    private String authDb;
    @Transient
    private String user;

    public HelloCommand(MongoConnection d) {
        super(d);
        this.setDb("");
        this.setColl("");
    }

    public String getAuthDb() {
        return this.authDb;
    }

    public HelloCommand setAuthDb(String authDb) {
        this.authDb = authDb;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public HelloCommand setUser(String user) {
        this.user = user;
        return this;
    }

    public Boolean getLoadBalanced() {
        return this.loadBalanced;
    }

    public HelloCommand setLoadBalanced(Boolean loadBalanced) {
        this.loadBalanced = loadBalanced;
        return this;
    }

    public Boolean getHelloOk() {
        return this.helloOk;
    }

    public HelloCommand setHelloOk(Boolean helloOk) {
        this.helloOk = helloOk;
        return this;
    }

    public boolean isIncludeClient() {
        return this.includeClient;
    }

    public HelloCommand setIncludeClient(boolean includeClient) {
        this.includeClient = includeClient;
        return this;
    }

    public String getSaslSupportedMechs() {
        return this.saslSupportedMechs;
    }

    public HelloCommand setSaslSupportedMechs(String dbDotUser) {
        this.saslSupportedMechs = dbDotUser;
        return this;
    }

    @Override
    public String getCommandName() {
        return "hello";
    }

    @Override
    public HelloCommand setDb(String db) {
        return this;
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> ret = super.asMap();
        ret.put(this.getCommandName(), 1);
        if (this.authDb != null) {
            ret.put("saslSupportedMechs", this.authDb + "." + this.user);
        }
        ret.put("$db", "local");
        String driverName = "unknown";
        if (this.getConnection() != null && this.getConnection() != null && this.getConnection().getDriver() != null) {
            driverName = this.getConnection().getDriver().getName();
        }
        if (this.includeClient) {
            ret.put("client", Doc.of("application", Doc.of("name", "Morphium"), "driver", Doc.of("name", driverName, "version", "1.0"), "os", Doc.of("type", System.getProperty("os.name"))));
        }
        return ret;
    }

    public HelloResult execute() throws MorphiumDriverException {
        int msg = this.getConnection().sendCommand(this);
        MorphiumCursor crs = this.getConnection().getAnswerFor(msg, this.getDefaultBatchSize());
        return HelloResult.fromMsg((Map<String, Object>)crs.next());
    }
}

