/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.util.List;
import java.util.Map;

public class DistinctMongoCommand
extends MongoCommand<DistinctMongoCommand> {
    private String key;
    private Map<String, Object> query;
    private Map<String, Object> readConcern;
    private Map<String, Object> collation;

    public DistinctMongoCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public String getCommandName() {
        return "distinct";
    }

    public String getKey() {
        return this.key;
    }

    public DistinctMongoCommand setKey(String key) {
        this.key = key;
        return this;
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public DistinctMongoCommand setQuery(Map<String, Object> query) {
        this.query = query;
        return this;
    }

    public Map<String, Object> getReadConcern() {
        return this.readConcern;
    }

    public DistinctMongoCommand setReadConcern(Map<String, Object> readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public Map<String, Object> getCollation() {
        return this.collation;
    }

    public DistinctMongoCommand setCollation(Map<String, Object> collation) {
        this.collation = collation;
        return this;
    }

    public List<Object> execute() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException("you need to set the connection!");
        }
        return (List)new NetworkCallHelper().doCall(() -> {
            this.setMetaData("server", connection.getConnectedTo());
            long start = System.currentTimeMillis();
            int msg = connection.sendCommand(this);
            Map<String, Object> res = connection.readSingleAnswer(msg);
            long dur = System.currentTimeMillis() - start;
            this.setMetaData("duration", dur);
            return (List)res.get("values");
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }
}

