/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Sequence;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.query.Query;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator {
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);
    private int inc;
    private long startValue;
    private Morphium morphium;
    private String id;
    private String name;

    public SequenceGenerator(Morphium m, String n) {
        this(m, n, 1, 1L);
    }

    public SequenceGenerator(Morphium mrph, String name, int inc, long startValue) {
        this.inc = inc;
        if (inc == 0) {
            throw new IllegalArgumentException("Cannot use increment value 0!");
        }
        this.name = name;
        this.startValue = startValue;
        this.morphium = mrph;
        this.id = UUID.randomUUID().toString();
        try {
            if (!this.morphium.getDriver().exists(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(Sequence.class)) || this.morphium.createQueryFor(Sequence.class).f("_id").eq(name).countAll() == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("Sequence does not exist yet... inserting");
                }
                Sequence s = new Sequence();
                s.setCurrentValue(startValue - (long)inc);
                s.setName(name);
                this.morphium.ensureIndicesFor(Sequence.class);
                this.morphium.storeNoCache(s);
            }
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public long getCurrentValue() {
        Sequence s = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name).get();
        if (s == null || s.getCurrentValue() == null) {
            return this.getNextValue(1);
        }
        return s.getCurrentValue();
    }

    public long getNextValue() {
        try {
            return this.getNextValue(0);
        }
        catch (RecursionException e) {
            log.error("REcursion failed, retrying...");
            return this.getNextValue(0);
        }
    }

    private synchronized long getNextValue(int recLevel) {
        Sequence s;
        Query<Sequence> seq;
        while (true) {
            if ((seq = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name)).countAll() == 0L) {
                log.error("Sequence vanished?");
                throw new RuntimeException("Sequence vanished");
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            Sequence sequence = seq.get();
            if (recLevel > 50) {
                log.error("Could not get lock on Sequence " + this.name + " Checking timestamp...");
                if (System.currentTimeMillis() - sequence.getLockedAt() > 30000L) {
                    log.error("Was locked for more than 30s - assuming error, resetting lock");
                    this.morphium.unset(sequence, "locked_by");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("overwriting lock for locked sequence " + this.name);
                    }
                    recLevel = 1;
                    continue;
                }
                if (recLevel > 1000) {
                    throw new RuntimeException("Getting lock on sequence " + this.name + " failed!");
                }
            }
            seq = seq.q().f("name").eq(this.name).f("locked_by").eq(null);
            values.put("locked_by", this.id);
            values.put("locked_at", System.currentTimeMillis());
            this.morphium.set(seq, values, false, false);
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.debug("locked sequence entry");
            seq = this.morphium.createQueryFor(Sequence.class);
            seq.f("_id").eq(this.name).f("locked_by").eq(this.id);
            if (seq.countAll() != 0L) break;
            log.debug("Locking failed on retry " + recLevel + " - restarting.");
            try {
                Thread.sleep((long)(300.0 * Math.random() + 100.0));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++recLevel;
        }
        if (seq.countAll() > 1L) {
            log.error("sequence name / locked by not unique??? - using first");
        }
        if (log.isDebugEnabled()) {
            log.debug("Found it!");
        }
        this.morphium.inc(seq, "current_value", this.inc);
        if (log.isDebugEnabled()) {
            log.debug("increased it");
        }
        if ((s = seq.get()) == null) {
            log.error("locked Sequence not found anymore?");
            seq = this.morphium.createQueryFor(Sequence.class).f("name").eq(this.name);
            for (Sequence sq : seq.asList()) {
                log.error("Sequence: " + sq.toString());
            }
            return -1L;
        }
        s.setLockedBy(null);
        this.morphium.store(s);
        if (log.isDebugEnabled()) {
            log.debug("unlocked it");
        }
        return s.getCurrentValue();
    }

    public int getInc() {
        return this.inc;
    }

    public void setInc(int inc) {
        this.inc = inc;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Morphium getMorphium() {
        return this.morphium;
    }

    public void setMorphium(Morphium morphium) {
        this.morphium = morphium;
    }

    public static class RecursionException
    extends RuntimeException {
    }
}

