/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.encryption;

import de.caluga.morphium.encryption.EncryptionKeyProvider;
import de.caluga.rsa.AES;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyEncryptionKeyProvider
implements EncryptionKeyProvider {
    private Map<String, byte[]> keys = new HashMap<String, byte[]>();

    public PropertyEncryptionKeyProvider() {
    }

    public PropertyEncryptionKeyProvider(Properties p, String prefix, String encryptionKeyForReading, boolean useBase64) {
        this.readFromProperties(p, prefix, encryptionKeyForReading, useBase64);
    }

    public PropertyEncryptionKeyProvider(Properties p, String prefix, String encryptionKeyForReading) {
        this.readFromProperties(p, prefix, encryptionKeyForReading, encryptionKeyForReading != null);
    }

    public void readFromProperties(Properties p, String prefix, String encryptionKeyForReading, boolean useBase64) {
        AES a = new AES();
        if (encryptionKeyForReading != null) {
            a.setKey(encryptionKeyForReading);
        }
        int idx = 0;
        if (prefix != null) {
            idx = prefix.length();
        }
        for (String n : p.stringPropertyNames()) {
            if (prefix != null && !n.startsWith(prefix)) continue;
            byte[] v = useBase64 ? Base64.getDecoder().decode(p.getProperty(n)) : p.getProperty(n).getBytes();
            if (encryptionKeyForReading != null) {
                v = a.decrypt(v);
            }
            this.keys.put(n.substring(idx), v);
        }
    }

    @Override
    public void setEncryptionKey(String name, byte[] key) {
        this.keys.put(name + ".enc", key);
    }

    @Override
    public void setDecryptionKey(String name, byte[] key) {
        this.keys.put(name + ".dec", key);
    }

    @Override
    public byte[] getEncryptionKey(String name) {
        if (this.keys.containsKey(name + ".enc")) {
            return this.keys.get(name + ".enc");
        }
        return this.keys.get(name);
    }

    @Override
    public byte[] getDecryptionKey(String name) {
        if (this.keys.containsKey(name + ".dec")) {
            return this.keys.get(name + ".dec");
        }
        return this.keys.get(name);
    }
}

