/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.driver.MorphiumId;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public static boolean matchesQuery(Map<String, Object> query, Map<String, Object> toCheck) {
        if (query.isEmpty()) {
            return true;
        }
        if (query.containsKey("$where")) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.getContext().setAttribute("obj", toCheck, 100);
            engine.getContext().setAttribute("this", toCheck, 100);
            try {
                Object result = engine.eval((String)query.get("$where"));
                if (result == null || result.equals(Boolean.FALSE)) {
                    return false;
                }
            }
            catch (ScriptException e) {
                throw new RuntimeException("Scripting error", e);
            }
        }
        Iterator<String> iterator = query.keySet().iterator();
        block55: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "$and": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (QueryHelper.matchesQuery(q, toCheck)) continue;
                        return false;
                    }
                    return true;
                }
                case "$or": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck)) continue;
                        return true;
                    }
                    return false;
                }
                case "$not": {
                    return !QueryHelper.matchesQuery((Map)query.get(key), toCheck);
                }
                case "$nor": {
                    List lst = (List)query.get(key);
                    for (Map q : lst) {
                        if (!QueryHelper.matchesQuery(q, toCheck)) continue;
                        return false;
                    }
                    return true;
                }
            }
            if (query.get(key) instanceof Map) {
                String k;
                Map q = (Map)query.get(key);
                assert (q.size() == 1);
                switch (k = (String)q.keySet().iterator().next()) {
                    case "$lt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) < 0;
                    }
                    case "$lte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) <= 0;
                    }
                    case "$gt": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) > 0;
                    }
                    case "$gte": {
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) >= 0;
                    }
                    case "$mod": {
                        Number n = (Number)toCheck.get(key);
                        List arr = (List)q.get(k);
                        int div = (Integer)arr.get(0);
                        int rem = (Integer)arr.get(1);
                        return n.intValue() % div == rem;
                    }
                    case "$ne": {
                        boolean contains = false;
                        if (toCheck.get(key) instanceof List) {
                            List chk = Collections.synchronizedList(new CopyOnWriteArrayList((List)toCheck.get(key)));
                            for (Object o : chk) {
                                if (o == null || q.get(k) == null || !o.equals(q.get(k))) continue;
                                contains = true;
                                break;
                            }
                            return !contains;
                        }
                        if (toCheck.get(key) == null && q.get(k) != null) {
                            return true;
                        }
                        if (toCheck.get(key) == null && q.get(k) == null) {
                            return false;
                        }
                        return ((Comparable)toCheck.get(key)).compareTo(q.get(k)) != 0;
                    }
                    case "$exists": {
                        boolean exists = toCheck.containsKey(key);
                        if (q.get(k).equals(Boolean.TRUE) || q.get(k).equals("true") || q.get(k).equals(1)) {
                            return exists;
                        }
                        return !exists;
                    }
                    case "$nin": {
                        boolean found = false;
                        block60: for (Object v : (List)q.get(k)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (toCheck.get(key) == null) {
                                if (v != null) continue;
                                found = true;
                                continue;
                            }
                            if (toCheck.get(key).equals(v)) {
                                found = true;
                            }
                            if (!(toCheck.get(key) instanceof List)) continue;
                            for (Object v2 : (List)toCheck.get(key)) {
                                if (!v2.equals(v)) continue;
                                found = true;
                                continue block60;
                            }
                        }
                        return !found;
                    }
                    case "$in": {
                        for (Object v : (List)q.get(k)) {
                            if (v instanceof MorphiumId) {
                                v = new ObjectId(v.toString());
                            }
                            if (toCheck.get(key) == null && v == null) {
                                return true;
                            }
                            if (toCheck.get(key) != null && toCheck.get(key).equals(v)) {
                                return true;
                            }
                            if (toCheck.get(key) == null || !(toCheck.get(key) instanceof List)) continue;
                            for (Object v2 : (List)toCheck.get(key)) {
                                if (!v2.equals(v)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    case "$comment": {
                        continue block55;
                    }
                    case "$expr": 
                    case "$jsonSchema": 
                    case "$type": 
                    case "$regex": 
                    case "$text": 
                    case "$geoIntersects": 
                    case "$geoWithin": 
                    case "$near": 
                    case "$nearSphere": 
                    case "$all": 
                    case "$elemMatch": 
                    case "$size": 
                    case "$bitsAllClear": 
                    case "$bitsAllSet": 
                    case "$bitsAnyClear": 
                    case "$bitsAnySet": {
                        log.warn("Unsupported op " + k + " for in memory driver");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown Operator " + k);
                    }
                }
                continue;
            }
            assert (query.size() == 1);
            if (toCheck.get(key) instanceof MorphiumId || toCheck.get(key) instanceof ObjectId) {
                return toCheck.get(key).toString().equals(query.get(key).toString());
            }
            if (toCheck.get(key) == null && query.get(key) != null) {
                return false;
            }
            if (toCheck.get(key) == null && query.get(key) == null) {
                return true;
            }
            return toCheck.get(key).equals(query.get(key));
        }
        return false;
    }
}

