/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.AggregationIterator;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemAggregator<T, R>
implements Aggregator<T, R> {
    private final Logger log = LoggerFactory.getLogger(InMemAggregator.class);
    private final List<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
    private final List<Group<T, R>> groups = new ArrayList<Group<T, R>>();
    private Class<? extends T> type;
    private Morphium morphium;
    private Class<? extends R> rType;
    private String collectionName;
    private boolean useDisk = false;
    private boolean explain = false;
    private Collation collation;

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            p.put(e.getKey(), e.getValue());
        }
        Utils.UtilsMap map = Utils.getMap("$project", p);
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> project(String fld, Expr e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(fld, e);
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> addFields(Map<String, Object> m) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (!(e.getValue() instanceof Expr)) {
                throw new IllegalArgumentException("InMemAggregator only works with Expr");
            }
            ret.put(e.getKey(), e.getValue());
        }
        Utils.UtilsMap o = Utils.getMap("$addFields", ret);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        if (this.collectionName == null) {
            this.collectionName = q.getCollectionName();
        }
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> matchSubQuery(Query<?> q) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Expr q) {
        this.params.add(Utils.getMap("$match", Utils.getMap("$expr", q)));
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        Utils.UtilsMap<String, Integer> o = Utils.getMap("$limit", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        Utils.UtilsMap<String, Integer> o = Utils.getMap("$skip", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        Utils.UtilsMap<String, String> o = Utils.getMap("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(Expr field) {
        Utils.UtilsMap<String, Expr> o = Utils.getMap("$unwind", field);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixed;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (i2.startsWith("$") && !(fld = fld.substring(1)).contains(".")) {
                fld = this.morphium.getARHelper().getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        Utils.UtilsMap<String, Map<String, Integer>> o = Utils.getMap("$sort", sort);
        this.params.add(o);
        return this;
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public void setCollectionName(String cn) {
        this.collectionName = cn;
    }

    @Override
    public Group<T, R> group(Map<String, Object> id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(Expr id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(String id) {
        Group gr = new Group(this, id);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public void addOperator(Map<String, Object> o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        try {
            return this.deserializeList();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getCount() {
        ArrayList<Map<String, Object>> pipeline = new ArrayList<Map<String, Object>>(this.getPipeline());
        pipeline.add(Utils.getMap("$count", "num"));
        List<Map<String, Object>> res = null;
        try {
            res = this.getMorphium().getDriver().aggregate(this.getMorphium().getConfig().getDatabase(), this.getCollectionName(), pipeline, this.isExplain(), this.isUseDisk(), this.getCollation(), this.getMorphium().getReadPreferenceForClass(this.getSearchType()));
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        if (res.get(0).get("num") instanceof Integer) {
            return ((Integer)res.get(0).get("num")).longValue();
        }
        return (Long)res.get(0).get("num");
    }

    @Override
    public MorphiumAggregationIterator<T, R> aggregateIterable() {
        AggregationIterator agg = new AggregationIterator();
        agg.setAggregator(this);
        return agg;
    }

    @Override
    public void aggregate(AsyncOperationCallback<R> callback) {
        if (callback == null) {
            try {
                this.morphium.getDriver().aggregate(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.getPipeline(), this.isExplain(), this.isUseDisk(), this.getCollation(), this.morphium.getReadPreferenceForClass(this.getSearchType()));
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.morphium.queueTask(() -> {
                try {
                    long start = System.currentTimeMillis();
                    List<R> result = this.deserializeList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, result, null, this);
                }
                catch (MorphiumDriverException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private List<R> deserializeList() throws MorphiumDriverException {
        List<Map<String, Object>> r = this.morphium.getDriver().aggregate(this.morphium.getConfig().getDatabase(), this.getCollectionName(), this.getPipeline(), this.isExplain(), this.isUseDisk(), this.getCollation(), this.morphium.getReadPreferenceForClass(this.getSearchType()));
        List<Object> result = new ArrayList();
        if (this.getResultType().equals(Map.class)) {
            result = r;
        } else {
            for (Map<String, Object> dbObj : r) {
                result.add(this.morphium.getMapper().deserialize(this.getResultType(), dbObj));
            }
        }
        return result;
    }

    @Override
    public void aggregateMap(AsyncOperationCallback<Map<String, Object>> callback) {
    }

    @Override
    public List<Map<String, Object>> getPipeline() {
        for (Group<T, R> g : this.groups) {
            g.end();
        }
        this.groups.clear();
        return this.params;
    }

    @Override
    public Aggregator<T, R> count(String fld) {
        this.params.add(Utils.getMap("$count", fld));
        return this;
    }

    @Override
    public Aggregator<T, R> count(Enum fld) {
        return this.count(fld.name());
    }

    @Override
    public Aggregator<T, R> bucket(Expr groupBy, List<Expr> boundaries, Expr preset, Map<String, Expr> output) {
        LinkedHashMap<String, Expr> out = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Expr> e : output.entrySet()) {
            out.put(e.getKey(), e.getValue());
        }
        ArrayList bn = new ArrayList();
        boundaries.stream().forEach(x -> bn.add(x));
        Utils.UtilsMap<String, Utils.UtilsMap<String, Map<String, Object>>> m = Utils.getMap("$bucket", Utils.getMap("groupBy", groupBy).add("boundaries", (Expr)((Object)bn)).add("default", preset).add("output", (Expr)((Object)Utils.getQueryObjectMap(output))));
        this.params.add(m);
        return this;
    }

    @Override
    public Aggregator<T, R> bucketAuto(Expr groupBy, int numBuckets, Map<String, Expr> output, Aggregator.BucketGranularity granularity) {
        LinkedHashMap<String, Expr> out = null;
        if (output != null) {
            out = new LinkedHashMap<String, Expr>();
            for (Map.Entry<String, Expr> e : output.entrySet()) {
                out.put(e.getKey(), e.getValue());
            }
        }
        Utils.UtilsMap<String, Expr> bucketAuto = Utils.getMap("groupBy", groupBy);
        bucketAuto.add("buckets", (Expr)((Object)Integer.valueOf(numBuckets)));
        Utils.UtilsMap<String, Utils.UtilsMap<String, Expr>> map = Utils.getMap("$bucketAuto", bucketAuto);
        if (out != null) {
            bucketAuto.add("output", (Expr)((Object)out));
        }
        if (granularity != null) {
            bucketAuto.add("granularity", (Expr)((Object)granularity.getValue()));
        }
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> collStats(Boolean latencyHistograms, Double scale, boolean count, boolean queryExecStats) {
        LinkedHashMap m = new LinkedHashMap();
        if (latencyHistograms != null) {
            m.put("latencyStats", Utils.getMap("histograms", latencyHistograms));
        }
        if (scale != null) {
            m.put("storageStats", Utils.getMap("scale", scale));
        }
        if (count) {
            m.put("count", new HashMap());
        }
        if (queryExecStats) {
            m.put("queryExecStats", new HashMap());
        }
        this.params.add(Utils.getMap("$collStats", m));
        return this;
    }

    @Override
    public Aggregator<T, R> currentOp(boolean allUsers, boolean idleConnections, boolean idleCursors, boolean idleSessions, boolean localOps) {
        this.params.add(Utils.getMap("$currentOp", Utils.getMap("allUsers", allUsers).add("idleConnections", idleConnections).add("idleCursors", idleCursors).add("idleSessions", idleSessions).add("localOps", localOps)));
        return this;
    }

    @Override
    public Aggregator<T, R> facetExpr(Map<String, Expr> facets) {
        Map<String, Object> map = Utils.getQueryObjectMap(facets);
        this.params.add(Utils.getMap("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> facet(Map<String, Aggregator> facets) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, Aggregator> e : facets.entrySet()) {
            map.put(e.getKey(), e.getValue().getPipeline());
        }
        this.params.add(Utils.getMap("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> geoNear(Map<Aggregator.GeoNearFields, Object> param) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Aggregator.GeoNearFields, Object> e : param.entrySet()) {
            map.put(e.getKey().name(), ((ObjectMapperImpl)this.morphium.getMapper()).marshallIfNecessary(e.getValue()));
        }
        this.params.add(Utils.getMap("$geoNear", map));
        return this;
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, Enum connectFromField, Enum connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField.name(), connectToField.name(), as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField, connectToField, as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(String fromCollection, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        Utils.UtilsMap<String, String> add = Utils.getMap("from", fromCollection).add("startWith", (String)((Object)startWith)).add("connectFromField", connectFromField).add("connectToField", connectToField).add("as", as);
        this.params.add(Utils.getMap("$graphLookup", add));
        if (maxDepth != null) {
            add.add("maxDepth", (String)((Object)maxDepth));
        }
        if (depthField != null) {
            add.add("depthField", depthField);
        }
        if (restrictSearchWithMatch != null) {
            add.add("restrictSearchWithMatch", (String)((Object)restrictSearchWithMatch));
        }
        return this;
    }

    @Override
    public Aggregator<T, R> indexStats() {
        this.params.add(Utils.getMap("$indexStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessionsAllUsers() {
        this.params.add(Utils.getMap("$listLocalSessions", Utils.getMap("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions() {
        this.params.add(Utils.getMap("$listLocalSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions(List<String> users, List<String> dbs) {
        ArrayList<Utils.UtilsMap<String, String>> usersList = new ArrayList<Utils.UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(Utils.getMap(users.get(i), dbs.get(j)));
        }
        this.params.add(Utils.getMap("$listLocalSessions", Utils.getMap("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessionsAllUsers() {
        this.params.add(Utils.getMap("$listSessions", Utils.getMap("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions() {
        this.params.add(Utils.getMap("$listSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions(List<String> users, List<String> dbs) {
        ArrayList<Utils.UtilsMap<String, String>> usersList = new ArrayList<Utils.UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(Utils.getMap(users.get(i), dbs.get(j)));
        }
        this.params.add(Utils.getMap("$listSessions", Utils.getMap("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> lookup(Class fromType, Enum localField, Enum foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        return this.lookup(this.getMorphium().getMapper().getCollectionName(fromType), localField.name(), foreignField.name(), outputArray, pipeline, let);
    }

    @Override
    public Aggregator<T, R> lookup(String fromCollection, String localField, String foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        Utils.UtilsMap<String, String> m = Utils.getMap("from", fromCollection);
        if (localField != null) {
            m.add("localField", localField);
        }
        if (foreignField != null) {
            m.add("foreignField", foreignField);
        }
        if (outputArray != null) {
            m.add("as", outputArray);
        }
        if (pipeline != null && pipeline.size() > 0) {
            ArrayList<Expr> lst = new ArrayList<Expr>();
            for (Expr expr : pipeline) {
                lst.add(expr);
            }
            m.put("pipeline", (String)((Object)lst));
        }
        if (let != null) {
            HashMap map = new HashMap();
            for (Map.Entry entry : let.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            m.put("let", (String)((Object)map));
        }
        this.params.add(Utils.getMap("$lookup", m));
        return this;
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Map<String, Expr> let, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, let, matchAction, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection, Map<String, Expr> let, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        Utils.UtilsMap<String, Utils.UtilsMap<String, String>> doc = Utils.getMap("into", Utils.getMap("db", intoDb).add("collection", intoCollection));
        if (let != null) {
            doc.put("let", (Utils.UtilsMap<String, String>)Utils.getNoExprMap(let));
        }
        if (matchAction != null) {
            doc.put("whenMatched", (Utils.UtilsMap<String, String>)((Object)matchAction.name()));
        }
        if (notMatchedAction != null) {
            doc.put("whenNotMatched", (Utils.UtilsMap<String, String>)((Object)notMatchedAction.name()));
        }
        if (onFields != null && onFields.length != 0) {
            doc.put("on", (Utils.UtilsMap<String, String>)((Object)Arrays.asList(onFields)));
        }
        this.params.add(Utils.getMap("$merge", doc));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String collectionName) {
        this.params.add(Utils.getMap("$out", Utils.getMap("coll", collectionName)));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String db, String collectionName) {
        this.params.add(Utils.getMap("$out", Utils.getMap("coll", collectionName).add("db", db)));
        return this;
    }

    @Override
    public Aggregator<T, R> planCacheStats(Map<String, Object> param) {
        this.params.add(Utils.getMap("$planCacheStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> redact(Expr redact) {
        this.params.add(Utils.getMap("$redact", redact));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceRoot(Expr newRoot) {
        this.params.add(Utils.getMap("$replaceRoot", Utils.getMap("newRoot", newRoot)));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceWith(Expr newDoc) {
        this.params.add(Utils.getMap("$replaceWith", newDoc));
        return this;
    }

    @Override
    public Aggregator<T, R> sample(int sampleSize) {
        this.params.add(Utils.getMap("$sample", Utils.getMap("size", sampleSize)));
        return this;
    }

    @Override
    public Aggregator<T, R> set(Map<String, Expr> param) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$set", Utils.getQueryObjectMap(param));
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sortByCount(Expr sortby) {
        this.params.add(Utils.getMap("$sortByCount", sortby));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(String collection) {
        this.params.add(Utils.getMap("$unionWith", collection));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(Aggregator agg) {
        this.params.add(Utils.getMap("$unionWith", Utils.getMap("coll", this.collectionName).add("pipeline", (String)((Object)agg.getPipeline()))));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(List<String> field) {
        this.params.add(Utils.getMap("$unset", field));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(String ... param) {
        this.params.add(Utils.getMap("$unset", Arrays.asList(param)));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(Enum ... field) {
        List lst = Arrays.stream(field).map(Enum::name).collect(Collectors.toList());
        this.params.add(Utils.getMap("$unset", lst));
        return this;
    }

    @Override
    public Aggregator<T, R> genericStage(String stageName, Object param) {
        if (!(param instanceof Expr)) {
            throw new IllegalArgumentException("inMemAggregation only works with Expr");
        }
        if (!stageName.startsWith("$")) {
            stageName = "$" + stageName;
        }
        this.params.add(Utils.getMap(stageName, param));
        return this;
    }

    @Override
    public Aggregator<T, R> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    private List<Map<String, Object>> execStep(Map<String, Object> step, List<Map<String, Object>> data) {
        if (step.keySet().size() != 1) {
            throw new IllegalArgumentException("Pipeline start wrong");
        }
        String stage = (String)step.keySet().stream().findFirst().get();
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        block34 : switch (stage) {
            case "$set": 
            case "$project": 
            case "$addFields": {
                for (Map<String, Object> o : data) {
                    HashMap<String, Object> obj = new HashMap<String, Object>(o);
                    ret.add(obj);
                    Map op = (Map)step.get(stage);
                    for (String k : op.keySet()) {
                        Object value = op.get(k);
                        if (value instanceof String && ((String)value).startsWith("$")) {
                            obj.put(k, obj.get(((String)value).substring(1)));
                            continue;
                        }
                        if (value instanceof Expr) {
                            obj.put(k, ((Expr)value).evaluate(obj));
                            continue;
                        }
                        if (!(value instanceof Map)) continue;
                        for (String fld : ((Map)value).keySet()) {
                            if (obj.get(fld) instanceof Expr) {
                                obj.put(fld, ((Expr)obj.get(fld)).evaluate(obj));
                                continue;
                            }
                            this.log.error("InMemoryAggregation oly works with Expr");
                        }
                    }
                }
                break;
            }
            case "$group": {
                Map group = (Map)step.get(stage);
                HashMap res = new HashMap();
                for (Map<String, Object> obj : data) {
                    HashMap<String, Object> o = new HashMap<String, Object>(obj);
                    Object id = group.get("_id");
                    if (id instanceof Map) continue;
                    if (id.toString().startsWith("$")) {
                        id = o.get(id.toString().substring(1));
                    }
                    res.putIfAbsent(id, new HashMap());
                    ((Map)res.get(id)).putIfAbsent("_id", id);
                    block67: for (String fld : group.keySet()) {
                        Object opValue = group.get(fld);
                        if (opValue instanceof Map) {
                            String op;
                            switch (op = (String)((Map)opValue).keySet().stream().findFirst().get()) {
                                case "$accumulator": 
                                case "$addToSet": 
                                case "$avg": {
                                    ((Map)res.get(id)).putIfAbsent(fld, Utils.getMap("sum", 0).add("count", 0).add("avg", 0));
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        Number count = (Number)((Map)((Map)res.get(id)).get(fld)).get("count");
                                        count = count.intValue() + 1;
                                        ((Map)((Map)res.get(id)).get(fld)).put("count", count);
                                        Number current = (Number)((Map)((Map)res.get(id)).get(fld)).get("sum");
                                        Number v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        Double sum = current.doubleValue() + v.doubleValue();
                                        ((Map)((Map)res.get(id)).get(fld)).put("sum", sum);
                                        ((Map)((Map)res.get(id)).get(fld)).put("avg", sum / count.doubleValue());
                                        break;
                                    }
                                    this.log.error("Average with no $-reference?");
                                    break;
                                }
                                case "$first": {
                                    ((Map)res.get(id)).putIfAbsent(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case "$last": {
                                    ((Map)res.get(id)).put(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case "$max": {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block67;
                                    Object oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id)).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id)).get(fld)).compareTo(oVal) <= 0) continue block67;
                                    ((Map)res.get(id)).put(fld, oVal);
                                    break;
                                }
                                case "$min": {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block67;
                                    Object oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id)).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id)).get(fld)).compareTo(oVal) >= 0) continue block67;
                                    ((Map)res.get(id)).put(fld, oVal);
                                    break;
                                }
                                case "$mergeObjects": 
                                case "$push": 
                                case "$stdDevPop": 
                                case "$stdDevSamp": 
                                case "$sum": {
                                    Number v;
                                    ((Map)res.get(id)).putIfAbsent(fld, 0);
                                    Number current = (Number)((Map)res.get(id)).get(fld);
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (((Map)opValue).get(op) instanceof Number) {
                                        v = (Number)((Map)opValue).get(op);
                                        ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (!(((Map)opValue).get(op) instanceof Expr)) continue block67;
                                    v = (Number)o.get(((Expr)((Map)opValue).get(op)).evaluate(o));
                                    ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                    break;
                                }
                                default: {
                                    this.log.error("unknown accumulator " + op);
                                }
                            }
                            continue;
                        }
                        if (!(opValue instanceof String) || !opValue.toString().startsWith("$")) continue;
                        opValue = o.get(opValue.toString().substring(1));
                        ((Map)res.get(id)).put(fld, opValue);
                    }
                }
                for (Map<String, Object> v : res.values()) {
                    ret.add(v);
                }
                break;
            }
            case "$skip": 
            case "$limit": {
                Object op = step.get(stage);
                if (op instanceof Expr) {
                    op = ((Expr)op).evaluate(new HashMap<String, Object>());
                }
                int idx = ((Number)op).intValue();
                if (stage.equals("\u00a7limit")) {
                    ret.addAll(data.subList(0, idx));
                    break;
                }
                ret.addAll(data.subList(idx, data.size() - idx));
                break;
            }
            case "$match": {
                for (Map<String, Object> o : data) {
                    if (!QueryHelper.matchesQuery((Map)step.get(stage), o)) continue;
                    ret.add(o);
                }
                break;
            }
            case "$unwind": {
                Object op = step.get(stage);
                for (Map<String, Object> o : data) {
                    String n;
                    List lst;
                    if (op instanceof Map) {
                        op = ((Map)op).get("path");
                    }
                    if (op instanceof Expr) {
                        lst = (List)((Expr)op).evaluate(o);
                        n = ((Expr)op).toQueryObject().toString();
                    } else if (op instanceof String) {
                        if (op.toString().startsWith("$")) {
                            op = op.toString().substring(1);
                        }
                        n = op.toString();
                        lst = (List)o.get(op.toString());
                    } else {
                        this.log.error("Wrong reference: " + op);
                        break block34;
                    }
                    if (lst == null) break block34;
                    for (Object value : lst) {
                        HashMap<String, Object> result = new HashMap<String, Object>(o);
                        if (n.startsWith("$")) {
                            n = n.substring(1);
                        }
                        if (result.containsKey(n)) {
                            result.put(n, value);
                        } else {
                            result.put(new AnnotationAndReflectionHelper(true).convertCamelCase(n), value);
                        }
                        ret.add(result);
                    }
                }
                break;
            }
            default: {
                this.log.error("unhandled Aggregation stage " + stage);
            }
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> aggregateMap() {
        return this.doAggregation();
    }

    private List<Map<String, Object>> doAggregation() {
        List<Map<String, Object>> result = this.getMorphium().createQueryFor(this.getSearchType()).asMapList();
        for (Map<String, Object> step : this.getPipeline()) {
            result = this.execStep(step, result);
        }
        return result;
    }
}

