/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.mapping;

import de.caluga.morphium.Utils;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import de.caluga.morphium.query.geospatial.Geo;
import de.caluga.morphium.query.geospatial.GeoType;
import de.caluga.morphium.query.geospatial.LineString;
import de.caluga.morphium.query.geospatial.MultiLineString;
import de.caluga.morphium.query.geospatial.MultiPoint;
import de.caluga.morphium.query.geospatial.MultiPolygon;
import de.caluga.morphium.query.geospatial.Point;
import de.caluga.morphium.query.geospatial.Polygon;
import java.util.List;
import java.util.Map;

public class BsonGeoMapper
implements MorphiumTypeMapper<Geo> {
    @Override
    public Object marshall(Geo o) {
        return Utils.getMap("type", o.getType().getMongoName()).add("coordinates", (String)o.getCoordinates());
    }

    @Override
    public Geo unmarshall(Object d) {
        if (!(d instanceof Map)) {
            return null;
        }
        Map data = (Map)d;
        String type = data.get("type").toString();
        Enum ty = null;
        for (GeoType t : GeoType.values()) {
            if (!t.getMongoName().equals(type)) continue;
            ty = t;
            break;
        }
        Geo ret = null;
        switch (1.$SwitchMap$de$caluga$morphium$query$geospatial$GeoType[ty.ordinal()]) {
            case 1: {
                Point p = new Point();
                p.setCoordinates((List)data.get("coordinates"));
                ret = p;
                break;
            }
            case 2: {
                Polygon pl = new Polygon();
                pl.setCoordinates((List)data.get("coordinates"));
                ret = pl;
                break;
            }
            case 3: {
                LineString ls = new LineString();
                ls.setCoordinates((List)data.get("coordinates"));
                ret = ls;
                break;
            }
            case 4: {
                MultiPoint mp = new MultiPoint();
                mp.setCoordinates((List)data.get("coordinates"));
                ret = mp;
                break;
            }
            case 5: {
                MultiPolygon mpl = new MultiPolygon();
                mpl.setCoordinates((List)data.get("coordinates"));
                ret = mpl;
                break;
            }
            case 6: {
                MultiLineString mls = new MultiLineString();
                mls.setCoordinates((List)data.get("coordinates"));
                ret = mls;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported geo type");
            }
        }
        return ret;
    }
}

