/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.ClientSessionOptions;
import com.mongodb.CursorType;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TransactionOptions;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import com.mongodb.event.ConnectionAddedEvent;
import com.mongodb.event.ConnectionCheckOutFailedEvent;
import com.mongodb.event.ConnectionCheckOutStartedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClearedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionReadyEvent;
import com.mongodb.event.ConnectionRemovedEvent;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.mongodb.DriverHelper;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.driver.mongodb.MongoTransactionContext;
import de.caluga.morphium.driver.mongodb.MongodbBulkContext;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.PatternCodec;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDriver
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(MongoDriver.class);
    private String[] hostSeed;
    private int maxConnections = 100;
    private int minConnections = 10;
    private int maxConnectionLifetime = 60000;
    private int maxConnectionIdleTime = 20000;
    private int connectionTimeout = 1000;
    private int defaultW = 1;
    private int heartbeatFrequency = 1000;
    private boolean defaultJ = false;
    private int writeTimeout = 1000;
    private int localThreshold = 15;
    private boolean defaultFsync;
    private int maxWaitTime;
    private int serverSelectionTimeout;
    private int readTimeout = 1000;
    private boolean retryReads = false;
    private boolean retryWrites = false;
    private String uuidRepresentation;
    private boolean useSSL = false;
    private SSLContext sslContext = null;
    private boolean sslInvalidHostNameAllowed = false;
    private int defaultBatchSize = 100;
    private int retriesOnNetworkError = 2;
    private int sleepBetweenErrorRetries = 500;
    private ReadPreference defaultReadPreference;
    private Map<String, String[]> credentials = new HashMap<String, String[]>();
    private MongoClient mongo;
    private Maximums maximums;
    private final List<CommandListener> commandListeners = new Vector<CommandListener>();
    private final List<ClusterListener> clusterListeners = new Vector<ClusterListener>();
    private final List<ConnectionPoolListener> connectionPoolListeners = new Vector<ConnectionPoolListener>();
    private boolean replicaset;
    private final ThreadLocal<MongoTransactionContext> currentTransaction = new ThreadLocal();

    @Override
    public boolean isReplicaset() {
        return this.replicaset;
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
        String[] cred = new String[]{login, new String(pwd)};
        this.credentials.put(db, cred);
    }

    @Override
    public List<String> listDatabases() throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        HashMap<String, Object> command = new HashMap<String, Object>();
        command.put("listDatabases", 1);
        Map<String, Object> res = this.runCommand("admin", command);
        ArrayList<String> ret = new ArrayList<String>();
        if (res.get("databases") != null) {
            List lst = (List)res.get("databases");
            for (Map db : lst) {
                if (db.get("name") != null) {
                    ret.add(db.get("name").toString());
                    continue;
                }
                this.log.error("No DB Name for this entry...");
            }
        }
        return ret;
    }

    @Override
    public void addCommandListener(CommandListener cmd) {
        this.commandListeners.add(cmd);
    }

    @Override
    public void removeCommandListener(CommandListener cmd) {
        this.commandListeners.remove(cmd);
    }

    @Override
    public void addClusterListener(ClusterListener cl) {
        this.clusterListeners.add(cl);
    }

    @Override
    public void removeClusterListener(ClusterListener cl) {
        this.clusterListeners.remove(cl);
    }

    @Override
    public void addConnectionPoolListener(ConnectionPoolListener cpl) {
        this.connectionPoolListeners.add(cpl);
    }

    @Override
    public void removeConnectionPoolListener(ConnectionPoolListener cpl) {
        this.connectionPoolListeners.remove(cpl);
    }

    @Override
    public List<String> listCollections(String db, String pattern) throws MorphiumDriverException {
        if (!this.isConnected()) {
            return null;
        }
        LinkedHashMap<String, Object> command = new LinkedHashMap<String, Object>();
        command.put("listCollections", 1);
        if (pattern != null) {
            HashMap<String, Pattern> query = new HashMap<String, Pattern>();
            query.put("name", Pattern.compile(pattern));
            command.put("filter", query);
        }
        Map<String, Object> res = this.runCommand(db, command);
        ArrayList<Map<String, Object>> colList = new ArrayList<Map<String, Object>>();
        ArrayList<String> colNames = new ArrayList<String>();
        this.addToListFromCursor(db, colList, res);
        for (Map map : colList) {
            colNames.add(map.get("name").toString());
        }
        return colNames;
    }

    private void addToListFromCursor(String db, List<Map<String, Object>> data, Map<String, Object> res) throws MorphiumDriverException {
        boolean valid;
        Map<String, Object> crs = (Map<String, Object>)res.get("cursor");
        do {
            if (crs.get("firstBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            } else if (crs.get("nextBatch") != null) {
                data.addAll((List)crs.get("firstBatch"));
            }
            LinkedHashMap<String, Object> doc = new LinkedHashMap<String, Object>();
            if (crs.get("id") != null && !crs.get("id").toString().equals("0")) {
                valid = true;
                doc.put("getMore", crs.get("id"));
                crs = this.runCommand(db, doc);
                continue;
            }
            valid = false;
        } while (valid);
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    @Override
    public void setDefaultReadPreference(ReadPreference defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
    }

    @Override
    public String[] getCredentials(String db) {
        return this.credentials.get(db);
    }

    @Override
    public boolean isDefaultFsync() {
        return this.defaultFsync;
    }

    @Override
    public void setDefaultFsync(boolean j) {
        this.defaultFsync = j;
    }

    @Override
    public String[] getHostSeed() {
        return this.hostSeed;
    }

    @Override
    public void setHostSeed(String ... host) {
        this.hostSeed = host;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public int getMinConnections() {
        return this.minConnections;
    }

    @Override
    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    @Override
    public int getMaxConnectionLifetime() {
        return this.maxConnectionLifetime;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
        this.maxConnectionLifetime = timeout;
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
        this.maxConnectionIdleTime = time;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    @Override
    public int getDefaultW() {
        return this.defaultW;
    }

    @Override
    public void setDefaultW(int w) {
        this.defaultW = w;
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
        this.credentials = credentials;
    }

    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    @Override
    public boolean isRetryReads() {
        return this.retryReads;
    }

    @Override
    public void setRetryReads(boolean retryReads) {
        this.retryReads = retryReads;
    }

    @Override
    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    @Override
    public void setRetryWrites(boolean retryWrites) {
        this.retryWrites = retryWrites;
    }

    @Override
    public String getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    @Override
    public void setUuidRepresentation(String uuidRepresentation) {
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public boolean isUseSSL() {
        return this.useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public boolean isDefaultJ() {
        return this.defaultJ;
    }

    @Override
    public void setDefaultJ(boolean j) {
        this.defaultJ = j;
    }

    @Override
    public int getLocalThreshold() {
        return this.localThreshold;
    }

    @Override
    public void setLocalThreshold(int thr) {
        this.localThreshold = thr;
    }

    @Override
    public void heartBeatFrequency(int t) {
        this.heartbeatFrequency = t;
    }

    @Override
    public void useSsl(boolean ssl) {
        this.useSSL = ssl;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    @Override
    public void connect(String replicasetName) throws MorphiumDriverException {
        block10: {
            try {
                MongoClientSettings.Builder o = MongoClientSettings.builder();
                o.writeConcern(WriteConcern.getWc(this.getDefaultW(), this.isDefaultFsync(), this.isDefaultJ(), this.getDefaultWriteTimeout()).toMongoWriteConcern());
                o.retryReads(this.retryReads);
                o.retryWrites(this.retryWrites);
                o.addCommandListener(new CommandListener(){

                    public void commandStarted(CommandStartedEvent event) {
                        for (CommandListener cl : MongoDriver.this.commandListeners) {
                            cl.commandStarted(event);
                        }
                    }

                    public void commandSucceeded(CommandSucceededEvent event) {
                        for (CommandListener cl : MongoDriver.this.commandListeners) {
                            cl.commandSucceeded(event);
                        }
                    }

                    public void commandFailed(CommandFailedEvent event) {
                        for (CommandListener cl : MongoDriver.this.commandListeners) {
                            cl.commandFailed(event);
                        }
                    }
                });
                o.applyToSocketSettings(socketSettings -> {
                    socketSettings.connectTimeout(this.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                    socketSettings.readTimeout(this.getReadTimeout(), TimeUnit.MILLISECONDS);
                });
                o.applyToConnectionPoolSettings(connectionPoolSettings -> {
                    connectionPoolSettings.maxConnectionIdleTime((long)this.maxConnectionIdleTime, TimeUnit.MILLISECONDS);
                    connectionPoolSettings.maxConnectionLifeTime((long)this.maxConnectionLifetime, TimeUnit.MILLISECONDS);
                    connectionPoolSettings.maintenanceFrequency((long)this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
                    connectionPoolSettings.maxSize(this.maxConnections);
                    connectionPoolSettings.minSize(this.minConnections);
                    connectionPoolSettings.maxWaitTime((long)this.maxWaitTime, TimeUnit.MILLISECONDS);
                    connectionPoolSettings.addConnectionPoolListener(new ConnectionPoolListener(){

                        public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionPoolOpened(event);
                            }
                        }

                        public void connectionPoolCreated(ConnectionPoolCreatedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionPoolCreated(event);
                            }
                        }

                        public void connectionPoolCleared(ConnectionPoolClearedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionPoolCleared(event);
                            }
                        }

                        public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionPoolClosed(event);
                            }
                        }

                        public void connectionCheckOutStarted(ConnectionCheckOutStartedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionCheckOutStarted(event);
                            }
                        }

                        public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionCheckedOut(event);
                            }
                        }

                        public void connectionCheckOutFailed(ConnectionCheckOutFailedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionCheckOutFailed(event);
                            }
                        }

                        public void connectionCheckedIn(ConnectionCheckedInEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionCheckedIn(event);
                            }
                        }

                        public void connectionAdded(ConnectionAddedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionAdded(event);
                            }
                        }

                        public void connectionCreated(ConnectionCreatedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionCreated(event);
                            }
                        }

                        public void connectionReady(ConnectionReadyEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionReady(event);
                            }
                        }

                        public void connectionRemoved(ConnectionRemovedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionRemoved(event);
                            }
                        }

                        public void connectionClosed(ConnectionClosedEvent event) {
                            for (ConnectionPoolListener cpl : MongoDriver.this.connectionPoolListeners) {
                                cpl.connectionClosed(event);
                            }
                        }
                    });
                });
                o.applyToClusterSettings(clusterSettings -> {
                    clusterSettings.serverSelectionTimeout((long)this.getConnectionTimeout(), TimeUnit.MILLISECONDS);
                    if (this.hostSeed.length > 1) {
                        clusterSettings.mode(ClusterConnectionMode.MULTIPLE);
                    } else {
                        clusterSettings.mode(ClusterConnectionMode.SINGLE);
                    }
                    if (replicasetName != null) {
                        clusterSettings.requiredReplicaSetName(replicasetName);
                    }
                    ArrayList<ServerAddress> hosts = new ArrayList<ServerAddress>();
                    for (String host : this.hostSeed) {
                        hosts.add(new ServerAddress(host));
                    }
                    clusterSettings.hosts(hosts);
                    clusterSettings.serverSelectionTimeout((long)this.getServerSelectionTimeout(), TimeUnit.MILLISECONDS);
                    clusterSettings.localThreshold((long)this.getLocalThreshold(), TimeUnit.MILLISECONDS);
                    clusterSettings.addClusterListener(new ClusterListener(){

                        public void clusterOpening(ClusterOpeningEvent event) {
                            for (ClusterListener cl : MongoDriver.this.clusterListeners) {
                                cl.clusterOpening(event);
                            }
                        }

                        public void clusterClosed(ClusterClosedEvent event) {
                            for (ClusterListener cl : MongoDriver.this.clusterListeners) {
                                cl.clusterClosed(event);
                            }
                        }

                        public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
                            for (ClusterListener cl : MongoDriver.this.clusterListeners) {
                                cl.clusterDescriptionChanged(event);
                            }
                        }
                    });
                });
                if (this.isUseSSL()) {
                    o.applyToSslSettings(sslSettings -> {
                        sslSettings.enabled(true);
                        sslSettings.invalidHostNameAllowed(this.isSslInvalidHostNameAllowed());
                        sslSettings.context(this.getSslContext());
                    });
                }
                if (this.uuidRepresentation != null && !this.uuidRepresentation.isEmpty()) {
                    o.uuidRepresentation(UuidRepresentation.valueOf((String)this.uuidRepresentation));
                }
                for (Map.Entry<String, String[]> e : this.credentials.entrySet()) {
                    MongoCredential cred = MongoCredential.createCredential((String)e.getValue()[0], (String)e.getKey(), (char[])e.getValue()[1].toCharArray());
                    o.credential(cred);
                }
                this.mongo = MongoClients.create((MongoClientSettings)o.build());
                try {
                    Document res = this.mongo.getDatabase("local").runCommand((Bson)new BasicDBObject("isMaster", (Object)true));
                    if (res.get((Object)"setName") != null) {
                        this.replicaset = true;
                        if (this.hostSeed.length == 1) {
                            this.log.warn("have to reconnect to cluster... only one host specified, but its a replicaset");
                            o.applyToClusterSettings(builder -> builder.mode(ClusterConnectionMode.MULTIPLE));
                            this.mongo.close();
                            this.mongo = MongoClients.create((MongoClientSettings)o.build());
                        }
                    }
                }
                catch (MongoCommandException mce) {
                    if (mce.getCode() == 20) {
                        this.replicaset = false;
                        break block10;
                    }
                    throw new MorphiumDriverException("Error getting replicaset status", mce);
                }
            }
            catch (Exception e) {
                throw new MorphiumDriverException("Error creating connection to mongo", e);
            }
        }
    }

    @Override
    public Maximums getMaximums() {
        if (this.maximums == null) {
            this.maximums = new Maximums();
            try {
                HashMap<String, Object> cmd = new HashMap<String, Object>();
                cmd.put("isMaster", 1);
                Map<String, Object> res = this.runCommand("admin", cmd);
                this.maximums.setMaxBsonSize((Integer)res.get("maxBsonObjectSize"));
                this.maximums.setMaxMessageSize((Integer)res.get("maxMessageSizeBytes"));
                this.maximums.setMaxWriteBatchSize((Integer)res.get("maxWriteBatchSize"));
            }
            catch (Exception e) {
                this.log.error("Error reading max avalues from DB", (Throwable)e);
            }
        }
        return this.maximums;
    }

    @Override
    public boolean isConnected() {
        return this.mongo != null;
    }

    @Override
    public int getDefaultWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
        this.writeTimeout = wt;
    }

    @Override
    public void close() throws MorphiumDriverException {
        try {
            if (this.currentTransaction.get() != null) {
                this.log.warn("Closing while transaction in progress - aborting!");
                this.abortTransaction();
            }
            this.mongo.close();
            this.mongo = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        return (Map)DriverHelper.doCall(() -> {
            Document ret = this.mongo.getDatabase("admin").runCommand((Bson)new BasicDBObject("replSetGetStatus", (Object)1));
            List mem = (List)ret.get((Object)"members");
            if (mem == null) {
                return null;
            }
            mem.stream().filter(d -> d.get((Object)"optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get((Object)"optime")).get("ts")));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        return (Map)DriverHelper.doCall(() -> {
            Document ret = this.mongo.getDatabase(db).runCommand((Bson)new BasicDBObject("dbstats", (Object)1));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> getOps(long threshold) {
        throw new RuntimeException("Not implemented yet, sorry...");
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(cmd);
        return (Map)DriverHelper.doCall(() -> {
            Document ret = this.currentTransaction.get() != null ? this.mongo.getDatabase(db).runCommand(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(cmd)) : this.mongo.getDatabase(db).runCommand((Bson)new BasicDBObject(cmd));
            return this.convertBSON((Map)ret);
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public MorphiumCursor initAggregationIteration(String db, String collection, List<Map<String, Object>> aggregationPipeline, ReadPreference readPreference, Collation collation, int batchSize, Map<String, Object> findMetaData) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(aggregationPipeline);
        return (MorphiumCursor)DriverHelper.doCall(() -> {
            AggregateIterable it;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> c = this.getCollection(database, collection, readPreference, null);
            ArrayList pipe = new ArrayList();
            aggregationPipeline.stream().forEach(x -> pipe.add(new BasicDBObject(x)));
            AggregateIterable aggregateIterable = it = this.currentTransaction.get() == null ? c.aggregate(pipe) : c.aggregate(this.currentTransaction.get().getSession(), pipe);
            if (batchSize != 0) {
                it.batchSize(batchSize);
            } else {
                it.batchSize(this.defaultBatchSize);
            }
            if (collation != null) {
                com.mongodb.client.model.Collation col = this.getCollation(collation);
                it.collation(col);
            }
            MongoCursor ret = it.iterator();
            this.handleMetaData(findMetaData, (MongoCursor<Document>)ret);
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
                int cnt = values.size();
                if ((cnt < batchSize || batchSize == 0) && (cnt < 1000 || batchSize != 0)) continue;
                break;
            }
            MorphiumCursor crs = new MorphiumCursor();
            crs.setBatchSize(batchSize);
            if (values.size() < batchSize || values.size() < 1000 && batchSize == 0) {
                ret.close();
            } else {
                crs.setInternalCursorObject(ret);
            }
            crs.setBatch(values);
            return crs;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Collation collation, Map<String, Object> findMetaData) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return (MorphiumCursor)DriverHelper.doCall(() -> {
            FindIterable it;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> c = this.getCollection(database, collection, readPreference, null);
            FindIterable findIterable = it = this.currentTransaction.get() == null ? c.find((Bson)new BasicDBObject(query)) : c.find(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
            if (projection != null && !projection.isEmpty()) {
                it.projection((Bson)new BasicDBObject(projection));
            }
            if (sort != null && !sort.isEmpty()) {
                it.sort((Bson)new BasicDBObject(sort));
            }
            if (skip != 0) {
                it.skip(skip);
            }
            if (limit != 0) {
                it.limit(limit);
            }
            if (batchSize != 0) {
                it.batchSize(batchSize);
            } else {
                it.batchSize(this.defaultBatchSize);
            }
            if (collation != null) {
                com.mongodb.client.model.Collation col = this.getCollation(collation);
                it.collation(col);
            }
            MongoCursor ret = it.iterator();
            this.handleMetaData(findMetaData, (MongoCursor<Document>)ret);
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
                int cnt = values.size();
                if ((cnt < batchSize || batchSize == 0) && (cnt < 1000 || batchSize != 0)) continue;
                break;
            }
            MorphiumCursor crs = new MorphiumCursor();
            crs.setBatchSize(batchSize);
            if (values.size() < batchSize || values.size() < 1000 && batchSize == 0) {
                ret.close();
            } else {
                crs.setInternalCursorObject(ret);
            }
            crs.setBatch(values);
            return crs;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void watch(String db, int maxWaitTime, boolean fullDocumentOnUpdate, List<Map<String, Object>> pipeline, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        this.watch(db, null, maxWaitTime, fullDocumentOnUpdate, pipeline, cb);
    }

    private void processChangeStreamEvent(DriverTailableIterationCallback cb, ChangeStreamDocument<Document> doc, long start) {
        try {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("clusterTime", Objects.requireNonNull(doc.getClusterTime()).getValue());
            if (doc.getDocumentKey().get((Object)"_id") instanceof BsonNull) {
                return;
            }
            if (doc.getDocumentKey() != null && doc.getDocumentKey().get((Object)"_id") instanceof BsonObjectId) {
                obj.put("documentKey", new MorphiumId(((BsonObjectId)doc.getDocumentKey().get((Object)"_id")).getValue().toByteArray()));
            }
            obj.put("operationType", doc.getOperationType().getValue());
            if (doc.getFullDocument() != null) {
                obj.put("fullDocument", new LinkedHashMap((Map)doc.getFullDocument()));
            }
            if (doc.getResumeToken() != null) {
                obj.put("resumeToken", new LinkedHashMap(doc.getResumeToken()));
            }
            if (doc.getNamespace() != null) {
                obj.put("collectionName", doc.getNamespace().getCollectionName());
                obj.put("dbName", doc.getNamespace().getDatabaseName());
            }
            if (doc.getUpdateDescription() != null) {
                obj.put("removedFields", doc.getUpdateDescription().getRemovedFields());
                obj.put("updatedFields", new LinkedHashMap(doc.getUpdateDescription().getUpdatedFields()));
            }
            DriverHelper.replaceBsonValues(obj);
            cb.incomingData(obj, System.currentTimeMillis() - start);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void watch(String db, String collection, int maxWaitTime, boolean fullDocumentOnUpdate, List<Map<String, Object>> pipeline, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            List p;
            if (pipeline == null) {
                p = Collections.emptyList();
            } else {
                p = new ArrayList();
                for (Map o : pipeline) {
                    p.add(new BasicDBObject(o));
                }
            }
            while (cb.isContinued() && this.mongo != null) {
                ChangeStreamIterable it = collection != null ? this.mongo.getDatabase(db).getCollection(collection).watch(p) : this.mongo.getDatabase(db).watch(p);
                it.maxAwaitTime((long)maxWaitTime, TimeUnit.MILLISECONDS);
                it.batchSize(this.defaultBatchSize);
                it.fullDocument(fullDocumentOnUpdate ? FullDocument.UPDATE_LOOKUP : FullDocument.DEFAULT);
                MongoCursor iterator = it.iterator();
                long start = System.currentTimeMillis();
                while (cb.isContinued() && this.mongo != null) {
                    ChangeStreamDocument doc = (ChangeStreamDocument)iterator.tryNext();
                    if (doc == null) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (!cb.isContinued()) continue;
                    this.processChangeStreamEvent(cb, (ChangeStreamDocument<Document>)doc, start);
                }
                iterator.close();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        DriverHelper.doCall(() -> {
            FindIterable ret;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> coll = this.getCollection(database, collection, readPreference, null);
            FindIterable findIterable = ret = this.currentTransaction.get() == null ? coll.find((Bson)new BasicDBObject(query)) : coll.find(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
            if (projection != null) {
                ret.projection((Bson)new BasicDBObject(projection));
            }
            if (sort != null) {
                ret = ret.sort((Bson)new BasicDBObject(sort));
            }
            if (skip != 0) {
                ret = ret.skip(skip);
            }
            if (limit != 0) {
                ret = ret.limit(limit);
            }
            if (batchSize != 0) {
                ret.batchSize(batchSize);
            } else {
                ret.batchSize(this.defaultBatchSize);
            }
            ret.cursorType(CursorType.TailableAwait);
            if (timeout == 0) {
                ret.noCursorTimeout(true);
            } else {
                ret.maxAwaitTime((long)timeout, TimeUnit.MILLISECONDS);
                ret.maxTime((long)timeout, TimeUnit.MILLISECONDS);
            }
            long start = System.currentTimeMillis();
            for (Document d : ret) {
                if (this.mongo == null || d == null) break;
                Map<String, Object> obj = this.convertBSON((Map)d);
                cb.incomingData(obj, System.currentTimeMillis() - start);
                if (cb.isContinued()) continue;
                break;
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    private void handleMetaData(Map<String, Object> findMetaData, MongoCursor<Document> ret) {
        if (findMetaData != null) {
            if (ret.getServerAddress() != null) {
                findMetaData.put("server", ret.getServerAddress().getHost() + ":" + ret.getServerAddress().getPort());
            }
            if (ret.getServerCursor() != null) {
                findMetaData.put("cursorId", ret.getServerCursor().getId());
            }
        }
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        return (MorphiumCursor)DriverHelper.doCall(() -> {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            int batchSize = crs.getBatchSize();
            MongoCursor ret = (MongoCursor)crs.getInternalCursorObject();
            if (ret == null) {
                return null;
            }
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
                int cnt = values.size();
                if (cnt >= batchSize && batchSize != 0 || cnt >= 1000 && batchSize == 0) break;
                if (this.mongo != null) continue;
                return null;
            }
            MorphiumCursor crs1 = new MorphiumCursor();
            crs1.setBatchSize(batchSize);
            if (batchSize != 0 && values.size() < batchSize || batchSize == 0 && values.size() < 1000) {
                ret.close();
            } else {
                crs1.setInternalCursorObject(ret);
            }
            crs1.setBatch(values);
            return crs1;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            if (crs != null) {
                MongoCursor ret = (MongoCursor)crs.getInternalCursorObject();
                ret.close();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Collation collation, Map<String, Object> findMetaData) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return (List)DriverHelper.doCall(() -> {
            FindIterable it;
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection<Document> coll = this.getCollection(database, collection, this.currentTransaction.get() == null ? readPreference : ReadPreference.primary(), null);
            FindIterable findIterable = it = this.currentTransaction.get() == null ? coll.find((Bson)new BasicDBObject(query)) : coll.find(this.currentTransaction.get().session, (Bson)new BasicDBObject(query));
            if (projection != null) {
                it.projection((Bson)new BasicDBObject(projection));
            }
            if (sort != null) {
                it.sort((Bson)new BasicDBObject(sort));
            }
            if (skip != 0) {
                it.skip(skip);
            }
            if (limit != 0) {
                it.limit(limit);
            }
            if (batchSize != 0) {
                it.batchSize(batchSize);
            } else {
                it.batchSize(this.defaultBatchSize);
            }
            it.maxAwaitTime((long)this.getMaxWaitTime(), TimeUnit.MILLISECONDS);
            it.maxTime((long)this.getMaxWaitTime(), TimeUnit.MILLISECONDS);
            if (collation != null) {
                com.mongodb.client.model.Collation col = this.getCollation(collation);
                it.collation(col);
            }
            MongoCursor ret = it.iterator();
            this.handleMetaData(findMetaData, (MongoCursor<Document>)ret);
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            while (ret.hasNext()) {
                Document d = (Document)ret.next();
                Map<String, Object> obj = this.convertBSON((Map)d);
                values.add(obj);
            }
            ret.close();
            return values;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    private com.mongodb.client.model.Collation getCollation(Collation collation) {
        if (collation == null) {
            return null;
        }
        Collation.Builder bld = com.mongodb.client.model.Collation.builder();
        if (collation.getLocale() != null) {
            bld.locale(collation.getLocale());
        } else {
            bld.locale("simple");
        }
        if (collation.getBackwards() != null) {
            bld.backwards(collation.getBackwards());
        }
        if (collation.getCaseLevel() != null) {
            bld.caseLevel(collation.getCaseLevel());
        }
        if (collation.getAlternate() != null) {
            bld.collationAlternate(collation.getAlternate().equals((Object)Collation.Alternate.NON_IGNORABLE) ? CollationAlternate.NON_IGNORABLE : CollationAlternate.SHIFTED);
        }
        if (collation.getCaseFirst() != null) {
            bld.collationCaseFirst(CollationCaseFirst.fromString((String)collation.getCaseFirst().getMongoText()));
        }
        if (collation.getMaxVariable() != null) {
            bld.collationMaxVariable(CollationMaxVariable.fromString((String)collation.getMaxVariable().getMongoText()));
        }
        if (collation.getStrength() != null) {
            bld.collationStrength(CollationStrength.fromInt((int)collation.getStrength().getMongoValue()));
        }
        return bld.build();
    }

    private <E> Map<String, Object> convertBSON(Map<String, E> d) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        for (Map.Entry<String, E> entry : d.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BsonTimestamp) {
                value = ((BsonTimestamp)value).getTime() * 1000;
            } else if (value instanceof BsonDocument) {
                value = this.convertBSON((Map<String, E>)((BsonDocument)value));
            } else if (value instanceof BsonBoolean) {
                value = ((BsonBoolean)value).getValue();
            } else if (value instanceof BsonDateTime) {
                value = ((BsonDateTime)value).getValue();
            } else if (value instanceof BsonInt32) {
                value = ((BsonInt32)value).getValue();
            } else if (value instanceof BsonInt64) {
                value = ((BsonInt64)value).getValue();
            } else if (value instanceof BsonDouble) {
                value = ((BsonDouble)value).getValue();
            } else if (value instanceof BsonUndefined) {
                value = null;
            } else if (value instanceof BsonRegularExpression) {
                BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)value;
                try {
                    Method getOptionsAsIntMethod = PatternCodec.class.getDeclaredMethod("getOptionsAsInt", BsonRegularExpression.class);
                    getOptionsAsIntMethod.setAccessible(true);
                    value = Pattern.compile(bsonRegularExpression.getPattern(), (Integer)getOptionsAsIntMethod.invoke(null, bsonRegularExpression));
                }
                catch (Exception e) {
                    this.log.debug(e.toString(), (Throwable)e);
                }
            } else if (value instanceof ObjectId) {
                value = new MorphiumId(((ObjectId)value).toByteArray());
            } else if (value instanceof BasicDBList) {
                value = this.convertBSON(Collections.singletonMap("list", new ArrayList((BasicDBList)value))).get("list");
            } else if (value instanceof BasicBSONObject || value instanceof Document || value instanceof BSONObject) {
                value = this.convertBSON((Map)value);
            } else if (value instanceof Binary) {
                Binary b = (Binary)value;
                value = b.getData();
            } else if (value instanceof BsonString) {
                value = value.toString();
            } else if (value instanceof List) {
                ArrayList<Object> v = new ArrayList<Object>();
                for (Object o : (List)value) {
                    if (o instanceof BSONObject || o instanceof BsonValue || o instanceof Map) {
                        v.add(this.convertBSON((Map)o));
                        continue;
                    }
                    if (o instanceof ObjectId) {
                        v.add(new MorphiumId(((ObjectId)o).toString()));
                        continue;
                    }
                    v.add(o);
                }
                value = v;
            } else if (value instanceof BsonArray) {
                value = this.convertBSON(Collections.singletonMap("list", new ArrayList(((BsonArray)value).getValues()))).get("list");
            } else if (value instanceof Document) {
                value = this.convertBSON((Map<String, E>)((Document)value));
            } else if (value instanceof BSONObject) {
                value = this.convertBSON((Map)value);
            }
            obj.put(entry.getKey(), value);
        }
        return obj;
    }

    public MongoCollection<Document> getCollection(MongoDatabase database, String collection, ReadPreference readPreference, WriteConcern wc) {
        MongoCollection coll = database.getCollection(collection);
        if (readPreference == null) {
            readPreference = this.defaultReadPreference;
        }
        if (readPreference != null) {
            com.mongodb.ReadPreference prf;
            TagSet tags = null;
            if (readPreference.getTagSet() != null) {
                List tagList = readPreference.getTagSet().entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
                tags = new TagSet(tagList);
            }
            switch (readPreference.getType()) {
                case NEAREST: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.nearest(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.nearest();
                    break;
                }
                case PRIMARY: {
                    prf = com.mongodb.ReadPreference.primary();
                    if (tags == null) break;
                    this.log.warn("Cannot use tags with primary only read preference!");
                    break;
                }
                case PRIMARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.primaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.primaryPreferred();
                    break;
                }
                case SECONDARY: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondary(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondary();
                    break;
                }
                case SECONDARY_PREFERRED: {
                    if (tags != null) {
                        prf = com.mongodb.ReadPreference.secondaryPreferred(tags);
                        break;
                    }
                    prf = com.mongodb.ReadPreference.secondaryPreferred();
                    break;
                }
                default: {
                    this.log.error("Unhandeled read preference: " + readPreference.toString());
                    prf = null;
                }
            }
            if (prf != null) {
                coll = coll.withReadPreference(prf);
            }
        }
        if (wc != null) {
            com.mongodb.WriteConcern writeConcern = wc.getW() < 0 ? com.mongodb.WriteConcern.MAJORITY : wc.toMongoWriteConcern();
            coll = coll.withWriteConcern(writeConcern);
        }
        return coll;
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, Collation collation, ReadPreference rp) {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        MongoDatabase database = this.mongo.getDatabase(db);
        MongoCollection<Document> coll = this.getCollection(database, collection, rp, null);
        CountOptions co = new CountOptions();
        if (collation != null) {
            com.mongodb.client.model.Collation col = this.getCollation(collation);
            co.collation(col);
        }
        if (this.currentTransaction.get() != null) {
            if (collation != null) {
                return coll.countDocuments(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), co);
            }
            return coll.countDocuments(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
        }
        if (collation != null) {
            return coll.countDocuments((Bson)new BasicDBObject(query), co);
        }
        return coll.countDocuments((Bson)new BasicDBObject(query));
    }

    @Override
    public long estimatedDocumentCount(String db, String collection, ReadPreference rp) {
        MongoDatabase database = this.mongo.getDatabase(db);
        MongoCollection<Document> coll = this.getCollection(database, collection, rp, null);
        return coll.estimatedDocumentCount();
    }

    @Override
    public Map<String, Integer> store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        return (Map)DriverHelper.doCall(() -> {
            DriverHelper.replaceMorphiumIdByObjectId(objs);
            MongoCollection c = this.mongo.getDatabase(db).getCollection(collection);
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            int total = objs.size();
            int updated = 0;
            for (Map toUpdate : objs) {
                UpdateOptions o = new UpdateOptions();
                Document filter = new Document();
                o.upsert(true);
                Object id = toUpdate.get("_id");
                if (id instanceof MorphiumId) {
                    id = new ObjectId(id.toString());
                }
                filter.put("_id", id);
                if (toUpdate.get("morphium version") != null) {
                    filter.put("morphium version", toUpdate.get("morphium version"));
                    toUpdate.put("morphium version", (Long)toUpdate.get("morphium version") + 1L);
                }
                Document tDocument = new Document(toUpdate);
                for (String k : tDocument.keySet()) {
                    if (!(tDocument.get((Object)k) instanceof byte[])) continue;
                    BsonBinary b = new BsonBinary((byte[])tDocument.get((Object)k));
                    tDocument.put(k, (Object)b);
                }
                tDocument.remove((Object)"_id");
                try {
                    ReplaceOptions r = new ReplaceOptions();
                    r.upsert(true);
                    UpdateResult res = this.currentTransaction.get() == null ? c.replaceOne((Bson)filter, (Object)tDocument, r) : c.replaceOne(this.currentTransaction.get().getSession(), (Bson)filter, (Object)tDocument, r);
                    updated = (int)((long)updated + res.getModifiedCount());
                    id = toUpdate.get("_id");
                    if (id instanceof ObjectId) {
                        toUpdate.put("_id", new MorphiumId(((ObjectId)id).toHexString()));
                    }
                    if (toUpdate.get("morphium version") == null || res.getModifiedCount() != 0L) continue;
                    throw new MorphiumDriverException("Version mismatch!");
                }
                catch (MongoWriteException e) {
                    if (!e.getMessage().contains("E11000 duplicate key error")) continue;
                    throw new ConcurrentModificationException("Version mismach - write failed", e);
                }
            }
            ret.put("total", total);
            ret.put("modified", updated);
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(objs);
        if (objs == null || objs.isEmpty()) {
            return;
        }
        List lst = objs.stream().map(Document::new).collect(Collectors.toList());
        for (Document d : lst) {
            for (String k : d.keySet()) {
                if (!(d.get((Object)k) instanceof byte[])) continue;
                BsonBinary b = new BsonBinary((byte[])d.get((Object)k));
                d.put(k, (Object)b);
            }
        }
        DriverHelper.doCall(() -> {
            MongoCollection c = this.mongo.getDatabase(db).getCollection(collection);
            if (lst.size() == 1) {
                InsertOneOptions op = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                if (this.currentTransaction.get() == null) {
                    c.insertOne(lst.get(0), op);
                } else {
                    c.insertOne(this.currentTransaction.get().getSession(), lst.get(0), op);
                }
            } else {
                InsertManyOptions imo = new InsertManyOptions();
                imo.ordered(false);
                imo.bypassDocumentValidation(Boolean.valueOf(true));
                if (this.currentTransaction.get() == null) {
                    c.insertMany(lst, imo);
                } else {
                    c.insertMany(this.currentTransaction.get().getSession(), lst, imo);
                }
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> op, boolean multiple, boolean upsert, Collation collation, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        DriverHelper.replaceMorphiumIdByObjectId(op);
        return (Map)DriverHelper.doCall(() -> {
            UpdateOptions opts = new UpdateOptions();
            com.mongodb.WriteConcern w = null;
            w = wc == null ? WriteConcern.getWc(this.getDefaultW(), this.isDefaultFsync(), this.isDefaultJ(), this.getDefaultWriteTimeout()).toMongoWriteConcern() : wc.toMongoWriteConcern();
            if (collation != null) {
                com.mongodb.client.model.Collation col = this.getCollation(collation);
                opts.collation(col);
            }
            opts.upsert(upsert);
            UpdateResult res = multiple ? (this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateMany((Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts) : this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateMany(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts)) : (this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateOne((Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts) : this.mongo.getDatabase(db).getCollection(collection).withWriteConcern(w).updateOne(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Bson)new BasicDBObject(op), opts));
            HashMap<String, Constable> ret = new HashMap<String, Constable>();
            if (w.isAcknowledged()) {
                ret.put("matched", Long.valueOf(res.getMatchedCount()));
                ret.put("modified", Long.valueOf(res.getModifiedCount()));
                ret.put("acc", Boolean.valueOf(res.wasAcknowledged()));
            }
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, Collation collation, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(query);
        return (Map)DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection coll = database.getCollection(collection);
            DeleteOptions opts = new DeleteOptions();
            if (collation != null) {
                com.mongodb.client.model.Collation col = this.getCollation(collation);
                opts.collation(col);
            }
            DeleteResult res = multiple ? (this.currentTransaction.get() == null ? coll.deleteMany((Bson)new BasicDBObject(query), opts) : coll.deleteMany(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), opts)) : (this.currentTransaction.get() == null ? coll.deleteOne((Bson)new BasicDBObject(query), opts) : coll.deleteOne(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), opts));
            HashMap<String, Constable> r = new HashMap<String, Constable>();
            r.put("deleted", Long.valueOf(res.getDeletedCount()));
            r.put("acc", Boolean.valueOf(res.wasAcknowledged()));
            return r;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            MongoCollection coll = database.getCollection(collection);
            if (this.currentTransaction.get() != null) {
                coll.drop(this.currentTransaction.get().getSession());
            } else {
                coll.drop();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public void drop(String db, WriteConcern wc) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            MongoDatabase database = this.mongo.getDatabase(db);
            if (wc != null) {
                com.mongodb.WriteConcern writeConcern = wc.toMongoWriteConcern();
                database = database.withWriteConcern(writeConcern);
            }
            if (this.currentTransaction.get() != null) {
                database.drop(this.currentTransaction.get().getSession());
            } else {
                database.drop();
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public boolean exists(String db) {
        for (String dbName : this.mongo.listDatabaseNames()) {
            if (!dbName.equals(db)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, Collation collation, ReadPreference rp) throws MorphiumDriverException {
        DriverHelper.replaceMorphiumIdByObjectId(filter);
        ArrayList<Object> ret = new ArrayList<Object>();
        DriverHelper.doCall(() -> {
            if (this.currentTransaction.get() == null) {
                List<Map<String, Object>> r = this.find(db, collection, filter, null, (Map<String, Object>)new BasicDBObject(field, (Object)1), 0, 1, 1, this.defaultReadPreference, collation, null);
                if (r == null || r.size() == 0) {
                    return null;
                }
                DistinctIterable lst = this.getCollection(this.mongo.getDatabase(db), collection, this.getDefaultReadPreference(), null).distinct(field, (Bson)new BasicDBObject(filter), r.get(0).get(field).getClass());
                for (Object o : lst) {
                    ret.add(o);
                }
            } else {
                List<Map<String, Object>> r = this.find(db, collection, filter, null, (Map<String, Object>)new BasicDBObject(field, (Object)1), 0, 1, 1, this.defaultReadPreference, collation, null);
                if (r == null || r.size() == 0) {
                    return null;
                }
                DistinctIterable it = this.getCollection(this.mongo.getDatabase(db), collection, this.getDefaultReadPreference(), null).distinct(this.currentTransaction.get().getSession(), field, (Bson)new BasicDBObject(filter), r.get(0).get(field).getClass());
                if (collation != null) {
                    com.mongodb.client.model.Collation col = this.getCollation(collation);
                    it.collation(col);
                }
                for (Object d : it) {
                    ret.add(d);
                }
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        return ret;
    }

    @Override
    public boolean exists(String db, String collection) throws MorphiumDriverException {
        Map found = (Map)DriverHelper.doCall(() -> {
            for (Document d : this.mongo.getDatabase(db).listCollections()) {
                if (!d.get((Object)"name").equals(collection)) continue;
                return d;
            }
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
        return found != null && !found.isEmpty();
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) throws MorphiumDriverException {
        return (List)DriverHelper.doCall(() -> {
            ArrayList values = new ArrayList();
            ListIndexesIterable indexes = this.currentTransaction.get() != null ? this.mongo.getDatabase(db).getCollection(collection).listIndexes(this.currentTransaction.get().getSession()) : this.mongo.getDatabase(db).getCollection(collection).listIndexes();
            for (Document d : indexes) {
                values.add(new HashMap(d));
            }
            return values;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public List<String> getCollectionNames(String db) throws MorphiumDriverException {
        return (List)DriverHelper.doCall(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.currentTransaction.get() == null) {
                for (String c : this.mongo.getDatabase(db).listCollectionNames()) {
                    ret.add(c);
                }
            } else {
                for (String c : this.mongo.getDatabase(db).listCollectionNames(this.currentTransaction.get().getSession())) {
                    ret.add(c);
                }
            }
            return ret;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public Map<String, Object> findAndOneAndDelete(String db, String col, Map<String, Object> query, Map<String, Integer> sort, Collation collation) {
        Document ret;
        DriverHelper.replaceMorphiumIdByObjectId(query);
        FindOneAndDeleteOptions opts = new FindOneAndDeleteOptions();
        if (collation != null) {
            com.mongodb.client.model.Collation c = this.getCollation(collation);
            opts.collation(c);
        }
        if (sort != null) {
            opts.sort((Bson)new BasicDBObject(sort));
        }
        if (this.currentTransaction.get() != null) {
            ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndDelete(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query));
            return this.convertBSON((Map)ret);
        }
        ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndDelete((Bson)new BasicDBObject(query));
        return this.convertBSON((Map)ret);
    }

    @Override
    public Map<String, Object> findAndOneAndUpdate(String db, String col, Map<String, Object> query, Map<String, Object> update, Map<String, Integer> sort, Collation collation) {
        Document ret;
        DriverHelper.replaceMorphiumIdByObjectId(query);
        FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions();
        if (collation != null) {
            com.mongodb.client.model.Collation c = this.getCollation(collation);
            opts.collation(c);
        }
        if (sort != null) {
            opts.sort((Bson)new BasicDBObject(sort));
        }
        if (this.currentTransaction.get() != null) {
            ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndUpdate(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Bson)new BasicDBObject(update), opts);
            return this.convertBSON((Map)ret);
        }
        ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndUpdate((Bson)new BasicDBObject(query), (Bson)new BasicDBObject(update), opts);
        return this.convertBSON((Map)ret);
    }

    @Override
    public Map<String, Object> findAndOneAndReplace(String db, String col, Map<String, Object> query, Map<String, Object> replacement, Map<String, Integer> sort, Collation collation) {
        Document ret;
        DriverHelper.replaceMorphiumIdByObjectId(query);
        FindOneAndReplaceOptions opts = new FindOneAndReplaceOptions();
        if (collation != null) {
            com.mongodb.client.model.Collation c = this.getCollation(collation);
            opts.collation(c);
        }
        if (sort != null) {
            opts.sort((Bson)new BasicDBObject(sort));
        }
        if (this.currentTransaction.get() != null) {
            ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndReplace(this.currentTransaction.get().getSession(), (Bson)new BasicDBObject(query), (Object)new Document(replacement), opts);
            return this.convertBSON((Map)ret);
        }
        ret = (Document)this.mongo.getDatabase(db).getCollection(col).findOneAndReplace((Bson)new BasicDBObject(query), (Object)new Document(replacement), opts);
        return this.convertBSON((Map)ret);
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, Collation collation, ReadPreference readPreference) {
        DriverHelper.replaceMorphiumIdByObjectId(pipeline);
        List list = pipeline.stream().map(BasicDBObject::new).collect(Collectors.toList());
        if (explain) {
            throw new IllegalArgumentException("Not implemented yet!");
        }
        MongoCollection<Document> c = this.getCollection(this.mongo.getDatabase(db), collection, this.getDefaultReadPreference(), null);
        AggregateIterable it = this.currentTransaction.get() == null ? c.aggregate(list, Document.class) : c.aggregate(this.currentTransaction.get().getSession(), list, Document.class);
        it.allowDiskUse(Boolean.valueOf(allowDiskUse));
        if (collation != null) {
            com.mongodb.client.model.Collation col = this.getCollation(collation);
            it.collation(col);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Document doc : it) {
            result.add(this.convertBSON((Map)doc));
        }
        return result;
    }

    @Override
    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    @Override
    public int getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    @Override
    public void setServerSelectionTimeout(int serverSelectionTimeout) {
        this.serverSelectionTimeout = serverSelectionTimeout;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    @Override
    public void setRetriesOnNetworkError(int retriesOnNetworkError) {
        this.retriesOnNetworkError = retriesOnNetworkError;
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return this.sleepBetweenErrorRetries;
    }

    @Override
    public void setSleepBetweenErrorRetries(int sleepBetweenErrorRetries) {
        this.sleepBetweenErrorRetries = sleepBetweenErrorRetries;
    }

    public Map<String, Object> getCollectionStats(String db, String coll, int scale, boolean verbose) throws MorphiumDriverException {
        Map<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("collStats", coll);
        cmd.put("scale", scale);
        cmd.put("verbose", verbose);
        cmd = this.runCommand(db, cmd);
        return cmd;
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        Object capped = this.getCollectionStats(db, coll, 1024, false).get("capped");
        if (capped == null) {
            return false;
        }
        if (capped instanceof String) {
            return capped.equals("true");
        }
        return capped.equals(Boolean.TRUE) || capped.equals(1) || capped.equals(true);
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, String db, String collection, boolean ordered, WriteConcern wc) {
        return new MongodbBulkContext(m, db, collection, this, ordered, wc);
    }

    public MongoDatabase getDb(String db) {
        return this.mongo.getDatabase(db);
    }

    public MongoCollection<Document> getCollection(String db, String coll) {
        return this.mongo.getDatabase(db).getCollection(coll);
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) throws MorphiumDriverException {
        DriverHelper.doCall(() -> {
            IndexOptions options1 = new IndexOptions();
            Method[] methods = IndexOptions.class.getMethods();
            if (options != null) {
                for (Map.Entry opt : options.entrySet()) {
                    if (((String)opt.getKey()).equals("")) continue;
                    try {
                        String name = (String)opt.getKey();
                        if (name.equals("expireAfterSeconds")) {
                            options1.expireAfter(Long.valueOf(((Integer)opt.getValue()).longValue()), TimeUnit.SECONDS);
                            continue;
                        }
                        Method method = null;
                        for (Method m : methods) {
                            if (!m.getName().equals(opt.getKey())) continue;
                            method = m;
                            break;
                        }
                        method.setAccessible(true);
                        Object val = opt.getValue();
                        if (!method.getParameterTypes()[0].equals(opt.getValue().getClass()) && (method.getParameterTypes()[0].equals(Boolean.TYPE) || method.getParameterTypes()[0].equals(Boolean.class))) {
                            val = val.equals("true") || val.equals(1);
                        }
                        method.invoke((Object)options1, val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.info("Could not find setting: " + (String)opt.getKey());
                    }
                }
            }
            this.mongo.getDatabase(db).getCollection(collection).createIndex((Bson)new BasicDBObject(index), options1);
            return null;
        }, this.retriesOnNetworkError, this.sleepBetweenErrorRetries);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) {
        return this.mapReduce(db, collection, mapping, reducing, null, null, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) {
        return this.mapReduce(db, collection, mapping, reducing, query, null, null);
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting, Collation collation) {
        MapReduceIterable res = this.currentTransaction.get() == null ? this.mongo.getDatabase(db).getCollection(collection).mapReduce(mapping, reducing) : this.mongo.getDatabase(db).getCollection(collection).mapReduce(this.currentTransaction.get().getSession(), mapping, reducing);
        if (collation != null) {
            com.mongodb.client.model.Collation col = this.getCollation(collation);
            res.collation(col);
        }
        if (query != null) {
            BasicDBObject v = new BasicDBObject(query);
            res.filter((Bson)v);
        }
        if (sorting != null) {
            res.sort((Bson)new BasicDBObject(sorting));
        }
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Document d : res) {
            Map value = (Map)d.get((Object)"value");
            for (Map.Entry s : value.entrySet()) {
                if (!(s.getValue() instanceof ObjectId)) continue;
                value.put(s.getKey(), new MorphiumId(((ObjectId)s.getValue()).toHexString()));
            }
            ret.add(value);
        }
        return ret;
    }

    @Override
    public void startTransaction() {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("Transaction in progress");
        }
        ClientSessionOptions.Builder b = ClientSessionOptions.builder();
        b.causallyConsistent(false);
        b.defaultTransactionOptions(TransactionOptions.builder().readConcern(ReadConcern.DEFAULT).readPreference(com.mongodb.ReadPreference.primary()).build());
        ClientSession ses = this.mongo.startSession(b.build());
        ses.startTransaction();
        MongoTransactionContext ctx = new MongoTransactionContext();
        ctx.setSession(ses);
        this.currentTransaction.set(ctx);
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        this.currentTransaction.get().getSession().commitTransaction();
        this.currentTransaction.set(null);
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public void abortTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        this.currentTransaction.get().getSession().abortTransaction();
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("Transaction in progress!");
        }
        this.currentTransaction.set((MongoTransactionContext)ctx);
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public boolean isSslInvalidHostNameAllowed() {
        return this.sslInvalidHostNameAllowed;
    }

    @Override
    public void setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
    }
}

