/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.driver.MorphiumId;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

public class Utils {
    public static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String toJsonString(Object o) {
        StringWriter sw = new StringWriter();
        try {
            Utils.writeJson(o, sw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static void writeJson(Object o, Writer out) throws IOException {
        if (o == null) {
            return;
        }
        boolean comma = false;
        if (o instanceof Collection) {
            out.write(" [ ");
            for (Object obj : (Collection)o) {
                if (comma) {
                    out.write(", ");
                }
                comma = true;
                Utils.writeJson(obj, out);
            }
            out.write("]");
            return;
        }
        if (o.getClass().isArray()) {
            out.write(" [ ");
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(o, i);
                if (comma) {
                    out.write(", ");
                }
                comma = true;
                Utils.writeJson(obj, out);
            }
            out.write("]");
            return;
        }
        if (o instanceof String || o instanceof MorphiumId || o instanceof ObjectId || o instanceof Enum) {
            out.write("\"");
            out.write(o.toString());
            out.write("\"");
            return;
        }
        if (!(o instanceof Map)) {
            out.write(o.toString());
            return;
        }
        Map db = (Map)o;
        out.write("{ ");
        comma = false;
        for (Map.Entry e : db.entrySet()) {
            if (comma) {
                out.write(", ");
            }
            comma = true;
            out.write("\"");
            out.write((String)e.getKey());
            out.write("\"");
            out.write(" : ");
            if (e.getValue() == null) {
                out.write(" null");
                continue;
            }
            if (e.getValue() instanceof String) {
                out.write("\"");
                out.write((String)e.getValue());
                out.write("\"");
                continue;
            }
            if (e.getValue() instanceof Enum) {
                out.write("\"");
                out.write(e.getValue().toString());
                out.write("\"");
                continue;
            }
            Utils.writeJson(e.getValue(), out);
        }
        out.write(" } ");
    }

    public static <K, V> UtilsMap<K, V> getMap(K key, V value) {
        UtilsMap<K, V> ret = new UtilsMap<K, V>();
        ret.put(key, value);
        return ret;
    }

    public static UtilsMap<String, Integer> getIntMap(String key, Integer value) {
        UtilsMap<String, Integer> ret = new UtilsMap<String, Integer>();
        ret.put(key, value);
        return ret;
    }

    public static String getHex(long i) {
        return Utils.getHex((byte)(i >> 56 & 0xFFL)) + Utils.getHex((byte)(i >> 48 & 0xFFL)) + Utils.getHex((byte)(i >> 40 & 0xFFL)) + Utils.getHex((byte)(i >> 32 & 0xFFL)) + Utils.getHex((byte)(i >> 24 & 0xFFL)) + Utils.getHex((byte)(i >> 16 & 0xFFL)) + Utils.getHex((byte)(i >> 8 & 0xFFL)) + Utils.getHex((byte)(i & 0xFFL));
    }

    public static String getHex(int i) {
        return Utils.getHex((byte)(i >> 24 & 0xFF)) + Utils.getHex((byte)(i >> 16 & 0xFF)) + Utils.getHex((byte)(i >> 8 & 0xFF)) + Utils.getHex((byte)(i & 0xFF));
    }

    public static String getHex(byte[] b) {
        return Utils.getHex(b, -1);
    }

    public static String getHex(byte[] b, int sz) {
        StringBuilder sb = new StringBuilder();
        int mainIdx = 0;
        int end = b.length;
        if (sz > 0 && sz < b.length) {
            end = sz;
        }
        while (mainIdx < end) {
            sb.append(Utils.getHex((byte)(mainIdx >> 24 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx >> 16 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx >> 8 & 0xFF)));
            sb.append(Utils.getHex((byte)(mainIdx & 0xFF)));
            sb.append(":  ");
            for (int i = mainIdx; i < mainIdx + 16 && i < b.length; ++i) {
                byte by = b[i];
                sb.append(Utils.getHex(by));
                sb.append(" ");
            }
            int l = 16;
            if (mainIdx + 16 > b.length) {
                l = b.length - mainIdx;
            }
            byte[] sr = new byte[l];
            int n = 0;
            for (int j = mainIdx; j < mainIdx + l; ++j) {
                sr[n] = b[j] > 63 ? b[j] : (b[j] == 0 ? 45 : 46);
                ++n;
            }
            String str = new String(sr, 0, l, StandardCharsets.UTF_8);
            sb.append("    ");
            sb.append(str);
            sb.append("\n");
            mainIdx += 16;
        }
        return sb.toString();
    }

    public static String getHex(byte by) {
        String ret = "";
        int idx = by >>> 4 & 0xF;
        ret = ret + hexChars[idx];
        idx = by & 0xF;
        ret = ret + hexChars[idx];
        return ret;
    }

    public static String getCacheKey(Class type, Map<String, Object> qo, Map<String, Integer> sort, Map<String, Object> projection, String collection, int skip, int limit, AnnotationAndReflectionHelper anHelper) {
        StringBuilder b = new StringBuilder();
        b.append(qo.toString());
        b.append(" c:").append(collection);
        b.append(" l:");
        b.append(limit);
        b.append(" s:");
        b.append(skip);
        if (sort != null) {
            b.append(" sort:{");
            for (Map.Entry<String, Integer> s : sort.entrySet()) {
                b.append(" ").append(s.getKey()).append(":").append(s.getValue());
            }
            b.append("}");
        }
        if (projection != null) {
            List<Field> fields = anHelper.getAllFields(type);
            boolean addProjection = false;
            if (projection.size() == fields.size()) {
                for (Field field : fields) {
                    if (projection.containsKey(anHelper.getFieldName(type, field.getName()))) continue;
                    addProjection = true;
                    break;
                }
            } else {
                addProjection = true;
            }
            if (addProjection) {
                b.append(" project:{");
                for (Map.Entry entry : projection.entrySet()) {
                    b.append(" ").append((String)entry.getKey()).append(":").append(entry.getValue());
                }
                b.append("}");
            }
        }
        return b.toString();
    }

    public static Object replaceMorphiumIds(Map m) {
        if (m == null) {
            return null;
        }
        LinkedHashMap toSet = new LinkedHashMap();
        for (Map.Entry e : m.entrySet()) {
            if (e.getValue() == null) {
                toSet.put(e.getKey(), null);
                continue;
            }
            if (e.getKey().equals("morphium id")) {
                return new ObjectId(e.getValue().toString());
            }
            if (e.getKey().equals("date field")) {
                return new Date((Long)e.getValue());
            }
            if (e.getValue() instanceof Map) {
                toSet.put(e.getKey(), Utils.replaceMorphiumIds((Map)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof Collection) {
                toSet.put(e.getKey(), Utils.replaceMorphiumIds((Collection)e.getValue()));
                continue;
            }
            toSet.put(e.getKey(), e.getValue());
        }
        return toSet;
    }

    public static Collection replaceMorphiumIds(Collection value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : value) {
            if (o == null) {
                ret.add(null);
                continue;
            }
            if (o instanceof Map && ((Map)o).containsKey("morphium id")) {
                ret.add(new ObjectId((String)((Map)o).get("morphium id")));
                continue;
            }
            if (o instanceof Map && ((Map)o).containsKey("date field")) {
                ret.add(new Date((Long)((Map)o).get("date field")));
                continue;
            }
            if (o instanceof Map) {
                ret.add(Utils.replaceMorphiumIds((Map)o));
                continue;
            }
            ret.add(o);
        }
        return ret;
    }

    public static Map<String, Object> getNoExprMap(Map<Object, Object> map) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> e : map.entrySet()) {
            String k = e.getKey().toString();
            if (e.getValue() instanceof Expr) {
                ret.put(k, ((Expr)e.getValue()).toQueryObject());
                continue;
            }
            ret.put(k, e.getValue());
        }
        return ret;
    }

    public static Map<String, Object> getQueryObjectMap(Map<String, Expr> exprMap) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Expr> e : exprMap.entrySet()) {
            ret.put(e.getKey(), e.getValue().toQueryObject());
        }
        return ret;
    }

    public static class UtilsMap<K, V>
    extends LinkedHashMap<K, V> {
        public UtilsMap<K, V> add(K key, V val) {
            if (val == null) {
                return this;
            }
            this.put(key, val);
            return this;
        }

        public UtilsMap<K, V> addAll(Map<K, V> m) {
            this.putAll(m);
            return this;
        }
    }
}

