/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.BinarySerializedObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.ReadOnly;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.annotations.encryption.Encrypted;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.mapping.BigIntegerTypeMapper;
import de.caluga.morphium.mapping.BsonGeoMapper;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import de.caluga.morphium.query.geospatial.Geo;
import de.caluga.morphium.query.geospatial.LineString;
import de.caluga.morphium.query.geospatial.MultiLineString;
import de.caluga.morphium.query.geospatial.MultiPoint;
import de.caluga.morphium.query.geospatial.MultiPolygon;
import de.caluga.morphium.query.geospatial.Point;
import de.caluga.morphium.query.geospatial.Polygon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

public class ObjectMapperImpl
implements MorphiumObjectMapper {
    private final Logger log = LoggerFactory.getLogger(ObjectMapperImpl.class);
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final ConcurrentHashMap<Class<?>, NameProvider> nameProviders;
    private final JSONParser jsonParser = new JSONParser();
    private final ArrayList<Class<?>> mongoTypes;
    private final ContainerFactory containerFactory;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper(true);
    private final Map<Class<?>, MorphiumTypeMapper> customMappers = new ConcurrentHashMap();
    private Morphium morphium;

    public ObjectMapperImpl() {
        this.nameProviders = new ConcurrentHashMap();
        this.mongoTypes = new ArrayList();
        this.mongoTypes.add(String.class);
        this.mongoTypes.add(Character.class);
        this.mongoTypes.add(Integer.class);
        this.mongoTypes.add(Long.class);
        this.mongoTypes.add(Float.class);
        this.mongoTypes.add(Double.class);
        this.mongoTypes.add(Date.class);
        this.mongoTypes.add(Boolean.class);
        this.mongoTypes.add(Byte.class);
        this.mongoTypes.add(Short.class);
        this.mongoTypes.add(AtomicBoolean.class);
        this.mongoTypes.add(AtomicInteger.class);
        this.mongoTypes.add(AtomicLong.class);
        this.mongoTypes.add(Pattern.class);
        this.mongoTypes.add(BigDecimal.class);
        this.mongoTypes.add(UUID.class);
        this.mongoTypes.add(Instant.class);
        this.mongoTypes.add(LocalDate.class);
        this.mongoTypes.add(LocalTime.class);
        this.mongoTypes.add(LocalDateTime.class);
        this.containerFactory = new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
        this.customMappers.put(BigInteger.class, new BigIntegerTypeMapper());
        this.customMappers.put(Geo.class, new BsonGeoMapper());
        this.customMappers.put(Point.class, new BsonGeoMapper());
        this.customMappers.put(MultiPoint.class, new BsonGeoMapper());
        this.customMappers.put(MultiLineString.class, new BsonGeoMapper());
        this.customMappers.put(MultiPolygon.class, new BsonGeoMapper());
        this.customMappers.put(Polygon.class, new BsonGeoMapper());
        this.customMappers.put(LineString.class, new BsonGeoMapper());
    }

    @Override
    public void setAnnotationHelper(AnnotationAndReflectionHelper an) {
        this.annotationHelper = an;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper(true);
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public <T> void registerCustomMapperFor(Class<T> cls, MorphiumTypeMapper<T> map) {
        this.customMappers.put(cls, map);
    }

    @Override
    public void deregisterCustomMapperFor(Class cls) {
        this.customMappers.remove(cls);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            this.log.error("Error getting nameProvider", (Throwable)ex);
            throw new IllegalArgumentException("could not get name provider", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        NameProvider np = this.nameProviders.get(cls);
        if (np == null) {
            np = p.nameProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.nameProviders.put(cls, np);
        }
        return np;
    }

    @Override
    public String getCollectionName(Class cls) {
        Entity p = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.annotationHelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            this.log.error("Could not instanciate NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.error("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    public Object marshallIfNecessary(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Expr) {
            return ((Expr)o).toQueryObject();
        }
        if (this.annotationHelper.isEntity(o) || this.customMappers.containsKey(o.getClass())) {
            return this.serialize(o);
        }
        if (o.getClass().isPrimitive()) {
            return o;
        }
        if (o.getClass().isArray()) {
            if (o.getClass().getComponentType().equals(Byte.TYPE)) {
                return o;
            }
            int arrayLength = Array.getLength(o);
            ArrayList<Object> lst = new ArrayList<Object>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                lst.add(this.marshallIfNecessary(Array.get(o, i)));
            }
            return this.serializeIterable(lst, null, null);
        }
        if (o instanceof Iterable) {
            return this.serializeIterable((Iterable)o, null, null);
        }
        if (o instanceof Map) {
            return this.serializeMap((Map)o, null);
        }
        return o;
    }

    @Override
    public Map<String, Object> serialize(Object o) {
        boolean objectSerializationEnabled;
        if (o == null) {
            return new HashMap<String, Object>();
        }
        Class<?> cls = this.annotationHelper.getRealClass(o.getClass());
        if (this.customMappers.containsKey(cls)) {
            Object ret = this.customMappers.get(cls).marshall(o);
            if (ret instanceof Map) {
                ((Map)ret).put("class_name", cls.getName());
                return (Map)ret;
            }
            return Utils.getMap("value", ret);
        }
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.annotationHelper.getRealObject(o);
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
        boolean objectIsEntity = e != null || emb != null;
        boolean warnOnNoEntitySerialization = this.morphium != null && this.morphium.getConfig() != null && this.morphium.getConfig().isWarnOnNoEntitySerialization();
        boolean bl = objectSerializationEnabled = this.morphium == null || this.morphium.getConfig() == null || this.morphium.getConfig().isObjectSerializationEnabled();
        if (!objectIsEntity && !warnOnNoEntitySerialization) {
            if (objectSerializationEnabled) {
                if (o instanceof Serializable) {
                    try {
                        BinarySerializedObject obj = new BinarySerializedObject();
                        obj.setOriginalClassName(cls.getName());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(out);
                        oout.writeObject(o);
                        oout.flush();
                        Base64.Encoder enc = Base64.getMimeEncoder();
                        String str = new String(enc.encode(out.toByteArray()));
                        obj.setB64Data(str);
                        return this.serialize(obj);
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Binary serialization failed! " + cls.getName(), ex);
                    }
                }
                throw new IllegalArgumentException("Cannot write object to db that is neither entity, embedded nor serializable! ObjectType: " + cls.getName());
            }
            throw new IllegalArgumentException("Object is no entity: " + cls.getSimpleName());
        }
        if (!objectIsEntity && warnOnNoEntitySerialization) {
            this.log.warn("Serializing non-entity of type " + cls.getName());
        }
        HashMap<String, Object> dbo = new HashMap<String, Object>();
        List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        String cn = cls.getName();
        if (e != null && !e.typeId().equals(".")) {
            cn = e.typeId();
        }
        if (emb != null && !emb.typeId().equals(".")) {
            cn = emb.typeId();
        }
        if (e != null && e.polymorph()) {
            dbo.put("class_name", cn);
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", cn);
        }
        Iterator<String> iterator = flds.iterator();
        while (iterator.hasNext()) {
            String f;
            String fName = f = iterator.next();
            try {
                Field fld = this.annotationHelper.getField(cls, f);
                if (fld == null) {
                    this.log.error("Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers()) || fld.isAnnotationPresent(ReadOnly.class)) continue;
                Map<String, Object> value = fld.get(o);
                if (fld.isAnnotationPresent(Encrypted.class)) {
                    try {
                        Encrypted enc = fld.getAnnotation(Encrypted.class);
                        ValueEncryptionProvider encP = enc.provider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        byte[] encKey = this.morphium.getEncryptionKeyProvider().getEncryptionKey(enc.keyName());
                        encP.setEncryptionKey(encKey);
                        byte[] encrypted = encP.encrypt(Utils.toJsonString(this.marshallIfNecessary(value)).getBytes());
                        dbo.put(fName, encrypted);
                        continue;
                    }
                    catch (Exception exc) {
                        throw new RuntimeException("Ecryption failed. Field: " + fName + " class: " + cls.getName(), exc);
                    }
                }
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly() || value == null) continue;
                    dbo.putAll(this.serializeMap(value, fld.getGenericType()));
                    continue;
                }
                if (dbo.containsKey(fName)) {
                    this.log.warn("Field " + fName + " is shadowed - inherited values?");
                    continue;
                }
                Object v = null;
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (Collection.class.isAssignableFrom(fld.getType())) {
                        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
                        for (Object rec2 : (Collection)((Object)value)) {
                            if (rec2 != null) {
                                Object id = this.annotationHelper.getId(rec2);
                                if (id == null) {
                                    id = this.automaticStore(r, rec2);
                                }
                                if (this.morphium == null) {
                                    throw new RuntimeException("cannot set dbRef - morphium is not set");
                                }
                                MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec2.getClass()).getName(), id);
                                lst.add(this.serialize(ref));
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else if (Map.class.isAssignableFrom(fld.getType())) {
                        HashMap map = new HashMap();
                        ((Map)value).forEach((key, rec) -> {
                            Object id = this.annotationHelper.getId(rec);
                            if (id == null) {
                                id = this.automaticStore(r, rec);
                            }
                            if (this.morphium == null) {
                                throw new RuntimeException("cannot set dbRef - morphium is not set");
                            }
                            MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec.getClass()).getName(), id);
                            map.put(key, this.serialize(ref));
                        });
                        v = map;
                    } else {
                        if (this.annotationHelper.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    this.log.error("Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.annotationHelper.getId(value);
                    }
                } else {
                    Class<?> valueClass = value == null ? fld.getType() : value.getClass();
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Entity.class)) {
                        if (value != null) {
                            Map<String, Object> obj = this.serialize(value);
                            obj.remove("_id");
                            v = obj;
                        }
                    } else if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Embedded.class)) {
                        if (value != null) {
                            v = this.serialize(value);
                        }
                    } else {
                        v = value;
                        if (v != null) {
                            if (v instanceof Map) {
                                v = this.serializeMap((Map)v, fld.getGenericType());
                            } else if (v.getClass().isArray()) {
                                if (!v.getClass().getComponentType().equals(Byte.TYPE)) {
                                    int arrayLength = Array.getLength(v);
                                    ArrayList<Object> lst = new ArrayList<Object>(arrayLength);
                                    for (int i = 0; i < arrayLength; ++i) {
                                        lst.add(Array.get(v, i));
                                    }
                                    v = this.serializeIterable(lst, fld.getType(), fld.getGenericType());
                                }
                            } else if (v instanceof Iterable) {
                                v = this.serializeIterable((Iterable)v, fld.getType(), fld.getGenericType());
                            } else if (v instanceof Calendar) {
                                v = ((Calendar)v).getTime();
                            } else if (v.getClass().equals(MorphiumId.class)) {
                                v = new ObjectId(((MorphiumId)v).getBytes());
                            } else if (this.customMappers.containsKey(v.getClass())) {
                                v = this.customMappers.get(v.getClass()).marshall(v);
                            } else if (v instanceof Enum) {
                                v = this.serializeEnum(fld.getType(), (Enum)v);
                            }
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                this.log.error("Illegal Access to field " + f);
            }
        }
        return dbo;
    }

    private Object automaticStore(Reference r, Object rec) {
        String coll;
        if (r.automaticStore()) {
            if (this.morphium == null) {
                throw new RuntimeException("Could not automagically store references as morphium is not set!");
            }
            coll = r.targetCollection();
            if (coll.equals(".")) {
                coll = null;
            }
        } else {
            throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
        }
        this.morphium.storeNoCache(rec, coll);
        Object id = this.annotationHelper.getId(rec);
        return id;
    }

    public List<Object> serializeIterable(Iterable v, Class<?> collectionClass, Type collectionType) {
        Class componentType;
        Class elementClass = null;
        Type elementType = null;
        if (collectionType instanceof ParameterizedType) {
            elementClass = this.getElementClass((ParameterizedType)collectionType);
            elementType = ObjectMapperImpl.getElementType((ParameterizedType)collectionType);
        } else if (collectionType instanceof GenericArrayType) {
            Type rawType;
            elementType = ((GenericArrayType)collectionType).getGenericComponentType();
            if (elementType instanceof Class) {
                elementClass = (Class)elementType;
            } else if (elementType instanceof ParameterizedType && (rawType = ((ParameterizedType)elementType).getRawType()) instanceof Class) {
                elementClass = (Class)rawType;
            }
        }
        if (collectionClass != null && (componentType = collectionClass.getComponentType()) != null && elementClass == null) {
            elementClass = componentType;
        }
        if (elementClass == null) {
            elementClass = Object.class;
        }
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object lo : v) {
            if (lo != null) {
                Class<?> loClass = lo.getClass();
                Entity loEntity = this.annotationHelper.getAnnotationFromHierarchy(loClass, Entity.class);
                Embedded loEmbedded = this.annotationHelper.getAnnotationFromHierarchy(loClass, Embedded.class);
                if (loEntity != null || loEmbedded != null) {
                    Map<String, Object> marshall = this.serialize(lo);
                    String cn = this.getTypeId(loClass, loEntity, loEmbedded);
                    marshall.put("class_name", cn);
                    lst.add(marshall);
                    continue;
                }
                if (lo instanceof Iterable) {
                    lst.add(this.serializeIterable((Iterable)lo, elementClass, elementType));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add(this.serializeMap((Map)lo, elementType));
                    continue;
                }
                if (lo instanceof MorphiumId) {
                    lst.add(new ObjectId(((MorphiumId)lo).getBytes()));
                    continue;
                }
                if (lo instanceof Enum) {
                    lst.add(this.serializeEnum(elementClass, (Enum)lo));
                    continue;
                }
                if (loClass.isPrimitive() || this.mongoTypes.contains(loClass)) {
                    lst.add(lo);
                    continue;
                }
                if (loClass.isArray()) {
                    if (loClass.getComponentType().equals(Byte.TYPE)) {
                        lst.add(lo);
                        continue;
                    }
                    int arrayLength = Array.getLength(lo);
                    ArrayList<Object> loLst = new ArrayList<Object>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        loLst.add(Array.get(lo, i));
                    }
                    lst.add(this.serializeIterable(loLst, elementClass, elementType));
                    continue;
                }
                lst.add(this.serialize(lo));
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private String getTypeId(Enum enumVal) {
        Class<?> cls = enumVal.getClass();
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null && superclass.isEnum()) {
            return superclass.getName();
        }
        return cls.getName();
    }

    private String getTypeId(Class cls, Entity e, Embedded emb) {
        Embedded clsEmbedded;
        Entity clsEntity;
        if (e != null && (clsEntity = this.annotationHelper.getAnnotationFromClass(cls, Entity.class)) != null && !clsEntity.typeId().equals(".")) {
            return clsEntity.typeId();
        }
        if (emb != null && (clsEmbedded = this.annotationHelper.getAnnotationFromClass(cls, Embedded.class)) != null && !clsEmbedded.typeId().equals(".")) {
            return clsEmbedded.typeId();
        }
        return cls.getName();
    }

    public Map<String, Object> serializeMap(Map v, Type mapType) {
        Class elementClass = null;
        Type elementType = null;
        if (mapType instanceof ParameterizedType) {
            elementClass = this.getElementClass((ParameterizedType)mapType);
            elementType = ObjectMapperImpl.getElementType((ParameterizedType)mapType);
        }
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                if (k instanceof Enum) {
                    k = ((Enum)k).name();
                } else {
                    this.log.debug("Map in Mongodb needs to have String as keys - using toString");
                    k = k.toString();
                    if (((String)k).contains(".")) {
                        this.log.warn(". not allowed as Key in Maps - converting to _");
                        k = ((String)k).replaceAll("\\.", "_");
                    }
                }
            }
            if ((mval = es.getValue()) != null) {
                Class<?> mvalClass = mval.getClass();
                Entity mvalEntity = this.annotationHelper.getAnnotationFromHierarchy(mvalClass, Entity.class);
                Embedded mvalEmbedded = this.annotationHelper.getAnnotationFromHierarchy(mvalClass, Embedded.class);
                if (mvalEntity != null || mvalEmbedded != null) {
                    Map<String, Object> obj = this.serialize(mval);
                    obj.put("class_name", this.getTypeId(mvalClass, mvalEntity, mvalEmbedded));
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.serializeMap((Map)mval, elementType);
                } else if (mval instanceof Iterable) {
                    mval = this.serializeIterable((Iterable)mval, elementClass, elementType);
                } else if (mvalClass.isArray()) {
                    if (!mvalClass.getComponentType().equals(Byte.TYPE)) {
                        int arrayLength = Array.getLength(mval);
                        ArrayList<Object> lst = new ArrayList<Object>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            lst.add(Array.get(mval, i));
                        }
                        mval = this.serializeIterable(lst, elementClass, elementType);
                    }
                } else if (mval instanceof Enum) {
                    mval = this.serializeEnum(elementClass, (Enum)mval);
                } else if (mval instanceof MorphiumId) {
                    mval = new ObjectId(((MorphiumId)mval).getBytes());
                } else if (!mvalClass.isPrimitive() && !this.mongoTypes.contains(mvalClass)) {
                    mval = this.serialize(mval);
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    public Object serializeEnum(Class<?> declaredClass, Enum val) {
        if (declaredClass != null && Enum.class.isAssignableFrom(declaredClass)) {
            return val.name();
        }
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("class_name", this.getTypeId(val));
        obj.put("name", val.name());
        return obj;
    }

    @Override
    public <T> T deserialize(Class<? extends T> cls, String jsonString) throws ParseException {
        if (jsonString.startsWith("{")) {
            HashMap obj = (HashMap)this.jsonParser.parse(jsonString, this.containerFactory);
            return this.deserialize(cls, obj);
        }
        return (T)((HashMap)this.jsonParser.parse("{\"value\":" + jsonString + "}", this.containerFactory)).get("value");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(Class<? extends T> theClass, Map<String, Object> o) {
        if (o == null) {
            return null;
        }
        Class<Object> cls = theClass;
        if (this.customMappers.containsKey(cls)) {
            return this.customMappers.get(cls).unmarshall(o);
        }
        try {
            boolean objectSerializationEnabled;
            Entity entity = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
            Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
            boolean objectIsEntity = entity != null || embedded != null;
            boolean warnOnNoEntitySerialization = this.morphium != null && this.morphium.getConfig() != null && this.morphium.getConfig().isWarnOnNoEntitySerialization();
            boolean bl = objectSerializationEnabled = this.morphium == null || this.morphium.getConfig() == null || this.morphium.getConfig().isObjectSerializationEnabled();
            if (!warnOnNoEntitySerialization && objectSerializationEnabled && !objectIsEntity) {
                cls = BinarySerializedObject.class;
            }
            if (o.get("class_name") != null || o.get("className") != null) {
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = this.annotationHelper.getClassForTypeId(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                return (T)Enum.valueOf(cls, (String)o.get("name"));
            }
            Class<Object> superclass = cls.getSuperclass();
            if (superclass != null && superclass.isEnum()) {
                return (T)Enum.valueOf(superclass, (String)o.get("name"));
            }
            Object ret = null;
            try {
                ret = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    Constructor<?> constructor = this.reflection.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    ret = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.log.error("Exception", (Throwable)e);
                }
            }
            if (ret == null) {
                throw new IllegalArgumentException("Could not instanciate " + cls.getName());
            }
            List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
            Iterator<String> e = flds.iterator();
            while (true) {
                Object value;
                String f;
                block108: {
                    Iterator decKey2;
                    HashMap hashMap;
                    MorphiumReference r;
                    Reference reference;
                    Class fldType;
                    block115: {
                        Iterator<Map.Entry<String, Object>> iterator;
                        HashMap<String, Object> data;
                        Field fld;
                        block111: {
                            block109: {
                                List<Object> valueFromDb;
                                block132: {
                                    block133: {
                                        block131: {
                                            Class<?> superclass2;
                                            block130: {
                                                block120: {
                                                    ArrayList<Serializable> collection;
                                                    block129: {
                                                        block121: {
                                                            ArrayList<Serializable> lst;
                                                            block124: {
                                                                block122: {
                                                                    block128: {
                                                                        block127: {
                                                                            block126: {
                                                                                block125: {
                                                                                    block123: {
                                                                                        block119: {
                                                                                            block118: {
                                                                                                block116: {
                                                                                                    block117: {
                                                                                                        block112: {
                                                                                                            void var19_32;
                                                                                                            block114: {
                                                                                                                block113: {
                                                                                                                    block110: {
                                                                                                                        if (!e.hasNext()) break block109;
                                                                                                                        f = e.next();
                                                                                                                        valueFromDb = o.get(f);
                                                                                                                        fld = this.annotationHelper.getField(cls, f);
                                                                                                                        fldType = fld.getType();
                                                                                                                        if (Modifier.isStatic(fld.getModifiers())) continue;
                                                                                                                        if (this.customMappers.containsKey(fldType)) {
                                                                                                                            fld.set(ret, this.customMappers.get(fldType).unmarshall(valueFromDb));
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        if (!fld.isAnnotationPresent(AdditionalData.class)) break block110;
                                                                                                                        if (!Map.class.isAssignableFrom(fldType)) {
                                                                                                                            this.log.error("Could not deserialize additional data into fld of type " + fldType.toString());
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        data = new HashMap<String, Object>();
                                                                                                                        iterator = o.entrySet().iterator();
                                                                                                                        break block111;
                                                                                                                    }
                                                                                                                    if (valueFromDb == null) {
                                                                                                                        if (fldType.isPrimitive() || !o.containsKey(f)) continue;
                                                                                                                        fld.set(ret, null);
                                                                                                                        continue;
                                                                                                                    }
                                                                                                                    if (fld.isAnnotationPresent(Encrypted.class)) {
                                                                                                                        void var19_28;
                                                                                                                        Encrypted enc = fld.getAnnotation(Encrypted.class);
                                                                                                                        Class<? extends ValueEncryptionProvider> encCls = enc.provider();
                                                                                                                        ValueEncryptionProvider ep = encCls.newInstance();
                                                                                                                        String string = enc.keyName();
                                                                                                                        if (string.equals(".")) {
                                                                                                                            String string2 = theClass.getName();
                                                                                                                        }
                                                                                                                        byte[] decKey2 = this.morphium.getEncryptionKeyProvider().getDecryptionKey((String)var19_28);
                                                                                                                        ep.setDecryptionKey(decKey2);
                                                                                                                        if (valueFromDb instanceof byte[]) {
                                                                                                                            valueFromDb = new String(ep.decrypt((byte[])valueFromDb));
                                                                                                                        } else {
                                                                                                                            if (!(valueFromDb instanceof String)) {
                                                                                                                                throw new RuntimeException("Decryption not possible, value is no byte array or base64 string!");
                                                                                                                            }
                                                                                                                            valueFromDb = new String(ep.decrypt(Base64.getDecoder().decode(valueFromDb.toString())));
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            valueFromDb = this.deserialize(fldType, (String)((Object)valueFromDb));
                                                                                                                        }
                                                                                                                        catch (Exception e2) {
                                                                                                                            this.log.debug("Not a json string, cannot deserialize further");
                                                                                                                        }
                                                                                                                        this.annotationHelper.setValue(ret, valueFromDb, f);
                                                                                                                        continue;
                                                                                                                    }
                                                                                                                    value = null;
                                                                                                                    if (Collection.class.isAssignableFrom(fldType) || !fld.isAnnotationPresent(Reference.class)) break block112;
                                                                                                                    reference = fld.getAnnotation(Reference.class);
                                                                                                                    r = null;
                                                                                                                    if (this.morphium != null) break block113;
                                                                                                                    this.log.error("Morphium not set - could not de-reference!");
                                                                                                                    break block108;
                                                                                                                }
                                                                                                                if (!Map.class.isAssignableFrom(fldType)) break block114;
                                                                                                                hashMap = new HashMap();
                                                                                                                decKey2 = ((Map)((Object)valueFromDb)).entrySet().iterator();
                                                                                                                break block115;
                                                                                                            }
                                                                                                            if (!(valueFromDb instanceof Map)) {
                                                                                                                List list = valueFromDb;
                                                                                                            } else {
                                                                                                                Map ref = (Map)((Object)valueFromDb);
                                                                                                                r = this.deserialize(MorphiumReference.class, ref);
                                                                                                                Object object = r.getId();
                                                                                                            }
                                                                                                            String collection2 = this.getCollectionName(fldType);
                                                                                                            if (r != null && r.getCollectionName() != null) {
                                                                                                                collection2 = r.getCollectionName();
                                                                                                            }
                                                                                                            if (var19_32 != null) {
                                                                                                                if (reference.lazyLoading()) {
                                                                                                                    void var19_34;
                                                                                                                    List<String> lst2 = this.annotationHelper.getFields(fldType, Id.class);
                                                                                                                    if (lst2.isEmpty()) {
                                                                                                                        throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                                                                                                    }
                                                                                                                    if (var19_32 instanceof String && this.annotationHelper.getField(fldType, lst2.get(0)).getType().equals(MorphiumId.class)) {
                                                                                                                        MorphiumId morphiumId = new MorphiumId(var19_32.toString());
                                                                                                                    }
                                                                                                                    value = this.morphium.createLazyLoadedEntity(fldType, var19_34, collection2);
                                                                                                                    break block108;
                                                                                                                } else {
                                                                                                                    try {
                                                                                                                        value = this.morphium.findById(fldType, var19_32, collection2);
                                                                                                                    }
                                                                                                                    catch (MorphiumAccessVetoException e3) {
                                                                                                                        this.log.info("not dereferencing due to veto from listener", (Throwable)e3);
                                                                                                                    }
                                                                                                                }
                                                                                                                break block108;
                                                                                                            } else {
                                                                                                                value = null;
                                                                                                            }
                                                                                                            break block108;
                                                                                                        }
                                                                                                        if (!fld.isAnnotationPresent(Id.class)) break block116;
                                                                                                        value = o.get("_id");
                                                                                                        if (value == null || value.getClass().equals(fldType)) break block108;
                                                                                                        this.log.debug("read value and field type differ...");
                                                                                                        if (!fldType.equals(MorphiumId.class)) break block117;
                                                                                                        this.log.debug("trying objectID conversion");
                                                                                                        if (value.getClass().equals(String.class)) {
                                                                                                            try {
                                                                                                                value = new MorphiumId((String)value);
                                                                                                            }
                                                                                                            catch (Exception e4) {
                                                                                                                this.log.error("Value and field type differ - Id conversion failed - setting returning null", (Throwable)e4);
                                                                                                                return null;
                                                                                                            }
                                                                                                        }
                                                                                                        break block108;
                                                                                                    }
                                                                                                    if (value.getClass().equals(MorphiumId.class)) {
                                                                                                        if (fldType.equals(String.class)) {
                                                                                                            value = value.toString();
                                                                                                            break block108;
                                                                                                        } else {
                                                                                                            if (!fldType.equals(Long.class) && !fldType.equals(Long.TYPE)) {
                                                                                                                this.log.error("cannot convert - ID IS SET TO NULL. Type read from db is " + value.getClass().getName() + " - expected value is " + fldType.getName());
                                                                                                                return null;
                                                                                                            }
                                                                                                            value = ((MorphiumId)value).getTime();
                                                                                                        }
                                                                                                    }
                                                                                                    break block108;
                                                                                                }
                                                                                                if (!this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Embedded.class)) break block118;
                                                                                                value = this.deserialize(fldType, (Map)((Object)valueFromDb));
                                                                                                break block108;
                                                                                            }
                                                                                            if (!Map.class.isAssignableFrom(fldType) || !(valueFromDb instanceof Map)) break block119;
                                                                                            value = this.fillMap(fld.getGenericType(), (Map)((Object)valueFromDb));
                                                                                            break block108;
                                                                                        }
                                                                                        if (!Collection.class.isAssignableFrom(fldType) && !fldType.isArray()) break block120;
                                                                                        collection = null;
                                                                                        if (valueFromDb instanceof Binary) {
                                                                                            valueFromDb = Arrays.asList(new byte[][]{((Binary)valueFromDb).getData()});
                                                                                        }
                                                                                        if (!valueFromDb.getClass().isArray()) break block121;
                                                                                        lst = new ArrayList<Serializable>();
                                                                                        if (!valueFromDb.getClass().getComponentType().isPrimitive()) break block122;
                                                                                        if (!valueFromDb.getClass().getComponentType().equals(Integer.TYPE)) break block123;
                                                                                        for (int n : (int[])valueFromDb) {
                                                                                            lst.add(Integer.valueOf(n));
                                                                                        }
                                                                                        break block124;
                                                                                    }
                                                                                    if (!valueFromDb.getClass().getComponentType().equals(Double.TYPE)) break block125;
                                                                                    for (double d : (double[])valueFromDb) {
                                                                                        lst.add(Double.valueOf(d));
                                                                                    }
                                                                                    break block124;
                                                                                }
                                                                                if (!valueFromDb.getClass().getComponentType().equals(Float.TYPE)) break block126;
                                                                                for (float f2 : (float[])valueFromDb) {
                                                                                    lst.add(Float.valueOf(f2));
                                                                                }
                                                                                break block124;
                                                                            }
                                                                            if (!valueFromDb.getClass().getComponentType().equals(Boolean.TYPE)) break block127;
                                                                            for (boolean bl2 : (boolean[])valueFromDb) {
                                                                                lst.add(Boolean.valueOf(bl2));
                                                                            }
                                                                            break block124;
                                                                        }
                                                                        if (!valueFromDb.getClass().getComponentType().equals(Byte.TYPE)) break block128;
                                                                        for (byte by : (byte[])valueFromDb) {
                                                                            lst.add(Byte.valueOf(by));
                                                                        }
                                                                        break block124;
                                                                    }
                                                                    if (valueFromDb.getClass().getComponentType().equals(Character.TYPE)) {
                                                                        for (char c : (char[])valueFromDb) {
                                                                            lst.add(Character.valueOf(c));
                                                                        }
                                                                        break block124;
                                                                    } else if (valueFromDb.getClass().getComponentType().equals(Long.TYPE)) {
                                                                        for (long l : (long[])valueFromDb) {
                                                                            lst.add(Long.valueOf(l));
                                                                        }
                                                                    }
                                                                    break block124;
                                                                }
                                                                Collections.addAll(lst, (Object[])valueFromDb);
                                                            }
                                                            collection = lst;
                                                            break block129;
                                                        }
                                                        collection = (ArrayList<Serializable>)valueFromDb;
                                                    }
                                                    value = this.fillCollection(fld.getAnnotation(Reference.class), fldType, fld.getGenericType(), collection);
                                                    break block108;
                                                }
                                                superclass2 = fldType.getSuperclass();
                                                if (!fldType.isEnum()) break block130;
                                                value = Enum.valueOf(fldType, (String)((Object)valueFromDb));
                                                break block108;
                                            }
                                            if (superclass2 == null || !superclass2.isEnum()) break block131;
                                            value = Enum.valueOf(superclass2, (String)((Object)valueFromDb));
                                            break block108;
                                        }
                                        if (!(valueFromDb instanceof ObjectId)) break block132;
                                        if (!fldType.equals(MorphiumId.class)) break block133;
                                        if (valueFromDb instanceof ObjectId) {
                                            value = new MorphiumId(((ObjectId)valueFromDb).toHexString());
                                            break block108;
                                        } else if (valueFromDb instanceof String) {
                                            value = new MorphiumId((String)((Object)valueFromDb));
                                            break block108;
                                        } else {
                                            this.log.error("Could not deserialize Value from DB of type " + valueFromDb.getClass().getName() + " and set it to morphiumId");
                                        }
                                        break block108;
                                    }
                                    value = new MorphiumId(((ObjectId)valueFromDb).toByteArray());
                                    break block108;
                                }
                                value = valueFromDb;
                                break block108;
                            }
                            if (entity != null) {
                                flds = this.annotationHelper.getFields(cls, Id.class);
                                if (flds.isEmpty()) {
                                    throw new RuntimeException("Error - class does not have an ID field!");
                                }
                                Field field = this.annotationHelper.getField(cls, flds.get(0));
                                Class<?> fieldType = field.getType();
                                Object idValue = o.get("_id");
                                if (idValue != null) {
                                    Class<?> idValueClass = idValue.getClass();
                                    if (idValueClass.equals(fieldType)) {
                                        field.set(ret, idValue);
                                    } else if (fieldType.equals(String.class) && idValueClass.equals(MorphiumId.class)) {
                                        this.log.warn("ID type missmatch - field is string but got objectId from mongo - converting");
                                        field.set(ret, idValue.toString());
                                    } else if (fieldType.equals(MorphiumId.class) && idValueClass.equals(ObjectId.class)) {
                                        field.set(ret, new MorphiumId(((ObjectId)idValue).toByteArray()));
                                    } else if (fieldType.equals(ObjectId.class) && idValueClass.equals(MorphiumId.class)) {
                                        field.set(ret, new ObjectId(((MorphiumId)idValue).getBytes()));
                                    } else if (fieldType.equals(ObjectId.class) && idValueClass.equals(String.class)) {
                                        field.set(ret, new ObjectId(((ObjectId)idValue).toString()));
                                    } else if (fieldType.equals(MorphiumId.class) && idValueClass.equals(String.class)) {
                                        field.set(ret, new MorphiumId((String)idValue));
                                    } else if (fieldType.equals(UUID.class) && idValueClass.equals(byte[].class)) {
                                        ByteBuffer bb = ByteBuffer.wrap((byte[])idValue);
                                        field.set(ret, new UUID(bb.getLong(), bb.getLong()));
                                    } else if (fieldType.equals(Integer.TYPE) && idValueClass.equals(Integer.class)) {
                                        field.set(ret, (int)((Integer)idValue));
                                    } else if (fieldType.equals(Long.TYPE) && idValueClass.equals(Long.class)) {
                                        field.set(ret, (long)((Long)idValue));
                                    } else if (fieldType.equals(Double.TYPE) && idValueClass.equals(Double.class)) {
                                        field.set(ret, (double)((Double)idValue));
                                    } else if (fieldType.equals(Float.TYPE) && idValueClass.equals(Float.class)) {
                                        field.set(ret, Float.valueOf(((Float)idValue).floatValue()));
                                    } else if (fieldType.equals(Boolean.TYPE) && idValueClass.equals(Boolean.class)) {
                                        field.set(ret, (boolean)((Boolean)idValue));
                                    } else {
                                        this.log.error("ID type missmatch");
                                        throw new IllegalArgumentException("ID type missmatch. Field in '" + ret.getClass().toString() + "' is '" + fieldType.toString() + "' but we got '" + idValueClass.toString() + "' from Mongo!");
                                    }
                                }
                            }
                            if (ret instanceof BinarySerializedObject) {
                                BinarySerializedObject bso = (BinarySerializedObject)ret;
                                Base64.Decoder dec = Base64.getMimeDecoder();
                                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(bso.getB64Data())));
                                return (T)in.readObject();
                            }
                            return (T)ret;
                        }
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> entry = iterator.next();
                            String string = entry.getKey();
                            Object v = entry.getValue();
                            if (flds.contains(string) || string.equals("_id")) continue;
                            if (v instanceof Map) {
                                Map mapV = (Map)v;
                                String string3 = (String)mapV.get("class_name");
                                if (string3 != null) {
                                    data.put(string, this.deserialize(this.annotationHelper.getClassForTypeId(string3), mapV));
                                    continue;
                                }
                                data.put(string, this.deserializeMap(mapV));
                                continue;
                            }
                            if (v instanceof List && !((List)v).isEmpty() && ((List)v).get(0) instanceof Map) {
                                data.put(string, this.deserializeList((List)v));
                                continue;
                            }
                            data.put(string, v);
                        }
                        fld.set(ret, data);
                        continue;
                    }
                    while (decKey2.hasNext()) {
                        void var22_69;
                        Map.Entry e5 = decKey2.next();
                        if (!(e5.getValue() instanceof Map)) {
                            Object v = e5.getValue();
                            r = null;
                        } else {
                            Map ref = (Map)e5.getValue();
                            r = this.deserialize(MorphiumReference.class, ref);
                            Object object = r.getId();
                        }
                        String collectionName = null;
                        Class type = fldType;
                        if (r != null) {
                            collectionName = r.getCollectionName() != null ? r.getCollectionName() : this.getCollectionName(this.annotationHelper.getClassForTypeId(r.getClassName()));
                            type = this.annotationHelper.getClassForTypeId(r.getClassName());
                        } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Entity.class)) {
                            collectionName = this.getCollectionName(fldType);
                        }
                        if (collectionName == null) {
                            throw new IllegalArgumentException("Could not create reference!");
                        }
                        if (reference.lazyLoading()) {
                            void var22_72;
                            List<String> lst = this.annotationHelper.getFields(fldType, Id.class);
                            if (lst.isEmpty()) {
                                throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                            }
                            if (var22_69 instanceof String && this.annotationHelper.getField(fldType, lst.get(0)).getType().equals(MorphiumId.class)) {
                                MorphiumId morphiumId = new MorphiumId(var22_69.toString());
                            } else if (var22_69 instanceof ObjectId && this.annotationHelper.getField(fldType, lst.get(0)).getType().equals(MorphiumId.class)) {
                                MorphiumId morphiumId = new MorphiumId(((ObjectId)var22_69).toByteArray());
                            }
                            value = this.morphium.createLazyLoadedEntity(fldType, var22_72, collectionName);
                        } else {
                            try {
                                value = this.morphium.findById(type, var22_69, collectionName);
                            }
                            catch (MorphiumAccessVetoException ex) {
                                this.log.info("not dereferencing due to veto from listener", (Throwable)ex);
                            }
                        }
                        hashMap.put(e5.getKey(), value);
                    }
                    value = hashMap;
                }
                this.annotationHelper.setValue(ret, value, f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object fillArray(Class<?> componentType, Collection<?> c) {
        Object arr = Array.newInstance(componentType, c.size());
        if (Integer.TYPE.equals(componentType) || Integer.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Integer) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, ((Number)o).intValue());
            }
        } else if (Long.TYPE.equals(componentType) || Long.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Long) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, ((Number)o).longValue());
            }
        } else if (Float.TYPE.equals(componentType) || Float.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Float) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, Float.valueOf(((Number)o).floatValue()));
            }
        } else if (Double.TYPE.equals(componentType) || Double.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Double) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, ((Number)o).doubleValue());
            }
        } else if (Byte.TYPE.equals(componentType) || Byte.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Byte) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, ((Number)o).byteValue());
            }
        } else if (Short.TYPE.equals(componentType) || Short.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Short) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (!(o instanceof Number)) continue;
                Array.set(arr, i++, ((Number)o).shortValue());
            }
        } else if (Boolean.TYPE.equals(componentType) || Boolean.class.equals(componentType)) {
            int i = 0;
            for (Object o : c) {
                if (o instanceof Boolean) {
                    Array.set(arr, i++, o);
                    continue;
                }
                if (o instanceof Number) {
                    Array.set(arr, i++, ((Number)o).intValue() != 0);
                    continue;
                }
                Array.set(arr, i++, Boolean.valueOf(o.toString()));
            }
        } else {
            int i = 0;
            for (Object o : c) {
                Array.set(arr, i++, o);
            }
        }
        return arr;
    }

    public Map<String, Object> deserializeMap(Map<String, Object> dbObject) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(dbObject);
        if (dbObject != null) {
            for (Map.Entry<String, Object> entry : dbObject.entrySet()) {
                retMap.put(entry.getKey(), this.unmarshallInternal(entry.getValue()));
            }
        } else {
            retMap = null;
        }
        return retMap;
    }

    private Object unmarshallInternal(Object val) {
        block13: {
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                String cn = (String)mapVal.get("class_name");
                if (cn == null) {
                    cn = (String)mapVal.get("className");
                }
                if (cn != null) {
                    try {
                        Class ecls = this.annotationHelper.getClassForTypeId(cn);
                        Object obj = this.deserialize(ecls, mapVal);
                        if (obj != null) {
                            return obj;
                        }
                        break block13;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                String d = (String)mapVal.get("_b64data");
                if (d == null) {
                    d = (String)mapVal.get("b64Data");
                }
                if (d != null) {
                    Base64.Decoder dec = Base64.getMimeDecoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(d)));
                        return in.readObject();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.deserializeMap(mapVal);
            }
            if (val instanceof ObjectId) {
                val = new MorphiumId(((ObjectId)val).toByteArray());
            } else if (val instanceof List) {
                List lst = (List)val;
                return this.deserializeList(lst);
            }
        }
        return val;
    }

    public List deserializeList(List<Object> lst) {
        return lst.stream().map(this::unmarshallInternal).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void fillCollection(Reference ref, Type listType, Class elementClass, Type elementType, List<?> fromDB, Collection toFillIn) {
        if (ref != null) {
            Iterator<?> iterator = fromDB.iterator();
            while (iterator.hasNext()) {
                Class type;
                Object obj = iterator.next();
                if (obj == null) {
                    toFillIn.add(null);
                    continue;
                }
                MorphiumReference r = this.deserialize(MorphiumReference.class, (Map)obj);
                try {
                    type = this.annotationHelper.getClassForTypeId(r.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (r.getCollectionName() == null) {
                    r.setCollectionName(this.getCollectionName(type));
                }
                if (ref.lazyLoading()) {
                    if (r.getId() instanceof String && this.morphium.getARHelper().getIdField(type).getType().equals(MorphiumId.class)) {
                        r.setId(new MorphiumId(r.getId().toString()));
                    }
                    toFillIn.add(this.morphium.createLazyLoadedEntity(type, r.getId(), r.getCollectionName()));
                    continue;
                }
                toFillIn.add(this.morphium.findById(type, r.getId(), r.getCollectionName()));
            }
            return;
        }
        Iterator<?> iterator = new ArrayList(fromDB).iterator();
        while (iterator.hasNext()) {
            Object val;
            block22: {
                val = iterator.next();
                if (val instanceof Map) {
                    if (((Map)val).containsKey("class_name") || ((Map)val).containsKey("className")) {
                        String cn = (String)((Map)val).get("class_name");
                        if (cn == null) {
                            cn = (String)((Map)val).get("className");
                        }
                        try {
                            Class ecls = this.annotationHelper.getClassForTypeId(cn);
                            Object um = this.deserialize(ecls, (Map)val);
                            if (um == null) continue;
                            toFillIn.add(um);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not find class", e);
                        }
                    }
                    if (listType != null) {
                        if (Map.class.isAssignableFrom(elementClass)) {
                            toFillIn.add(this.fillMap((ParameterizedType)elementType, (Map)val));
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Embedded.class);
                        if (entity != null || embedded != null) {
                            toFillIn.add(this.deserialize(elementClass, (Map)val));
                            continue;
                        }
                        break block22;
                    } else {
                        this.log.warn("Cannot de-reference to unknown collection type - trying object instead");
                        toFillIn.add(val);
                        continue;
                    }
                }
                if (val instanceof List) {
                    toFillIn.add(this.fillCollection(null, elementClass, elementType, (List)val));
                    continue;
                }
            }
            Object unmarshalled = this.unmarshallInternal(val);
            elementClass = ClassUtils.primitiveToWrapper((Class)elementClass);
            if (unmarshalled != null && elementClass != null && !elementClass.isAssignableFrom(unmarshalled.getClass())) {
                try {
                    unmarshalled = AnnotationAndReflectionHelper.convertType(unmarshalled, "", elementClass);
                }
                catch (Exception e) {
                    this.log.warn("", (Throwable)e);
                }
            }
            toFillIn.add(unmarshalled);
        }
    }

    public Object fillCollection(Reference ref, Class<?> collectionClass, Type collectionType, List<?> fromDb) {
        Class elementClass = null;
        Type elementType = null;
        if (collectionType instanceof ParameterizedType) {
            elementClass = this.getElementClass((ParameterizedType)collectionType);
            elementType = ObjectMapperImpl.getElementType((ParameterizedType)collectionType);
        } else if (collectionType instanceof GenericArrayType) {
            Type rawType;
            elementType = ((GenericArrayType)collectionType).getGenericComponentType();
            if (elementType instanceof Class) {
                elementClass = (Class)elementType;
            } else if (elementType instanceof ParameterizedType && (rawType = ((ParameterizedType)elementType).getRawType()) instanceof Class) {
                elementClass = (Class)rawType;
            }
        }
        Class<?> componentType = collectionClass.getComponentType();
        if (componentType != null && elementClass == null) {
            elementClass = componentType;
        }
        if (elementClass == null) {
            elementClass = Object.class;
        }
        AbstractCollection innerCollection = null;
        innerCollection = List.class.isAssignableFrom(collectionClass) ? new ArrayList(fromDb.size()) : (Enum.class.isAssignableFrom(elementClass) && Collection.class.isAssignableFrom(collectionClass) ? EnumSet.noneOf(elementClass) : (Set.class.isAssignableFrom(collectionClass) ? new LinkedHashSet() : new ArrayList(fromDb.size())));
        this.fillCollection(ref, collectionType, elementClass, elementType, fromDb, innerCollection);
        if (componentType != null) {
            return this.fillArray(componentType, innerCollection);
        }
        return innerCollection;
    }

    public static Type getElementType(ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            return actualTypeArguments[actualTypeArguments.length - 1];
        }
        return null;
    }

    private Class getElementClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[parameters.length - 1];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return this.annotationHelper.getClassForTypeId(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        this.log.error("Could not determin type of element!");
        return Object.class;
    }

    private Class getKeyClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[0];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return this.annotationHelper.getClassForTypeId(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        this.log.error("Could not determin type of key!");
        return Object.class;
    }

    protected Map fillMap(Type mapType, Map<String, Object> fromDB) {
        boolean useEnumMap = false;
        Class keyClass = null;
        if (mapType instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)mapType;
            keyClass = this.getKeyClass(genericType);
            if (EnumMap.class.isAssignableFrom((Class)genericType.getRawType())) {
                useEnumMap = true;
            } else if (Enum.class.isAssignableFrom(keyClass)) {
                useEnumMap = true;
            }
        }
        AbstractMap toFill = useEnumMap ? new EnumMap(keyClass) : new HashMap();
        if (fromDB != null && !fromDB.isEmpty()) {
            this.fillMap(mapType, fromDB, toFill);
        }
        return toFill;
    }

    protected void fillMap(Type mapType, Map<String, Object> fromDB, Map toFillIn) {
        Class keyClass = null;
        Class elementClass = null;
        Type elementType = null;
        if (mapType instanceof ParameterizedType) {
            keyClass = this.getKeyClass((ParameterizedType)mapType);
            elementClass = this.getElementClass((ParameterizedType)mapType);
            elementType = ObjectMapperImpl.getElementType((ParameterizedType)mapType);
        }
        Method convertMethod = null;
        if (keyClass != null && !String.class.equals((Object)keyClass)) {
            convertMethod = AnnotationAndReflectionHelper.getConvertMethod(keyClass);
        }
        for (Map.Entry<String, Object> entry : fromDB.entrySet()) {
            Object unmarshalled;
            Object val;
            String stringKey = entry.getKey();
            Object key = stringKey;
            if (convertMethod != null) {
                try {
                    key = convertMethod.invoke(null, stringKey);
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    this.log.error("Could not convert " + stringKey + " to key type " + keyClass, (Throwable)e);
                    continue;
                }
            }
            if ((val = entry.getValue()) instanceof Map) {
                if (elementClass != null) {
                    if (Map.class.isAssignableFrom(elementClass)) {
                        toFillIn.put(key, this.fillMap(elementType, (Map)val));
                        continue;
                    }
                    Entity entity = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Entity.class);
                    Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Embedded.class);
                    if (entity != null || embedded != null) {
                        toFillIn.put(key, this.deserialize(elementClass, (Map)val));
                        continue;
                    }
                }
            } else if (val instanceof List) {
                toFillIn.put(key, this.fillCollection(null, elementClass, elementType, (List)val));
                continue;
            }
            if ((unmarshalled = this.unmarshallInternal(val)) != null && elementClass != null && !elementClass.isAssignableFrom(unmarshalled.getClass())) {
                try {
                    unmarshalled = AnnotationAndReflectionHelper.convertType(unmarshalled, "", elementClass);
                }
                catch (Exception e) {
                    this.log.warn("", (Throwable)e);
                }
            }
            toFillIn.put(key, unmarshalled);
        }
    }
}

