/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.NameProvider;
import java.util.Hashtable;
import org.slf4j.LoggerFactory;

public final class DefaultNameProvider
implements NameProvider {
    private final Hashtable<Class<?>, String> collectionNameCache = new Hashtable();

    @Override
    public String getCollectionName(Class<?> type, MorphiumObjectMapper om, boolean translateCamelCase, boolean useFQN, String specifiedName, Morphium morphium) {
        String name = specifiedName;
        if (name == null) {
            name = this.collectionNameCache.get(type);
        }
        if (name == null) {
            name = type.getSimpleName();
            if (useFQN) {
                name = type.getName().replaceAll("\\.", "_");
            }
            if (translateCamelCase) {
                AnnotationAndReflectionHelper ar = morphium != null ? morphium.getARHelper() : new AnnotationAndReflectionHelper(true);
                name = ar.convertCamelCase(name);
            }
            try {
                this.collectionNameCache.put(type, name);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DefaultNameProvider.class).debug("Could not store name in cache!");
            }
        }
        return name;
    }
}

