/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.replicaset.OplogListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Pattern;
import org.bson.BsonTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogMonitor
implements Runnable,
ShutdownListener {
    private final Collection<OplogListener> listeners;
    private final Morphium morphium;
    private final Logger log = LoggerFactory.getLogger(OplogMonitor.class);
    private final String nameSpace;
    private final boolean useRegex;
    private boolean running = true;
    private long timestamp;
    private Thread oplogMonitorThread;

    public OplogMonitor(Morphium m) {
        this(m, null, false);
    }

    public OplogMonitor(Morphium m, Class<?> entity) {
        this(m, m.getConfig().getDatabase() + "." + m.getMapper().getCollectionName(entity), false);
    }

    public OplogMonitor(Morphium m, String nameSpace, boolean regex) {
        this.morphium = m;
        this.listeners = new ConcurrentLinkedDeque<OplogListener>();
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.morphium.addShutdownListener(this);
        this.nameSpace = nameSpace;
        this.useRegex = regex;
    }

    public void addListener(OplogListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(OplogListener lst) {
        this.listeners.remove(lst);
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public void start() {
        if (this.oplogMonitorThread != null) {
            throw new RuntimeException("Already running!");
        }
        this.oplogMonitorThread = new Thread(this);
        this.oplogMonitorThread.setDaemon(true);
        this.oplogMonitorThread.setName("oplogmonitor");
        this.oplogMonitorThread.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        long start = System.currentTimeMillis();
        while (this.oplogMonitorThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 1000L) continue;
        }
        if (this.oplogMonitorThread.isAlive()) {
            this.oplogMonitorThread.interrupt();
        }
        this.oplogMonitorThread = null;
        this.listeners.clear();
        this.morphium.removeShutdownListener(this);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public void run() {
        LinkedHashMap<String, Object> q = new LinkedHashMap<String, Object>();
        HashMap<String, BsonTimestamp> q2 = new HashMap<String, BsonTimestamp>();
        q2.put("$gt", new BsonTimestamp((int)this.timestamp, 0));
        if (this.nameSpace != null) {
            String ns = this.morphium.getConfig().getDatabase() + "." + this.nameSpace;
            if (this.nameSpace.contains(".") && !this.useRegex) {
                ns = this.nameSpace;
            }
            if (this.useRegex) {
                q.put("ns", Pattern.compile(ns));
            } else {
                q.put("ns", ns);
            }
        }
        q.put("ts", q2);
        while (this.running) {
            try {
                this.morphium.getDriver().tailableIteration("local", "oplog.rs", q, null, null, 0, 0, 1000, null, 60000, new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        if (!OplogMonitor.this.running) {
                            return;
                        }
                        OplogMonitor.this.timestamp = ((Integer)data.get("ts")).intValue();
                        for (OplogListener lst : OplogMonitor.this.listeners) {
                            if (!OplogMonitor.this.running) {
                                return;
                            }
                            try {
                                lst.incomingData(data);
                            }
                            catch (Exception e) {
                                OplogMonitor.this.log.error("listener threw exception", (Throwable)e);
                            }
                        }
                    }

                    @Override
                    public boolean isContinued() {
                        return OplogMonitor.this.running;
                    }
                });
            }
            catch (MorphiumDriverException e) {
                this.log.warn("Error in oplogmonitor - restarting", (Throwable)e);
            }
        }
    }

    @Override
    public void onShutdown(Morphium m) {
        this.stop();
    }
}

