/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationIterator<T, R>
implements MorphiumAggregationIterator<T, R> {
    private final Logger log = LoggerFactory.getLogger(AggregationIterator.class);
    private MorphiumCursor currentBatch;
    private int cursor = 0;
    private int cursorExternal = 0;
    private boolean multithreadded;
    private int windowSize = -1;
    private Aggregator<T, R> aggregator;

    @Override
    public int getWindowSize() {
        if (this.windowSize <= 0) {
            this.windowSize = this.aggregator.getMorphium().getConfig().getCursorBatchSize();
        }
        return this.windowSize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.windowSize = sz;
    }

    @Override
    public int getCurrentBufferSize() {
        return this.currentBatch.getBatch().size();
    }

    @Override
    public List<R> getCurrentBuffer() {
        return null;
    }

    @Override
    public long getCount() {
        return this.aggregator.getCount();
    }

    @Override
    public int getCursor() {
        return this.cursorExternal;
    }

    @Override
    public void ahead(int jump) {
        this.cursor += jump;
        this.cursorExternal += jump;
        while (this.cursor >= this.currentBatch.getBatch().size()) {
            int diff = this.cursor - this.currentBatch.getBatch().size();
            this.cursor = this.currentBatch.getBatch().size() - 1;
            this.next();
            this.cursor += diff;
        }
    }

    @Override
    public void back(int jump) {
        this.cursor -= jump;
        this.cursorExternal -= jump;
        if (this.cursor < 0) {
            throw new IllegalArgumentException("cannot jumb back over batch boundaries!");
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        throw new IllegalArgumentException("not possible");
    }

    @Override
    public int getNumberOfAvailableThreads() {
        return 1;
    }

    @Override
    public int getNumberOfThreads() {
        return 1;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        return this.multithreadded;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.multithreadded = mu;
    }

    @Override
    public Iterator<R> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.multithreadded) {
            AggregationIterator aggregationIterator = this;
            synchronized (aggregationIterator) {
                return this.doHasNext();
            }
        }
        return this.doHasNext();
    }

    private boolean doHasNext() {
        if (this.currentBatch != null && this.currentBatch.getBatch() != null && this.currentBatch.getBatch().size() > this.cursor) {
            return true;
        }
        if (this.currentBatch == null && this.cursorExternal == 0) {
            try {
                this.currentBatch = this.aggregator.getMorphium().getDriver().initAggregationIteration(this.aggregator.getMorphium().getConfig().getDatabase(), this.aggregator.getCollectionName(), this.aggregator.getPipeline(), this.aggregator.getMorphium().getReadPreferenceForClass(this.aggregator.getSearchType()), this.aggregator.getCollation(), this.getWindowSize(), null);
            }
            catch (MorphiumDriverException e) {
                this.log.error("error during fetching first batch", (Throwable)e);
            }
            return this.doHasNext();
        }
        return false;
    }

    @Override
    public R next() {
        if (this.currentBatch == null && !this.hasNext()) {
            return null;
        }
        Map<String, Object> unmarshall = null;
        unmarshall = this.aggregator.getResultType().equals(Map.class) ? this.currentBatch.getBatch().get(this.cursor) : this.aggregator.getMorphium().getMapper().deserialize(this.aggregator.getResultType(), this.currentBatch.getBatch().get(this.cursor));
        this.aggregator.getMorphium().firePostLoadEvent(unmarshall);
        try {
            if (this.currentBatch == null && this.cursorExternal == 0) {
                this.currentBatch = this.aggregator.getMorphium().getDriver().initAggregationIteration(this.aggregator.getMorphium().getConfig().getDatabase(), this.aggregator.getCollectionName(), this.aggregator.getPipeline(), this.aggregator.getMorphium().getReadPreferenceForClass(this.aggregator.getSearchType()), this.aggregator.getCollation(), this.getWindowSize(), null);
                this.cursor = 0;
            } else if (this.currentBatch != null && this.cursor + 1 < this.currentBatch.getBatch().size()) {
                ++this.cursor;
            } else if (this.currentBatch != null && this.cursor + 1 == this.currentBatch.getBatch().size()) {
                this.currentBatch = this.aggregator.getMorphium().getDriver().nextIteration(this.currentBatch);
                this.cursor = 0;
            } else {
                ++this.cursor;
            }
            if (this.multithreadded && this.currentBatch != null && this.currentBatch.getBatch() != null) {
                this.currentBatch.setBatch(Collections.synchronizedList(this.currentBatch.getBatch()));
            }
        }
        catch (MorphiumDriverException e) {
            this.log.error("Got error during iteration...", (Throwable)e);
        }
        ++this.cursorExternal;
        return (R)unmarshall;
    }

    @Override
    public Aggregator<T, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setAggregator(Aggregator<T, R> aggregator) {
        this.aggregator = aggregator;
    }
}

