/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.Utils;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.annotations.Capped;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Version;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.WriterTask;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumWriterImpl
implements MorphiumWriter,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(MorphiumWriterImpl.class);
    private Morphium morphium;
    private int maximumRetries = 10;
    private int pause = 250;
    private ThreadPoolExecutor executor = null;

    @Override
    public void setMaximumQueingTries(int n) {
        this.maximumRetries = n;
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.pause = p;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        if (m != null) {
            int max;
            LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(){

                @Override
                public boolean offer(Runnable e) {
                    int maximumPoolSize;
                    int poolSize = MorphiumWriterImpl.this.executor.getPoolSize();
                    if (poolSize >= (maximumPoolSize = MorphiumWriterImpl.this.executor.getMaximumPoolSize()) || poolSize > MorphiumWriterImpl.this.executor.getActiveCount()) {
                        return super.offer(e);
                    }
                    return false;
                }
            };
            int core = m.getConfig().getMaxConnections() / 2;
            if (core <= 1) {
                core = 1;
            }
            if ((max = m.getConfig().getMaxConnections() * m.getConfig().getThreadConnectionMultiplier()) <= core) {
                max = 2 * core;
            }
            this.executor = new ThreadPoolExecutor(core, max, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue);
            this.executor.setRejectedExecutionHandler((r, executor) -> {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            this.executor.setThreadFactory(new ThreadFactory(){
                private final AtomicInteger num = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread ret = new Thread(r, "writer " + this.num);
                    this.num.set(this.num.get() + 1);
                    ret.setDaemon(true);
                    return ret;
                }
            });
            m.addShutdownListener(this);
        }
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    @Override
    public <T> void insert(final List<T> lst, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                @Override
                public void run() {
                    HashMap sorted = new HashMap();
                    for (Object o : lst) {
                        Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(o.getClass());
                        if (!MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(type, Entity.class)) {
                            logger.error("Not an entity! Storing not possible! Even not in list!");
                            continue;
                        }
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                        o = MorphiumWriterImpl.this.morphium.getARHelper().getRealObject(o);
                        if (o == null) {
                            logger.warn("Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                            return;
                        }
                        sorted.putIfAbsent(o.getClass(), new ArrayList());
                        ((List)sorted.get(o.getClass())).add(o);
                        if (MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(o.getClass(), CreationTime.class)) {
                            try {
                                MorphiumWriterImpl.this.morphium.setAutoValues(o);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                logger.error(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
                            }
                        }
                        MorphiumWriterImpl.this.morphium.firePreStore(o, true);
                    }
                    long allStart = System.currentTimeMillis();
                    try {
                        for (Map.Entry entry : sorted.entrySet()) {
                            Class c = (Class)entry.getKey();
                            ArrayList<Map<String, Object>> dbLst = new ArrayList<Map<String, Object>>();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            MorphiumWriterImpl.this.createIndexAndCaps(c, coll, this.callback);
                            for (Object record2 : (List)entry.getValue()) {
                                MorphiumWriterImpl.this.setIdIfNull(record2);
                                Map<String, Object> marshall = MorphiumWriterImpl.this.morphium.getMapper().serialize(record2);
                                dbLst.add(marshall);
                            }
                            long start = System.currentTimeMillis();
                            if (!dbLst.isEmpty()) {
                                MorphiumWriterImpl.this.morphium.getDriver().insert(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll, dbLst, wc);
                                boolean marshall = false;
                            }
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(c);
                            long dur = System.currentTimeMillis() - start;
                            MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, dbLst, dur, true, WriteAccessType.BULK_INSERT);
                            ((List)entry.getValue()).forEach(record -> MorphiumWriterImpl.this.morphium.firePostStore(record, true));
                        }
                        if (this.callback != null) {
                            this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (this.callback == null) {
                            throw new RuntimeException(e);
                        }
                        this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, lst);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    private void setIdIfNull(Object record) throws IllegalAccessException {
        Field idf = this.morphium.getARHelper().getIdField(record);
        if (idf.get(record) != null) {
            return;
        }
        if (idf.get(record) == null && idf.getType().equals(MorphiumId.class)) {
            idf.set(record, new MorphiumId());
        } else if (idf.get(record) == null && idf.getType().equals(ObjectId.class)) {
            idf.set(record, new ObjectId());
        } else if (idf.get(record) == null && idf.getType().equals(String.class)) {
            idf.set(record, new MorphiumId().toString());
        } else {
            throw new IllegalArgumentException("Cannot set ID of non-ID-Type");
        }
    }

    @Override
    public <T> void insert(final List<T> lst, final String cn, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                @Override
                public void run() {
                    try {
                        String collectionName = cn;
                        if (lst == null || lst.isEmpty()) {
                            return;
                        }
                        if (collectionName == null) {
                            collectionName = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(lst.get(0).getClass());
                        }
                        ArrayList<Map<String, Object>> dbLst = new ArrayList<Map<String, Object>>();
                        WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(lst.get(0).getClass());
                        HashMap<Object, Boolean> isNew = new HashMap<Object, Boolean>();
                        for (Object o : lst) {
                            isNew.put(o, true);
                            try {
                                MorphiumWriterImpl.this.setIdIfNull(o);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            dbLst.add(MorphiumWriterImpl.this.morphium.getMapper().serialize(o));
                        }
                        if (MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), collectionName)) {
                            logger.warn("collection does not exist while storing list -  taking first element of list to ensure indices");
                            MorphiumWriterImpl.this.createCappedCollationColl(lst.get(0).getClass());
                            MorphiumWriterImpl.this.morphium.ensureIndicesFor(lst.get(0).getClass(), collectionName, this.callback);
                        }
                        long start = System.currentTimeMillis();
                        MorphiumWriterImpl.this.morphium.firePreStore(isNew);
                        long dur = System.currentTimeMillis() - start;
                        MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(lst.get(0).getClass(), lst, dur, true, WriteAccessType.BULK_UPDATE);
                        start = System.currentTimeMillis();
                        MorphiumWriterImpl.this.morphium.getDriver().insert(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), collectionName, dbLst, wc);
                        dur = System.currentTimeMillis() - start;
                        ArrayList cleared = new ArrayList();
                        for (Object o : lst) {
                            if (cleared.contains(o.getClass())) continue;
                            cleared.add(o.getClass());
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                        }
                        MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(lst.get(0).getClass(), dbLst, dur, true, WriteAccessType.BULK_INSERT);
                        MorphiumWriterImpl.this.morphium.firePostStore(isNew);
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public <T> void insert(final T obj, final String collection, AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.insert((List)obj, callback);
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    Object o = obj;
                    Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(o.getClass());
                    if (!MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(type, Entity.class)) {
                        throw new RuntimeException("Not an entity: " + type.getSimpleName() + " Storing not possible!");
                    }
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    o = MorphiumWriterImpl.this.morphium.getARHelper().getRealObject(o);
                    if (o == null) {
                        logger.warn("Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                        return;
                    }
                    if (MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                        MorphiumWriterImpl.this.morphium.setAutoValues(o);
                    }
                    MorphiumWriterImpl.this.morphium.firePreStore(o, true);
                    MorphiumWriterImpl.this.setIdIfNull(o);
                    Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(type, Entity.class);
                    if (en.autoVersioning()) {
                        MorphiumWriterImpl.this.morphium.getARHelper().setValue(o, 1, MorphiumWriterImpl.this.morphium.getARHelper().getFields(type, Version.class).get(0));
                    }
                    Map<String, Object> marshall = MorphiumWriterImpl.this.morphium.getMapper().serialize(o);
                    String coll = collection;
                    if (coll == null) {
                        coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(type);
                    }
                    MorphiumWriterImpl.this.createIndexAndCaps(type, coll, this.callback);
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                    ArrayList<Map<String, Object>> objs = new ArrayList<Map<String, Object>>();
                    objs.add(marshall);
                    try {
                        MorphiumWriterImpl.this.morphium.getDriver().insert(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll, objs, wc);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), marshall, dur, true, WriteAccessType.SINGLE_INSERT);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                    MorphiumWriterImpl.this.morphium.firePostStore(o, true);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, null, obj, new Object[0]);
                    }
                }
                catch (Exception e) {
                    MorphiumWriterImpl.this.checkViolations(e);
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, e.getMessage(), e, obj, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private <T> void createIndexAndCaps(Class type, String coll, AsyncOperationCallback<T> callback) throws MorphiumDriverException {
        if (this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !this.morphium.getDriver().exists(this.getDbName(), coll)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Collection " + coll + " does not exist - ensuring indices");
            }
            this.createCappedCollationColl(type);
            this.morphium.ensureIndicesFor(type, coll, callback);
        }
    }

    @Override
    public <T> void store(final T obj, final String collection, AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.store((List)obj, collection, callback);
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    List<String> flds;
                    Map<String, Integer> ret;
                    boolean isNew;
                    Object o = obj;
                    Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(o.getClass());
                    if (!MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(type, Entity.class)) {
                        throw new RuntimeException("Not an entity: " + type.getSimpleName() + " Storing not possible!");
                    }
                    Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(o.getClass(), Entity.class);
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    Object id = MorphiumWriterImpl.this.morphium.getARHelper().getId(o);
                    o = MorphiumWriterImpl.this.morphium.getARHelper().getRealObject(o);
                    if (o == null) {
                        logger.warn("Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                        return;
                    }
                    boolean bl = isNew = id == null;
                    if (MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                        isNew = MorphiumWriterImpl.this.morphium.setAutoValues(o);
                    }
                    MorphiumWriterImpl.this.morphium.firePreStore(o, isNew);
                    MorphiumWriterImpl.this.setIdIfNull(o);
                    Map<String, Object> marshall = MorphiumWriterImpl.this.morphium.getMapper().serialize(o);
                    String coll = collection;
                    if (coll == null) {
                        coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(type);
                    }
                    MorphiumWriterImpl.this.createIndexAndCaps(type, coll, this.callback);
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                    ArrayList<Map<String, Object>> objs = new ArrayList<Map<String, Object>>();
                    objs.add(marshall);
                    try {
                        ret = MorphiumWriterImpl.this.morphium.getDriver().store(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll, objs, wc);
                    }
                    catch (MorphiumDriverException mde) {
                        if (mde.getMessage().contains("duplicate key") && mde.getMessage().contains("_id") && en.autoVersioning()) {
                            throw new ConcurrentModificationException("Versioning / upsert failure - concurrent modification!");
                        }
                        throw mde;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    if (en.autoVersioning()) {
                        if (ret.get("total") < ret.get("modified")) {
                            throw new ConcurrentModificationException("versioning failure");
                        }
                        if (en.autoVersioning()) {
                            String fld = MorphiumWriterImpl.this.morphium.getARHelper().getFields(type, Version.class).get(0);
                            Long v = MorphiumWriterImpl.this.morphium.getARHelper().getLongValue(o, fld);
                            v = v + 1L;
                            MorphiumWriterImpl.this.morphium.getARHelper().setValue(o, v, fld);
                        }
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), marshall, dur, true, WriteAccessType.SINGLE_INSERT);
                    if (isNew && (flds = MorphiumWriterImpl.this.morphium.getARHelper().getFields(o.getClass(), Id.class)) == null) {
                        throw new RuntimeException("Object does not have an ID field!");
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(o.getClass());
                    MorphiumWriterImpl.this.morphium.firePostStore(o, isNew);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, null, obj, new Object[0]);
                    }
                }
                catch (Exception e) {
                    MorphiumWriterImpl.this.checkViolations(e);
                    if (this.callback == null) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, e.getMessage(), e, obj, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private void checkViolations(Exception e) {
        if (e instanceof RuntimeException && e.getClass().getName().equals("javax.validation.ConstraintViolationException")) {
            try {
                Method m = e.getClass().getMethod("getConstraintViolations", new Class[0]);
                Set violations = (Set)m.invoke((Object)e, new Object[0]);
                for (Object v : violations) {
                    m = v.getClass().getMethod("getMessage", new Class[0]);
                    String msg = (String)m.invoke(v, new Object[0]);
                    m = v.getClass().getMethod("getRootBean", new Class[0]);
                    Object bean = m.invoke(v, new Object[0]);
                    String s = Utils.toJsonString(bean);
                    String type = bean.getClass().getName();
                    m = v.getClass().getMethod("getInvalidValue", new Class[0]);
                    Object invalidValue = m.invoke(v, new Object[0]);
                    m = v.getClass().getMethod("getPropertyPath", new Class[0]);
                    Iterable pth = (Iterable)m.invoke(v, new Object[0]);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object p : pth) {
                        m = p.getClass().getMethod("getName", new Class[0]);
                        String name = (String)m.invoke(p, new Object[0]);
                        stringBuilder.append(".");
                        stringBuilder.append(name);
                    }
                    logger.error("Validation of " + type + " failed: " + msg + " - Invalid Value: " + invalidValue + " for path: " + stringBuilder.toString() + "\n Tried to store: " + s);
                }
            }
            catch (Exception e1) {
                logger.error("Could not get more information about validation error ", (Throwable)e1);
            }
        }
    }

    @Override
    public <T> void store(final List<T> lst, final String cln, AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            WriterTask r = new WriterTask(){
                private AsyncOperationCallback<T> callback;

                public void setCallback(AsyncOperationCallback cb) {
                    this.callback = cb;
                }

                @Override
                public void run() {
                    long allStart = System.currentTimeMillis();
                    try {
                        String coll;
                        Class c;
                        HashMap toUpdate = new HashMap();
                        HashMap newElementsToInsert = new HashMap();
                        for (Object e : lst) {
                            boolean isn;
                            Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(e.getClass());
                            if (!MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(type, Entity.class)) {
                                logger.error("Not an entity! Storing not possible! Even not in list!");
                                continue;
                            }
                            MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                            Object e2 = MorphiumWriterImpl.this.morphium.getARHelper().getRealObject(e);
                            if (e2 == null) {
                                logger.warn("Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                                return;
                            }
                            boolean bl = isn = MorphiumWriterImpl.this.morphium.getId(e2) == null;
                            if (MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                                isn = MorphiumWriterImpl.this.morphium.setAutoValues(e2);
                            }
                            if (isn) {
                                MorphiumWriterImpl.this.setIdIfNull(e2);
                                newElementsToInsert.putIfAbsent(e2.getClass(), new ArrayList());
                                ((List)newElementsToInsert.get(e2.getClass())).add(MorphiumWriterImpl.this.morphium.getMapper().serialize(e2));
                            } else {
                                toUpdate.putIfAbsent(e2.getClass(), new ArrayList());
                                ((List)toUpdate.get(e2.getClass())).add(MorphiumWriterImpl.this.morphium.getMapper().serialize(e2));
                            }
                            MorphiumWriterImpl.this.morphium.firePreStore(e2, isn);
                        }
                        for (Map.Entry entry : toUpdate.entrySet()) {
                            c = (Class)entry.getKey();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            coll = cln != null ? cln : MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            MorphiumWriterImpl.this.createIndexAndCaps(c, coll, this.callback);
                            Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(c, Entity.class);
                            long start = System.currentTimeMillis();
                            Map<String, Integer> ret = MorphiumWriterImpl.this.morphium.getDriver().store(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll, (List)entry.getValue(), wc);
                            if (en.autoVersioning() && ret.get("total") < ret.get("modified")) {
                                throw new ConcurrentModificationException("versioning failure");
                            }
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(c);
                            long dur = System.currentTimeMillis() - start;
                            MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, toUpdate, dur, true, WriteAccessType.BULK_INSERT);
                            ((List)entry.getValue()).forEach(record -> MorphiumWriterImpl.this.morphium.firePostStore(record, true));
                        }
                        for (Map.Entry entry : newElementsToInsert.entrySet()) {
                            c = (Class)entry.getKey();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            String string = coll = cln != null ? cln : MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            if (MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll)) {
                                MorphiumWriterImpl.this.createCappedCollationColl(c, coll);
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(c, coll, this.callback);
                            }
                            long start = System.currentTimeMillis();
                            MorphiumWriterImpl.this.morphium.getDriver().insert(MorphiumWriterImpl.this.morphium.getConfig().getDatabase(), coll, (List)entry.getValue(), wc);
                            MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(c);
                            long dur = System.currentTimeMillis() - start;
                            MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, toUpdate, dur, true, WriteAccessType.BULK_INSERT);
                            ((List)entry.getValue()).forEach(record -> MorphiumWriterImpl.this.morphium.firePostStore(record, true));
                        }
                        if (this.callback != null) {
                            this.callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (this.callback == null) {
                            throw new RuntimeException(e);
                        }
                        this.callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, lst);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void flush(Class type) {
    }

    @Override
    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.store(lst, (String)null, callback);
    }

    private void createCappedCollationColl(Class c) {
        this.createCappedCollationColl(c, null);
    }

    private void createCappedCollationColl(Class c, String n) {
        de.caluga.morphium.annotations.Collation collation;
        if (logger.isDebugEnabled()) {
            logger.debug("Collection does not exist - ensuring indices / capped status / Schema validation");
        }
        Entity e = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Entity.class);
        LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("create", n != null ? n : this.morphium.getMapper().getCollectionName(c));
        Capped capped = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Capped.class);
        if (capped != null) {
            cmd.put("capped", true);
            cmd.put("size", capped.maxSize());
            cmd.put("max", capped.maxEntries());
        }
        if (!e.schemaDef().equals("")) {
            JSONParser jsonParser = new JSONParser();
            try {
                Map def = (Map)jsonParser.parse(e.schemaDef(), new ContainerFactory(){

                    public Map createObjectContainer() {
                        return new HashMap();
                    }

                    public List creatArrayContainer() {
                        return new ArrayList();
                    }
                });
                cmd.put("validator", def);
                cmd.put("validationLevel", e.validationLevel().name());
                cmd.put("validationAction", e.validationAction().name());
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        if (!e.comment().equals("")) {
            cmd.put("comment", e.comment());
        }
        if ((collation = this.morphium.getARHelper().getAnnotationFromHierarchy(c, de.caluga.morphium.annotations.Collation.class)) != null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("locale", collation.locale());
            if (!collation.alternate().equals("")) {
                map.put("alternate", (Object)collation.alternate());
            }
            if (!collation.caseFirst().equals("")) {
                map.put("caseFirst", (Object)collation.caseFirst());
            }
            map.put("backwards", collation.backwards());
            map.put("caseLevel", collation.caseLevel());
            map.put("numericOrdering", collation.numericOrdering());
            map.put("strength", (Object)collation.strength());
            cmd.put("collation", map);
        }
        try {
            this.morphium.getDriver().runCommand(this.morphium.getConfig().getDatabase(), cmd);
        }
        catch (MorphiumDriverException ex) {
            if (ex.getMessage().startsWith("internal error: Command failed with error 48 (NamespaceExists): 'Collection already exists. NS:")) {
                LoggerFactory.getLogger(MorphiumWriterImpl.class).error("Collection already exists...?");
            }
            throw new RuntimeException(ex);
        }
    }

    public <T> void convertToCapped(Class<T> c) {
        this.convertToCapped(c, null);
    }

    public <T> void convertToCapped(Class<T> c, AsyncOperationCallback<T> callback) {
        Runnable r = () -> {
            WriteConcern wc = this.morphium.getWriteConcernForClass(c);
            String coll = this.morphium.getMapper().getCollectionName(c);
            try {
                if (this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !this.morphium.getDriver().exists(this.morphium.getConfig().getDatabase(), coll)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Collection does not exist - ensuring indices / capped status");
                    }
                    LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
                    cmd.put("create", coll);
                    Capped capped = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        cmd.put("capped", true);
                        cmd.put("size", capped.maxSize());
                        cmd.put("max", capped.maxEntries());
                    }
                    this.morphium.getDriver().runCommand(this.getDbName(), cmd);
                } else {
                    Capped capped = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        HashMap<String, Object> cmd = new HashMap<String, Object>();
                        cmd.put("convertToCapped", coll);
                        cmd.put("size", capped.maxSize());
                        cmd.put("max", capped.maxEntries());
                        this.morphium.getDriver().runCommand(this.getDbName(), cmd);
                        this.morphium.ensureIndicesFor(c, callback);
                    }
                }
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        };
        if (callback == null) {
            r.run();
        } else {
            this.morphium.getAsyncOperationsThreadPool().execute(r);
        }
    }

    private String getDbName() {
        return this.morphium.getConfig().getDatabase();
    }

    private void executeWriteBatch(List<Object> es, Class c, WriteConcern wc, BulkRequestContext bulkCtx, long start) {
        try {
            bulkCtx.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(c, es, dur, false, WriteAccessType.BULK_UPDATE);
        this.morphium.getCache().clearCacheIfNecessary(c);
        this.morphium.firePostStore(es, false);
    }

    @Override
    public <T> void set(final T toSet, final String collection, final String field, final Object v, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask<T>(){
            private AsyncOperationCallback<T> callback;

            @Override
            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                Object value = v;
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                value = MorphiumWriterImpl.this.marshallIfNecessary(value);
                if (collection == null) {
                    MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> update = value != null ? Utils.getMap("$set", Utils.getMap(fieldName, value instanceof Enum ? ((Enum)value).name() : value)) : Utils.getMap("$set", Utils.getMap(fieldName, null));
                List<String> lastChangeFields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, LastChange.class);
                if (lastChangeFields != null && !lastChangeFields.isEmpty() && MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                    MorphiumWriterImpl.this.updateField(cls, update, lastChangeFields);
                }
                List<String> creationTimeFields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, CreationTime.class);
                if (upsert && creationTimeFields != null && !creationTimeFields.isEmpty()) {
                    long cnt;
                    try {
                        cnt = MorphiumWriterImpl.this.morphium.getDriver().count(MorphiumWriterImpl.this.getDbName(), collection, query, null, null);
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                    if (cnt == 0L) {
                        MorphiumWriterImpl.this.updateField(cls, update, creationTimeFields);
                    }
                }
                Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(toSet.getClass(), Entity.class);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    if (upsert && MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), collection)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(cls, collection);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, collection, this.callback);
                    }
                    if (en != null && en.autoVersioning()) {
                        List<String> versionFields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, Version.class);
                        query.put("morphium version", MorphiumWriterImpl.this.morphium.getARHelper().getValue(toSet, versionFields.get(0)));
                        update.put("morphium version", (Long)MorphiumWriterImpl.this.morphium.getARHelper().getValue(toSet, versionFields.get(0)) + 1L);
                    }
                    Map<String, Object> res = MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), collection, query, update, multiple, upsert, null, wc);
                    if (en != null && en.autoVersioning() && res.get("modified").equals(0L)) {
                        throw new ConcurrentModificationException("could not modify");
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    try {
                        f.set(toSet, v);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, null, System.currentTimeMillis() - start, null, toSet, field, v);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field, v);
                }
                MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private void updateField(Class cls, Map<String, Object> update, List<String> lastChangeFields) {
        for (String fL : lastChangeFields) {
            Field fld = this.morphium.getARHelper().getField(cls, fL);
            if (fld.getType().equals(Date.class)) {
                ((Map)update.get("$set")).put(fL, new Date());
                continue;
            }
            ((Map)update.get("$set")).put(fL, System.currentTimeMillis());
        }
    }

    public <T> void submitAndBlockIfNecessary(AsyncOperationCallback<T> callback, WriterTask<T> r) {
        if (callback == null) {
            r.run();
        } else {
            r.setCallback(callback);
            int tries = 0;
            boolean retry = true;
            while (retry) {
                try {
                    ++tries;
                    this.executor.execute(r);
                    retry = false;
                }
                catch (OutOfMemoryError ignored) {
                    logger.error(tries + " - Got OutOfMemory Erro, retrying...", (Throwable)ignored);
                }
                catch (RejectedExecutionException e) {
                    if (tries > this.maximumRetries) {
                        throw new RuntimeException("Could not write - not even after " + this.maximumRetries + " retries and pause of " + this.pause + "ms", e);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.warn("thread pool exceeded - waiting " + this.pause + " ms for the " + tries + ". time");
                    }
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public <T> void updateUsingFields(final T ent, final String collection, AsyncOperationCallback<T> callback, final String ... fields) {
        if (ent == null) {
            return;
        }
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.morphium.getARHelper().getId(ent);
                if (id == null) {
                    logger.warn("trying to partially update new object - storing it in full!");
                    MorphiumWriterImpl.this.store(ent, collection, this.callback);
                    return;
                }
                MorphiumWriterImpl.this.morphium.firePreStore(ent, false);
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                HashMap<String, Object> find = new HashMap<String, Object>();
                find.put("_id", id);
                HashMap<String, Object> update = new HashMap<String, Object>();
                for (String f : fields) {
                    try {
                        Object value = MorphiumWriterImpl.this.morphium.getARHelper().getValue(ent, f);
                        Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(value.getClass(), Entity.class);
                        if (MorphiumWriterImpl.this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class)) {
                            value = MorphiumWriterImpl.this.morphium.getARHelper().getField(ent.getClass(), f).getAnnotation(Reference.class) != null ? MorphiumWriterImpl.this.morphium.getARHelper().getId(ent) : MorphiumWriterImpl.this.morphium.getMapper().serialize(value);
                        }
                        if (en != null && en.translateCamelCase() || en != null && MorphiumWriterImpl.this.morphium.getConfig().isCamelCaseConversionEnabled()) {
                            f = MorphiumWriterImpl.this.morphium.getARHelper().convertCamelCase(f);
                        }
                        update.put(f, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Class<?> type = MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(ent.getClass());
                LastChange t = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(type, LastChange.class);
                if (t != null) {
                    List<String> lst = MorphiumWriterImpl.this.morphium.getARHelper().getFields(ent.getClass(), LastChange.class);
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(type, ctf);
                        if (f != null) {
                            try {
                                f.set(ent, now);
                            }
                            catch (IllegalAccessException e) {
                                logger.error("Could not set modification time", (Throwable)e);
                            }
                        }
                        update.put(ctf, now);
                    }
                }
                update = Utils.getMap("$set", update);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                long start = System.currentTimeMillis();
                try {
                    Entity en;
                    String collectionName = collection;
                    if (collectionName == null) {
                        collectionName = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(ent.getClass());
                    }
                    if (MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), collectionName)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(ent.getClass(), collectionName);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(ent.getClass(), collectionName, this.callback);
                    }
                    if ((en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(ent.getClass(), Entity.class)) != null && en.autoVersioning()) {
                        List<String> fl = MorphiumWriterImpl.this.morphium.getARHelper().getFields(ent.getClass(), Version.class);
                        find.put("morphium version", MorphiumWriterImpl.this.morphium.getARHelper().getValue(ent, fl.get(0)));
                        update.put("morphium version", (Long)MorphiumWriterImpl.this.morphium.getARHelper().getValue(ent, fl.get(0)) + 1L);
                    }
                    MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), collectionName, find, update, false, false, null, wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(ent.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(ent.getClass()));
                    MorphiumWriterImpl.this.morphium.firePostStore(ent, false);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, null, ent, new Object[]{fields});
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, e.getMessage(), e, ent, new Object[]{fields});
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void remove(final List<T> lst, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                HashMap sortedMap = new HashMap();
                for (Object o : lst) {
                    if (sortedMap.get(o.getClass()) == null) {
                        ArrayList queries = new ArrayList();
                        sortedMap.put(o.getClass(), queries);
                    }
                    Query<?> q = MorphiumWriterImpl.this.morphium.createQueryFor(o.getClass());
                    q.f(MorphiumWriterImpl.this.morphium.getARHelper().getIdFieldName(o)).eq(MorphiumWriterImpl.this.morphium.getARHelper().getId(o));
                    ((List)sortedMap.get(o.getClass())).add(q);
                }
                MorphiumWriterImpl.this.morphium.firePreRemove(lst);
                long start = System.currentTimeMillis();
                try {
                    for (Class cls : sortedMap.keySet()) {
                        Query orQuery = MorphiumWriterImpl.this.morphium.createQueryFor(cls);
                        orQuery = orQuery.or((List)sortedMap.get(cls));
                        MorphiumWriterImpl.this.remove(orQuery, null);
                    }
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemove(lst);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, null, lst);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, null, lst);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void remove(Query<T> q, AsyncOperationCallback<T> callback) {
        this.remove(q, true, callback);
    }

    @Override
    public <T> void remove(final Query<T> q, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(q.getType());
                long start = System.currentTimeMillis();
                try {
                    String collectionName = q.getCollectionName();
                    MorphiumWriterImpl.this.morphium.getDriver().delete(MorphiumWriterImpl.this.getDbName(), collectionName, q.toQueryObject(), multiple, q.getCollation(), wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(q.getType(), q.toQueryObject(), dur, false, WriteAccessType.BULK_DELETE);
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, null, null, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void remove(final T o, final String collection, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Object id = MorphiumWriterImpl.this.morphium.getARHelper().getId(o);
                MorphiumWriterImpl.this.morphium.firePreRemove(o);
                HashMap<String, Object> db = new HashMap<String, Object>();
                db.put("_id", id);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(o.getClass());
                long start = System.currentTimeMillis();
                try {
                    if (collection == null) {
                        MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(o.getClass());
                    }
                    MorphiumWriterImpl.this.morphium.getDriver().delete(MorphiumWriterImpl.this.getDbName(), collection, db, false, null, wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), o, dur, false, WriteAccessType.SINGLE_DELETE);
                    MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(o);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, o, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, o, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final T toInc, final String collection, final String field, final Number amount, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class<?> cls = toInc.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toInc));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> update = Utils.getMap("$inc", Utils.getMap(fieldName, amount));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toInc.getClass());
                long start = System.currentTimeMillis();
                try {
                    if (MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                    }
                    Entity en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(cls, Entity.class);
                    Long currentVersion = MorphiumWriterImpl.this.morphium.getARHelper().getLongValue(toInc, "morphium version");
                    if (en != null && en.autoVersioning()) {
                        query.put("morphium version", currentVersion);
                        ((Map)update.get("$inc")).put("morphium version", currentVersion + 1L);
                    }
                    Map<String, Object> res = MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, query, update, false, false, null, wc);
                    if (en != null && en.autoVersioning() && res.get("modified").equals(0L)) {
                        throw new ConcurrentModificationException("Versioning error? Could not update");
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    if (en != null && en.autoVersioning()) {
                        MorphiumWriterImpl.this.morphium.getARHelper().setValue(toInc, currentVersion + 1L, MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, Version.class).get(0));
                    }
                    if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        try {
                            f.set(toInc, (Integer)f.get(toInc) + amount.intValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                        try {
                            f.set(toInc, (Double)f.get(toInc) + amount.doubleValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                        try {
                            f.set(toInc, Float.valueOf(((Float)f.get(toInc)).floatValue() + amount.floatValue()));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        try {
                            f.set(toInc, (Long)f.get(toInc) + amount.longValue());
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        logger.error("Could not set increased value - unsupported type " + cls.getName());
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toInc.getClass(), toInc, System.currentTimeMillis() - start, false, WriteAccessType.SINGLE_UPDATE);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, null, System.currentTimeMillis() - start, null, toInc, field, amount);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, null, System.currentTimeMillis() - start, e.getMessage(), e, toInc, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final Query<T> query, final Map<String, Number> fieldsToInc, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                HashMap<String, Object> update = new HashMap<String, Object>();
                update.put("$inc", new HashMap(fieldsToInc));
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                try {
                    if (upsert && MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                    }
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, qobj, update, multiple, upsert, query.getCollation(), wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, upsert, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, fieldsToInc);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fieldsToInc);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final Number amount, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = query.getCollectionName();
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> update = Utils.getMap("$inc", Utils.getMap(fieldName, amount));
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                long start = System.currentTimeMillis();
                try {
                    if (upsert && MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                    }
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, qobj, update, multiple, upsert, query.getCollation(), wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, upsert, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, field, amount);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        this.submitAndBlockIfNecessary(callback, new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                List<String> latChangeFlds;
                Entity en;
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                HashMap<String, Object> toSet = new HashMap<String, Object>();
                for (Map.Entry ef : values.entrySet()) {
                    String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, (String)ef.getKey());
                    toSet.put(fieldName, MorphiumWriterImpl.this.marshallIfNecessary(ef.getValue()));
                }
                Utils.UtilsMap<String, Object> update = Utils.getMap("$set", toSet);
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    List<String> creationTimeFlds = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, CreationTime.class);
                    try {
                        if (creationTimeFlds != null && !creationTimeFlds.isEmpty() && MorphiumWriterImpl.this.morphium.getDriver().count(MorphiumWriterImpl.this.getDbName(), coll, qobj, query.getCollation(), null) == 0L && creationTimeFlds != null && !creationTimeFlds.isEmpty() && MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                            MorphiumWriterImpl.this.updateField(cls, update, creationTimeFlds);
                        }
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                }
                if ((en = MorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(cls, Entity.class)).autoVersioning()) {
                    update.put("$inc", Utils.getMap("morphium version", 1));
                }
                if ((latChangeFlds = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, LastChange.class)) != null && !latChangeFlds.isEmpty() && MorphiumWriterImpl.this.morphium.isAutoValuesEnabledForThread()) {
                    MorphiumWriterImpl.this.updateField(cls, update, latChangeFlds);
                }
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    if (upsert && MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                        MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                    }
                    Map<String, Object> daa = MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, qobj, update, multiple, upsert, query.getCollation(), wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, upsert, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, values, upsert, multiple);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, values, upsert, multiple);
                }
            }
        });
    }

    @Override
    public <T> void unset(Query<T> query, AsyncOperationCallback<T> callback, boolean multiple, Enum ... fields) {
        ArrayList<String> flds = new ArrayList<String>();
        for (Enum e : fields) {
            flds.add(e.name());
        }
        this.unset(query, callback, multiple, flds.toArray(new String[fields.length]));
    }

    @Override
    public <T> void unset(final Query<T> query, AsyncOperationCallback<T> callback, final boolean multiple, final String ... fields) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                Map<String, Object> qobj = query.toQueryObject();
                HashMap<String, String> toSet = new HashMap<String, String>();
                for (String f : fields) {
                    toSet.put(f, "");
                }
                Utils.UtilsMap<String, Object> update = Utils.getMap("$unset", toSet);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, qobj, update, multiple, false, query.getCollation(), wc);
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, false, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, fields, false, multiple);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, fields, false, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(final T toSet, final String collection, final String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.morphium.getARHelper().getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet, collection, callback);
        }
        WT r = new WT(){

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> update = Utils.getMap("$unset", Utils.getMap(fieldName, 1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toSet.getClass());
                this.doUpdate(cls, toSet, coll, field, query, f, update, wc);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void pop(final T obj, final String collection, final String field, final boolean first, AsyncOperationCallback<T> callback) {
        if (obj == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.morphium.getARHelper().getId(obj) == null) {
            logger.info("just storing object as it is new...");
            this.store(obj, collection, callback);
        }
        WT r = new WT(){

            @Override
            public void run() {
                Class<?> cls = obj.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("_id", MorphiumWriterImpl.this.morphium.getId(obj));
                Field f = MorphiumWriterImpl.this.morphium.getARHelper().getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> update = Utils.getMap("$pop", Utils.getMap(fieldName, first ? -1 : 1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(obj.getClass());
                this.doUpdate(cls, obj, coll, field, query, f, update, wc);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(Query<T> query, String field, boolean multiple, AsyncOperationCallback<T> callback) {
        this.unset(query, callback, multiple, field);
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> query, final String field, final Object value, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                String coll = query.getCollectionName();
                Map<String, Object> qobj = query.toQueryObject();
                if (upsert) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                Object v = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String fieldName = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                Utils.UtilsMap<String, Object> set = Utils.getMap(fieldName, v instanceof Enum ? ((Enum)v).name() : v);
                Utils.UtilsMap<String, Utils.UtilsMap<String, Object>> update = Utils.getMap(push ? "$push" : "$pull", set);
                long start = System.currentTimeMillis();
                try {
                    MorphiumWriterImpl.this.pushIt(push, upsert, multiple, cls, coll, qobj, update, query.getCollation());
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, null, null, field, value, upsert, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, upsert, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private Object marshallIfNecessary(Object value) {
        if (value != null) {
            if (value instanceof Enum) {
                return ((Enum)value).name();
            }
            if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
                Map<String, Object> marshall = this.morphium.getMapper().serialize(value);
                marshall.put("class_name", this.morphium.getARHelper().getRealClass(value.getClass()).getName());
                value = marshall;
            } else if (List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
                for (Object o : (List)value) {
                    if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(o.getClass(), Embedded.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(o.getClass(), Entity.class)) {
                        Map<String, Object> marshall = this.morphium.getMapper().serialize(o);
                        marshall.put("class_name", this.morphium.getARHelper().getRealClass(o.getClass()).getName());
                        lst.add(marshall);
                        continue;
                    }
                    lst.add((Map<String, Object>)o);
                }
                value = lst;
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> e;
                    Map.Entry<String, Object> en = e = iterator.next();
                    if (!String.class.isAssignableFrom(e.getKey().getClass())) {
                        throw new IllegalArgumentException("Can't push maps with Key not of type String!");
                    }
                    if (!this.morphium.getARHelper().isAnnotationPresentInHierarchy(en.getValue().getClass(), Entity.class) && !this.morphium.getARHelper().isAnnotationPresentInHierarchy(en.getValue().getClass(), Embedded.class)) continue;
                    Map<String, Object> marshall = this.morphium.getMapper().serialize(en.getValue());
                    marshall.put("class_name", this.morphium.getARHelper().getRealClass(en.getValue().getClass()).getName());
                    ((Map)value).put(en.getKey(), marshall);
                }
            }
        }
        return value;
    }

    private void pushIt(boolean push, boolean upsert, boolean multiple, Class<?> cls, String coll, Map<String, Object> qobj, Map<String, Object> update, Collation collation) {
        Entity en;
        this.morphium.firePreUpdateEvent(this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
        List<String> lastChangeFields = this.morphium.getARHelper().getFields(cls, LastChange.class);
        if (lastChangeFields != null && !lastChangeFields.isEmpty()) {
            update.put("$set", new HashMap());
            this.updateField(cls, update, lastChangeFields);
        }
        if (upsert) {
            this.doUpsert(upsert, cls, coll, qobj, update, collation);
        }
        if ((en = this.morphium.getARHelper().getAnnotationFromHierarchy(cls, Entity.class)).autoVersioning()) {
            update.put("$inc", Utils.getMap("morphium version", 1));
        }
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        try {
            if (this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !this.morphium.getDriver().exists(this.getDbName(), coll) && upsert) {
                this.createCappedCollationColl(cls, coll);
                this.morphium.ensureIndicesFor(cls, coll);
            }
            this.morphium.getDriver().update(this.getDbName(), coll, qobj, update, multiple, upsert, collation, wc);
            this.morphium.inc(StatisticKeys.WRITES);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, upsert, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.getCache().clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
    }

    private void doUpsert(boolean upsert, Class<?> cls, String coll, Map<String, Object> qobj, Map<String, Object> update, Collation collation) {
        List<String> creationTimeFields = this.morphium.getARHelper().getFields(cls, CreationTime.class);
        if (upsert && creationTimeFields != null && !creationTimeFields.isEmpty()) {
            long cnt;
            try {
                cnt = this.morphium.getDriver().count(this.getDbName(), coll, qobj, collation, null);
                this.morphium.inc(StatisticKeys.WRITES);
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
            if (cnt == 0L) {
                update.putIfAbsent("$set", new HashMap());
                this.updateField(cls, update, creationTimeFields);
            }
        }
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> query, final String f, final List<?> v, final boolean upsert, final boolean multiple, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){
            private AsyncOperationCallback<T> callback;

            public void setCallback(AsyncOperationCallback cb) {
                this.callback = cb;
            }

            @Override
            public void run() {
                List value = v;
                String field = f;
                Class cls = query.getType();
                String coll = query.getCollectionName();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                long start = System.currentTimeMillis();
                value = value.stream().map(o -> MorphiumWriterImpl.this.marshallIfNecessary(o)).collect(Collectors.toList());
                try {
                    Utils.UtilsMap<String, Object> update;
                    Map<String, Object> qobj = query.toQueryObject();
                    if (upsert) {
                        qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    }
                    field = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, field);
                    if (push) {
                        Utils.UtilsMap set = Utils.getMap(field, Utils.getMap("$each", value));
                        update = Utils.getMap("$push", set);
                    } else {
                        update = Utils.getMap("$pullAll", Utils.getMap(field, value));
                    }
                    List<String> lastChangeFields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, LastChange.class);
                    if (lastChangeFields != null && !lastChangeFields.isEmpty()) {
                        update.put("$set", new HashMap());
                        MorphiumWriterImpl.this.updateField(cls, update, lastChangeFields);
                    }
                    if (upsert) {
                        MorphiumWriterImpl.this.doUpsert(upsert, cls, coll, qobj, update, query.getCollation());
                    }
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    try {
                        if (upsert && MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                            MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                            MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                        }
                        MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, qobj, update, multiple, upsert, query.getCollation(), wc);
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, upsert, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (this.callback != null) {
                        this.callback.onOperationSucceeded(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, null, null, field, value, upsert, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (this.callback == null) {
                        throw new RuntimeException(e);
                    }
                    this.callback.onOperationError(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, upsert, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, final String collection, AsyncOperationCallback<T> callback) {
        if (!this.morphium.getARHelper().isAnnotationPresentInHierarchy(cls, Entity.class)) {
            throw new RuntimeException("No entity class: " + cls.getName());
        }
        WriterTask r = new WriterTask(){

            public void setCallback(AsyncOperationCallback cb) {
            }

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreDrop(cls);
                long start = System.currentTimeMillis();
                String co = collection;
                if (co == null) {
                    co = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                try {
                    MorphiumWriterImpl.this.morphium.getDriver().drop(MorphiumWriterImpl.this.getDbName(), co, null);
                }
                catch (MorphiumDriverException e) {
                    throw new RuntimeException(e);
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, null, dur, false, WriteAccessType.DROP);
                MorphiumWriterImpl.this.morphium.firePostDropEvent(cls);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final String collection, final Map<String, Object> index, final Map<String, Object> options, AsyncOperationCallback<T> callback) {
        WriterTask r = new WriterTask(){

            public void setCallback(AsyncOperationCallback cb) {
            }

            @Override
            public void run() {
                List<String> fields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, new Class[0]);
                LinkedHashMap idx = new LinkedHashMap();
                for (Map.Entry es : index.entrySet()) {
                    String k = (String)es.getKey();
                    if (!(k.contains(".") || fields.contains(k) || fields.contains(MorphiumWriterImpl.this.morphium.getARHelper().convertCamelCase(k)))) {
                        throw new IllegalArgumentException("Field unknown for type " + cls.getSimpleName() + ": " + k);
                    }
                    String fn = MorphiumWriterImpl.this.morphium.getARHelper().getFieldName(cls, k);
                    idx.put(fn, es.getValue());
                }
                long start = System.currentTimeMillis();
                LinkedHashMap<String, Object> keys = new LinkedHashMap<String, Object>(idx);
                String coll = collection;
                if (coll == null) {
                    coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                }
                try {
                    MorphiumWriterImpl.this.morphium.getDriver().createIndex(MorphiumWriterImpl.this.getDbName(), coll, keys, options);
                }
                catch (MorphiumDriverException e) {
                    throw new RuntimeException(e);
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, keys, dur, false, WriteAccessType.ENSURE_INDEX);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public int writeBufferCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public void onShutdown(Morphium m) {
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract class WT<T>
    implements WriterTask<T> {
        private AsyncOperationCallback<T> callback;

        @Override
        public void setCallback(AsyncOperationCallback cb) {
            this.callback = cb;
        }

        public void doUpdate(Class cls, T toSet, String coll, String field, Map<String, Object> query, Field f, Map<String, Object> update, WriteConcern wc) {
            long start = System.currentTimeMillis();
            try {
                if (MorphiumWriterImpl.this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !MorphiumWriterImpl.this.morphium.getDriver().exists(MorphiumWriterImpl.this.getDbName(), coll)) {
                    MorphiumWriterImpl.this.createCappedCollationColl(cls, coll);
                    MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls, coll, this.callback);
                }
                MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, query, update, false, false, null, wc);
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                List<String> lastChangeFields = MorphiumWriterImpl.this.morphium.getARHelper().getFields(cls, LastChange.class);
                if (lastChangeFields != null && !lastChangeFields.isEmpty()) {
                    update = Utils.getMap("$set", new HashMap());
                    MorphiumWriterImpl.this.updateField(cls, update, lastChangeFields);
                    MorphiumWriterImpl.this.morphium.getDriver().update(MorphiumWriterImpl.this.getDbName(), coll, query, update, false, false, null, wc);
                }
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toSet.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                try {
                    f.set(toSet, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.morphium.getARHelper().getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                if (this.callback != null) {
                    this.callback.onOperationSucceeded(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, null, toSet, field);
                }
            }
            catch (Exception e) {
                if (this.callback == null) {
                    throw new RuntimeException(e);
                }
                this.callback.onOperationError(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field);
            }
        }
    }
}

