/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Embedded(translateCamelCase=false)
public class ReplicaSetStatus {
    private String set;
    private int myState;
    private String syncSourceHost;
    private Date date;
    private int term;
    private int syncSourceId;
    private long heartbeatIntervalMillis;
    private int majorityVoteCount;
    private int writeMajorityCount;
    private int votingMembersCount;
    private int writableVotingMembersCount;
    private long lastStableRecoveryTimestamp;
    private List<ReplicaSetNode> members;
    private Map<String, Object> optimes;
    private Map<String, Object> electionCandidateMetrics;
    @Transient
    private ReplicaSetConf config;

    public String getSet() {
        return this.set;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public int getMyState() {
        return this.myState;
    }

    public void setMyState(int myState) {
        this.myState = myState;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public List<ReplicaSetNode> getMembers() {
        return this.members;
    }

    public void setMembers(List<ReplicaSetNode> members) {
        this.members = members;
    }

    public ReplicaSetConf getConfig() {
        return this.config;
    }

    public void setConfig(ReplicaSetConf config) {
        this.config = config;
    }

    public String getSyncSourceHost() {
        return this.syncSourceHost;
    }

    public void setSyncSourceHost(String syncSourceHost) {
        this.syncSourceHost = syncSourceHost;
    }

    public int getTerm() {
        return this.term;
    }

    public void setTerm(int term) {
        this.term = term;
    }

    public int getSyncSourceId() {
        return this.syncSourceId;
    }

    public void setSyncSourceId(int syncSourceId) {
        this.syncSourceId = syncSourceId;
    }

    public long getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public void setHeartbeatIntervalMillis(long heartbeatIntervalMillis) {
        this.heartbeatIntervalMillis = heartbeatIntervalMillis;
    }

    public int getMajorityVoteCount() {
        return this.majorityVoteCount;
    }

    public void setMajorityVoteCount(int majorityVoteCount) {
        this.majorityVoteCount = majorityVoteCount;
    }

    public int getWriteMajorityCount() {
        return this.writeMajorityCount;
    }

    public void setWriteMajorityCount(int writeMajorityCount) {
        this.writeMajorityCount = writeMajorityCount;
    }

    public int getVotingMembersCount() {
        return this.votingMembersCount;
    }

    public void setVotingMembersCount(int votingMembersCount) {
        this.votingMembersCount = votingMembersCount;
    }

    public int getWritableVotingMembersCount() {
        return this.writableVotingMembersCount;
    }

    public void setWritableVotingMembersCount(int writableVotingMembersCount) {
        this.writableVotingMembersCount = writableVotingMembersCount;
    }

    public long getLastStableRecoveryTimestamp() {
        return this.lastStableRecoveryTimestamp;
    }

    public void setLastStableRecoveryTimestamp(long lastStableRecoveryTimestamp) {
        this.lastStableRecoveryTimestamp = lastStableRecoveryTimestamp;
    }

    public Map<String, Object> getOptimes() {
        return this.optimes;
    }

    public void setOptimes(Map<String, Object> optimes) {
        this.optimes = optimes;
    }

    public Map<String, Object> getElectionCandidateMetrics() {
        return this.electionCandidateMetrics;
    }

    public void setElectionCandidateMetrics(Map<String, Object> electionCandidateMetrics) {
        this.electionCandidateMetrics = electionCandidateMetrics;
    }

    public int getActiveNodes() {
        if (this.members == null) {
            return 0;
        }
        int up = 0;
        for (ReplicaSetNode n : this.members) {
            if (n.getState() > 2) continue;
            boolean ignore = false;
            for (ConfNode c : this.config.getMembers()) {
                if (c.getId() != n.getId() || c.getHidden() == null || !c.getHidden().booleanValue()) continue;
                ignore = true;
            }
            if (ignore) continue;
            ++up;
        }
        return up;
    }

    public String toString() {
        return Utils.toJsonString(new ObjectMapperImpl().serialize(this));
    }
}

