/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.jms.Consumer;
import de.caluga.morphium.messaging.jms.Producer;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class Context
implements JMSContext {
    private final int sessionMode;
    private final Morphium morphium;
    private final Messaging messaging;
    private boolean startOnCosumerCreate = true;

    public Context(Morphium morphium, String name, int sessionMode) {
        this.morphium = morphium;
        this.sessionMode = sessionMode;
        this.messaging = new Messaging(morphium, 100, true, true, 10);
        if (name != null) {
            this.messaging.setQueueName(name);
        }
    }

    public Context(Morphium morphium) {
        this(morphium, null, 2);
    }

    public JMSContext createContext(int sessionMode) {
        return new Context(this.morphium, null, sessionMode);
    }

    public JMSProducer createProducer() {
        return new Producer(this.messaging);
    }

    public String getClientID() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public void setClientID(String clientID) {
        this.messaging.setSenderId(clientID);
    }

    public ConnectionMetaData getMetaData() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public ExceptionListener getExceptionListener() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public void setExceptionListener(ExceptionListener listener) {
    }

    public void start() {
        this.messaging.start();
    }

    public void stop() {
        this.messaging.terminate();
    }

    public boolean getAutoStart() {
        return this.startOnCosumerCreate;
    }

    public void setAutoStart(boolean autoStart) {
        this.startOnCosumerCreate = autoStart;
    }

    public void close() {
        this.stop();
    }

    public BytesMessage createBytesMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public MapMessage createMapMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public Message createMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public ObjectMessage createObjectMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public StreamMessage createStreamMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public TextMessage createTextMessage() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public TextMessage createTextMessage(String text) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public boolean getTransacted() {
        return false;
    }

    public int getSessionMode() {
        return 0;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void recover() {
    }

    public JMSConsumer createConsumer(Destination destination) {
        if (this.startOnCosumerCreate) {
            this.start();
        }
        return new Consumer(this.messaging, destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public Queue createQueue(String queueName) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public Topic createTopic(String topicName) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public QueueBrowser createBrowser(Queue queue) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public TemporaryQueue createTemporaryQueue() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public TemporaryTopic createTemporaryTopic() {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public void unsubscribe(String name) {
    }

    public void acknowledge() {
    }
}

