/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchinAggregationIterator<T, R>
implements MorphiumAggregationIterator<T, R> {
    private final Logger log = LoggerFactory.getLogger(PrefetchinAggregationIterator.class);
    private long lastAccess = System.currentTimeMillis();
    private List<List<R>> prefetchBuffer = new CopyOnWriteArrayList<List<R>>();
    private int batchsize;
    private MorphiumCursor cursor;
    private int numPrefetchBuffers;
    private volatile int cursorPos;
    private boolean startedAlready = false;
    private Aggregator<T, R> aggregator;

    public List<List<R>> getPrefetchBuffer() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer;
    }

    public void setPrefetchBuffer(List<List<R>> prefetchBuffer) {
        this.checkAndUpdateLastAccess();
        this.prefetchBuffer = prefetchBuffer;
    }

    @Override
    public int getWindowSize() {
        this.checkAndUpdateLastAccess();
        return this.batchsize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.checkAndUpdateLastAccess();
        this.batchsize = sz;
    }

    @Override
    public Aggregator<T, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setAggregator(Aggregator<T, R> aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public int getCurrentBufferSize() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer.size();
    }

    @Override
    public List<R> getCurrentBuffer() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer.get(0);
    }

    @Override
    public long getCount() {
        this.checkAndUpdateLastAccess();
        return 0L;
    }

    @Override
    public int getCursor() {
        this.checkAndUpdateLastAccess();
        return this.cursorPos;
    }

    @Override
    public void ahead(int jump) {
        for (int i = 0; i < jump; ++i) {
            this.next();
        }
    }

    @Override
    public void back(int jump) {
        if (jump < this.cursorPos % this.getWindowSize()) {
            this.cursorPos -= jump;
        } else {
            throw new IllegalArgumentException("Cannot jump back past window boundaries");
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        this.checkAndUpdateLastAccess();
        if (n <= 1) {
            n = 2;
            this.log.error("Prefetching only makes sense with at least 2 prefetchwindows... setting to 2");
        }
        this.numPrefetchBuffers = n;
    }

    @Override
    public int getNumberOfAvailableThreads() {
        this.checkAndUpdateLastAccess();
        return this.numPrefetchBuffers;
    }

    @Override
    public int getNumberOfThreads() {
        this.checkAndUpdateLastAccess();
        return 0;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        this.checkAndUpdateLastAccess();
        return true;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.checkAndUpdateLastAccess();
    }

    @Override
    public Iterator<R> iterator() {
        this.checkAndUpdateLastAccess();
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready) {
            this.startedAlready = true;
            try {
                this.cursor = this.aggregator.getMorphium().getDriver().initAggregationIteration(this.aggregator.getMorphium().getConfig().getDatabase(), this.aggregator.getCollectionName(), this.aggregator.getPipeline(), this.aggregator.getMorphium().getReadPreferenceForClass(this.aggregator.getSearchType()), this.aggregator.getCollation(), this.getWindowSize(), null);
                if (this.cursor == null) {
                    return false;
                }
                if (this.cursor.getBatch() == null) {
                    return false;
                }
                this.prefetchBuffer.add(this.getBatch(this.cursor));
                this.startPrefetch();
                if (!this.prefetchBuffer.get(0).isEmpty()) {
                    return true;
                }
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
        }
        while (this.prefetchBuffer.size() <= 1 && this.cursor != null) {
            Thread.yield();
        }
        if (this.prefetchBuffer.isEmpty()) {
            return false;
        }
        return (this.cursorPos % this.getWindowSize() != 0 || this.prefetchBuffer.size() != 1 || this.cursor != null) && this.cursorPos % this.getWindowSize() < this.prefetchBuffer.get(0).size();
    }

    private List<R> getBatch(MorphiumCursor crs) {
        List<Map<String, Object>> batch = crs.getBatch();
        ArrayList<R> ret = new ArrayList<R>();
        if (batch == null) {
            return ret;
        }
        for (Map<String, Object> obj : batch) {
            R unmarshall = this.aggregator.getMorphium().getMapper().deserialize(this.aggregator.getResultType(), obj);
            ret.add(unmarshall);
        }
        this.aggregator.getMorphium().firePostLoad(ret);
        return ret;
    }

    private void startPrefetch() {
        this.aggregator.getMorphium().queueTask(() -> {
            this.log.info("Starting prefetching...");
            block6: while (this.cursor != null) {
                while (this.prefetchBuffer.size() >= this.numPrefetchBuffers && this.cursor != null) {
                    try {
                        int waitTime = this.aggregator.getMorphium().getConfig().getMaxWaitTime();
                        if (waitTime > 0 && System.currentTimeMillis() - this.lastAccess > (long)waitTime) {
                            this.log.error("Cursor timeout... closing");
                            try {
                                this.aggregator.getMorphium().getDriver().closeIteration(this.cursor);
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            this.cursor = null;
                            return;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.log.debug("got interrupted - ignore");
                    }
                }
                while (this.prefetchBuffer.size() < this.numPrefetchBuffers) {
                    try {
                        if (this.cursor == null) continue block6;
                        MorphiumCursor crs = this.aggregator.getMorphium().getDriver().nextIteration(this.cursor);
                        if (crs == null || crs.getBatch() == null || crs.getBatch().isEmpty()) {
                            this.cursor = null;
                            continue block6;
                        }
                        this.prefetchBuffer.add(this.getBatch(crs));
                        this.cursor = crs;
                    }
                    catch (MorphiumDriverException e) {
                        this.cursor = null;
                        e.printStackTrace();
                        continue block6;
                    }
                }
            }
            this.log.info("Prefetch finished");
        });
    }

    @Override
    public R next() {
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready && !this.hasNext()) {
            return null;
        }
        if (this.prefetchBuffer.isEmpty()) {
            this.log.error("Prefetchbuffer is empty!");
            return null;
        }
        if (this.cursorPos != 0 && this.cursorPos % this.getWindowSize() == 0) {
            this.prefetchBuffer.remove(0);
        }
        while (this.prefetchBuffer.isEmpty() && this.cursor != null) {
            Thread.yield();
        }
        return this.prefetchBuffer.get(0).get(this.cursorPos++ % this.getWindowSize());
    }

    private void checkAndUpdateLastAccess() {
        this.lastAccess = System.currentTimeMillis();
    }
}

