/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.BinarySerializedObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.ReadOnly;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.annotations.encryption.Encrypted;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.mapping.BigIntegerTypeMapper;
import de.caluga.morphium.mapping.BsonGeoMapper;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import de.caluga.morphium.query.geospatial.Geo;
import de.caluga.morphium.query.geospatial.LineString;
import de.caluga.morphium.query.geospatial.MultiLineString;
import de.caluga.morphium.query.geospatial.MultiPoint;
import de.caluga.morphium.query.geospatial.MultiPolygon;
import de.caluga.morphium.query.geospatial.Point;
import de.caluga.morphium.query.geospatial.Polygon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

public class ObjectMapperImpl
implements MorphiumObjectMapper {
    private final Logger log = LoggerFactory.getLogger(ObjectMapperImpl.class);
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final Map<Class<?>, NameProvider> nameProviders;
    private final JSONParser jsonParser = new JSONParser();
    private final List<Class<?>> mongoTypes;
    private final ContainerFactory containerFactory;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper(true);
    private final Map<Class<?>, MorphiumTypeMapper> customMappers = new ConcurrentHashMap();
    private Morphium morphium;

    public ObjectMapperImpl() {
        this.nameProviders = new ConcurrentHashMap();
        this.mongoTypes = Collections.synchronizedList(new ArrayList());
        this.mongoTypes.add(String.class);
        this.mongoTypes.add(Character.class);
        this.mongoTypes.add(Integer.class);
        this.mongoTypes.add(Long.class);
        this.mongoTypes.add(Float.class);
        this.mongoTypes.add(Double.class);
        this.mongoTypes.add(Date.class);
        this.mongoTypes.add(Boolean.class);
        this.mongoTypes.add(Byte.class);
        this.mongoTypes.add(Short.class);
        this.mongoTypes.add(AtomicBoolean.class);
        this.mongoTypes.add(AtomicInteger.class);
        this.mongoTypes.add(AtomicLong.class);
        this.mongoTypes.add(Pattern.class);
        this.mongoTypes.add(BigDecimal.class);
        this.mongoTypes.add(UUID.class);
        this.mongoTypes.add(Instant.class);
        this.mongoTypes.add(LocalDate.class);
        this.mongoTypes.add(LocalTime.class);
        this.mongoTypes.add(LocalDateTime.class);
        this.containerFactory = new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
        this.customMappers.put(BigInteger.class, new BigIntegerTypeMapper());
        this.customMappers.put(Geo.class, new BsonGeoMapper());
        this.customMappers.put(Point.class, new BsonGeoMapper());
        this.customMappers.put(MultiPoint.class, new BsonGeoMapper());
        this.customMappers.put(MultiLineString.class, new BsonGeoMapper());
        this.customMappers.put(MultiPolygon.class, new BsonGeoMapper());
        this.customMappers.put(Polygon.class, new BsonGeoMapper());
        this.customMappers.put(LineString.class, new BsonGeoMapper());
    }

    @Override
    public void setAnnotationHelper(AnnotationAndReflectionHelper an) {
        this.annotationHelper = an;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper(true);
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public <T> void registerCustomMapperFor(Class<T> cls, MorphiumTypeMapper<T> map) {
        this.customMappers.put(cls, map);
    }

    @Override
    public void deregisterCustomMapperFor(Class cls) {
        this.customMappers.remove(cls);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            this.log.error("Error getting nameProvider", (Throwable)ex);
            throw new IllegalArgumentException("could not get name provider", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviders.get(cls) == null) {
            NameProvider np = p.nameProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setNameProviderForClass(cls, np);
        }
        return this.nameProviders.get(cls);
    }

    @Override
    public String getCollectionName(Class cls) {
        Entity p = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.annotationHelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            this.log.error("Could not instanciate NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.error("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    public Object marshallIfNecessary(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Expr) {
            return ((Expr)o).toQueryObject();
        }
        if (this.annotationHelper.isEntity(o) || this.customMappers.containsKey(o.getClass())) {
            return this.serialize(o);
        }
        if (o.getClass().isPrimitive()) {
            return o;
        }
        if (o.getClass().isArray()) {
            if (o.getClass().getComponentType().equals(Byte.TYPE)) {
                return o;
            }
            ArrayList<Object> lst = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(o); ++i) {
                lst.add(this.marshallIfNecessary(Array.get(o, i)));
            }
            return this.serializeIterable(lst, null);
        }
        if (o instanceof Iterable) {
            return this.serializeIterable((Iterable)o, null);
        }
        if (o instanceof Map) {
            return this.serializeMap((Map)o, null);
        }
        return o;
    }

    @Override
    public Map<String, Object> serialize(Object o) {
        if (o == null) {
            return new HashMap<String, Object>();
        }
        Class<?> c = this.annotationHelper.getRealClass(o.getClass());
        if (this.customMappers.containsKey(c)) {
            Object ret = this.customMappers.get(c).marshall(o);
            if (ret instanceof Map) {
                ((Map)ret).put("class_name", o.getClass().getName());
                return (Map)ret;
            }
            return Utils.getMap("value", ret);
        }
        if (!this.annotationHelper.isEntity(o) && !this.morphium.getConfig().isWarnOnNoEntitySerialization()) {
            if (this.morphium.getConfig().isObjectSerializationEnabled()) {
                if (o instanceof Serializable) {
                    try {
                        BinarySerializedObject obj = new BinarySerializedObject();
                        obj.setOriginalClassName(o.getClass().getName());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(out);
                        oout.writeObject(o);
                        oout.flush();
                        Base64.Encoder enc = Base64.getMimeEncoder();
                        String str = new String(enc.encode(out.toByteArray()));
                        obj.setB64Data(str);
                        return this.serialize(obj);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Binary serialization failed! " + o.getClass().getName(), e);
                    }
                }
                throw new IllegalArgumentException("Cannot write object to db that is neither entity, embedded nor serializable! ObjectType: " + o.getClass().getName());
            }
            throw new IllegalArgumentException("Object is no entity: " + o.getClass().getSimpleName());
        }
        if (!this.annotationHelper.isEntity(o) && this.morphium.getConfig().isWarnOnNoEntitySerialization()) {
            this.log.warn("Serializing non-entity of type " + o.getClass().getName());
        }
        HashMap<String, Object> dbo = new HashMap<String, Object>();
        Class<?> cls = this.annotationHelper.getRealClass(o.getClass());
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.annotationHelper.getRealObject(o);
        List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
        String cn = cls.getName();
        if (e != null && !e.typeId().equals(".")) {
            cn = e.typeId();
        }
        if (emb != null && !emb.typeId().equals(".")) {
            cn = emb.typeId();
        }
        if (e != null && e.polymorph()) {
            dbo.put("class_name", cn);
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", cn);
        }
        Iterator<String> iterator = flds.iterator();
        while (iterator.hasNext()) {
            String f;
            String fName = f = iterator.next();
            try {
                ArrayList<Object> lst;
                Field fld = this.annotationHelper.getField(cls, f);
                if (fld == null) {
                    this.log.error("Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers()) || fld.isAnnotationPresent(ReadOnly.class)) continue;
                Map<String, Object> value = fld.get(o);
                if (fld.isAnnotationPresent(Encrypted.class)) {
                    try {
                        Encrypted enc = fld.getAnnotation(Encrypted.class);
                        ValueEncryptionProvider encP = enc.provider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        byte[] encKey = this.morphium.getEncryptionKeyProvider().getEncryptionKey(enc.keyName());
                        encP.setEncryptionKey(encKey);
                        byte[] encrypted = encP.encrypt(Utils.toJsonString(this.marshallIfNecessary(value)).getBytes());
                        dbo.put(fName, encrypted);
                        continue;
                    }
                    catch (Exception exc) {
                        throw new RuntimeException("Ecryption failed. Field: " + fName + " class: " + o.getClass().getName(), exc);
                    }
                }
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly() || value == null) continue;
                    dbo.putAll(this.serializeMap(value, fld.getGenericType()));
                    continue;
                }
                if (dbo.containsKey(fName)) {
                    this.log.warn("Field " + fName + " is shadowed - inherited values?");
                    continue;
                }
                Map<String, Object> v = null;
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (Collection.class.isAssignableFrom(fld.getType())) {
                        lst = new ArrayList<Object>();
                        for (Object rec2 : (Collection)((Object)value)) {
                            if (rec2 != null) {
                                Object id = this.annotationHelper.getId(rec2);
                                if (id == null) {
                                    id = this.automaticStore(r, rec2);
                                }
                                if (this.morphium == null) {
                                    throw new RuntimeException("cannot set dbRef - morphium is not set");
                                }
                                MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec2.getClass()).getName(), id);
                                lst.add(this.serialize(ref));
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else if (Map.class.isAssignableFrom(fld.getType())) {
                        HashMap map = new HashMap();
                        ((Map)value).forEach((key, rec) -> {
                            Object id = this.annotationHelper.getId(rec);
                            if (id == null) {
                                id = this.automaticStore(r, rec);
                            }
                            if (this.morphium == null) {
                                throw new RuntimeException("cannot set dbRef - morphium is not set");
                            }
                            MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec.getClass()).getName(), id);
                            map.put(key, this.serialize(ref));
                        });
                        v = map;
                    } else {
                        if (this.annotationHelper.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    this.log.error("Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.annotationHelper.getId(value);
                    }
                } else {
                    Class<?> valueClass = value == null ? fld.getType() : value.getClass();
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Entity.class)) {
                        if (value != null) {
                            Map<String, Object> obj = this.serialize(value);
                            obj.remove("_id");
                            v = obj;
                        }
                    } else if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Embedded.class)) {
                        if (value != null) {
                            v = this.serialize(value);
                        }
                    } else {
                        v = value;
                        if (v != null) {
                            if (v instanceof Map) {
                                v = this.serializeMap(v, fld.getGenericType());
                            } else if (v.getClass().isArray()) {
                                if (!v.getClass().getComponentType().equals(Byte.TYPE)) {
                                    lst = new ArrayList();
                                    for (int i = 0; i < Array.getLength(v); ++i) {
                                        lst.add(this.marshallIfNecessary(Array.get(v, i)));
                                    }
                                    v = this.serializeIterable(lst, null);
                                }
                            } else if (v instanceof Iterable) {
                                v = this.serializeIterable((Iterable)((Object)v), fld.getGenericType());
                            } else if (v.getClass().equals(GregorianCalendar.class)) {
                                v = ((GregorianCalendar)((Object)v)).getTime();
                            } else if (v.getClass().equals(MorphiumId.class)) {
                                v = new ObjectId(((MorphiumId)((Object)v)).getBytes());
                            } else if (this.customMappers.containsKey(v.getClass())) {
                                v = this.customMappers.get(v.getClass()).marshall(v);
                            } else if (v instanceof Enum) {
                                v = this.serializeEnum(fld.getType(), (Enum)((Object)v));
                            }
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                this.log.error("Illegal Access to field " + f);
            }
        }
        return dbo;
    }

    private Object automaticStore(Reference r, Object rec) {
        String coll;
        if (r.automaticStore()) {
            if (this.morphium == null) {
                throw new RuntimeException("Could not automagically store references as morphium is not set!");
            }
            coll = r.targetCollection();
            if (coll.equals(".")) {
                coll = null;
            }
        } else {
            throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
        }
        this.morphium.storeNoCache(rec, coll);
        Object id = this.annotationHelper.getId(rec);
        return id;
    }

    public List<Object> serializeIterable(Iterable v, Type iterableType) {
        Class elementClass = null;
        Type elementType = null;
        if (iterableType instanceof ParameterizedType) {
            elementClass = this.getElementClass((ParameterizedType)iterableType);
            Type[] actualTypeArguments = ((ParameterizedType)iterableType).getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                elementType = actualTypeArguments[0];
            }
        }
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object lo : v) {
            if (lo != null) {
                if (this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Embedded.class)) {
                    Map<String, Object> marshall = this.serialize(lo);
                    String cn = this.getTypeId(lo);
                    marshall.put("class_name", cn);
                    lst.add(marshall);
                    continue;
                }
                if (lo instanceof Iterable) {
                    lst.add(this.serializeIterable((Iterable)lo, elementType));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add(this.serializeMap((Map)lo, elementType));
                    continue;
                }
                if (lo instanceof MorphiumId) {
                    lst.add(new ObjectId(((MorphiumId)lo).getBytes()));
                    continue;
                }
                if (lo instanceof Enum) {
                    lst.add(this.serializeEnum(elementClass, (Enum)lo));
                    continue;
                }
                if (lo.getClass().isPrimitive() || this.mongoTypes.contains(lo.getClass())) {
                    lst.add(lo);
                    continue;
                }
                if (lo.getClass().isArray()) {
                    if (lo.getClass().getComponentType().equals(Byte.TYPE)) {
                        lst.add(lo);
                        continue;
                    }
                    for (int i = 0; i < Array.getLength(lo); ++i) {
                        try {
                            lst.add(this.marshallIfNecessary(Array.get(lo, i)));
                            continue;
                        }
                        catch (Exception e) {
                            lst.add(this.marshallIfNecessary(((Integer)Array.get(lo, i)).byteValue()));
                        }
                    }
                    continue;
                }
                lst.add(this.serialize(lo));
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private String getTypeId(Object lo) {
        Class<?> cls = lo.getClass();
        Class<?> superclass = cls.getSuperclass();
        String cn = superclass != null && superclass.isEnum() ? superclass.getName() : cls.getName();
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(this.log.getClass(), Embedded.class);
        if (e != null && !e.typeId().equals(".")) {
            cn = e.typeId();
        } else if (emb != null && !emb.typeId().equals(".")) {
            cn = emb.typeId();
        }
        return cn;
    }

    public Map<String, Object> serializeMap(Map v, Type mapType) {
        Class elementClass = null;
        Type elementType = null;
        if (mapType instanceof ParameterizedType) {
            elementClass = this.getElementClass((ParameterizedType)mapType);
            Type[] actualTypeArguments = ((ParameterizedType)mapType).getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length > 1) {
                elementType = actualTypeArguments[1];
            }
        }
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                if (k instanceof Enum) {
                    k = ((Enum)k).name();
                } else {
                    this.log.debug("Map in Mongodb needs to have String as keys - using toString");
                    k = k.toString();
                    if (((String)k).contains(".")) {
                        this.log.warn(". not allowed as Key in Maps - converting to _");
                        k = ((String)k).replaceAll("\\.", "_");
                    }
                }
            }
            if ((mval = es.getValue()) != null) {
                if (this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Embedded.class)) {
                    Map<String, Object> obj = this.serialize(mval);
                    obj.put("class_name", this.getTypeId(mval));
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.serializeMap((Map)mval, elementType);
                } else if (mval instanceof Iterable) {
                    mval = this.serializeIterable((Iterable)mval, elementType);
                } else if (mval.getClass().isArray()) {
                    if (!mval.getClass().getComponentType().equals(Byte.TYPE)) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        for (int i = 0; i < Array.getLength(mval); ++i) {
                            lst.add(this.marshallIfNecessary(Array.get(mval, i)));
                        }
                        mval = this.serializeIterable(lst, null);
                    }
                } else if (mval instanceof Enum) {
                    mval = this.serializeEnum(elementClass, (Enum)mval);
                } else if (mval instanceof MorphiumId) {
                    mval = new ObjectId(((MorphiumId)mval).getBytes());
                } else if (!mval.getClass().isPrimitive() && !this.mongoTypes.contains(mval.getClass())) {
                    mval = this.serialize(mval);
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    public Object serializeEnum(Class<?> declaredClass, Enum val) {
        if (declaredClass != null && Enum.class.isAssignableFrom(declaredClass)) {
            return val.name();
        }
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("class_name", this.getTypeId(val));
        obj.put("name", val.name());
        return obj;
    }

    @Override
    public <T> T deserialize(Class<? extends T> cls, String jsonString) throws ParseException {
        if (jsonString.startsWith("{")) {
            HashMap obj = (HashMap)this.jsonParser.parse(jsonString, this.containerFactory);
            return this.deserialize(cls, obj);
        }
        return (T)((HashMap)this.jsonParser.parse("{\"value\":" + jsonString + "}", this.containerFactory)).get("value");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(Class<? extends T> theClass, Map<String, Object> o) {
        if (o == null) {
            return null;
        }
        Class<BinarySerializedObject> cls = theClass;
        if (this.customMappers.containsKey(cls)) {
            return this.customMappers.get(cls).unmarshall(o);
        }
        try {
            if (this.morphium != null && !this.morphium.getConfig().isWarnOnNoEntitySerialization() && this.morphium.getConfig().isObjectSerializationEnabled() && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Embedded.class)) {
                cls = BinarySerializedObject.class;
            }
            if (o.get("class_name") != null || o.get("className") != null) {
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = this.annotationHelper.getClassForTypeId(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                return (T)Enum.valueOf(cls, (String)o.get("name"));
            }
            Class superclass = cls.getSuperclass();
            if (superclass != null && superclass.isEnum()) {
                return Enum.valueOf(superclass, (String)o.get("name"));
            }
            Object ret = null;
            try {
                ret = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    Constructor<?> constructor = this.reflection.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    ret = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.log.error("Exception", (Throwable)e);
                }
            }
            if (ret == null) {
                throw new IllegalArgumentException("Could not instanciate " + cls.getName());
            }
            List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
            Iterator<String> e = flds.iterator();
            while (true) {
                Object value;
                String f;
                block130: {
                    Object arr;
                    ArrayList<Serializable> lst;
                    Class fldType;
                    block152: {
                        Iterator decKey2;
                        HashMap v;
                        Object r;
                        Reference reference;
                        block137: {
                            Iterator<Map.Entry<String, Object>> iterator;
                            HashMap<String, Object> data;
                            Field fld;
                            block133: {
                                block131: {
                                    Object valueFromDb;
                                    block155: {
                                        block156: {
                                            block154: {
                                                Class<?> superclass2;
                                                block153: {
                                                    block142: {
                                                        block151: {
                                                            block146: {
                                                                block143: {
                                                                    block144: {
                                                                        block150: {
                                                                            block149: {
                                                                                block148: {
                                                                                    block147: {
                                                                                        block145: {
                                                                                            block141: {
                                                                                                block140: {
                                                                                                    block138: {
                                                                                                        block139: {
                                                                                                            block134: {
                                                                                                                Object id;
                                                                                                                block136: {
                                                                                                                    block135: {
                                                                                                                        block132: {
                                                                                                                            if (!e.hasNext()) break block131;
                                                                                                                            f = e.next();
                                                                                                                            valueFromDb = o.get(f);
                                                                                                                            fld = this.annotationHelper.getField(cls, f);
                                                                                                                            fldType = fld.getType();
                                                                                                                            if (Modifier.isStatic(fld.getModifiers())) continue;
                                                                                                                            if (this.customMappers.containsKey(fldType)) {
                                                                                                                                fld.set(ret, this.customMappers.get(fldType).unmarshall(valueFromDb));
                                                                                                                                continue;
                                                                                                                            }
                                                                                                                            if (!fld.isAnnotationPresent(AdditionalData.class)) break block132;
                                                                                                                            if (!Map.class.isAssignableFrom(fldType)) {
                                                                                                                                this.log.error("Could not deserialize additional data into fld of type " + fldType.toString());
                                                                                                                                continue;
                                                                                                                            }
                                                                                                                            data = new HashMap<String, Object>();
                                                                                                                            iterator = o.entrySet().iterator();
                                                                                                                            break block133;
                                                                                                                        }
                                                                                                                        if (valueFromDb == null) {
                                                                                                                            if (fldType.isPrimitive() || !o.containsKey(f)) continue;
                                                                                                                            fld.set(ret, null);
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        if (fld.isAnnotationPresent(Encrypted.class)) {
                                                                                                                            Encrypted enc = fld.getAnnotation(Encrypted.class);
                                                                                                                            Class<? extends ValueEncryptionProvider> encCls = enc.provider();
                                                                                                                            ValueEncryptionProvider ep = encCls.newInstance();
                                                                                                                            String key = enc.keyName();
                                                                                                                            if (key.equals(".")) {
                                                                                                                                key = theClass.getName();
                                                                                                                            }
                                                                                                                            byte[] decKey2 = this.morphium.getEncryptionKeyProvider().getDecryptionKey(key);
                                                                                                                            ep.setDecryptionKey(decKey2);
                                                                                                                            if (valueFromDb instanceof byte[]) {
                                                                                                                                valueFromDb = new String(ep.decrypt((byte[])valueFromDb));
                                                                                                                            } else {
                                                                                                                                if (!(valueFromDb instanceof String)) {
                                                                                                                                    throw new RuntimeException("Decryption not possible, value is no byte array or base64 string!");
                                                                                                                                }
                                                                                                                                valueFromDb = new String(ep.decrypt(Base64.getDecoder().decode(valueFromDb.toString())));
                                                                                                                            }
                                                                                                                            try {
                                                                                                                                valueFromDb = this.deserialize(fldType, (String)valueFromDb);
                                                                                                                            }
                                                                                                                            catch (Exception e2) {
                                                                                                                                this.log.debug("Not a json string, cannot deserialize further");
                                                                                                                            }
                                                                                                                            this.annotationHelper.setValue(ret, valueFromDb, f);
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        value = null;
                                                                                                                        if (Collection.class.isAssignableFrom(fldType) || !fld.isAnnotationPresent(Reference.class)) break block134;
                                                                                                                        reference = fld.getAnnotation(Reference.class);
                                                                                                                        r = null;
                                                                                                                        if (this.morphium != null) break block135;
                                                                                                                        this.log.error("Morphium not set - could not de-reference!");
                                                                                                                        break block130;
                                                                                                                    }
                                                                                                                    if (!Map.class.isAssignableFrom(fldType)) break block136;
                                                                                                                    v = new HashMap();
                                                                                                                    decKey2 = ((Map)valueFromDb).entrySet().iterator();
                                                                                                                    break block137;
                                                                                                                }
                                                                                                                if (!(valueFromDb instanceof Map)) {
                                                                                                                    id = valueFromDb;
                                                                                                                } else {
                                                                                                                    Map ref = (Map)valueFromDb;
                                                                                                                    r = this.deserialize(MorphiumReference.class, ref);
                                                                                                                    id = ((MorphiumReference)r).getId();
                                                                                                                }
                                                                                                                String collection = this.getCollectionName(fldType);
                                                                                                                if (r != null && ((MorphiumReference)r).getCollectionName() != null) {
                                                                                                                    collection = ((MorphiumReference)r).getCollectionName();
                                                                                                                }
                                                                                                                if (id != null) {
                                                                                                                    if (reference.lazyLoading()) {
                                                                                                                        List<String> lst2 = this.annotationHelper.getFields(fldType, Id.class);
                                                                                                                        if (lst2.isEmpty()) {
                                                                                                                            throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                                                                                                        }
                                                                                                                        if (id instanceof String && this.annotationHelper.getField(fldType, lst2.get(0)).getType().equals(MorphiumId.class)) {
                                                                                                                            id = new MorphiumId(id.toString());
                                                                                                                        }
                                                                                                                        value = this.morphium.createLazyLoadedEntity(fldType, id, collection);
                                                                                                                        break block130;
                                                                                                                    } else {
                                                                                                                        try {
                                                                                                                            value = this.morphium.findById(fldType, id, collection);
                                                                                                                        }
                                                                                                                        catch (MorphiumAccessVetoException e3) {
                                                                                                                            this.log.info("not dereferencing due to veto from listener", (Throwable)e3);
                                                                                                                        }
                                                                                                                    }
                                                                                                                    break block130;
                                                                                                                } else {
                                                                                                                    value = null;
                                                                                                                }
                                                                                                                break block130;
                                                                                                            }
                                                                                                            if (!fld.isAnnotationPresent(Id.class)) break block138;
                                                                                                            value = o.get("_id");
                                                                                                            if (value == null || value.getClass().equals(fldType)) break block130;
                                                                                                            this.log.debug("read value and field type differ...");
                                                                                                            if (!fldType.equals(MorphiumId.class)) break block139;
                                                                                                            this.log.debug("trying objectID conversion");
                                                                                                            if (value.getClass().equals(String.class)) {
                                                                                                                try {
                                                                                                                    value = new MorphiumId((String)value);
                                                                                                                }
                                                                                                                catch (Exception e4) {
                                                                                                                    this.log.error("Value and field type differ - Id conversion failed - setting returning null", (Throwable)e4);
                                                                                                                    return null;
                                                                                                                }
                                                                                                            }
                                                                                                            break block130;
                                                                                                        }
                                                                                                        if (value.getClass().equals(MorphiumId.class)) {
                                                                                                            if (fldType.equals(String.class)) {
                                                                                                                value = value.toString();
                                                                                                                break block130;
                                                                                                            } else {
                                                                                                                if (!fldType.equals(Long.class) && !fldType.equals(Long.TYPE)) {
                                                                                                                    this.log.error("cannot convert - ID IS SET TO NULL. Type read from db is " + value.getClass().getName() + " - expected value is " + fldType.getName());
                                                                                                                    return null;
                                                                                                                }
                                                                                                                value = ((MorphiumId)value).getTime();
                                                                                                            }
                                                                                                        }
                                                                                                        break block130;
                                                                                                    }
                                                                                                    if (!this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Embedded.class)) break block140;
                                                                                                    value = this.deserialize(fldType, (HashMap)valueFromDb);
                                                                                                    break block130;
                                                                                                }
                                                                                                if (!Map.class.isAssignableFrom(fldType) || !(valueFromDb instanceof Map)) break block141;
                                                                                                value = this.fillMap(fld.getGenericType(), (Map)valueFromDb);
                                                                                                break block130;
                                                                                            }
                                                                                            if (!Collection.class.isAssignableFrom(fldType) && !fldType.isArray()) break block142;
                                                                                            lst = new ArrayList<Serializable>();
                                                                                            if (!valueFromDb.getClass().isArray()) break block143;
                                                                                            if (!valueFromDb.getClass().getComponentType().isPrimitive()) break block144;
                                                                                            if (!valueFromDb.getClass().getComponentType().equals(Integer.TYPE)) break block145;
                                                                                            for (Object i : (Object)((int[])valueFromDb)) {
                                                                                                lst.add(Integer.valueOf((int)i));
                                                                                            }
                                                                                            break block146;
                                                                                        }
                                                                                        if (!valueFromDb.getClass().getComponentType().equals(Double.TYPE)) break block147;
                                                                                        for (Object i : (Object)((double[])valueFromDb)) {
                                                                                            lst.add(Double.valueOf((double)i));
                                                                                        }
                                                                                        break block146;
                                                                                    }
                                                                                    if (!valueFromDb.getClass().getComponentType().equals(Float.TYPE)) break block148;
                                                                                    for (Object i : (Object)((float[])valueFromDb)) {
                                                                                        lst.add(Float.valueOf((float)i));
                                                                                    }
                                                                                    break block146;
                                                                                }
                                                                                if (!valueFromDb.getClass().getComponentType().equals(Boolean.TYPE)) break block149;
                                                                                for (Object i : (Object)((boolean[])valueFromDb)) {
                                                                                    lst.add(Boolean.valueOf((boolean)i));
                                                                                }
                                                                                break block146;
                                                                            }
                                                                            if (!valueFromDb.getClass().getComponentType().equals(Byte.TYPE)) break block150;
                                                                            for (Object i : (Object)((byte[])valueFromDb)) {
                                                                                lst.add(Byte.valueOf((byte)i));
                                                                            }
                                                                            break block146;
                                                                        }
                                                                        if (valueFromDb.getClass().getComponentType().equals(Character.TYPE)) {
                                                                            for (Object i : (Object)((char[])valueFromDb)) {
                                                                                lst.add(Character.valueOf((char)i));
                                                                            }
                                                                            break block146;
                                                                        } else if (valueFromDb.getClass().getComponentType().equals(Long.TYPE)) {
                                                                            for (Object i : (Object)((long[])valueFromDb)) {
                                                                                lst.add(Long.valueOf((long)i));
                                                                            }
                                                                        }
                                                                        break block146;
                                                                    }
                                                                    Collections.addAll(lst, (Object[])valueFromDb);
                                                                    break block146;
                                                                }
                                                                ParameterizedType type = fld.getGenericType() instanceof ParameterizedType ? (ParameterizedType)fld.getGenericType() : new ParameterizedType(){

                                                                    @Override
                                                                    public Type getRawType() {
                                                                        return Array.class;
                                                                    }

                                                                    @Override
                                                                    public Type getOwnerType() {
                                                                        return null;
                                                                    }

                                                                    @Override
                                                                    public Type[] getActualTypeArguments() {
                                                                        return new Type[]{fldType.getComponentType()};
                                                                    }
                                                                };
                                                                this.fillList(fld, fld.getAnnotation(Reference.class), type, (List)valueFromDb, lst);
                                                            }
                                                            if (!fldType.isArray()) break block151;
                                                            arr = Array.newInstance(fldType.getComponentType(), lst.size());
                                                            break block152;
                                                        }
                                                        value = EnumSet.class.isAssignableFrom(fldType) ? EnumSet.copyOf(lst) : (Set.class.isAssignableFrom(fldType) ? new LinkedHashSet(lst) : lst);
                                                        break block130;
                                                    }
                                                    superclass2 = fldType.getSuperclass();
                                                    if (!fldType.isEnum()) break block153;
                                                    value = Enum.valueOf(fldType, (String)valueFromDb);
                                                    break block130;
                                                }
                                                if (superclass2 == null || !superclass2.isEnum()) break block154;
                                                value = Enum.valueOf(superclass2, (String)valueFromDb);
                                                break block130;
                                            }
                                            if (!(valueFromDb instanceof ObjectId)) break block155;
                                            if (!fldType.equals(MorphiumId.class)) break block156;
                                            if (valueFromDb instanceof ObjectId) {
                                                value = new MorphiumId(((ObjectId)valueFromDb).toHexString());
                                                break block130;
                                            } else if (valueFromDb instanceof String) {
                                                value = new MorphiumId((String)valueFromDb);
                                                break block130;
                                            } else {
                                                this.log.error("Could not deserialize Value from DB of type " + valueFromDb.getClass().getName() + " and set it to morphiumId");
                                            }
                                            break block130;
                                        }
                                        value = new MorphiumId(((ObjectId)valueFromDb).toByteArray());
                                        break block130;
                                    }
                                    value = valueFromDb;
                                    break block130;
                                }
                                if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                                    flds = this.annotationHelper.getFields(cls, Id.class);
                                    if (flds.isEmpty()) {
                                        throw new RuntimeException("Error - class does not have an ID field!");
                                    }
                                    Field field = this.annotationHelper.getField(cls, flds.get(0));
                                    Class<?> fieldType = field.getType();
                                    Object idValue = o.get("_id");
                                    if (idValue != null) {
                                        Class<?> idValueClass = idValue.getClass();
                                        if (idValueClass.equals(fieldType)) {
                                            field.set(ret, idValue);
                                        } else if (fieldType.equals(String.class) && idValueClass.equals(MorphiumId.class)) {
                                            this.log.warn("ID type missmatch - field is string but got objectId from mongo - converting");
                                            field.set(ret, idValue.toString());
                                        } else if (fieldType.equals(MorphiumId.class) && idValueClass.equals(ObjectId.class)) {
                                            field.set(ret, new MorphiumId(((ObjectId)idValue).toByteArray()));
                                        } else if (fieldType.equals(ObjectId.class) && idValueClass.equals(MorphiumId.class)) {
                                            field.set(ret, new ObjectId(((MorphiumId)idValue).getBytes()));
                                        } else if (fieldType.equals(ObjectId.class) && idValueClass.equals(String.class)) {
                                            field.set(ret, new ObjectId(((ObjectId)idValue).toString()));
                                        } else if (fieldType.equals(MorphiumId.class) && idValueClass.equals(String.class)) {
                                            field.set(ret, new MorphiumId((String)idValue));
                                        } else if (fieldType.equals(UUID.class) && idValueClass.equals(byte[].class)) {
                                            ByteBuffer bb = ByteBuffer.wrap((byte[])idValue);
                                            field.set(ret, new UUID(bb.getLong(), bb.getLong()));
                                        } else if (fieldType.equals(Integer.TYPE) && idValueClass.equals(Integer.class)) {
                                            field.set(ret, (int)((Integer)idValue));
                                        } else if (fieldType.equals(Long.TYPE) && idValueClass.equals(Long.class)) {
                                            field.set(ret, (long)((Long)idValue));
                                        } else if (fieldType.equals(Double.TYPE) && idValueClass.equals(Double.class)) {
                                            field.set(ret, (double)((Double)idValue));
                                        } else if (fieldType.equals(Float.TYPE) && idValueClass.equals(Float.class)) {
                                            field.set(ret, Float.valueOf(((Float)idValue).floatValue()));
                                        } else if (fieldType.equals(Boolean.TYPE) && idValueClass.equals(Boolean.class)) {
                                            field.set(ret, (boolean)((Boolean)idValue));
                                        } else {
                                            this.log.error("ID type missmatch");
                                            throw new IllegalArgumentException("ID type missmatch. Field in '" + ret.getClass().toString() + "' is '" + fieldType.toString() + "' but we got '" + idValueClass.toString() + "' from Mongo!");
                                        }
                                    }
                                }
                                if (ret instanceof BinarySerializedObject) {
                                    BinarySerializedObject bso = (BinarySerializedObject)ret;
                                    Base64.Decoder dec = Base64.getMimeDecoder();
                                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(bso.getB64Data())));
                                    return (T)in.readObject();
                                }
                                return (T)ret;
                            }
                            while (iterator.hasNext()) {
                                Map.Entry<String, Object> entry = iterator.next();
                                String k = entry.getKey();
                                Object v2 = entry.getValue();
                                if (flds.contains(k) || k.equals("_id")) continue;
                                if (v2 instanceof Map) {
                                    Map mapV = (Map)v2;
                                    String mapVClassName = (String)mapV.get("class_name");
                                    if (mapVClassName != null) {
                                        data.put(k, this.deserialize(this.annotationHelper.getClassForTypeId(mapVClassName), mapV));
                                        continue;
                                    }
                                    data.put(k, this.deserializeMap(mapV));
                                    continue;
                                }
                                if (v2 instanceof List && !((List)v2).isEmpty() && ((List)v2).get(0) instanceof Map) {
                                    data.put(k, this.deserializeList((List)v2));
                                    continue;
                                }
                                data.put(k, v2);
                            }
                            fld.set(ret, data);
                            continue;
                        }
                        while (decKey2.hasNext()) {
                            Object id;
                            Map.Entry e5 = decKey2.next();
                            if (!(e5.getValue() instanceof Map)) {
                                id = e5.getValue();
                                r = null;
                            } else {
                                Map ref = (Map)e5.getValue();
                                r = this.deserialize(MorphiumReference.class, ref);
                                id = ((MorphiumReference)r).getId();
                            }
                            String collectionName = null;
                            Class type = fldType;
                            if (r != null) {
                                collectionName = ((MorphiumReference)r).getCollectionName() != null ? ((MorphiumReference)r).getCollectionName() : this.getCollectionName(this.annotationHelper.getClassForTypeId(((MorphiumReference)r).getClassName()));
                                type = this.annotationHelper.getClassForTypeId(((MorphiumReference)r).getClassName());
                            } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fldType, Entity.class)) {
                                collectionName = this.getCollectionName(fldType);
                            }
                            if (collectionName == null) {
                                throw new IllegalArgumentException("Could not create reference!");
                            }
                            if (reference.lazyLoading()) {
                                List<String> lst3 = this.annotationHelper.getFields(fldType, Id.class);
                                if (lst3.isEmpty()) {
                                    throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                }
                                if (id instanceof String && this.annotationHelper.getField(fldType, lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(id.toString());
                                } else if (id instanceof ObjectId && this.annotationHelper.getField(fldType, lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(((ObjectId)id).toByteArray());
                                }
                                value = this.morphium.createLazyLoadedEntity(fldType, id, collectionName);
                            } else {
                                try {
                                    value = this.morphium.findById(type, id, collectionName);
                                }
                                catch (MorphiumAccessVetoException ex) {
                                    this.log.info("not dereferencing due to veto from listener", (Throwable)ex);
                                }
                            }
                            v.put(e5.getKey(), value);
                        }
                        value = v;
                        break block130;
                    }
                    for (int i = 0; i < lst.size(); ++i) {
                        if (fldType.getComponentType().isPrimitive()) {
                            if (fldType.getComponentType().equals(Integer.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).intValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, (Integer)lst.get(i));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).intValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fldType.getComponentType().equals(Long.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, (Long)lst.get(i));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fldType.getComponentType().equals(Float.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, Float.valueOf(((Double)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, Float.valueOf(((Integer)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, Float.valueOf(((Long)lst.get(i)).floatValue()));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fldType.getComponentType().equals(Double.TYPE)) {
                                if (lst.get(i) instanceof Float) {
                                    Array.set(arr, i, ((Float)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).doubleValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fldType.getComponentType().equals(Byte.TYPE)) {
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).byteValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).byteValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (!fldType.getComponentType().equals(Boolean.TYPE)) continue;
                            if (lst.get(i) instanceof String) {
                                Array.set(arr, i, lst.get(i).toString().equalsIgnoreCase("true"));
                                continue;
                            }
                            if (lst.get(i) instanceof Integer) {
                                Array.set(arr, i, (Integer)lst.get(i) == 1);
                                continue;
                            }
                            Array.set(arr, i, lst.get(i));
                            continue;
                        }
                        Array.set(arr, i, lst.get(i));
                    }
                    value = arr;
                }
                this.annotationHelper.setValue(ret, value, f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> deserializeMap(Map<String, Object> dbObject) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(dbObject);
        if (dbObject != null) {
            for (Map.Entry<String, Object> entry : dbObject.entrySet()) {
                retMap.put(entry.getKey(), this.unmarshallInternal(entry.getValue()));
            }
        } else {
            retMap = null;
        }
        return retMap;
    }

    private Object unmarshallInternal(Object val) {
        block13: {
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                String cn = (String)mapVal.get("class_name");
                if (cn == null) {
                    cn = (String)mapVal.get("className");
                }
                if (cn != null) {
                    try {
                        Class ecls = this.annotationHelper.getClassForTypeId(cn);
                        Object obj = this.deserialize(ecls, mapVal);
                        if (obj != null) {
                            return obj;
                        }
                        break block13;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                String d = (String)mapVal.get("_b64data");
                if (d == null) {
                    d = (String)mapVal.get("b64Data");
                }
                if (d != null) {
                    Base64.Decoder dec = Base64.getMimeDecoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(d)));
                        return in.readObject();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.deserializeMap(mapVal);
            }
            if (val instanceof ObjectId) {
                val = new MorphiumId(((ObjectId)val).toByteArray());
            } else if (val instanceof List) {
                List lst = (List)val;
                return this.deserializeList(lst);
            }
        }
        return val;
    }

    public List deserializeList(List<Object> lst) {
        return lst.stream().map(this::unmarshallInternal).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void fillList(Field forField, Reference ref, ParameterizedType listType, List<?> fromDB, List toFillIn) {
        Iterator<?> iterator;
        Class elementClass = null;
        Type elementType = null;
        if (listType instanceof ParameterizedType) {
            elementClass = this.getElementClass(listType);
            Type[] actualTypeArguments = listType.getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length > 0) {
                elementType = actualTypeArguments[0];
            }
        } else {
            elementClass = Object.class;
        }
        fromDB = new ArrayList(fromDB);
        if (ref != null) {
            iterator = fromDB.iterator();
            while (iterator.hasNext()) {
                Class type;
                Object obj = iterator.next();
                if (obj == null) {
                    toFillIn.add(null);
                    continue;
                }
                MorphiumReference r = this.deserialize(MorphiumReference.class, (Map)obj);
                try {
                    type = this.annotationHelper.getClassForTypeId(r.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (r.getCollectionName() == null) {
                    r.setCollectionName(this.getCollectionName(type));
                }
                if (ref.lazyLoading()) {
                    if (r.getId() instanceof String && this.morphium.getARHelper().getIdField(type).getType().equals(MorphiumId.class)) {
                        r.setId(new MorphiumId(r.getId().toString()));
                    }
                    toFillIn.add(this.morphium.createLazyLoadedEntity(type, r.getId(), r.getCollectionName()));
                    continue;
                }
                toFillIn.add(this.morphium.findById(type, r.getId(), r.getCollectionName()));
            }
            return;
        }
        iterator = fromDB.iterator();
        while (iterator.hasNext()) {
            Object unmarshalled;
            Object val;
            block28: {
                val = iterator.next();
                if (val instanceof Map) {
                    if (((Map)val).containsKey("class_name") || ((Map)val).containsKey("className")) {
                        String cn = (String)((Map)val).get("class_name");
                        if (cn == null) {
                            cn = (String)((Map)val).get("className");
                        }
                        try {
                            Class ecls = this.annotationHelper.getClassForTypeId(cn);
                            Object um = this.deserialize(ecls, (Map)val);
                            if (um == null) continue;
                            toFillIn.add(um);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not find class", e);
                        }
                    }
                    if (listType != null) {
                        if (Map.class.isAssignableFrom(elementClass)) {
                            toFillIn.add(this.fillMap((ParameterizedType)elementType, (Map)val));
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Embedded.class);
                        if (entity != null || embedded != null) {
                            toFillIn.add(this.deserialize(elementClass, (Map)val));
                            continue;
                        }
                        break block28;
                    } else {
                        this.log.warn("Cannot de-reference to unknown collection type - trying object instead");
                        toFillIn.add(val);
                        continue;
                    }
                }
                if (val instanceof List) {
                    if (elementType instanceof ParameterizedType) {
                        ArrayList lt = new ArrayList();
                        this.fillList(forField, ref, (ParameterizedType)elementType, (List)val, lt);
                        if (EnumSet.class.isAssignableFrom(elementClass)) {
                            toFillIn.add(EnumSet.copyOf(lt));
                            continue;
                        }
                        if (Set.class.isAssignableFrom(elementClass)) {
                            toFillIn.add(new LinkedHashSet(lt));
                            continue;
                        }
                        toFillIn.add(lt);
                        continue;
                    }
                    this.log.warn("Cannot de-reference to unknown collection - trying to add Object only");
                    toFillIn.add(val);
                    continue;
                }
            }
            if ((unmarshalled = this.unmarshallInternal(val)) != null && elementClass != null && !elementClass.isAssignableFrom(unmarshalled.getClass())) {
                try {
                    unmarshalled = AnnotationAndReflectionHelper.convertType(unmarshalled, "", elementClass);
                }
                catch (Exception e) {
                    this.log.warn("", (Throwable)e);
                }
            }
            toFillIn.add(unmarshalled);
        }
    }

    private Class getElementClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[parameters.length - 1];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return this.annotationHelper.getClassForTypeId(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        this.log.error("Could not determin type of element!");
        return Object.class;
    }

    private Class getKeyClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[0];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return this.annotationHelper.getClassForTypeId(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        this.log.error("Could not determin type of key!");
        return Object.class;
    }

    protected Map fillMap(Type mapType, Map<String, Object> fromDB) {
        boolean useEnumMap = false;
        Class keyClass = null;
        if (mapType instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)mapType;
            keyClass = this.getKeyClass(genericType);
            if (EnumMap.class.isAssignableFrom((Class)genericType.getRawType())) {
                useEnumMap = true;
            } else if (Enum.class.isAssignableFrom(keyClass)) {
                useEnumMap = true;
            }
        }
        AbstractMap toFill = useEnumMap ? new EnumMap(keyClass) : new HashMap();
        if (fromDB != null && !fromDB.isEmpty()) {
            this.fillMap(mapType, fromDB, toFill);
        }
        return toFill;
    }

    protected void fillMap(Type mapType, Map<String, Object> fromDB, Map toFillIn) {
        Class keyClass = null;
        Class elementClass = null;
        Type elementType = null;
        if (mapType instanceof ParameterizedType) {
            keyClass = this.getKeyClass((ParameterizedType)mapType);
            elementClass = this.getElementClass((ParameterizedType)mapType);
            Type[] actualTypeArguments = ((ParameterizedType)mapType).getActualTypeArguments();
            if (actualTypeArguments != null && actualTypeArguments.length > 1) {
                elementType = actualTypeArguments[1];
            }
        }
        Method convertMethod = null;
        if (keyClass != null && !String.class.equals((Object)keyClass)) {
            convertMethod = AnnotationAndReflectionHelper.getConvertMethod(keyClass);
        }
        for (Map.Entry<String, Object> entry : fromDB.entrySet()) {
            Object unmarshalled;
            Object val;
            String stringKey = entry.getKey();
            Object key = stringKey;
            if (convertMethod != null) {
                try {
                    key = convertMethod.invoke(null, stringKey);
                }
                catch (ReflectiveOperationException | RuntimeException e) {
                    this.log.error("Could not convert " + stringKey + " to key type " + keyClass, (Throwable)e);
                    continue;
                }
            }
            if ((val = entry.getValue()) instanceof Map) {
                if (elementClass != null) {
                    if (Map.class.isAssignableFrom(elementClass)) {
                        toFillIn.put(key, this.fillMap(elementType, (Map)val));
                        continue;
                    }
                    Entity entity = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Entity.class);
                    Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(elementClass, Embedded.class);
                    if (entity != null || embedded != null) {
                        toFillIn.put(key, this.deserialize(elementClass, (Map)val));
                        continue;
                    }
                }
            } else if (val instanceof List) {
                ArrayList lt = new ArrayList();
                if (elementType instanceof ParameterizedType) {
                    this.fillList(null, null, (ParameterizedType)elementType, (List)val, lt);
                } else {
                    this.fillList(null, null, null, (List)val, lt);
                }
                if (elementClass != null && EnumSet.class.isAssignableFrom(elementClass)) {
                    toFillIn.put(key, EnumSet.copyOf(lt));
                    continue;
                }
                if (elementClass != null && Set.class.isAssignableFrom(elementClass)) {
                    toFillIn.put(key, new LinkedHashSet(lt));
                    continue;
                }
                toFillIn.put(key, lt);
                continue;
            }
            if ((unmarshalled = this.unmarshallInternal(val)) != null && elementClass != null && !elementClass.isAssignableFrom(unmarshalled.getClass())) {
                try {
                    unmarshalled = AnnotationAndReflectionHelper.convertType(unmarshalled, "", elementClass);
                }
                catch (Exception e) {
                    this.log.warn("", (Throwable)e);
                }
            }
            toFillIn.put(key, unmarshalled);
        }
    }
}

