/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import java.util.LinkedHashMap;
import java.util.Map;

public class Collation {
    private String locale;
    private Boolean caseLevel;
    private CaseFirst caseFirst;
    private Strength strength;
    private Boolean numericOrdering;
    private Alternate alternate;
    private MaxVariable maxVariable;
    private Boolean backwards;
    private Boolean normalization;

    public Collation() {
    }

    public Collation(String locale, Boolean caseLevel, CaseFirst caseFirst, Strength strength, Boolean numericOrdering, Alternate alternate, MaxVariable maxVariable, Boolean backwards, Boolean normalization) {
        this.locale = locale;
        this.caseLevel = caseLevel;
        this.caseFirst = caseFirst;
        this.strength = strength;
        this.numericOrdering = numericOrdering;
        this.alternate = alternate;
        this.maxVariable = maxVariable;
        this.backwards = backwards;
    }

    public Boolean getNormalization() {
        return this.normalization;
    }

    public Collation normalization(Boolean normalization) {
        this.normalization = normalization;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public Collation locale(String locale) {
        this.locale = locale;
        return this;
    }

    public Boolean getCaseLevel() {
        return this.caseLevel;
    }

    public Collation caseLevel(Boolean caseLevel) {
        this.caseLevel = caseLevel;
        return this;
    }

    public CaseFirst getCaseFirst() {
        return this.caseFirst;
    }

    public Collation caseFirst(CaseFirst caseFirst) {
        this.caseFirst = caseFirst;
        return this;
    }

    public Strength getStrength() {
        return this.strength;
    }

    public Collation strength(Strength strength) {
        this.strength = strength;
        return this;
    }

    public Boolean getNumericOrdering() {
        return this.numericOrdering;
    }

    public Collation numericOrdering(Boolean numericOrdering) {
        this.numericOrdering = numericOrdering;
        return this;
    }

    public Alternate getAlternate() {
        return this.alternate;
    }

    public Collation alternate(Alternate alternate) {
        this.alternate = alternate;
        return this;
    }

    public MaxVariable getMaxVariable() {
        return this.maxVariable;
    }

    public Collation maxVariable(MaxVariable maxVariable) {
        this.maxVariable = maxVariable;
        return this;
    }

    public Boolean getBackwards() {
        return this.backwards;
    }

    public Collation backwards(Boolean backwards) {
        this.backwards = backwards;
        return this;
    }

    public Map<String, Object> toQueryObject() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (this.locale != null) {
            ret.put("locale", this.locale);
        }
        if (this.caseLevel != null) {
            ret.put("caseLevel", this.caseLevel);
        }
        if (this.caseFirst != null) {
            ret.put("caseFirst", (Object)this.caseFirst);
        }
        if (this.strength != null) {
            ret.put("strength", (Object)this.strength);
        }
        if (this.numericOrdering != null) {
            ret.put("numericOrdering", this.numericOrdering);
        }
        if (this.alternate != null) {
            ret.put("alternate", (Object)this.alternate);
        }
        if (this.maxVariable != null) {
            ret.put("maxVariable", (Object)this.maxVariable);
        }
        if (this.backwards != null) {
            ret.put("backwards", this.backwards);
        }
        return ret;
    }

    public static enum Strength {
        PRIMARY(1),
        SECONDARY(2),
        TERTIARY(3),
        QUATERNARY(4),
        IDENTICAL(5);

        int mongoValue;

        private Strength(int mongoValue) {
            this.mongoValue = mongoValue;
        }

        public int getMongoValue() {
            return this.mongoValue;
        }
    }

    public static enum MaxVariable {
        PUNCT("punct"),
        SPACE("space");

        String mongoText;

        private MaxVariable(String mongoText) {
            this.mongoText = mongoText;
        }

        public String getMongoText() {
            return this.mongoText;
        }
    }

    public static enum CaseFirst {
        LOWER("lower"),
        OFF("off"),
        UPPER("upper");

        String mongoText;

        private CaseFirst(String mongoText) {
            this.mongoText = mongoText;
        }

        public String getMongoText() {
            return this.mongoText;
        }
    }

    public static enum Alternate {
        SHIFTED("shifted"),
        NON_IGNORABLE("non-ignorable");

        String mongoText;

        private Alternate(String mongoText) {
            this.mongoText = mongoText;
        }

        public String getMongoText() {
            return this.mongoText;
        }
    }
}

