/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.query.MorphiumQueryIterator;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchingQueryIterator<T>
implements MorphiumQueryIterator<T> {
    private final Logger log = LoggerFactory.getLogger(PrefetchingQueryIterator.class);
    private long lastAccess = System.currentTimeMillis();
    private List<List<Map<String, Object>>> prefetchBuffer = new CopyOnWriteArrayList<List<Map<String, Object>>>();
    private Query<T> query;
    private int batchsize;
    private MorphiumCursor cursor;
    private int numPrefetchBuffers;
    private volatile int cursorPos;
    private boolean startedAlready = false;

    public List<List<Map<String, Object>>> getPrefetchBuffer() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer;
    }

    public void setPrefetchBuffer(List<List<Map<String, Object>>> prefetchBuffer) {
        this.checkAndUpdateLastAccess();
        this.prefetchBuffer = prefetchBuffer;
    }

    @Override
    public int getWindowSize() {
        this.checkAndUpdateLastAccess();
        return this.batchsize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.checkAndUpdateLastAccess();
        this.batchsize = sz;
    }

    @Override
    public Query<T> getQuery() {
        this.checkAndUpdateLastAccess();
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        this.checkAndUpdateLastAccess();
        this.query = q;
    }

    @Override
    public int getCurrentBufferSize() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer.size();
    }

    @Override
    public List<T> getCurrentBuffer() {
        this.checkAndUpdateLastAccess();
        ArrayList<T> ret = new ArrayList<T>();
        for (Map<String, Object> o : this.prefetchBuffer.get(0)) {
            ret.add(this.query.getMorphium().getMapper().deserialize(this.query.getType(), o));
        }
        return ret;
    }

    @Override
    public long getCount() {
        this.checkAndUpdateLastAccess();
        return this.query.countAll();
    }

    @Override
    public int getCursor() {
        this.checkAndUpdateLastAccess();
        return this.cursorPos;
    }

    @Override
    public void ahead(int jump) {
        for (int i = 0; i < jump; ++i) {
            this.next();
        }
    }

    @Override
    public void back(int jump) {
        if (jump < this.cursorPos % this.getWindowSize()) {
            this.cursorPos -= jump;
        } else {
            throw new IllegalArgumentException("Cannot jump back past window boundaries");
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        this.checkAndUpdateLastAccess();
        if (n <= 1) {
            n = 2;
            this.log.error("Prefetching only makes sense with at least 2 prefetchwindows... setting to 2");
        }
        this.numPrefetchBuffers = n;
    }

    @Override
    public int getNumberOfAvailableThreads() {
        this.checkAndUpdateLastAccess();
        return this.numPrefetchBuffers;
    }

    @Override
    public int getNumberOfThreads() {
        this.checkAndUpdateLastAccess();
        return 0;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        this.checkAndUpdateLastAccess();
        return true;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.checkAndUpdateLastAccess();
    }

    @Override
    public Iterator<T> iterator() {
        this.checkAndUpdateLastAccess();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        PrefetchingQueryIterator prefetchingQueryIterator = this;
        synchronized (prefetchingQueryIterator) {
            return this.doHasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHasNext() {
        boolean ret;
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready) {
            this.startedAlready = true;
            try {
                PrefetchingQueryIterator prefetchingQueryIterator = this;
                synchronized (prefetchingQueryIterator) {
                    this.cursor = this.query.getMorphium().getDriver().initIteration(this.query.getMorphium().getConfig().getDatabase(), this.query.getCollectionName(), this.query.toQueryObject(), this.query.getSort(), this.query.getFieldListForQuery(), this.query.getSkip(), this.query.getLimit(), this.batchsize, this.query.getMorphium().getReadPreferenceForClass(this.query.getType()), this.query.getCollation(), null);
                }
                if (this.cursor == null) {
                    return false;
                }
                if (this.cursor.getBatch() == null) {
                    try {
                        this.query.getMorphium().getDriver().closeIteration(this.cursor);
                    }
                    catch (MorphiumDriverException morphiumDriverException) {
                        // empty catch block
                    }
                    return false;
                }
                this.prefetchBuffer.add(this.getBatch(this.cursor));
                this.startPrefetch();
                if (!this.prefetchBuffer.get(0).isEmpty()) {
                    return true;
                }
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
        }
        while (this.prefetchBuffer.size() <= 1 && this.cursor != null) {
            Thread.yield();
        }
        if (this.prefetchBuffer.isEmpty()) {
            try {
                this.query.getMorphium().getDriver().closeIteration(this.cursor);
            }
            catch (MorphiumDriverException e) {
                // empty catch block
            }
            return false;
        }
        boolean bl = ret = (this.cursorPos % this.getWindowSize() != 0 || this.prefetchBuffer.size() != 1 || this.cursor != null) && this.cursorPos % this.getWindowSize() < this.prefetchBuffer.get(0).size();
        if (!ret) {
            try {
                this.query.getMorphium().getDriver().closeIteration(this.cursor);
            }
            catch (MorphiumDriverException morphiumDriverException) {
                // empty catch block
            }
        }
        return ret;
    }

    private List<Map<String, Object>> getBatch(MorphiumCursor crs) {
        List<Map<String, Object>> batch = crs.getBatch();
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        if (batch == null) {
            return ret;
        }
        this.query.getMorphium().firePostLoad(batch);
        return batch;
    }

    private void startPrefetch() {
        this.query.getMorphium().queueTask(() -> {
            this.log.info("Starting prefetching...");
            block6: while (this.cursor != null) {
                while (this.prefetchBuffer.size() >= this.numPrefetchBuffers && this.cursor != null) {
                    try {
                        int maxWaitTime = this.query.getMorphium().getConfig().getMaxWaitTime();
                        if (maxWaitTime > 0 && System.currentTimeMillis() - this.lastAccess > (long)maxWaitTime) {
                            this.log.error("Cursor timeout... closing");
                            try {
                                this.query.getMorphium().getDriver().closeIteration(this.cursor);
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            this.cursor = null;
                            return;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.log.debug("got interrupted - ignore");
                    }
                }
                while (this.prefetchBuffer.size() < this.numPrefetchBuffers) {
                    try {
                        if (this.cursor == null) continue block6;
                        MorphiumCursor crs = this.query.getMorphium().getDriver().nextIteration(this.cursor);
                        if (crs == null || crs.getBatch() == null || crs.getBatch().isEmpty()) {
                            this.cursor = null;
                            continue block6;
                        }
                        this.prefetchBuffer.add(this.getBatch(crs));
                        this.cursor = crs;
                    }
                    catch (MorphiumDriverException e) {
                        this.cursor = null;
                        e.printStackTrace();
                        continue block6;
                    }
                }
            }
            this.log.info("Prefetch finished");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> nextMap() {
        PrefetchingQueryIterator prefetchingQueryIterator = this;
        synchronized (prefetchingQueryIterator) {
            return this.doNextMap();
        }
    }

    private Map<String, Object> doNextMap() {
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready && !this.hasNext()) {
            return null;
        }
        if (this.prefetchBuffer.isEmpty()) {
            this.log.error("Prefetchbuffer is empty!");
            return null;
        }
        if (this.cursorPos != 0 && this.cursorPos % this.getWindowSize() == 0) {
            this.prefetchBuffer.remove(0);
        }
        while (this.prefetchBuffer.isEmpty() && this.cursor != null) {
            Thread.yield();
        }
        return this.prefetchBuffer.get(0).get(this.cursorPos++ % this.getWindowSize());
    }

    @Override
    public T next() {
        Map<String, Object> o = this.nextMap();
        if (o == null) {
            return null;
        }
        return this.query.getMorphium().getMapper().deserialize(this.query.getType(), o);
    }

    private void checkAndUpdateLastAccess() {
        this.lastAccess = System.currentTimeMillis();
    }

    @Override
    public void close() {
        try {
            this.query.getMorphium().getDriver().closeIteration(this.cursor);
        }
        catch (MorphiumDriverException morphiumDriverException) {
            // empty catch block
        }
    }
}

