/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.aggregation.AggregationIterator;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.query.Query;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemAggregator<T, R>
implements Aggregator<T, R> {
    private final Logger log = LoggerFactory.getLogger(InMemAggregator.class);
    private final List<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
    private final List<Group<T, R>> groups = new ArrayList<Group<T, R>>();
    private Class<? extends T> type;
    private Morphium morphium;
    private Class<? extends R> rType;
    private String collectionName;
    private boolean useDisk = false;
    private boolean explain = false;
    private Collation collation;

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            p.put(e.getKey(), e.getValue());
        }
        Utils.UtilsMap map = Utils.getMap("$project", p);
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> project(String fld, Expr e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(fld, e);
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> addFields(Map<String, Object> m) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (!(e.getValue() instanceof Expr)) {
                throw new IllegalArgumentException("InMemAggregator only works with Expr");
            }
            ret.put(e.getKey(), e.getValue());
        }
        Utils.UtilsMap o = Utils.getMap("$addFields", ret);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        if (this.collectionName == null) {
            this.collectionName = q.getCollectionName();
        }
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> matchSubQuery(Query<?> q) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$match", q.toQueryObject());
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Expr q) {
        this.params.add(Utils.getMap("$match", Utils.getMap("$expr", q)));
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        Utils.UtilsMap<String, Integer> o = Utils.getMap("$limit", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        Utils.UtilsMap<String, Integer> o = Utils.getMap("$skip", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        Utils.UtilsMap<String, String> o = Utils.getMap("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(Expr field) {
        Utils.UtilsMap<String, Expr> o = Utils.getMap("$unwind", field);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixed;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (i2.startsWith("$")) {
                fld = fld.substring(1);
            }
            if (!fld.contains(".")) {
                fld = this.morphium.getARHelper().getMongoFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        Utils.UtilsMap<String, Map<String, Integer>> o = Utils.getMap("$sort", sort);
        this.params.add(o);
        return this;
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public void setCollectionName(String cn) {
        this.collectionName = cn;
    }

    @Override
    public Group<T, R> group(Map<String, Object> id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(Expr id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(String id) {
        Group gr = new Group(this, id);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public void addOperator(Map<String, Object> o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        try {
            return this.deserializeList();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getCount() {
        ArrayList<Map<String, Object>> pipeline = new ArrayList<Map<String, Object>>(this.getPipeline());
        pipeline.add(Utils.getMap("$count", "num"));
        List<Map<String, Object>> res = null;
        res = this.doAggregation();
        if (res.get(0).get("num") instanceof Integer) {
            return ((Integer)res.get(0).get("num")).longValue();
        }
        return (Long)res.get(0).get("num");
    }

    @Override
    public MorphiumAggregationIterator<T, R> aggregateIterable() {
        AggregationIterator agg = new AggregationIterator();
        agg.setAggregator(this);
        return agg;
    }

    @Override
    public void aggregate(AsyncOperationCallback<R> callback) {
        if (callback == null) {
            new Thread(this::doAggregation);
        } else {
            this.morphium.queueTask(() -> {
                try {
                    long start = System.currentTimeMillis();
                    List<R> result = this.deserializeList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, result, null, this);
                }
                catch (MorphiumDriverException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private List<R> deserializeList() throws MorphiumDriverException {
        List<Map<String, Object>> r = this.doAggregation();
        List<Object> result = new ArrayList();
        if (this.getResultType().equals(Map.class)) {
            result = r;
        } else {
            for (Map<String, Object> dbObj : r) {
                result.add(this.morphium.getMapper().deserialize(this.getResultType(), dbObj));
            }
        }
        return result;
    }

    @Override
    public void aggregateMap(AsyncOperationCallback<Map<String, Object>> callback) {
    }

    @Override
    public List<Map<String, Object>> getPipeline() {
        for (Group<T, R> g : this.groups) {
            g.end();
        }
        this.groups.clear();
        return this.params;
    }

    @Override
    public Aggregator<T, R> count(String fld) {
        this.params.add(Utils.getMap("$count", fld));
        return this;
    }

    @Override
    public Aggregator<T, R> count(Enum fld) {
        return this.count(fld.name());
    }

    @Override
    public Aggregator<T, R> bucket(Expr groupBy, List<Expr> boundaries, Expr preset, Map<String, Expr> output) {
        LinkedHashMap<String, Expr> out = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Expr> e : output.entrySet()) {
            out.put(e.getKey(), e.getValue());
        }
        ArrayList<Expr> bn = new ArrayList<Expr>(boundaries);
        Utils.UtilsMap<String, Utils.UtilsMap<String, Map<String, Object>>> m = Utils.getMap("$bucket", Utils.getMap("groupBy", groupBy).add("boundaries", (Expr)((Object)bn)).add("default", (ArrayList<Expr>)((Object)preset)).add("output", (ArrayList<Expr>)((Object)Utils.getQueryObjectMap(output))));
        this.params.add(m);
        return this;
    }

    @Override
    public Aggregator<T, R> bucketAuto(Expr groupBy, int numBuckets, Map<String, Expr> output, Aggregator.BucketGranularity granularity) {
        LinkedHashMap<String, Expr> out = null;
        if (output != null) {
            out = new LinkedHashMap<String, Expr>();
            for (Map.Entry<String, Expr> e : output.entrySet()) {
                out.put(e.getKey(), e.getValue());
            }
        }
        Utils.UtilsMap<String, Expr> bucketAuto = Utils.getMap("groupBy", groupBy);
        bucketAuto.add("buckets", (Expr)((Object)Integer.valueOf(numBuckets)));
        Utils.UtilsMap<String, Utils.UtilsMap<String, Expr>> map = Utils.getMap("$bucketAuto", bucketAuto);
        if (out != null) {
            bucketAuto.add("output", (Expr)((Object)out));
        }
        if (granularity != null) {
            bucketAuto.add("granularity", (Expr)((Object)granularity.getValue()));
        }
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> collStats(Boolean latencyHistograms, Double scale, boolean count, boolean queryExecStats) {
        LinkedHashMap m = new LinkedHashMap();
        if (latencyHistograms != null) {
            m.put("latencyStats", Utils.getMap("histograms", latencyHistograms));
        }
        if (scale != null) {
            m.put("storageStats", Utils.getMap("scale", scale));
        }
        if (count) {
            m.put("count", new HashMap());
        }
        if (queryExecStats) {
            m.put("queryExecStats", new HashMap());
        }
        this.params.add(Utils.getMap("$collStats", m));
        return this;
    }

    @Override
    public Aggregator<T, R> currentOp(boolean allUsers, boolean idleConnections, boolean idleCursors, boolean idleSessions, boolean localOps) {
        this.params.add(Utils.getMap("$currentOp", Utils.getMap("allUsers", allUsers).add("idleConnections", idleConnections).add("idleCursors", idleCursors).add("idleSessions", idleSessions).add("localOps", localOps)));
        return this;
    }

    @Override
    public Aggregator<T, R> facetExpr(Map<String, Expr> facets) {
        Map<String, Object> map = Utils.getQueryObjectMap(facets);
        this.params.add(Utils.getMap("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> facet(Map<String, Aggregator> facets) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, Aggregator> e : facets.entrySet()) {
            map.put(e.getKey(), e.getValue().getPipeline());
        }
        this.params.add(Utils.getMap("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> geoNear(Map<Aggregator.GeoNearFields, Object> param) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Aggregator.GeoNearFields, Object> e : param.entrySet()) {
            map.put(e.getKey().name(), ((ObjectMapperImpl)this.morphium.getMapper()).marshallIfNecessary(e.getValue()));
        }
        this.params.add(Utils.getMap("$geoNear", map));
        return this;
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, Enum connectFromField, Enum connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField.name(), connectToField.name(), as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField, connectToField, as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(String fromCollection, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        Utils.UtilsMap<String, String> add = Utils.getMap("from", fromCollection).add("startWith", (String)((Object)startWith)).add("connectFromField", connectFromField).add("connectToField", connectToField).add("as", as);
        this.params.add(Utils.getMap("$graphLookup", add));
        if (maxDepth != null) {
            add.add("maxDepth", (String)((Object)maxDepth));
        }
        if (depthField != null) {
            add.add("depthField", depthField);
        }
        if (restrictSearchWithMatch != null) {
            add.add("restrictSearchWithMatch", (String)((Object)restrictSearchWithMatch));
        }
        return this;
    }

    @Override
    public Aggregator<T, R> indexStats() {
        this.params.add(Utils.getMap("$indexStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessionsAllUsers() {
        this.params.add(Utils.getMap("$listLocalSessions", Utils.getMap("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions() {
        this.params.add(Utils.getMap("$listLocalSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions(List<String> users, List<String> dbs) {
        ArrayList<Utils.UtilsMap<String, String>> usersList = new ArrayList<Utils.UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(Utils.getMap(users.get(i), dbs.get(j)));
        }
        this.params.add(Utils.getMap("$listLocalSessions", Utils.getMap("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessionsAllUsers() {
        this.params.add(Utils.getMap("$listSessions", Utils.getMap("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions() {
        this.params.add(Utils.getMap("$listSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions(List<String> users, List<String> dbs) {
        ArrayList<Utils.UtilsMap<String, String>> usersList = new ArrayList<Utils.UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(Utils.getMap(users.get(i), dbs.get(j)));
        }
        this.params.add(Utils.getMap("$listSessions", Utils.getMap("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> lookup(Class fromType, Enum localField, Enum foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        return this.lookup(this.getMorphium().getMapper().getCollectionName(fromType), this.getMorphium().getARHelper().getMongoFieldName(this.getSearchType(), localField.name()), this.getMorphium().getARHelper().getMongoFieldName(fromType, foreignField.name()), outputArray, pipeline, let);
    }

    @Override
    public Aggregator<T, R> lookup(String fromCollection, String localField, String foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        Utils.UtilsMap<String, String> m = Utils.getMap("from", fromCollection);
        if (localField != null) {
            m.add("localField", localField);
        }
        if (foreignField != null) {
            m.add("foreignField", foreignField);
        }
        if (outputArray != null) {
            m.add("as", outputArray);
        }
        if (pipeline != null && pipeline.size() > 0) {
            ArrayList<Expr> lst = new ArrayList<Expr>(pipeline);
            m.put("pipeline", (String)((Object)lst));
        }
        if (let != null) {
            HashMap<String, Expr> map = new HashMap<String, Expr>();
            for (Map.Entry<String, Expr> e : let.entrySet()) {
                map.put(e.getKey(), e.getValue());
            }
            m.put("let", (String)((Object)map));
        }
        this.params.add(Utils.getMap("$lookup", m));
        return this;
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(intoDb, intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection) {
        return this.merge(intoDb, intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    private Aggregator<T, R> merge(String intoDb, String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> pipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        Class<?> entity = this.morphium.getMapper().getClassForCollectionName(intoCollection);
        ArrayList<String> flds = new ArrayList<String>();
        if (entity != null) {
            for (String f : onFields) {
                flds.add(this.morphium.getARHelper().getMongoFieldName(entity, f));
            }
        } else {
            this.log.warn("no entity know for collection " + intoCollection);
            this.log.warn("cannot check field names / properties");
            flds.addAll(Arrays.asList(onFields));
        }
        Utils.UtilsMap<String, Utils.UtilsMap<String, String>> doc = Utils.getMap("into", Utils.getMap("db", intoDb).add("coll", intoCollection));
        if (let != null) {
            doc.put("let", (Utils.UtilsMap<String, String>)Utils.getNoExprMap(let));
        }
        if (matchAction != null) {
            doc.put("whenMatched", (Utils.UtilsMap<String, String>)((Object)matchAction.name()));
        }
        if (notMatchedAction != null) {
            doc.put("whenNotMatched", (Utils.UtilsMap<String, String>)((Object)notMatchedAction.name()));
        }
        if (onFields != null && onFields.length != 0) {
            doc.put("on", (Utils.UtilsMap<String, String>)((Object)flds));
        }
        if (pipeline != null) {
            doc.put("whenMatched", (Utils.UtilsMap<String, String>)((Object)pipeline));
        }
        this.params.add(Utils.getMap("$merge", doc));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String collectionName) {
        this.params.add(Utils.getMap("$out", Utils.getMap("coll", collectionName)));
        return this;
    }

    @Override
    public Aggregator<T, R> out(Class<?> type) {
        return this.out(this.morphium.getMapper().getCollectionName(type));
    }

    @Override
    public Aggregator<T, R> out(String db, String collectionName) {
        this.params.add(Utils.getMap("$out", Utils.getMap("coll", collectionName).add("db", db)));
        return this;
    }

    @Override
    public Aggregator<T, R> planCacheStats(Map<String, Object> param) {
        this.params.add(Utils.getMap("$planCacheStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> redact(Expr redact) {
        this.params.add(Utils.getMap("$redact", redact));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceRoot(Expr newRoot) {
        this.params.add(Utils.getMap("$replaceRoot", Utils.getMap("newRoot", newRoot)));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceWith(Expr newDoc) {
        this.params.add(Utils.getMap("$replaceWith", newDoc));
        return this;
    }

    @Override
    public Aggregator<T, R> sample(int sampleSize) {
        this.params.add(Utils.getMap("$sample", Utils.getMap("size", sampleSize)));
        return this;
    }

    @Override
    public Aggregator<T, R> set(Map<String, Expr> param) {
        Utils.UtilsMap<String, Map<String, Object>> o = Utils.getMap("$set", Utils.getQueryObjectMap(param));
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sortByCount(Expr sortby) {
        this.params.add(Utils.getMap("$sortByCount", sortby));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(String collection) {
        this.params.add(Utils.getMap("$unionWith", collection));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(Aggregator agg) {
        this.params.add(Utils.getMap("$unionWith", Utils.getMap("coll", this.collectionName).add("pipeline", (String)((Object)agg.getPipeline()))));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(List<String> field) {
        this.params.add(Utils.getMap("$unset", field));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(String ... param) {
        this.params.add(Utils.getMap("$unset", Arrays.asList(param)));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(Enum ... field) {
        List lst = Arrays.stream(field).map(Enum::name).collect(Collectors.toList());
        this.params.add(Utils.getMap("$unset", lst));
        return this;
    }

    @Override
    public Aggregator<T, R> genericStage(String stageName, Object param) {
        if (!(param instanceof Expr)) {
            throw new IllegalArgumentException("inMemAggregation only works with Expr");
        }
        if (!stageName.startsWith("$")) {
            stageName = "$" + stageName;
        }
        this.params.add(Utils.getMap(stageName, param));
        return this;
    }

    @Override
    public Aggregator<T, R> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private List<Map<String, Object>> execStep(Map<String, Object> step, List<Map<String, Object>> data) {
        if (step.keySet().size() != 1) {
            throw new IllegalArgumentException("Pipeline start wrong");
        }
        stage = (String)step.keySet().stream().findFirst().get();
        ret = new ArrayList<Map<String, Object>>();
        var5_5 = stage;
        var6_6 = -1;
        switch (var5_5.hashCode()) {
            case 1142092165: {
                if (!var5_5.equals("$unset")) break;
                var6_6 = 0;
                break;
            }
            case -1992648075: {
                if (!var5_5.equals("$project")) break;
                var6_6 = 1;
                break;
            }
            case 1186238: {
                if (!var5_5.equals("$set")) break;
                var6_6 = 2;
                break;
            }
            case 1133580054: {
                if (!var5_5.equals("$addFields")) break;
                var6_6 = 3;
                break;
            }
            case 1125500779: {
                if (!var5_5.equals("$count")) break;
                var6_6 = 4;
                break;
            }
            case 1129278683: {
                if (!var5_5.equals("$group")) break;
                var6_6 = 5;
                break;
            }
            case 36778915: {
                if (!var5_5.equals("$skip")) break;
                var6_6 = 6;
                break;
            }
            case 1133625879: {
                if (!var5_5.equals("$limit")) break;
                var6_6 = 7;
                break;
            }
            case 1134317601: {
                if (!var5_5.equals("$match")) break;
                var6_6 = 8;
                break;
            }
            case 1045241669: {
                if (!var5_5.equals("$unwind")) break;
                var6_6 = 9;
                break;
            }
            case 979024588: {
                if (!var5_5.equals("$search")) break;
                var6_6 = 10;
                break;
            }
            case 36783042: {
                if (!var5_5.equals("$sort")) break;
                var6_6 = 11;
                break;
            }
            case 788266654: {
                if (!var5_5.equals("$lookup")) break;
                var6_6 = 12;
                break;
            }
            case 975686350: {
                if (!var5_5.equals("$sample")) break;
                var6_6 = 13;
                break;
            }
            case 1134434964: {
                if (!var5_5.equals("$merge")) break;
                var6_6 = 14;
                break;
            }
            case 782135058: {
                if (!var5_5.equals("$replaceRoot")) break;
                var6_6 = 15;
                break;
            }
            case 782278390: {
                if (!var5_5.equals("$replaceWith")) break;
                var6_6 = 16;
                break;
            }
            case 1872936810: {
                if (!var5_5.equals("$planCacheStats")) break;
                var6_6 = 17;
                break;
            }
            case 950468485: {
                if (!var5_5.equals("$redact")) break;
                var6_6 = 18;
                break;
            }
            case 1909156054: {
                if (!var5_5.equals("$sortByCount")) break;
                var6_6 = 19;
                break;
            }
            case 913007761: {
                if (!var5_5.equals("$unionWith")) break;
                var6_6 = 20;
                break;
            }
            case -2121910890: {
                if (!var5_5.equals("$currentOp")) break;
                var6_6 = 21;
                break;
            }
            case 347878790: {
                if (!var5_5.equals("$listLocalSessions")) break;
                var6_6 = 22;
                break;
            }
            case -705166812: {
                if (!var5_5.equals("$findAndModyfy")) break;
                var6_6 = 23;
                break;
            }
            case 1046515181: {
                if (!var5_5.equals("$update")) break;
                var6_6 = 24;
                break;
            }
            case 507158286: {
                if (!var5_5.equals("$bucket")) break;
                var6_6 = 25;
                break;
            }
            case 850901469: {
                if (!var5_5.equals("$bucketAuto")) break;
                var6_6 = 26;
                break;
            }
            case -912162449: {
                if (!var5_5.equals("$collStats")) break;
                var6_6 = 27;
                break;
            }
            case 516313471: {
                if (!var5_5.equals("$listSessions")) break;
                var6_6 = 28;
                break;
            }
            case 1127836691: {
                if (!var5_5.equals("$facet")) break;
                var6_6 = 29;
                break;
            }
            case 470319633: {
                if (!var5_5.equals("$indexStats")) break;
                var6_6 = 30;
                break;
            }
            case -1763259787: {
                if (!var5_5.equals("$geoNear")) break;
                var6_6 = 31;
                break;
            }
            case 1806558660: {
                if (!var5_5.equals("$graphLookup")) break;
                var6_6 = 32;
            }
        }
        block38 : switch (var6_6) {
            case 0: {
                for (Map<String, Object> objm : data) {
                    newO = new HashMap<String, Object>(objm);
                    if (step.get(stage) instanceof List) {
                        flds = (List)step.get(stage);
                        for (String f : flds) {
                            newO.remove(this.morphium.getARHelper().getMongoFieldName(this.type, f));
                        }
                    } else {
                        newO.remove(step.get(stage));
                    }
                    ret.add(newO);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                for (Map<String, Object> o : data) {
                    obj = new HashMap<String, Object>(o);
                    ret.add(obj);
                    op = (Map)step.get(stage);
                    for (String k : op.keySet()) {
                        value = op.get(k);
                        if (value instanceof String && ((String)value).startsWith("$")) {
                            obj.put(k, obj.get(((String)value).substring(1)));
                            continue;
                        }
                        if (value instanceof Expr) {
                            obj.put(k, ((Expr)value).evaluate(obj));
                            continue;
                        }
                        if (!(value instanceof Map)) continue;
                        for (String fld : ((Map)value).keySet()) {
                            if (obj.get(fld) instanceof Expr) {
                                obj.put(fld, ((Expr)obj.get(fld)).evaluate(obj));
                                continue;
                            }
                            this.log.error("InMemoryAggregation oly works with Expr");
                        }
                    }
                }
                break;
            }
            case 4: {
                ret.add(Utils.getMap((String)step.get(stage), data.size()));
                break;
            }
            case 5: {
                group = (Map)step.get(stage);
                res = new HashMap<V, HashMap<K, V>>();
                for (Map<String, Object> obj : data) {
                    o = new HashMap<String, Object>(obj);
                    id = group.get("_id");
                    if (id instanceof Map) continue;
                    if (id.toString().startsWith("$")) {
                        id = o.get(id.toString().substring(1));
                    }
                    res.putIfAbsent(id, new HashMap<K, V>());
                    ((Map)res.get(id)).putIfAbsent("_id", id);
                    block108: for (String fld : group.keySet()) {
                        opValue = group.get(fld);
                        if (opValue instanceof Map) {
                            var17_47 = op = (String)((Map)opValue).keySet().stream().findFirst().get();
                            var18_50 = -1;
                            switch (var17_47.hashCode()) {
                                case -1890005014: {
                                    if (!var17_47.equals("$addToSet")) break;
                                    var18_50 = 0;
                                    break;
                                }
                                case 36699454: {
                                    if (!var17_47.equals("$push")) break;
                                    var18_50 = 1;
                                    break;
                                }
                                case 1169454: {
                                    if (!var17_47.equals("$avg")) break;
                                    var18_50 = 2;
                                    break;
                                }
                                case 1128089868: {
                                    if (!var17_47.equals("$first")) break;
                                    var18_50 = 3;
                                    break;
                                }
                                case 36561082: {
                                    if (!var17_47.equals("$last")) break;
                                    var18_50 = 4;
                                    break;
                                }
                                case 1180352: {
                                    if (!var17_47.equals("$max")) break;
                                    var18_50 = 5;
                                    break;
                                }
                                case 1180590: {
                                    if (!var17_47.equals("$min")) break;
                                    var18_50 = 6;
                                    break;
                                }
                                case 1186727: {
                                    if (!var17_47.equals("$sum")) break;
                                    var18_50 = 7;
                                    break;
                                }
                                case 473442786: {
                                    if (!var17_47.equals("$accumulator")) break;
                                    var18_50 = 8;
                                    break;
                                }
                                case -72682528: {
                                    if (!var17_47.equals("$mergeObjects")) break;
                                    var18_50 = 9;
                                    break;
                                }
                                case 718859867: {
                                    if (!var17_47.equals("$stdDevPop")) break;
                                    var18_50 = 10;
                                    break;
                                }
                                case 809895335: {
                                    if (!var17_47.equals("$stdDevSamp")) break;
                                    var18_50 = 11;
                                }
                            }
                            switch (var18_50) {
                                case 0: 
                                case 1: {
                                    setValue = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id)).putIfAbsent(fld, new ArrayList<E>());
                                    if (op.equals("$push")) {
                                        ((List)((Map)res.get(id)).get(fld)).add(setValue);
                                        break;
                                    }
                                    l = (List)((Map)res.get(id)).get(fld);
                                    if (l.contains(setValue)) continue block108;
                                    l.add(setValue);
                                    break;
                                }
                                case 2: {
                                    ((Map)res.get(id)).putIfAbsent(fld, Utils.getMap("sum", 0).add("count", 0).add("avg", 0));
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        count = (Number)((Map)((Map)res.get(id)).get(fld)).get("count");
                                        count = count.intValue() + 1;
                                        ((Map)((Map)res.get(id)).get(fld)).put("count", count);
                                        current = (Number)((Map)((Map)res.get(id)).get(fld)).get("sum");
                                        v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        sum = current.doubleValue() + v.doubleValue();
                                        ((Map)((Map)res.get(id)).get(fld)).put("sum", sum);
                                        ((Map)((Map)res.get(id)).get(fld)).put("avg", sum / count.doubleValue());
                                        break;
                                    }
                                    this.log.error("Average with no $-reference?");
                                    break;
                                }
                                case 3: {
                                    ((Map)res.get(id)).putIfAbsent(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case 4: {
                                    ((Map)res.get(id)).put(fld, o.get(((Map)opValue).get(op).toString().substring(1)));
                                    break;
                                }
                                case 5: {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block108;
                                    oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id)).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id)).get(fld)).compareTo(oVal) <= 0) continue block108;
                                    ((Map)res.get(id)).put(fld, oVal);
                                    break;
                                }
                                case 6: {
                                    if (!((Map)opValue).get(op).toString().startsWith("$")) continue block108;
                                    oVal = o.get(((Map)opValue).get(op).toString().substring(1));
                                    ((Map)res.get(id)).putIfAbsent(fld, oVal);
                                    if (((Comparable)((Map)res.get(id)).get(fld)).compareTo(oVal) >= 0) continue block108;
                                    ((Map)res.get(id)).put(fld, oVal);
                                    break;
                                }
                                case 7: {
                                    ((Map)res.get(id)).putIfAbsent(fld, 0);
                                    current = (Number)((Map)res.get(id)).get(fld);
                                    if (((Map)opValue).get(op).toString().startsWith("$")) {
                                        v = (Number)o.get(((Map)opValue).get(op).toString().substring(1));
                                        ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (((Map)opValue).get(op) instanceof Number) {
                                        v = (Number)((Map)opValue).get(op);
                                        ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                        break;
                                    }
                                    if (!(((Map)opValue).get(op) instanceof Expr)) continue block108;
                                    v = (Number)o.get(((Expr)((Map)opValue).get(op)).evaluate(o));
                                    ((Map)res.get(id)).put(fld, current.doubleValue() + v.doubleValue());
                                    break;
                                }
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    throw new RuntimeException(op + " not implemented yet,sorry");
                                }
                                default: {
                                    this.log.error("unknown accumulator " + op);
                                }
                            }
                            continue;
                        }
                        if (!(opValue instanceof String) || !opValue.toString().startsWith("$")) continue;
                        opValue = o.get(opValue.toString().substring(1));
                        ((Map)res.get(id)).put(fld, opValue);
                    }
                }
                ret.addAll(res.values());
                break;
            }
            case 6: 
            case 7: {
                op = step.get(stage);
                if (op instanceof Expr) {
                    op = ((Expr)op).evaluate(new HashMap<String, Object>());
                }
                idx = ((Number)op).intValue();
                if (stage.equals("$limit")) {
                    ret.addAll(data.subList(0, idx));
                    break;
                }
                ret.addAll(data.subList(idx, data.size() - idx));
                break;
            }
            case 8: {
                ret = data.stream().filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execStep$1(java.util.Map java.lang.String java.util.Map ), (Ljava/util/Map;)Z)(step, (String)stage)).collect(Collectors.toList());
                break;
            }
            case 9: {
                op = step.get(stage);
                for (Map<String, Object> o : data) {
                    if (op instanceof Map) {
                        op = ((Map)op).get("path");
                    }
                    if (op instanceof Expr) {
                        lst = (List)((Expr)op).evaluate(o);
                        n = ((Expr)op).toQueryObject().toString();
                    } else if (op instanceof String) {
                        if (op.toString().startsWith("$")) {
                            op = op.toString().substring(1);
                        }
                        n = op.toString();
                        lst = (List)o.get(op.toString());
                    } else {
                        this.log.error("Wrong reference: " + op);
                        break block38;
                    }
                    if (lst == null) break block38;
                    for (E value : lst) {
                        result = new HashMap<String, Object>(o);
                        if (n.startsWith("$")) {
                            n = n.substring(1);
                        }
                        if (result.containsKey(n)) {
                            result.put(n, value);
                        } else {
                            result.put(new AnnotationAndReflectionHelper(true).convertCamelCase(n), value);
                        }
                        ret.add(result);
                    }
                }
                break;
            }
            case 10: {
                this.log.warn("The $search aggregation pipeline stage is only available for collections hosted on MongoDB Atlas cluster tiers running MongoDB version 4.2 or later. To learn more, see Atlas Search.");
                break;
            }
            case 11: {
                keysToSortBy = (Map)step.get(stage);
                ret = new ArrayList<Map<String, Object>>(data);
                ret.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$execStep$2(java.util.Map java.util.Map java.util.Map ), (Ljava/util/Map;Ljava/util/Map;)I)((Map)keysToSortBy));
                break;
            }
            case 12: {
                ret = new ArrayList<E>();
                lookup = (Map)step.get(stage);
                collection = (String)lookup.get("from");
                localField = (String)lookup.get("localField");
                foreignField = (String)lookup.get("foreignField");
                pipeline = (List)lookup.get("pipeline");
                let = (Map)lookup.get("let");
                as = (String)lookup.get("as");
                if (pipeline != null || let != null) {
                    throw new IllegalArgumentException("pipeline/let is not supported yet.");
                }
                for (Map<String, Object> doc : data) {
                    localValue = doc.get(localField);
                    try {
                        other = this.morphium.getDriver().find(this.morphium.getConfig().getDatabase(), collection, Utils.getMap(foreignField, localValue), null, null, 0, 0, 100, null, null, null);
                        o = new HashMap<String, Object>(doc);
                        o.put(as, other);
                        ret.add(o);
                    }
                    catch (MorphiumDriverException e) {
                        throw new RuntimeException(e);
                    }
                }
                break;
            }
            case 13: {
                size = ((Number)((Map)step.get(stage)).get("size")).intValue();
                o = new ArrayList<Map<String, Object>>(data);
                Collections.shuffle(o);
                ret = o.subList(0, size);
                break;
            }
            case 14: {
                setting = (Map)step.get(stage);
                db = this.morphium.getConfig().getDatabase();
                coll = "";
                if (setting.get("into") instanceof Map) {
                    db = (String)((Map)setting.get("into")).get("db");
                    coll = (String)((Map)setting.get("into")).get("coll");
                } else {
                    coll = (String)setting.get("into");
                }
                if (setting.containsKey("on")) {
                    on = (List)setting.get("on");
                    notMatched = Aggregator.MergeActionWhenNotMatched.insert;
                    matched = Aggregator.MergeActionWhenMatched.merge;
                    mergePipeline = null;
                    if (setting.containsKey("whenMatched")) {
                        if (setting.get("whenMatched") instanceof Map) {
                            mergePipeline = (List)setting.get("whenMatched");
                        } else {
                            matched = Aggregator.MergeActionWhenMatched.valueOf((String)setting.get("whenMatched"));
                        }
                    }
                    if (setting.containsKey("whenNotMatched")) {
                        notMatched = Aggregator.MergeActionWhenNotMatched.valueOf((String)setting.get("whenNotMatched"));
                    }
                    block112: for (Map<String, Object> doc : data) {
                        try {
                            q = new HashMap<String, Object>();
                            for (String onfld : on) {
                                q.put(onfld, doc.get(onfld));
                            }
                            toMergeTo = this.morphium.getDriver().find(db, coll, q, null, null, 0, -1, 100, null, null, null);
                            if (toMergeTo == null || toMergeTo.size() == 0) {
                                switch (1.$SwitchMap$de$caluga$morphium$aggregation$Aggregator$MergeActionWhenNotMatched[notMatched.ordinal()]) {
                                    case 1: {
                                        throw new MorphiumDriverException("Aggregation merge step failed - no doc matched!");
                                    }
                                    case 2: {
                                        continue block112;
                                    }
                                    case 3: {
                                        this.morphium.getDriver().store(db, coll, Collections.singletonList(doc), null);
                                        continue block112;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("unknown whenNotMatched action " + (Object)notMatched);
                                    }
                                }
                            }
                            if (toMergeTo.size() > 1) {
                                throw new MorphiumDriverException("Aggregation merge step failed - on fields query returned more than one value. On-Fields are not unique");
                            }
                            mergeObject = toMergeTo.get(0);
                            switch (1.$SwitchMap$de$caluga$morphium$aggregation$Aggregator$MergeActionWhenMatched[matched.ordinal()]) {
                                case 1: {
                                    if (mergePipeline != null) {
                                        block114: for (Map mergePipelineStep : mergePipeline) {
                                            var36_88 = s = (String)mergePipelineStep.keySet().stream().findFirst().get();
                                            var37_89 = -1;
                                            switch (var36_88.hashCode()) {
                                                case 1186238: {
                                                    if (!var36_88.equals("$set")) break;
                                                    var37_89 = 0;
                                                    break;
                                                }
                                                case 1133580054: {
                                                    if (!var36_88.equals("$addFields")) break;
                                                    var37_89 = 1;
                                                    break;
                                                }
                                                case 1142092165: {
                                                    if (!var36_88.equals("$unset")) break;
                                                    var37_89 = 2;
                                                    break;
                                                }
                                                case -1992648075: {
                                                    if (!var36_88.equals("$project")) break;
                                                    var37_89 = 3;
                                                    break;
                                                }
                                                case 782135058: {
                                                    if (!var36_88.equals("$replaceRoot")) break;
                                                    var37_89 = 4;
                                                    break;
                                                }
                                                case 782278390: {
                                                    if (!var36_88.equals("$replaceWith")) break;
                                                    var37_89 = 5;
                                                }
                                            }
                                            switch (var37_89) {
                                                case 0: 
                                                case 1: {
                                                    continue block114;
                                                }
                                                case 2: {
                                                    newO = new HashMap<String, Object>(doc);
                                                    if (mergePipelineStep.get(s) instanceof List) {
                                                        flds = (List)mergePipelineStep.get(s);
                                                        for (String f : flds) {
                                                            newO.remove(f);
                                                        }
                                                    } else {
                                                        newO.remove(mergePipelineStep.get(s));
                                                    }
                                                    ret.add(newO);
                                                    continue block114;
                                                }
                                                case 3: {
                                                    continue block114;
                                                }
                                                case 4: 
                                                case 5: {
                                                    newRoot = mergePipelineStep.get(s) instanceof Map != false ? ((Map)mergePipelineStep.get(s)).get("newRoot") : mergePipelineStep.get(s);
                                                    if (newRoot instanceof String) {
                                                        if (newRoot.toString().startsWith("$")) {
                                                            ret.add((Map)Expr.field(newRoot.toString()).evaluate(doc));
                                                            continue block114;
                                                        }
                                                        throw new IllegalArgumentException("cannot replace root with single value");
                                                    }
                                                    expr = Expr.parse(newRoot);
                                                    ret.add((Map)expr.evaluate(doc));
                                                    continue block114;
                                                }
                                            }
                                            throw new MorphiumDriverException("Aggregation error: unknown aggregation step in merge pipeline " + s);
                                        }
                                        continue block112;
                                    }
                                    if (mergeObject.containsKey("_id")) {
                                        throw new MorphiumDriverException("Aggregation merge failure: referenced object keeps _id!");
                                    }
                                    newDoc = new HashMap<String, Object>(doc);
                                    newDoc.putAll(mergeObject);
                                    this.morphium.getDriver().store(db, coll, Collections.singletonList(mergeObject), null);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("unknown whenMatched action " + (Object)matched);
                                }
                            }
                        }
                        catch (MorphiumDriverException e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                try {
                    this.morphium.getDriver().store(db, coll, data, null);
                }
                catch (MorphiumDriverException e) {
                    this.log.error("Something went wrong with $merge", (Throwable)e);
                }
            }
            case 15: 
            case 16: {
                newRoot = step.get(stage) instanceof Map != false ? ((Map)step.get(stage)).get("newRoot") : step.get(stage);
                if (!(newRoot instanceof String)) ** GOTO lbl568
                if (newRoot.toString().startsWith("$")) {
                    for (Map<String, Object> doc : data) {
                        ret.add((Map)Expr.field(newRoot.toString()).evaluate(doc));
                    }
                } else {
                    throw new IllegalArgumentException("cannot replace root with single value");
lbl568:
                    // 1 sources

                    expr = Expr.parse(newRoot);
                    for (Map<String, Object> doc : data) {
                        ret.add((Map)expr.evaluate(doc));
                    }
                }
                break;
            }
            default: {
                this.log.error("unhandled Aggregation stage " + stage);
            }
        }
        return ret;
    }

    @Override
    public List<Map<String, Object>> aggregateMap() {
        return this.doAggregation();
    }

    private List<Map<String, Object>> doAggregation() {
        List<Map<String, Object>> result = this.getMorphium().createQueryFor(this.getSearchType()).asMapList();
        for (Map<String, Object> step : this.getPipeline()) {
            result = this.execStep(step, result);
        }
        return result;
    }

    private static /* synthetic */ int lambda$execStep$2(Map keysToSortBy, Map o1, Map o2) {
        for (String k : keysToSortBy.keySet()) {
            int i = ((Comparable)o1.get(k)).compareTo(o2.get(k));
            if (i == 0) continue;
            if (keysToSortBy.get(k).equals(-1)) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    private static /* synthetic */ boolean lambda$execStep$1(Map step, String stage, Map doc) {
        return QueryHelper.matchesQuery((Map)step.get(stage), doc);
    }
}

