/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.LazyDeReferencingProxy;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.ProfilingListener;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.Statistics;
import de.caluga.morphium.Utils;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.Capped;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.annotations.lifecycle.PostRemove;
import de.caluga.morphium.annotations.lifecycle.PostStore;
import de.caluga.morphium.annotations.lifecycle.PostUpdate;
import de.caluga.morphium.annotations.lifecycle.PreRemove;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.annotations.lifecycle.PreUpdate;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.bulk.MorphiumBulkContext;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.MorphiumCacheImpl;
import de.caluga.morphium.changestream.ChangeStreamEvent;
import de.caluga.morphium.changestream.ChangeStreamListener;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.encryption.EncryptionKeyProvider;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MongoFieldImpl;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.replicaset.RSMonitor;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.replicaset.ReplicasetStatusListener;
import de.caluga.morphium.validation.JavaxValidationStorageListener;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Morphium
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Morphium.class);
    private final ThreadLocal<Boolean> enableAutoValues = new ThreadLocal();
    private final ThreadLocal<Boolean> enableReadCache = new ThreadLocal();
    private final ThreadLocal<Boolean> disableWriteBuffer = new ThreadLocal();
    private final ThreadLocal<Boolean> disableAsyncWrites = new ThreadLocal();
    private final List<ProfilingListener> profilingListeners;
    private final List<ShutdownListener> shutDownListeners = new CopyOnWriteArrayList<ShutdownListener>();
    private MorphiumConfig config;
    private Map<StatisticKeys, StatisticValue> stats = new ConcurrentHashMap<StatisticKeys, StatisticValue>();
    private List<MorphiumStorageListener> listeners = new CopyOnWriteArrayList<MorphiumStorageListener>();
    private AnnotationAndReflectionHelper annotationHelper;
    private MorphiumObjectMapper objectMapper;
    private EncryptionKeyProvider encryptionKeyProvider;
    private RSMonitor rsMonitor;
    private ThreadPoolExecutor asyncOperationsThreadPool;
    private MorphiumDriver morphiumDriver;
    private JavaxValidationStorageListener lst;

    public Morphium() {
        this.profilingListeners = new CopyOnWriteArrayList<ProfilingListener>();
    }

    public Morphium(String host, String db) {
        this();
        MorphiumConfig cfg = new MorphiumConfig(db, 100, 5000, 5000);
        cfg.addHostToSeed(host);
        this.setConfig(cfg);
    }

    public Morphium(String host, int port, String db) {
        this();
        MorphiumConfig cfg = new MorphiumConfig(db, 100, 5000, 5000);
        cfg.addHostToSeed(host, port);
        this.setConfig(cfg);
    }

    public Morphium(MorphiumConfig cfg) {
        this();
        this.setConfig(cfg);
    }

    public MorphiumConfig getConfig() {
        return this.config;
    }

    public void setConfig(MorphiumConfig cfg) {
        if (this.config != null) {
            throw new RuntimeException("Cannot change config!");
        }
        this.config = cfg;
        this.annotationHelper = new AnnotationAndReflectionHelper(cfg.isCamelCaseConversionEnabled());
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(){
            private static final long serialVersionUID = -6903933921423432194L;

            @Override
            public boolean offer(Runnable e) {
                int maximumPoolSize;
                int poolSize = Morphium.this.asyncOperationsThreadPool.getPoolSize();
                if (poolSize >= (maximumPoolSize = Morphium.this.asyncOperationsThreadPool.getMaximumPoolSize()) || poolSize > Morphium.this.asyncOperationsThreadPool.getActiveCount()) {
                    return super.offer(e);
                }
                return false;
            }
        };
        this.asyncOperationsThreadPool = new ThreadPoolExecutor(this.getConfig().getThreadPoolAsyncOpCoreSize(), this.getConfig().getThreadPoolAsyncOpMaxSize(), this.getConfig().getThreadPoolAsyncOpKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue);
        this.asyncOperationsThreadPool.setRejectedExecutionHandler((r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        this.asyncOperationsThreadPool.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread ret = new Thread(r, "asyncOp " + this.num);
                this.num.set(this.num.get() + 1);
                ret.setDaemon(true);
                return ret;
            }
        });
        this.initializeAndConnect();
    }

    public ThreadPoolExecutor getAsyncOperationsThreadPool() {
        return this.asyncOperationsThreadPool;
    }

    private void initializeAndConnect() {
        Map<Class<?>, List<Map<String, Object>>> missing;
        if (this.config == null) {
            throw new RuntimeException("Please specify configuration!");
        }
        for (StatisticKeys k : StatisticKeys.values()) {
            this.stats.put(k, new StatisticValue());
        }
        if (this.morphiumDriver == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    this.setName("shutdown_hook");
                    try {
                        Morphium.this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            try {
                this.morphiumDriver = (MorphiumDriver)Class.forName(this.config.getDriverClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.morphiumDriver.setConnectionTimeout(this.config.getConnectionTimeout());
            this.morphiumDriver.setMaxConnections(this.config.getMaxConnections());
            this.morphiumDriver.setMinConnections(this.config.getMinConnectionsHost());
            this.morphiumDriver.setReadTimeout(this.config.getReadTimeout());
            this.morphiumDriver.setRetryReads(this.config.isRetryReads());
            this.morphiumDriver.setRetryWrites(this.config.isRetryWrites());
            this.morphiumDriver.setHeartbeatFrequency(this.config.getHeartbeatFrequency());
            this.morphiumDriver.setMaxConnectionIdleTime(this.config.getMaxConnectionIdleTime());
            this.morphiumDriver.setMaxConnectionLifetime(this.config.getMaxConnectionLifeTime());
            this.morphiumDriver.setMaxWaitTime(this.config.getMaxWaitTime());
            this.morphiumDriver.setServerSelectionTimeout(this.config.getServerSelectionTimeout());
            this.morphiumDriver.setUuidRepresentation(this.config.getUuidRepresentation());
            this.morphiumDriver.setUseSSL(this.config.isUseSSL());
            this.morphiumDriver.setSslContext(this.config.getSslContext());
            this.morphiumDriver.setSslInvalidHostNameAllowed(this.config.isSslInvalidHostNameAllowed());
            if (this.config.getHostSeed().isEmpty()) {
                throw new RuntimeException("Error - no server address specified!");
            }
            if (this.config.getMongoLogin() != null && this.config.getMongoPassword() != null) {
                this.morphiumDriver.setCredentials(this.config.getDatabase(), this.config.getMongoLogin(), this.config.getMongoPassword().toCharArray());
            }
            if (this.config.getMongoAdminUser() != null && this.config.getMongoAdminPwd() != null) {
                this.morphiumDriver.setCredentials("admin", this.config.getMongoAdminUser(), this.config.getMongoAdminPwd().toCharArray());
            }
            String[] seed = new String[this.config.getHostSeed().size()];
            for (int i = 0; i < seed.length; ++i) {
                seed[i] = this.config.getHostSeed().get(i);
            }
            this.morphiumDriver.setHostSeed(seed);
            this.morphiumDriver.setDefaultReadPreference(this.config.getDefaultReadPreference());
            try {
                this.morphiumDriver.connect(this.config.getRequiredReplicaSetName());
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.config.getWriter() == null) {
            this.config.setWriter(new MorphiumWriterImpl());
        }
        if (this.config.getBufferedWriter() == null) {
            this.config.setBufferedWriter(new BufferedMorphiumWriterImpl());
        }
        this.config.getWriter().setMorphium(this);
        this.config.getWriter().setMaximumQueingTries(this.config.getMaximumRetriesWriter());
        this.config.getWriter().setPauseBetweenTries(this.config.getRetryWaitTimeWriter());
        this.config.getBufferedWriter().setMorphium(this);
        this.config.getBufferedWriter().setMaximumQueingTries(this.config.getMaximumRetriesBufferedWriter());
        this.config.getBufferedWriter().setPauseBetweenTries(this.config.getRetryWaitTimeBufferedWriter());
        this.config.getAsyncWriter().setMorphium(this);
        this.config.getAsyncWriter().setMaximumQueingTries(this.config.getMaximumRetriesAsyncWriter());
        this.config.getAsyncWriter().setPauseBetweenTries(this.config.getRetryWaitTimeAsyncWriter());
        if (this.config.getCache() == null) {
            this.config.setCache(new MorphiumCacheImpl());
        }
        this.config.getCache().setAnnotationAndReflectionHelper(this.getARHelper());
        this.config.getCache().setGlobalCacheTimeout(this.config.getGlobalCacheValidTime());
        this.config.getCache().setHouskeepingIntervalPause(this.config.getHousekeepingTimeout());
        this.setValidationSupport();
        try {
            this.objectMapper = this.config.getOmClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.objectMapper.setMorphium(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.encryptionKeyProvider = this.config.getEncryptionKeyProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.isReplicaSet()) {
            this.rsMonitor = new RSMonitor(this);
            this.rsMonitor.start();
            this.rsMonitor.getReplicaSetStatus(false);
        }
        if (!this.config.getIndexCappedCheck().equals((Object)MorphiumConfig.IndexCappedCheck.NO_CHECK) && this.config.getIndexCappedCheck().equals((Object)MorphiumConfig.IndexCappedCheck.CREATE_ON_STARTUP) && (missing = this.checkIndices(classInfo -> !classInfo.getPackageName().startsWith("de.caluga.morphium"))) != null && !missing.isEmpty()) {
            for (Class<?> cls : missing.keySet()) {
                if (missing.get(cls).size() == 0) continue;
                try {
                    if (this.config.getIndexCappedCheck().equals((Object)MorphiumConfig.IndexCappedCheck.WARN_ON_STARTUP)) {
                        logger.warn("Missing indices for entity " + cls.getName() + ": " + missing.get(cls).size());
                        if (!this.cappedMissing(missing.get(cls))) continue;
                        logger.warn("No capped settings missing for " + cls.getName());
                        continue;
                    }
                    if (!this.config.getIndexCappedCheck().equals((Object)MorphiumConfig.IndexCappedCheck.CREATE_ON_STARTUP)) continue;
                    logger.warn("Creating missing indices for entity " + cls.getName());
                    this.ensureIndicesFor(cls);
                    if (!this.cappedMissing(missing.get(cls))) continue;
                    logger.warn("applying capped settings for entity " + cls.getName());
                    this.ensureCapped(cls);
                }
                catch (Exception e) {
                    logger.error("Could not process indices for entity " + cls.getName(), (Throwable)e);
                }
            }
        }
    }

    private boolean cappedMissing(List<Map<String, Object>> lst) {
        for (Map<String, Object> idx : lst) {
            if (!idx.containsKey("__capped_size")) continue;
            return true;
        }
        return false;
    }

    public EncryptionKeyProvider getEncryptionKeyProvider() {
        return this.encryptionKeyProvider;
    }

    public MorphiumCache getCache() {
        return this.config.getCache();
    }

    public boolean isValidationEnabled() {
        return this.lst != null;
    }

    public void disableValidation() {
        if (this.lst == null) {
            return;
        }
        this.listeners.remove(this.lst);
        this.lst = null;
    }

    public void enableValidation() {
        this.setValidationSupport();
        if (this.lst == null) {
            throw new RuntimeException("Validation not possible - javax.validation implementation not in Classpath?");
        }
    }

    private void setValidationSupport() {
        if (this.lst != null) {
            if (!this.listeners.contains(this.lst)) {
                this.listeners.add(this.lst);
            }
            return;
        }
        try {
            this.getClass().getClassLoader().loadClass("javax.validation.ValidatorFactory");
            this.lst = new JavaxValidationStorageListener();
            this.addListener(this.lst);
            logger.debug("Adding javax.validation Support...");
        }
        catch (Exception cnf) {
            logger.debug("Validation disabled!");
        }
    }

    public List<String> listDatabases() {
        try {
            return this.getDriver().listDatabases();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException("Could not list databases", e);
        }
    }

    public List<String> listCollections() {
        return this.listCollections(null);
    }

    public List<String> listCollections(String pattern) {
        try {
            return this.getDriver().listCollections(this.getConfig().getDatabase(), pattern);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void reconnectToDb(String db) {
        Properties prop = this.getConfig().asProperties();
        this.close();
        MorphiumConfig cfg = new MorphiumConfig(prop);
        this.setConfig(cfg);
    }

    public void addListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>(this.listeners);
        newList.add(lst);
        this.listeners = newList;
    }

    public void removeListener(MorphiumStorageListener lst) {
        ArrayList<MorphiumStorageListener> newList = new ArrayList<MorphiumStorageListener>(this.listeners);
        newList.remove(lst);
        this.listeners = newList;
    }

    public MorphiumDriver getDriver() {
        return this.morphiumDriver;
    }

    public void setDriver(MorphiumDriver drv) {
        this.morphiumDriver = drv;
    }

    public <T> Query<T> createQueryByTemplate(T template, Enum ... fields) {
        String[] flds = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            flds[i] = fields[i].name();
        }
        return this.createQueryByTemplate(template, flds);
    }

    public Query<Map<String, Object>> createMapQuery(String collection) {
        Class<? extends Query> qImpl = this.config.getQueryFact().getQueryImpl();
        try {
            Query q = qImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            q.setMorphium(this);
            q.setCollectionName(collection);
            return q;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> Query<T> createQueryByTemplate(T template, String ... fields) {
        Class<?> cls = template.getClass();
        List<String> flds = fields.length > 0 ? new ArrayList<String>(Arrays.asList(fields)) : this.annotationHelper.getFields(cls, new Class[0]);
        Query<?> q = this.createQueryFor(cls);
        for (String f : flds) {
            try {
                q.f(f).eq(this.annotationHelper.getValue(template, f));
            }
            catch (Exception e) {
                logger.error("Could not read field " + f + " of object " + cls.getName());
            }
        }
        return q;
    }

    public <T> List<T> findByTemplate(T template, Enum ... fields) {
        return this.createQueryByTemplate(template, fields).asList();
    }

    public <T> List<T> findByTemplate(T template, String ... fields) {
        return this.createQueryByTemplate(template, fields).asList();
    }

    public <T> void unset(T toSet, Enum field) {
        this.unset(toSet, field.name(), (AsyncOperationCallback)null);
    }

    public <T> void unset(T toSet, String field) {
        this.unset(toSet, field, (AsyncOperationCallback)null);
    }

    public <T> void unset(T toSet, Enum field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, field.name(), callback);
    }

    public <T> void unset(T toSet, String collection, Enum field) {
        this.unset(toSet, collection, field.name(), null);
    }

    public <T> void unset(T toSet, String collection, Enum field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, collection, field.name(), callback);
    }

    public <T> void unset(T toSet, String field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, callback);
    }

    public <T> void unset(T toSet, String collection, String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(toSet.getClass());
        wr.unset(toSet, collection, field, callback);
    }

    public <T> void unsetQ(Query<T> q, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> void unsetQ(Query<T> q, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, boolean multiple, String ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, AsyncOperationCallback<T> cb, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> void unsetQ(Query<T> q, boolean multiple, AsyncOperationCallback<T> cb, Enum ... field) {
        this.getWriterForClass(q.getType()).unset(q, cb, multiple, field);
    }

    public <T> void ensureIndicesFor(Class<T> type) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), null);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection) {
        this.ensureIndicesFor(type, onCollection, null);
    }

    public <T> void ensureIndicesFor(Class<T> type, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), callback);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, onCollection, callback, this.getWriterForClass(type));
    }

    public void addReplicasetStatusListener(ReplicasetStatusListener lst) {
        if (this.rsMonitor != null) {
            this.rsMonitor.addListener(lst);
        }
    }

    public void removeReplicasetStatusListener(ReplicasetStatusListener lst) {
        if (this.rsMonitor != null) {
            this.rsMonitor.removeListener(lst);
        }
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback, MorphiumWriter wr) {
        List<String> flds;
        Index i;
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, Index.class)) {
            List<Annotation> lst = this.annotationHelper.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                i = (Index)a;
                if (i.value().length <= 0) continue;
                List<Map<String, Object>> options = null;
                if (i.options().length > 0) {
                    options = this.createIndexMapFrom(i.options());
                }
                if (!i.locale().equals("")) {
                    Utils.UtilsMap<String, String> collation = Utils.getMap("locale", i.locale());
                    collation.put("alternate", i.alternate().mongoText);
                    collation.put("backwards", (String)((Object)Boolean.valueOf(i.backwards())));
                    collation.put("caseFirst", i.caseFirst().mongoText);
                    collation.put("caseLevel", (String)((Object)Boolean.valueOf(i.caseLevel())));
                    collation.put("maxVariable", i.maxVariable().mongoText);
                    collation.put("strength", (String)((Object)Integer.valueOf(i.strength().mongoValue)));
                    options.add(Utils.getMap("collation", collation));
                }
                List<Map<String, Object>> idx = this.createIndexMapFrom(i.value());
                int cnt = 0;
                for (Map<String, Object> m : idx) {
                    Map<String, Object> optionsMap = null;
                    if (options != null && options.size() > cnt) {
                        optionsMap = options.get(cnt);
                    }
                    wr.ensureIndex(type, onCollection, m, optionsMap, callback);
                    ++cnt;
                }
            }
        }
        if ((flds = this.annotationHelper.getFields(type, Index.class)) != null && !flds.isEmpty()) {
            for (String f : flds) {
                i = this.annotationHelper.getField(type, f).getAnnotation(Index.class);
                LinkedHashMap<String, Object> idx = new LinkedHashMap<String, Object>();
                if (i.decrement()) {
                    idx.put(f, -1);
                } else {
                    idx.put(f, 1);
                }
                Map<String, Object> optionsMap = null;
                if (this.createIndexMapFrom(i.options()) != null) {
                    optionsMap = this.createIndexMapFrom(i.options()).get(0);
                }
                wr.ensureIndex(type, onCollection, idx, optionsMap, callback);
            }
        }
    }

    public <T> void convertToCapped(Class<T> c, int size, AsyncOperationCallback<T> cb) {
        this.convertToCapped(this.getMapper().getCollectionName(c), size, cb);
        this.ensureIndicesFor(c, cb);
    }

    public <T> void convertToCapped(String coll, int size, AsyncOperationCallback<T> cb) {
        LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("convertToCapped", coll);
        cmd.put("size", size);
        try {
            this.morphiumDriver.runCommand(this.config.getDatabase(), cmd);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> execCommand(String cmd) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(cmd, "1");
        return this.execCommand(map);
    }

    public Map<String, Object> execCommand(Map<String, Object> command) {
        Map<String, Object> ret;
        LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>(command);
        try {
            ret = this.morphiumDriver.runCommand(this.config.getDatabase(), cmd);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public <T> void ensureCapped(Class<T> c) {
        this.ensureCapped(c, null);
    }

    public <T> void ensureCapped(Class<T> c, AsyncOperationCallback<T> callback) {
        Runnable r = () -> {
            String coll = this.getMapper().getCollectionName(c);
            try {
                boolean exists = this.morphiumDriver.exists(this.config.getDatabase(), coll);
                if (exists && this.morphiumDriver.isCapped(this.config.getDatabase(), coll)) {
                    return;
                }
                if (this.config.isAutoIndexAndCappedCreationOnWrite() && !exists) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Collection does not exist - ensuring indices / capped status");
                    }
                    LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
                    cmd.put("create", coll);
                    Capped capped = this.annotationHelper.getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        cmd.put("capped", true);
                        cmd.put("size", capped.maxSize());
                        cmd.put("max", capped.maxEntries());
                    }
                    this.morphiumDriver.runCommand(this.config.getDatabase(), cmd);
                } else {
                    Capped capped = this.annotationHelper.getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        this.convertToCapped(c, capped.maxSize(), null);
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
        if (callback == null) {
            r.run();
        } else {
            this.asyncOperationsThreadPool.execute(r);
        }
    }

    public Map<String, Object> simplifyQueryObject(Map<String, Object> q) {
        if (q.keySet().size() == 1 && q.get("$and") != null) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            List lst = (List)q.get("$and");
            for (Object o : lst) {
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                return q;
            }
            return ret;
        }
        return q;
    }

    public <T> void set(Query<T> query, Enum field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, Enum field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field.name(), val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public <T> void set(Query<T> query, String field, Object val) {
        this.set((T)query, field, val, (AsyncOperationCallback<T>)null);
    }

    public <T> void set(Query<T> query, String field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field, val);
        this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public void setEnum(Query<?> query, Map<Enum, Object> values, boolean upsert, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        this.set(query, toSet, upsert, multiple);
    }

    public void push(Query<?> query, Enum field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, Enum field, Object value) {
        this.pull(query, field.name(), value, false, true);
    }

    public void push(Query<?> query, String field, Object value) {
        this.push(query, field, value, false, true);
    }

    public void pull(Query<?> query, String field, Object value) {
        this.pull(query, field, value, false, true);
    }

    public void push(Query<?> query, Enum field, Object value, boolean upsert, boolean multiple) {
        this.push(query, field.name(), value, upsert, multiple);
    }

    public void pull(Query<?> query, Enum field, Object value, boolean upsert, boolean multiple) {
        this.pull(query, field.name(), value, upsert, multiple);
    }

    public void pushAll(Query<?> query, Enum field, List<Object> value, boolean upsert, boolean multiple) {
        this.pushAll(query, field.name(), value, upsert, multiple);
    }

    public void push(Object entity, String field, Object value, boolean upsert) {
        this.push(entity, null, field, value, upsert);
    }

    public void push(Object entity, String collection, String field, Object value, boolean upsert) {
        Object id = this.getId(entity);
        if (!upsert || id != null) {
            Query<?> id1 = this.createQueryFor(entity.getClass()).f("_id").eq(id);
            if (collection != null) {
                id1.setCollectionName(collection);
            }
            this.push(id1, field, value, upsert, false);
        }
        Field fld = this.getARHelper().getField(entity.getClass(), field);
        try {
            if (fld.getType().isArray()) {
                Object a = fld.get(entity);
                Object arr = null;
                if (a == null) {
                    arr = Array.newInstance(((Class)fld.getGenericType()).getComponentType(), 1);
                    Array.set(arr, 0, value);
                } else {
                    arr = Array.newInstance(((Class)fld.getGenericType()).getComponentType(), Array.getLength(a) + 1);
                    for (int i = 0; i < Array.getLength(a); ++i) {
                        Array.set(arr, i, Array.get(a, i));
                    }
                    Array.set(arr, Array.getLength(a), value);
                }
                fld.set(entity, arr);
            } else if (Collection.class.isAssignableFrom(fld.getType())) {
                ArrayList<Object> v = null;
                v = (ArrayList<Object>)fld.get(entity);
                if (v == null) {
                    v = new ArrayList<Object>();
                    v.add(value);
                    fld.set(entity, v);
                } else {
                    v.add(value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not update entity", e);
        }
        if (upsert && id == null) {
            this.store(entity);
        }
    }

    public void push(Object entity, String collection, Enum field, Object value, boolean upsert) {
        this.push(entity, collection, field.name(), value, upsert);
    }

    public void push(Object entity, Enum field, Object value, boolean upsert) {
        this.push(entity, field.name(), value, upsert);
    }

    public void pullAll(Query<?> query, Enum field, List<Object> value, boolean upsert, boolean multiple) {
        this.pull(query, field.name(), value, upsert, multiple);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.push(query, field, value, upsert, multiple, null);
    }

    public <T> void push(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).pushPull(true, query, field, value, upsert, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.pull(query, field, value, upsert, multiple, null);
    }

    public <T> void pull(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        wr.pushPull(false, query, field, value, upsert, multiple, callback);
    }

    public <T> void pull(T entity, String field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (entity == null) {
            throw new IllegalArgumentException("Null Entity cannot be pulled...");
        }
        this.pull(this.createQueryFor(entity.getClass()).f("_id").eq(this.getId(entity)), field, value, upsert, multiple, callback);
    }

    public <T> void pull(Query<T> query, String field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        wr.pushPull(false, query, field, value, upsert, multiple, callback);
    }

    public void pushAll(Query<?> query, String field, List<?> value, boolean upsert, boolean multiple) {
        this.pushAll(query, field, value, upsert, multiple, null);
    }

    public <T> void pushAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        wr.pushPullAll(true, query, field, value, upsert, multiple, callback);
    }

    public <T> void set(Query<T> query, Enum field, Object val, boolean upsert, boolean multiple) {
        this.set(query, field.name(), val, upsert, multiple, null);
    }

    public <T> void set(Query<T> query, Enum field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.set(query, field.name(), val, upsert, multiple, callback);
    }

    public void pullAll(Query<?> query, String field, List<Object> value, boolean upsert, boolean multiple) {
        this.pull(query, field, value, upsert, multiple);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean upsert, boolean multiple) {
        this.set(query, field, val, upsert, multiple, null);
    }

    public <T> void set(Query<T> query, String field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        this.set(query, map, upsert, multiple, callback);
    }

    public void set(Query<?> query, Map<String, Object> map, boolean upsert, boolean multiple) {
        this.set(query, map, upsert, multiple, null);
    }

    public <T> void set(Query<T> query, Map<String, Object> map, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).set(query, map, upsert, multiple, callback);
    }

    public <T> void currentDate(Query<?> query, String field, boolean upsert, boolean multiple) {
        this.set(query, Utils.getMap("$currentDate", Utils.getMap(field, 1)), upsert, multiple);
    }

    public <T> void currentDate(Query<?> query, Enum field, boolean upsert, boolean multiple) {
        this.set(query, Utils.getMap("$currentDate", Utils.getMap(field.name(), 1)), upsert, multiple);
    }

    public <T> void set(T toSet, Enum field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, callback);
    }

    public <T> void set(T toSet, Enum field, Object value) {
        this.set(toSet, field.name(), value, null);
    }

    public <T> void set(T toSet, String collection, Enum field, Object value) {
        this.set(toSet, collection, field.name(), value, false, null);
    }

    public <T> void set(T toSet, Enum field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, upserts, callback);
    }

    public <T> void set(T toSet, Map<Enum, Object> values) {
        this.set(toSet, this.getMapper().getCollectionName(toSet.getClass()), false, values, null);
    }

    public <T> void set(String inCollection, Map<Enum, Object> values, T into) {
        this.set(into, inCollection, false, values, null);
    }

    public <T> void set(T toSet, String collection, boolean upserts, Map<Enum, Object> values) {
        this.set(toSet, collection, upserts, values, null);
    }

    public <T> void set(T toSet, String collection, boolean upserts, Map<Enum, Object> values, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> strValues = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : values.entrySet()) {
            strValues.put(e.getKey().name(), e.getValue());
        }
        this.set(toSet, collection, strValues, upserts, callback);
    }

    public <T> void set(T toSet, String field, Object value) {
        this.set(toSet, field, value, null);
    }

    public <T> void set(T toSet, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, value, upserts, callback);
    }

    public <T> void set(Map<String, Object> values, T into) {
        this.set(into, this.getMapper().getCollectionName(into.getClass()), values, false, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values) {
        this.set(toSet, collection, values, false, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values, boolean upserts) {
        this.set(toSet, collection, values, upserts, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values, boolean upserts, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.annotationHelper.callLifecycleMethod(PreUpdate.class, toSet);
        this.getWriterForClass(toSet.getClass()).set(toSet, collection, values, upserts, callback);
        this.annotationHelper.callLifecycleMethod(PostUpdate.class, toSet);
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDriver().getDBStats(db);
    }

    public Map<String, Object> getDbStats() throws MorphiumDriverException {
        return this.getDriver().getDBStats(this.getConfig().getDatabase());
    }

    public Map<String, Object> getCollStats(Class<?> coll) throws MorphiumDriverException {
        return this.getDriver().getCollStats(this.getConfig().getDatabase(), this.getMapper().getCollectionName(coll));
    }

    public Map<String, Object> getCollStats(String coll) throws MorphiumDriverException {
        return this.getDriver().getCollStats(this.getConfig().getDatabase(), coll);
    }

    public <T> void set(T toSet, String collection, Enum field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, collection, Utils.getMap(field.name(), value), upserts, callback);
    }

    public <T> void set(T toSet, String collection, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, collection, Utils.getMap(field, value), upserts, callback);
    }

    public <T> void set(T toSet, String field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field, value, false, callback);
    }

    public void dec(Query<?> query, Enum field, double amount, boolean upsert, boolean multiple) {
        this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public void dec(Query<?> query, Enum field, long amount, boolean upsert, boolean multiple) {
        this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public void dec(Query<?> query, Enum field, Number amount, boolean upsert, boolean multiple) {
        this.dec(query, field.name(), amount.doubleValue(), upsert, multiple);
    }

    public void dec(Query<?> query, Enum field, int amount, boolean upsert, boolean multiple) {
        this.dec(query, field.name(), amount, upsert, multiple);
    }

    public void dec(Query<?> query, String field, double amount, boolean upsert, boolean multiple) {
        this.inc(query, field, -amount, upsert, multiple);
    }

    public void dec(Query<?> query, String field, long amount, boolean upsert, boolean multiple) {
        this.inc(query, field, -amount, upsert, multiple);
    }

    public void dec(Query<?> query, String field, int amount, boolean upsert, boolean multiple) {
        this.inc(query, field, -amount, upsert, multiple);
    }

    public void dec(Query<?> query, String field, Number amount, boolean upsert, boolean multiple) {
        this.inc(query, field, -amount.doubleValue(), upsert, multiple);
    }

    public void dec(Query<?> query, String field, double amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, String field, long amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, String field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, String field, Number amount) {
        this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public void dec(Query<?> query, Enum field, double amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, long amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, int amount) {
        this.inc(query, field, -amount, false, false);
    }

    public void dec(Query<?> query, Enum field, Number amount) {
        this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public void inc(Query<?> query, String field, long amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, String field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, String field, Number amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, String field, double amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, double amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, long amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, int amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, Number amount) {
        this.inc(query, field, amount, false, false);
    }

    public void inc(Query<?> query, Enum field, double amount, boolean upsert, boolean multiple) {
        this.inc(query, field.name(), amount, upsert, multiple);
    }

    public void inc(Query<?> query, Enum field, long amount, boolean upsert, boolean multiple) {
        this.inc(query, field.name(), amount, upsert, multiple);
    }

    public void inc(Query<?> query, Enum field, int amount, boolean upsert, boolean multiple) {
        this.inc(query, field.name(), amount, upsert, multiple);
    }

    public void inc(Query<?> query, Enum field, Number amount, boolean upsert, boolean multiple) {
        this.inc(query, field.name(), amount, upsert, multiple);
    }

    public <T> void inc(Map<Enum, Number> fieldsToInc, Query<T> matching, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Number> toUpdate = new HashMap<String, Number>();
        for (Map.Entry<Enum, Number> e : fieldsToInc.entrySet()) {
            toUpdate.put(e.getKey().name(), e.getValue());
        }
        this.inc(matching, toUpdate, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, Map<String, Number> toUpdate, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, toUpdate, upsert, multiple, callback);
    }

    public <T> void dec(Map<Enum, Number> fieldsToInc, Query<T> matching, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Number> toUpdate = new HashMap<String, Number>();
        for (Map.Entry<Enum, Number> e : fieldsToInc.entrySet()) {
            toUpdate.put(e.getKey().name(), e.getValue());
        }
        this.dec(matching, toUpdate, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, Map<String, Number> toUpdate, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, toUpdate, upsert, multiple, callback);
    }

    public void inc(Query<?> query, String name, long amount, boolean upsert, boolean multiple) {
        this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public void inc(Query<?> query, String name, int amount, boolean upsert, boolean multiple) {
        this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public void inc(Query<?> query, String name, double amount, boolean upsert, boolean multiple) {
        this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public void inc(Query<?> query, String name, Number amount, boolean upsert, boolean multiple) {
        this.inc(query, name, amount, upsert, multiple, null);
    }

    public <T> void inc(Query<T> query, Enum field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, Enum field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, Enum field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, Enum field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void inc(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, Enum field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, Enum field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, Enum field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, Enum field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> void dec(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        this.getWriterForClass(query.getType()).inc(query, name, -amount.doubleValue(), upsert, multiple, callback);
    }

    public MorphiumWriter getWriterForClass(Class<?> cls) {
        if (this.annotationHelper.isBufferedWrite(cls) && this.isWriteBufferEnabledForThread()) {
            return this.config.getBufferedWriter();
        }
        if (this.annotationHelper.isAsyncWrite(cls) && this.isAsyncWritesEnabledForThread()) {
            return this.config.getAsyncWriter();
        }
        return this.config.getWriter();
    }

    public void dec(Object toDec, Enum field, double amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, double amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum field, int amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, int amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum field, long amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, long amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum field, Number amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, Number amount) {
        this.inc(toDec, field, -amount.doubleValue());
    }

    public void inc(Object toSet, Enum field, long i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, long i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum field, int i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, int i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum field, double i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, double i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum field, Number i) {
        this.inc(toSet, field.name(), i, null);
    }

    public void inc(Object toSet, String field, Number i) {
        this.inc(toSet, field, i, null);
    }

    public <T> void inc(T toSet, Enum field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum collection, Enum field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, double i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, int i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, long i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, Number i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            logger.info("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void delete(List<T> lst, String forceCollectionName) {
        this.delete((T)lst, forceCollectionName, (AsyncOperationCallback<T>)null);
    }

    public <T> void delete(List<T> lst, String forceCollectionName, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (Object o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        for (Object o : bufferedDel) {
            this.config.getBufferedWriter().remove(o, forceCollectionName, callback);
        }
        for (Object o : directDel) {
            this.config.getWriter().remove(o, forceCollectionName, callback);
        }
    }

    public <T> void delete(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        this.config.getBufferedWriter().remove(bufferedDel, callback);
        this.config.getWriter().remove(directDel, callback);
    }

    public void inc(StatisticKeys k) {
        this.stats.get((Object)k).inc();
    }

    public void updateUsingFields(Object ent, String ... fields) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fields);
    }

    public void updateUsingFields(Object ent, Enum ... fieldNames) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fieldNames);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, Enum ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, String ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, Enum ... fields) {
        ArrayList<String> g = new ArrayList<String>();
        for (Enum e : fields) {
            g.add(e.name());
        }
        this.updateUsingFields(ent, collection, callback, g.toArray(new String[0]));
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = this.getARHelper().getMongoFieldName(ent.getClass(), fields[idx]);
        }
        this.getWriterForClass(ent.getClass()).updateUsingFields(ent, collection, null, fields);
    }

    public MorphiumObjectMapper getMapper() {
        return this.objectMapper;
    }

    public AnnotationAndReflectionHelper getARHelper() {
        if (this.annotationHelper == null) {
            return new AnnotationAndReflectionHelper(true);
        }
        return this.annotationHelper;
    }

    public <T> T reread(T o) {
        return this.reread(o, this.objectMapper.getCollectionName(o.getClass()));
    }

    public <T> T reread(T o, String collection) {
        if (o == null) {
            return null;
        }
        Object id = this.getId(o);
        if (id == null) {
            return null;
        }
        HashMap<String, Object> srch = new HashMap<String, Object>();
        srch.put("_id", id);
        try {
            HashMap<String, Object> findMetaData = new HashMap<String, Object>();
            List<Map<String, Object>> found = this.morphiumDriver.find(this.config.getDatabase(), collection, srch, null, null, 0, 1, 1, null, null, findMetaData);
            if (found != null && !found.isEmpty()) {
                Map<String, Object> dbo = found.get(0);
                Object fromDb = this.objectMapper.deserialize(o.getClass(), dbo);
                if (fromDb == null) {
                    throw new RuntimeException("could not reread from db");
                }
                List<String> flds = this.annotationHelper.getFields(o.getClass(), new Class[0]);
                for (String f : flds) {
                    Field fld = this.annotationHelper.getField(o.getClass(), f);
                    if (Modifier.isStatic(fld.getModifiers())) continue;
                    try {
                        fld.set(o, fld.get(fromDb));
                    }
                    catch (IllegalAccessException e) {
                        logger.error("Could not set Value: " + fld);
                    }
                }
            } else {
                return null;
            }
            this.firePostLoadEvent(o);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public void firePreStore(Object o, boolean isNew) {
        if (o == null) {
            return;
        }
        for (MorphiumStorageListener l : this.listeners) {
            l.preStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PreStore.class, o);
    }

    public void firePostStore(Object o, boolean isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PostStore.class, o);
    }

    public void firePreDrop(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preDrop(this, cls);
        }
    }

    public <T> void firePostStore(Map<T, Boolean> isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postStore(this, isNew);
        }
        for (MorphiumStorageListener o : isNew.keySet()) {
            this.annotationHelper.callLifecycleMethod(PreStore.class, o);
        }
    }

    public <T> void firePostRemove(List<T> toRemove) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, toRemove);
        }
        for (MorphiumStorageListener o : toRemove) {
            this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
        }
    }

    public <T> void firePostLoad(List<T> loaded) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postLoad(this, loaded);
        }
        for (MorphiumStorageListener o : loaded) {
            this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
        }
    }

    public void firePreStore(Map<Object, Boolean> isNew) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preStore(this, isNew);
        }
        for (Object o : isNew.keySet()) {
            this.annotationHelper.callLifecycleMethod(PreStore.class, o);
        }
    }

    public <T> void firePreRemove(List<T> lst) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(this, lst);
        }
        for (MorphiumStorageListener o : lst) {
            this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
        }
    }

    public void firePreRemove(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
    }

    public void firePostDropEvent(Class cls) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postDrop(this, cls);
        }
    }

    public void firePostUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postUpdate(this, cls, t);
        }
    }

    public void firePreUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preUpdate(this, cls, t);
        }
    }

    public void firePostRemoveEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
    }

    public void firePostRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postRemove(this, q);
        }
    }

    public void firePreRemoveEvent(Query q) {
        for (MorphiumStorageListener l : this.listeners) {
            l.preRemove(this, q);
        }
    }

    public <T> T deReference(T obj) {
        if (obj instanceof LazyDeReferencingProxy) {
            obj = ((LazyDeReferencingProxy)obj).__getDeref();
        }
        List<Field> flds = this.getARHelper().getAllFields(obj.getClass());
        for (Field fld : flds) {
            fld.setAccessible(true);
            Reference r = fld.getAnnotation(Reference.class);
            if (r == null || !r.lazyLoading()) continue;
            try {
                LazyDeReferencingProxy v = (LazyDeReferencingProxy)fld.get(obj);
                Object value = v.__getDeref();
                fld.set(obj, value);
            }
            catch (IllegalAccessException e) {
                logger.error("dereferencing of field " + fld.getName() + " failed", (Throwable)e);
            }
        }
        return obj;
    }

    public void setNameProviderForClass(Class<?> cls, NameProvider pro) {
        this.getMapper().setNameProviderForClass(cls, pro);
    }

    public NameProvider getNameProviderForClass(Class<?> cls) {
        return this.getMapper().getNameProviderForClass(cls);
    }

    public void firePostLoadEvent(Object o) {
        for (MorphiumStorageListener l : this.listeners) {
            l.postLoad(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
    }

    private ReplicaSetStatus getReplicaSetStatus() {
        return this.rsMonitor.getReplicaSetStatus(false);
    }

    public ReplicaSetStatus getCurrentRSState() {
        if (this.rsMonitor == null) {
            return null;
        }
        return this.rsMonitor.getCurrentStatus();
    }

    public boolean isReplicaSet() {
        return this.config.isReplicaset();
    }

    public ReadPreference getReadPreferenceForClass(Class<?> cls) {
        if (cls == null) {
            return this.config.getDefaultReadPreference();
        }
        DefaultReadPreference rp = this.annotationHelper.getAnnotationFromHierarchy(cls, DefaultReadPreference.class);
        if (rp == null) {
            return this.config.getDefaultReadPreference();
        }
        return rp.value().getPref();
    }

    public MorphiumBulkContext createBulkRequestContext(Class<?> type, boolean ordered) {
        return new MorphiumBulkContext(this.getDriver().createBulkContext(this, this.config.getDatabase(), this.getMapper().getCollectionName(type), ordered, this.getWriteConcernForClass(type)));
    }

    public MorphiumBulkContext createBulkRequestContext(String collection, boolean ordered) {
        return new MorphiumBulkContext(this.getDriver().createBulkContext(this, this.config.getDatabase(), collection, ordered, null));
    }

    public WriteConcern getWriteConcernForClass(Class<?> cls) {
        WriteSafety safety = this.annotationHelper.getAnnotationFromHierarchy(cls, WriteSafety.class);
        if (safety == null) {
            return null;
        }
        boolean fsync = safety.waitForSync();
        boolean j = safety.waitForJournalCommit();
        if (j && fsync) {
            fsync = false;
        }
        int w = safety.level().getValue();
        if (!this.isReplicaSet() && w > 1) {
            w = 1;
        }
        long timeout = safety.timeout();
        if (this.isReplicaSet() && w > 2) {
            ReplicaSetStatus s = this.rsMonitor.getCurrentStatus();
            if (this.getConfig().isReplicaset() && s == null || s.getActiveNodes() == 0) {
                logger.warn("ReplicaSet status is null or no node active! Assuming default write concern");
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Active nodes now: " + s.getActiveNodes());
            }
            int activeNodes = s.getActiveNodes();
            long masterOpTime = 0L;
            long maxReplLag = 0L;
            for (ReplicaSetNode node : s.getMembers()) {
                if (node.getState() != 1) continue;
                masterOpTime = node.getOptimeDate().getTime();
            }
            for (ReplicaSetNode node : s.getMembers()) {
                long tm;
                if (node.getState() != 2 || maxReplLag >= (tm = node.getOptimeDate().getTime() - masterOpTime)) continue;
                maxReplLag = tm;
            }
            if (timeout < 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting timeout to replication lag*3");
                }
                if (maxReplLag < 0L) {
                    maxReplLag = -maxReplLag;
                }
                if (maxReplLag == 0L) {
                    maxReplLag = 1L;
                }
                timeout = maxReplLag * 3000L;
                if (maxReplLag > 10L) {
                    logger.warn("Warning: replication lag too high! timeout set to " + timeout + "ms - replication Lag is " + maxReplLag + "s - write should take place in Background!");
                }
            }
            w = activeNodes;
            if (timeout > 0L && timeout < maxReplLag * 1000L) {
                logger.warn("Timeout is set smaller than replication lag - increasing to replication_lag time * 3");
                timeout = maxReplLag * 3000L;
            }
        }
        if (!this.isReplicaSet() && timeout < 0L) {
            timeout = 0L;
        }
        return WriteConcern.getWc(w, fsync, j, (int)timeout);
    }

    public void addProfilingListener(ProfilingListener l) {
        this.profilingListeners.add(l);
    }

    public void removeProfilingListener(ProfilingListener l) {
        this.profilingListeners.remove(l);
    }

    public void fireProfilingWriteEvent(Class type, Object data, long time, boolean isNew, WriteAccessType wt) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.writeAccess(type, data, time, isNew, wt);
            }
            catch (Throwable e) {
                logger.error("Error during profiling: ", e);
            }
        }
    }

    public void fireProfilingReadEvent(Query q, long time, ReadAccessType t) {
        for (ProfilingListener l : this.profilingListeners) {
            try {
                l.readAccess(q, time, t);
            }
            catch (Throwable e) {
                logger.error("Error during profiling", e);
            }
        }
    }

    public void clearCollection(Class<?> cls) {
        this.delete(this.createQueryFor(cls));
    }

    public void clearCollection(Class<?> cls, String colName) {
        Query<?> q = this.createQueryFor(cls);
        q.setCollectionName(colName);
        this.delete(q);
    }

    public void clearCollectionOneByOne(Class<?> cls) {
        this.inc(StatisticKeys.WRITES);
        List<?> lst = this.readAll(cls);
        lst.forEach(this::delete);
        this.getCache().clearCacheIfNecessary(cls);
    }

    public <T> List<T> readAll(Class<? extends T> cls) {
        this.inc(StatisticKeys.READS);
        Query<T> qu = this.createQueryFor(cls);
        return qu.asList();
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type, String usingCollectionName) {
        return this.createQueryFor(type).setCollectionName(usingCollectionName);
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type) {
        Query<T> q = this.config.getQueryFact().createQuery(this, type);
        q.setAutoValuesEnabled(this.isAutoValuesEnabledForThread());
        return q;
    }

    public <T> List<T> find(Query<T> q) {
        return q.asList();
    }

    public List<Object> distinct(Enum key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Query q) {
        try {
            return this.morphiumDriver.distinct(this.config.getDatabase(), q.getCollectionName(), key, q.toQueryObject(), q.getCollation(), this.getReadPreferenceForClass(q.getType()));
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> distinct(String key, Class cls) {
        return this.distinct(key, cls, null);
    }

    public List<Object> distinct(String key, Class cls, Collation collation) {
        try {
            return this.morphiumDriver.distinct(this.config.getDatabase(), this.objectMapper.getCollectionName(cls), this.getARHelper().getMongoFieldName(cls, key), new HashMap<String, Object>(), collation, this.getReadPreferenceForClass(cls));
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> distinct(String key, String collectionName) {
        return this.distinct(key, collectionName, null);
    }

    public List<Object> distinct(String key, String collectionName, Collation collation) {
        try {
            return this.morphiumDriver.distinct(this.config.getDatabase(), collectionName, key, new HashMap<String, Object>(), collation, this.config.getDefaultReadPreference());
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T findById(Class<? extends T> type, Object id) {
        return this.findById(type, id, null);
    }

    public <T> void findById(Class<? extends T> type, Object id, String collection, AsyncOperationCallback callback) {
        this.createQueryFor(type).setCollectionName(collection).f(this.getARHelper().getIdFieldName(type)).eq(id).get(callback);
    }

    public <T> T findById(Class<? extends T> type, Object id, String collection) {
        boolean useCache;
        this.inc(StatisticKeys.READS);
        Cache c = this.getARHelper().getAnnotationFromHierarchy(type, Cache.class);
        boolean bl = useCache = c != null && c.readCache() && this.isReadCacheEnabledForThread();
        if (useCache) {
            if (this.getCache().getFromIDCache(type, id) != null) {
                this.inc(StatisticKeys.CHITS);
                return this.getCache().getFromIDCache(type, id);
            }
            this.inc(StatisticKeys.CMISS);
        } else {
            this.inc(StatisticKeys.NO_CACHED_READS);
        }
        List<String> ls = this.annotationHelper.getFields(type, Id.class);
        if (ls.isEmpty()) {
            throw new RuntimeException("Cannot find by ID on non-Entity");
        }
        return this.createQueryFor(type).setCollectionName(collection).f(ls.get(0)).eq(id).get();
    }

    public <T> List<T> findByField(Class<? extends T> cls, String fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public <T> List<T> findByField(Class<? extends T> cls, Enum fld, Object val) {
        return this.findByField(cls, fld.name(), val);
    }

    public <T> boolean setAutoValues(T o) throws IllegalAccessException {
        boolean aNew;
        Class<?> type = o.getClass();
        Object id = this.getARHelper().getId(o);
        boolean bl = aNew = id == null;
        if (!this.isAutoValuesEnabledForThread()) {
            return aNew;
        }
        Object reread = null;
        CreationTime ct = this.getARHelper().getAnnotationFromHierarchy(o.getClass(), CreationTime.class);
        if (ct != null && this.config.isCheckForNew() && ct.checkForNew() && !aNew) {
            reread = this.findById(this.getARHelper().getRealClass(o.getClass()), this.getARHelper().getId(o));
            boolean bl2 = aNew = reread == null;
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(type, CreationTime.class) && aNew) {
            boolean checkForNew = Objects.requireNonNull(ct).checkForNew() || this.getConfig().isCheckForNew();
            List<String> lst = this.getARHelper().getFields(type, CreationTime.class);
            for (String fld : lst) {
                Field field = this.getARHelper().getField(o.getClass(), fld);
                if (id != null) {
                    Object value;
                    if (checkForNew && reread == null) {
                        reread = this.findById(o.getClass(), id);
                        boolean bl3 = aNew = reread == null;
                        if (reread == null) continue;
                        value = field.get(reread);
                        field.set(o, value);
                        aNew = false;
                        continue;
                    }
                    if (reread == null) {
                        aNew = id instanceof MorphiumId;
                        continue;
                    }
                    value = field.get(reread);
                    field.set(o, value);
                    aNew = false;
                    continue;
                }
                aNew = true;
            }
            if (aNew) {
                if (lst.isEmpty()) {
                    logger.error("Unable to store creation time as @CreationTime for field is missing");
                } else {
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Object val = null;
                        Field f = this.getARHelper().getField(type, ctf);
                        if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                            val = now;
                        } else if (f.getType().equals(Date.class)) {
                            val = new Date(now);
                        } else if (f.getType().equals(String.class)) {
                            CreationTime ctField = f.getAnnotation(CreationTime.class);
                            SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                            val = df.format(now);
                        }
                        try {
                            f.set(o, val);
                        }
                        catch (IllegalAccessException e) {
                            logger.error("Could not set creation time", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(type, LastChange.class)) {
            List<String> lst = this.getARHelper().getFields(type, LastChange.class);
            if (lst != null && !lst.isEmpty()) {
                long now = System.currentTimeMillis();
                for (String ctf : lst) {
                    Object val = null;
                    Field f = this.getARHelper().getField(type, ctf);
                    if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                        val = now;
                    } else if (f.getType().equals(Date.class)) {
                        val = new Date(now);
                    } else if (f.getType().equals(String.class)) {
                        LastChange ctField = f.getAnnotation(LastChange.class);
                        SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                        val = df.format(now);
                    }
                    try {
                        f.set(o, val);
                    }
                    catch (IllegalAccessException e) {
                        logger.error("Could not set modification time", (Throwable)e);
                    }
                }
            } else {
                logger.warn("Could not store last change - @LastChange missing!");
            }
        }
        return aNew;
    }

    public void clearCachefor(Class<?> cls) {
        this.getCache().clearCachefor(cls);
    }

    public void clearCacheforClassIfNecessary(Class<?> cls) {
        this.getCache().clearCacheIfNecessary(cls);
    }

    public <T> void storeNoCache(T lst) {
        this.storeNoCache(lst, this.getMapper().getCollectionName(lst.getClass()), null);
    }

    public <T> void storeNoCache(T o, AsyncOperationCallback<T> callback) {
        this.storeNoCache(o, this.getMapper().getCollectionName(o.getClass()), callback);
    }

    public <T> void storeNoCache(T o, String collection) {
        this.storeNoCache(o, collection, null);
    }

    public <T> void storeNoCache(T o, String collection, AsyncOperationCallback<T> callback) {
        this.config.getWriter().store(o, collection, callback);
    }

    public <T> void storeBuffered(T lst) {
        this.storeBuffered(lst, null);
    }

    public <T> void storeBuffered(T lst, AsyncOperationCallback<T> callback) {
        this.storeBuffered(lst, this.getMapper().getCollectionName(lst.getClass()), callback);
    }

    public <T> void storeBuffered(T lst, String collection, AsyncOperationCallback<T> callback) {
        this.config.getBufferedWriter().store(lst, collection, callback);
    }

    public void flush() {
        this.config.getBufferedWriter().flush();
        this.config.getWriter().flush();
    }

    public void flush(Class type) {
        this.config.getBufferedWriter().flush(type);
        this.config.getWriter().flush(type);
    }

    public Object getId(Object o) {
        return this.annotationHelper.getId(o);
    }

    public <T> void dropCollection(Class<T> cls, AsyncOperationCallback<T> callback) {
        this.dropCollection(cls, this.getMapper().getCollectionName(cls), callback);
    }

    public <T> void dropCollection(Class<T> cls, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).dropCollection(cls, collection, callback);
    }

    public void dropCollection(Class<?> cls) {
        this.getWriterForClass(cls).dropCollection(cls, this.getMapper().getCollectionName(cls), null);
    }

    public <T> void ensureIndex(Class<T> cls, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), index, callback);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, Map<String, Object> options, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, options, callback);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, null, callback);
    }

    public int writeBufferCount() {
        return this.config.getWriter().writeBufferCount() + this.config.getBufferedWriter().writeBufferCount();
    }

    public <T> void store(List<T> lst, String collectionName, AsyncOperationCallback<T> callback) {
        if (lst == null || lst.isEmpty()) {
            return;
        }
        this.getWriterForClass(lst.get(0).getClass()).store(lst, collectionName, callback);
    }

    public void ensureIndex(Class<?> cls, Map<String, Object> index) {
        this.getWriterForClass(cls).ensureIndex(cls, this.getMapper().getCollectionName(cls), index, null, null);
    }

    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index, Map<String, Object> options) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, options, null);
    }

    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index) {
        this.getWriterForClass(cls).ensureIndex(cls, collection, index, null, null);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum e : fldStr) {
            String f = e.name();
            m.put(f, 1);
        }
        this.getWriterForClass(cls).ensureIndex(cls, collection, m, null, callback);
    }

    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, String ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, String ... fldStr) {
        List<Map<String, Object>> m = this.createIndexMapFrom(fldStr);
        for (Map<String, Object> idx : m) {
            this.getWriterForClass(cls).ensureIndex(cls, collection, idx, null, callback);
        }
    }

    public List<Map<String, Object>> createIndexMapFrom(String[] fldStr) {
        if (fldStr.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        for (String f : fldStr) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (String idx : f.split(",")) {
                if (idx.contains(":")) {
                    String[] i = idx.split(":");
                    String value = i[1].replaceAll(" ", "");
                    String key = i[0].replaceAll(" ", "");
                    if (value.matches("^['\"].*['\"]$") || value.equals("2d")) {
                        m.put(key, value);
                        continue;
                    }
                    try {
                        int v = Integer.parseInt(value);
                        m.put(key, v);
                    }
                    catch (NumberFormatException e) {
                        try {
                            long l = Long.parseLong(value);
                            m.put(key, l);
                        }
                        catch (NumberFormatException ex) {
                            try {
                                double d = Double.parseDouble(value);
                                m.put(key, d);
                            }
                            catch (NumberFormatException e1) {
                                m.put(key, value);
                            }
                        }
                    }
                    continue;
                }
                if ((idx = idx.replaceAll(" ", "")).startsWith("-")) {
                    m.put(idx.substring(1), -1);
                    continue;
                }
                idx = idx.replaceAll("^\\+", "").replaceAll(" ", "");
                m.put(idx, 1);
            }
            lst.add(m);
        }
        return lst;
    }

    public String getDatabase() {
        return this.getConfig().getDatabase();
    }

    public void ensureIndex(Class<?> cls, String ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public void ensureIndex(Class<?> cls, Enum ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public <T> void insert(T o) {
        if (o instanceof List) {
            this.insertList((List)o, null);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), null);
        } else {
            this.insert(o, null);
        }
    }

    public <T> void insert(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), callback);
        } else {
            this.insert(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    private <T> void insert(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), collection, callback);
        }
        this.getWriterForClass(o.getClass()).insert(o, collection, callback);
    }

    private <T> void insertList(List lst, String collection, AsyncOperationCallback<T> callback) {
        HashMap writers = new HashMap();
        HashMap values = new HashMap();
        for (Object o : lst) {
            writers.putIfAbsent(o.getClass(), this.getWriterForClass(o.getClass()));
            values.putIfAbsent(o.getClass(), new ArrayList());
            ((List)values.get(o.getClass())).add(o);
        }
        for (Class cls : writers.keySet()) {
            try {
                ((MorphiumWriter)writers.get(cls)).insert((List)values.get(cls), collection, callback);
            }
            catch (Exception e) {
                logger.error("Write failed for " + cls.getName() + " lst of size " + ((List)values.get(cls)).size(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void insertList(List arrayList, AsyncOperationCallback<T> callback) {
        this.insertList(arrayList, null, callback);
    }

    private <T> void insertList(List arrayList) {
        this.insertList(arrayList, null, null);
    }

    public Map<String, Integer> storeMaps(Class type, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.saveMaps(type, lst);
    }

    public Map<String, Integer> saveMaps(Class type, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.getDriver().store(this.getDatabase(), this.getMapper().getCollectionName(type), lst, null);
    }

    public Map<String, Integer> storeMaps(String collection, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.saveMaps(collection, lst);
    }

    public Map<String, Integer> saveMaps(String collection, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.getDriver().store(this.getDatabase(), collection, lst, null);
    }

    public Map<String, Integer> storeMap(String collection, Map<String, Object> m) throws MorphiumDriverException {
        return this.saveMap(collection, m);
    }

    public Map<String, Integer> saveMap(String collection, Map<String, Object> m) throws MorphiumDriverException {
        return this.getDriver().store(this.getDatabase(), collection, Arrays.asList(m), null);
    }

    public Map<String, Integer> storeMap(Class type, Map<String, Object> m) throws MorphiumDriverException {
        return this.getDriver().store(this.getDatabase(), this.getMapper().getCollectionName(type), Arrays.asList(m), this.getWriteConcernForClass(type));
    }

    public <T> void store(T o) {
        this.save(o);
    }

    public <T> void save(T o) {
        if (o instanceof List) {
            this.storeList((List)o);
        } else if (o instanceof Collection) {
            this.storeList(new ArrayList((Collection)o));
        } else {
            this.store(o, null);
        }
    }

    public <T> void store(T o, AsyncOperationCallback<T> callback) {
        this.save(o, callback);
    }

    public <T> void save(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.storeList((List)o, callback);
        } else if (o instanceof Collection) {
            this.storeList(new ArrayList((Collection)o), callback);
        } else {
            this.store(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    public <T> void store(T o, String collection, AsyncOperationCallback<T> callback) {
        this.save(o, collection, callback);
    }

    public <T> void save(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.storeList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.storeList(new ArrayList((Collection)o), collection, callback);
        }
        if (this.getARHelper().getId(o) != null) {
            this.getWriterForClass(o.getClass()).store(o, collection, callback);
        } else {
            this.getWriterForClass(o.getClass()).insert(o, collection, callback);
        }
    }

    public <T> void save(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.save(lst, callback);
    }

    public <T> void storeList(List<T> lst, String collection) {
        this.storeList(lst, collection, null);
    }

    public <T> void saveList(List<T> lst, String collection) {
        this.saveList(lst, collection, null);
    }

    public <T> void storeList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
        this.saveList(lst, collection, callback);
    }

    public <T> void saveList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
        HashMap writers = new HashMap();
        HashMap values = new HashMap();
        for (T o : lst) {
            writers.putIfAbsent(o.getClass(), this.getWriterForClass(o.getClass()));
            values.putIfAbsent(o.getClass(), new ArrayList());
            ((List)values.get(o.getClass())).add(o);
        }
        for (Class cls : writers.keySet()) {
            try {
                ((MorphiumWriter)writers.get(cls)).store((List)values.get(cls), collection, callback);
            }
            catch (Exception e) {
                logger.error("Async Write failed for " + cls.getName() + " lst of size " + ((List)values.get(cls)).size(), (Throwable)e);
                callback.onOperationError(AsyncOperationType.WRITE, null, 0L, e.getMessage(), e, null, cls);
            }
        }
    }

    public <T> void storeList(List<T> lst) {
        this.saveList(lst);
    }

    public <T> void saveList(List<T> lst) {
        this.storeList(lst, (AsyncOperationCallback)null);
    }

    public <T> void storeList(Set<T> set) {
        this.saveList(set);
    }

    public <T> void saveList(Set<T> set) {
        this.storeList(new ArrayList<T>(set), (AsyncOperationCallback)null);
    }

    public <T> void storeList(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void saveList(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> storeDirect = new ArrayList<T>();
        ArrayList<T> insertDirect = new ArrayList<T>();
        if (this.isWriteBufferEnabledForThread()) {
            ArrayList<T> storeInBg = new ArrayList<T>();
            ArrayList<T> insertInBg = new ArrayList<T>();
            for (T o : lst) {
                if (this.annotationHelper.isBufferedWrite(this.getARHelper().getRealClass(o.getClass()))) {
                    if (this.getARHelper().getId(o) == null) {
                        insertInBg.add(o);
                        continue;
                    }
                    storeInBg.add(o);
                    continue;
                }
                if (this.getARHelper().getId(o) == null) {
                    insertDirect.add(o);
                    continue;
                }
                storeDirect.add(o);
            }
            this.config.getBufferedWriter().store(storeInBg, callback);
            this.config.getWriter().store(storeDirect, callback);
            this.config.getBufferedWriter().insert(insertInBg, callback);
            this.config.getWriter().insert(insertDirect, callback);
        } else {
            for (T o : lst) {
                if (this.getARHelper().getId(o) == null) {
                    insertDirect.add(o);
                    continue;
                }
                storeDirect.add(o);
            }
            this.config.getWriter().store(storeDirect, callback);
            this.config.getWriter().insert(insertDirect, callback);
        }
    }

    public <T> void delete(Query<T> o) {
        this.getWriterForClass(o.getType()).remove(o, null);
    }

    public <T> void delete(Query<T> o, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(o.getType()).remove(o, callback);
    }

    public <T> void pushPull(boolean push, Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPull(push, query, field, value, upsert, multiple, callback);
    }

    public <T> void pushPullAll(boolean push, Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(push, query, field, value, upsert, multiple, callback);
    }

    public <T> void pullAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(query.getType()).pushPullAll(false, query, field, value, upsert, multiple, callback);
    }

    public void delete(Object o) {
        this.delete(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void delete(Object o, String collection) {
        this.getWriterForClass(o.getClass()).remove(o, collection, null);
    }

    public <T> void delete(T lo, AsyncOperationCallback<T> callback) {
        if (lo instanceof Query) {
            this.delete((T)((Query)lo), callback);
            return;
        }
        this.getWriterForClass(lo.getClass()).remove(lo, this.getMapper().getCollectionName(lo.getClass()), callback);
    }

    public <T> void delete(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(lo.getClass()).remove(lo, collection, callback);
    }

    public boolean exists(String db) throws MorphiumDriverException {
        return this.getDriver().exists(db);
    }

    public boolean exists(String db, String col) throws MorphiumDriverException {
        return this.getDriver().exists(db, col);
    }

    public Map<String, Double> getStatistics() {
        return new Statistics(this);
    }

    public void resetStatistics() {
        HashMap<StatisticKeys, StatisticValue> s = new HashMap<StatisticKeys, StatisticValue>();
        for (StatisticKeys k : StatisticKeys.values()) {
            s.put(k, new StatisticValue());
        }
        this.stats = s;
    }

    public Map<StatisticKeys, StatisticValue> getStats() {
        return this.stats;
    }

    public List<ShutdownListener> getShutDownListeners() {
        return this.shutDownListeners;
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutDownListeners.add(l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutDownListeners.remove(l);
    }

    @Override
    public void close() {
        if (this.asyncOperationsThreadPool != null) {
            this.asyncOperationsThreadPool.shutdownNow();
        }
        this.asyncOperationsThreadPool = null;
        for (ShutdownListener l : this.shutDownListeners) {
            l.onShutdown(this);
        }
        if (this.rsMonitor != null) {
            this.rsMonitor.terminate();
            this.rsMonitor = null;
        }
        if (this.config != null) {
            this.config.getAsyncWriter().close();
            this.config.getBufferedWriter().close();
            this.config.getWriter().close();
        }
        if (this.morphiumDriver != null) {
            try {
                this.morphiumDriver.close();
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
            this.morphiumDriver = null;
        }
        if (this.config != null) {
            this.config.getCache().resetCache();
            this.config.getCache().close();
            this.config.setBufferedWriter(null);
            this.config.setAsyncWriter(null);
            this.config.setWriter(null);
            this.config = null;
        }
    }

    public String createCamelCase(String n) {
        return this.annotationHelper.createCamelCase(n, false);
    }

    public <T> List<T> mapReduce(Class<? extends T> type, String map, String reduce) throws MorphiumDriverException {
        List<Map<String, Object>> result = this.getDriver().mapReduce(this.getConfig().getDatabase(), this.getMapper().getCollectionName(type), map, reduce);
        ArrayList<T> ret = new ArrayList<T>();
        for (Map<String, Object> o : result) {
            ret.add(this.getMapper().deserialize(type, o));
        }
        return ret;
    }

    public <T, R> Aggregator<T, R> createAggregator(Class<? extends T> type, Class<? extends R> resultType) {
        Aggregator<T, R> aggregator = this.config.getAggregatorFactory().createAggregator(type, resultType);
        aggregator.setMorphium(this);
        return aggregator;
    }

    public <T> T createLazyLoadedEntity(Class<? extends T> cls, Object id, String collectionName) {
        return (T)Enhancer.create(cls, (Class[])new Class[]{Serializable.class}, new LazyDeReferencingProxy<T>(this, cls, id, collectionName));
    }

    public <T> MongoField<T> createMongoField() {
        if (this.config == null) {
            return new MongoFieldImpl();
        }
        try {
            return this.config.getFieldImplClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public int getWriteBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount() + this.config.getWriter().writeBufferCount() + this.config.getAsyncWriter().writeBufferCount();
    }

    public int getBufferedWriterBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount();
    }

    public int getAsyncWriterBufferCount() {
        return this.config.getAsyncWriter().writeBufferCount();
    }

    public int getWriterBufferCount() {
        return this.config.getWriter().writeBufferCount();
    }

    public void disableAutoValuesForThread() {
        this.enableAutoValues.set(false);
    }

    public void enableAutoValuesForThread() {
        this.enableAutoValues.set(true);
    }

    public boolean isAutoValuesEnabledForThread() {
        return (this.enableAutoValues.get() == null || this.enableAutoValues.get() != false) && this.config.isAutoValuesEnabled();
    }

    public void disableReadCacheForThread() {
        this.enableReadCache.set(false);
    }

    public void enableReadCacheForThread() {
        this.enableReadCache.set(true);
    }

    public boolean isReadCacheEnabledForThread() {
        return (this.enableReadCache.get() == null || this.enableReadCache.get() != false) && this.config.isReadCacheEnabled();
    }

    public void disableWriteBufferForThread() {
        this.disableWriteBuffer.set(false);
    }

    public void enableWriteBufferForThread() {
        this.disableWriteBuffer.set(true);
    }

    public boolean isWriteBufferEnabledForThread() {
        return (this.disableWriteBuffer.get() == null || this.disableWriteBuffer.get() != false) && this.config.isBufferedWritesEnabled();
    }

    public void disableAsyncWritesForThread() {
        this.disableAsyncWrites.set(false);
    }

    public void enableAsyncWritesForThread() {
        this.disableAsyncWrites.set(true);
    }

    public boolean isAsyncWritesEnabledForThread() {
        return (this.disableAsyncWrites.get() == null || this.disableAsyncWrites.get() != false) && this.config.isAsyncWritesEnabled();
    }

    public void queueTask(Runnable runnable) {
        boolean queued = false;
        do {
            try {
                this.asyncOperationsThreadPool.execute(runnable);
                queued = true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!queued);
    }

    public int getNumberOfAvailableThreads() {
        return this.asyncOperationsThreadPool.getMaximumPoolSize() - this.asyncOperationsThreadPool.getActiveCount();
    }

    public int getActiveThreads() {
        return this.asyncOperationsThreadPool.getActiveCount();
    }

    public void startTransaction() {
        this.getDriver().startTransaction();
    }

    public MorphiumTransactionContext getTransaction() {
        return this.getDriver().getTransactionContext();
    }

    public void setTransaction(MorphiumTransactionContext ctx) {
        this.getDriver().setTransactionContext(ctx);
    }

    public void commitTransaction() {
        this.getDriver().commitTransaction();
    }

    public void abortTransaction() {
        this.getDriver().abortTransaction();
    }

    public <T> void watchAsync(String collectionName, boolean updateFull, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(collectionName, updateFull, null, lst));
    }

    public <T> void watchAsync(String collectionName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(collectionName, updateFull, pipeline, lst));
    }

    public <T> void watchAsync(Class<T> entity, boolean updateFull, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(entity, updateFull, null, lst));
    }

    public <T> void watchAsync(Class<T> entity, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(entity, updateFull, pipeline, lst));
    }

    public <T> void watch(Class<T> entity, boolean updateFull, ChangeStreamListener lst) {
        this.watch(this.getMapper().getCollectionName(entity), updateFull, null, lst);
    }

    public <T> void watch(Class<T> entity, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watch(this.getMapper().getCollectionName(entity), updateFull, pipeline, lst);
    }

    public <T> void watch(String collectionName, boolean updateFull, ChangeStreamListener lst) {
        this.watch(collectionName, this.config.getMaxWaitTime(), updateFull, null, lst);
    }

    public <T> void watch(String collectionName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watch(collectionName, this.config.getMaxWaitTime(), updateFull, pipeline, lst);
    }

    public <T> void watch(String collectionName, int maxWaitTime, boolean updateFull, List<Map<String, Object>> pipeline, final ChangeStreamListener lst) {
        try {
            this.getDriver().watch(this.config.getDatabase(), collectionName, maxWaitTime, updateFull, pipeline, new DriverTailableIterationCallback(){
                boolean b = true;

                @Override
                public void incomingData(Map<String, Object> data, long dur) {
                    this.b = Morphium.this.processEvent(lst, data);
                }

                @Override
                public boolean isContinued() {
                    return this.b;
                }
            });
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean processEvent(ChangeStreamListener lst, Map<String, Object> doc) {
        ObjectMapperImpl mapper = new ObjectMapperImpl();
        AnnotationAndReflectionHelper hlp = new AnnotationAndReflectionHelper(false);
        mapper.setAnnotationHelper(hlp);
        Map obj = (Map)doc.get("fullDocument");
        doc.remove("fullDocument");
        ChangeStreamEvent evt = mapper.deserialize(ChangeStreamEvent.class, doc);
        evt.setFullDocument(obj);
        return lst.incomingData(evt);
    }

    public <T> void watchDbAsync(String dbName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> {
            this.watchDb(dbName, updateFull, lst);
            logger.debug("watch async finished");
        });
    }

    public <T> void watchDbAsync(boolean updateFull, ChangeStreamListener lst) {
        this.watchDbAsync(this.config.getDatabase(), updateFull, null, lst);
    }

    public <T> void watchDbAsync(boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watchDbAsync(this.config.getDatabase(), updateFull, pipeline, lst);
    }

    public <T> void watchDb(boolean updateFull, ChangeStreamListener lst) {
        this.watchDb(this.getConfig().getDatabase(), updateFull, lst);
    }

    public <T> void watchDb(String dbName, boolean updateFull, ChangeStreamListener lst) {
        this.watchDb(dbName, this.getConfig().getMaxWaitTime(), updateFull, null, lst);
    }

    public <T> void watchDb(String dbName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watchDb(dbName, this.getConfig().getMaxWaitTime(), updateFull, pipeline, lst);
    }

    public <T> void watchDb(String dbName, int maxWaitTime, boolean updateFull, List<Map<String, Object>> pipeline, final ChangeStreamListener lst) {
        try {
            this.getDriver().watch(dbName, maxWaitTime, updateFull, pipeline, new DriverTailableIterationCallback(){
                private boolean b = true;

                @Override
                public void incomingData(Map<String, Object> data, long dur) {
                    this.b = Morphium.this.processEvent(lst, data);
                }

                @Override
                public boolean isContinued() {
                    return this.b;
                }
            });
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        MorphiumConfig cfg = this.getConfig();
        if (this.lst != null) {
            this.listeners.remove(this.lst);
        }
        this.close();
        this.setConfig(cfg);
        this.initializeAndConnect();
    }

    public List<Map<String, Object>> getMissingIndicesFor(Class<?> entity) throws MorphiumDriverException {
        return this.getMissingIndicesFor(entity, this.objectMapper.getCollectionName(entity));
    }

    public List<Map<String, Object>> getMissingIndicesFor(Class<?> entity, String collection) throws MorphiumDriverException {
        List<String> flds;
        ArrayList<Map<String, Object>> missingIndexDef = new ArrayList<Map<String, Object>>();
        Index i = this.annotationHelper.getAnnotationFromClass(entity, Index.class);
        List<Map<String, Object>> ind = this.morphiumDriver.getIndexes(this.getConfig().getDatabase(), collection);
        ArrayList<Map> indices = new ArrayList<Map>();
        for (Map<String, Object> m : ind) {
            Map indexKey = (Map)m.get("key");
            indices.add(indexKey);
        }
        if (indices.size() > 0 && indices.get(0) == null) {
            logger.error("Something is wrong!");
        }
        if (i != null && i.value().length > 0) {
            List<Map<String, Object>> options = null;
            if (i.options().length > 0) {
                options = this.createIndexMapFrom(i.options());
            }
            if (!i.locale().equals("")) {
                Utils.UtilsMap<String, String> collation = Utils.getMap("locale", i.locale());
                collation.put("alternate", i.alternate().mongoText);
                collation.put("backwards", (String)((Object)Boolean.valueOf(i.backwards())));
                collation.put("caseFirst", i.caseFirst().mongoText);
                collation.put("caseLevel", (String)((Object)Boolean.valueOf(i.caseLevel())));
                collation.put("maxVariable", i.maxVariable().mongoText);
                collation.put("strength", (String)((Object)Integer.valueOf(i.strength().mongoValue)));
                options.add(Utils.getMap("collation", collation));
            }
            List<Map<String, Object>> idx = this.createIndexMapFrom(i.value());
            if (!this.morphiumDriver.exists(this.config.getDatabase(), collection) || indices.size() == 0) {
                logger.info("Collection '" + collection + "' for entity '" + entity.getName() + "' does not exist.");
                return idx;
            }
            int cnt = 0;
            for (Map<String, Object> m : idx) {
                Map<String, Object> optionsMap = null;
                if (options != null && options.size() > cnt) {
                    optionsMap = options.get(cnt);
                    if (!indices.contains(m)) {
                        if (m.values().toArray()[0].equals("text")) {
                            logger.info("Handling text index");
                            boolean found = false;
                            for (Map<String, Object> indexDef : ind) {
                                if (!indexDef.containsKey("textIndexVersion")) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                missingIndexDef.add(m);
                            }
                        } else {
                            missingIndexDef.add(m);
                        }
                    }
                }
                ++cnt;
            }
        }
        if ((flds = this.annotationHelper.getFields(entity, Index.class)) != null && !flds.isEmpty()) {
            for (String f : flds) {
                i = this.annotationHelper.getField(entity, f).getAnnotation(Index.class);
                LinkedHashMap<String, Integer> idx = new LinkedHashMap<String, Integer>();
                if (i.decrement()) {
                    idx.put(f, -1);
                } else {
                    idx.put(f, 1);
                }
                Map<String, Object> optionsMap = null;
                if (this.createIndexMapFrom(i.options()) != null) {
                    optionsMap = this.createIndexMapFrom(i.options()).get(0);
                }
                if (indices.contains(idx)) continue;
                if (idx.values().toArray()[0].equals("text")) {
                    logger.info("checking for text index...");
                    for (Map<String, Object> indexDef : ind) {
                        if (indexDef.containsKey("textIndexVersion")) continue;
                        missingIndexDef.add(idx);
                    }
                    continue;
                }
                missingIndexDef.add(idx);
            }
        }
        return missingIndexDef;
    }

    public Map<Class<?>, List<Map<String, Object>>> checkIndices() {
        return this.checkIndices(null);
    }

    public Map<Class<?>, List<Map<String, Object>>> checkIndices(ClassInfoList.ClassInfoFilter filter) {
        ConcurrentHashMap missingIndicesByClass = new ConcurrentHashMap();
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableClassInfo().scan();){
            ClassInfoList entities = scanResult.getAllClasses();
            if (filter != null) {
                entities = entities.filter(filter);
            }
            for (String cn : entities.getNames()) {
                try {
                    Class<?> entity;
                    if (cn.startsWith("sun.") || cn.startsWith("com.sun.") || cn.startsWith("org.assertj.") || this.annotationHelper.getAnnotationFromHierarchy(entity = Class.forName(cn), Entity.class) == null) continue;
                    List<Map<String, Object>> missing = this.getMissingIndicesFor(entity);
                    if (missing != null && !missing.isEmpty()) {
                        missingIndicesByClass.put(entity, missing);
                    }
                    if (!this.annotationHelper.isAnnotationPresentInHierarchy(entity, Capped.class) || this.morphiumDriver.isCapped(this.getConfig().getDatabase(), this.getMapper().getCollectionName(entity))) continue;
                    missingIndicesByClass.putIfAbsent(entity, new ArrayList());
                    Capped capped = this.annotationHelper.getAnnotationFromClass(entity, Capped.class);
                    ((List)missingIndicesByClass.get(entity)).add(Utils.getMap("__capped_entries", capped.maxEntries()).add("__capped_size", capped.maxSize()));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        return missingIndicesByClass;
    }

    public void addCommandListener(CommandListener cmd) {
        this.morphiumDriver.addCommandListener(cmd);
    }

    public void removeCommandListener(CommandListener cmd) {
        this.morphiumDriver.removeCommandListener(cmd);
    }

    public void addClusterListener(ClusterListener cl) {
        this.morphiumDriver.addClusterListener(cl);
    }

    public void removeClusterListener(ClusterListener cl) {
        this.morphiumDriver.removeClusterListener(cl);
    }

    public void addConnectionPoolListener(ConnectionPoolListener cpl) {
        this.morphiumDriver.addConnectionPoolListener(cpl);
    }

    public void removeConnectionPoolListener(ConnectionPoolListener cpl) {
        this.morphiumDriver.removeConnectionPoolListener(cpl);
    }
}

