/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.inmem;

import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.rits.cloning.Cloner;
import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.FunctionNotSupportedException;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.inmem.InMemDumpContainer;
import de.caluga.morphium.driver.inmem.InMemTransactionContext;
import de.caluga.morphium.driver.inmem.QueryHelper;
import de.caluga.morphium.driver.mongodb.Maximums;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import org.bson.types.ObjectId;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDriver
implements MorphiumDriver {
    private final Logger log = LoggerFactory.getLogger(InMemoryDriver.class);
    private final Map<String, Map<String, List<Map<String, Object>>>> database = new ConcurrentHashMap<String, Map<String, List<Map<String, Object>>>>();
    private final ThreadLocal<InMemTransactionContext> currentTransaction = new ThreadLocal();
    private final AtomicLong txn = new AtomicLong();
    private final Map<String, List<DriverTailableIterationCallback>> watchersByDb = new ConcurrentHashMap<String, List<DriverTailableIterationCallback>>();
    private ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);
    private final List<Object> monitors = new CopyOnWriteArrayList<Object>();
    private List<Runnable> eventQueue = new CopyOnWriteArrayList<Runnable>();

    public Map<String, List<Map<String, Object>>> getDatabase(String dbn) {
        return this.database.get(dbn);
    }

    public void setDatabase(String dbn, Map<String, List<Map<String, Object>>> db) {
        if (db != null) {
            this.database.put(dbn, db);
        }
    }

    public void restore(InputStream in) throws IOException, ParseException {
        GZIPInputStream gzin = new GZIPInputStream(in);
        BufferedInputStream bin = new BufferedInputStream(gzin);
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        String l = null;
        StringBuilder b = new StringBuilder();
        while ((l = br.readLine()) != null) {
            b.append(l);
        }
        br.close();
        ObjectMapperImpl mapper = new ObjectMapperImpl();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        this.log.info("Read in json: " + b);
        InMemDumpContainer cnt = mapper.deserialize(InMemDumpContainer.class, b.toString());
        this.log.info("Restoring DB " + cnt.getDb() + " dump from " + new Date(cnt.getCreated()));
        this.setDatabase(cnt.getDb(), cnt.getData());
    }

    public void restoreFromFile(File f) throws IOException, ParseException {
        this.restore(new FileInputStream(f));
    }

    public void dumpToFile(Morphium m, String db, File f) throws IOException {
        this.dump(m, db, new FileOutputStream(f));
    }

    public void dump(Morphium m, String db, OutputStream out) throws IOException {
        MorphiumObjectMapper mapper = m.getMapper();
        MorphiumTypeMapper<ObjectId> typeMapper = this.getObjectIdTypeMapper();
        mapper.registerCustomMapperFor(ObjectId.class, typeMapper);
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        InMemDumpContainer d = new InMemDumpContainer();
        d.setCreated(System.currentTimeMillis());
        d.setData(this.getDatabase(db));
        d.setDb(db);
        Map<String, Object> ser = mapper.serialize(d);
        OutputStreamWriter wr = new OutputStreamWriter(gzip);
        Utils.writeJson(ser, wr);
        wr.flush();
        gzip.finish();
        gzip.flush();
        out.flush();
        gzip.close();
    }

    private MorphiumTypeMapper<ObjectId> getObjectIdTypeMapper() {
        return new MorphiumTypeMapper<ObjectId>(){

            @Override
            public Object marshall(ObjectId o) {
                ConcurrentHashMap<String, String> m = new ConcurrentHashMap<String, String>();
                m.put("value", o.toHexString());
                m.put("class_name", o.getClass().getName());
                return m;
            }

            @Override
            public ObjectId unmarshall(Object d) {
                return new ObjectId(((Map)d).get("value").toString());
            }
        };
    }

    @Override
    public List<String> listDatabases() {
        return new CopyOnWriteArrayList<String>(this.database.keySet());
    }

    @Override
    public List<String> listCollections(String db, String pattern) {
        Set<String> collections = this.database.get(db).keySet();
        CopyOnWriteArrayList<String> ret = new CopyOnWriteArrayList<String>();
        if (pattern == null) {
            ret.addAll(collections);
        } else {
            for (String col : collections) {
                if (!col.matches(pattern)) continue;
                ret.add(col);
            }
        }
        return ret;
    }

    public void resetData() {
        this.database.clear();
        this.currentTransaction.remove();
    }

    @Override
    public void setCredentials(String db, String login, char[] pwd) {
    }

    @Override
    public int getDefaultWriteTimeout() {
        return 0;
    }

    @Override
    public void setDefaultWriteTimeout(int wt) {
    }

    @Override
    public boolean isReplicaset() {
        return false;
    }

    @Override
    public String[] getCredentials(String db) {
        return new String[0];
    }

    @Override
    public boolean isDefaultFsync() {
        return false;
    }

    @Override
    public void setDefaultFsync(boolean j) {
    }

    @Override
    public String[] getHostSeed() {
        return new String[0];
    }

    @Override
    public void setHostSeed(String ... host) {
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public void setMaxConnections(int maxConnections) {
    }

    @Override
    public int getMinConnections() {
        return 0;
    }

    @Override
    public void setMinConnections(int minConnections) {
    }

    @Override
    public int getMaxConnectionLifetime() {
        return 0;
    }

    @Override
    public void setMaxConnectionLifetime(int timeout) {
    }

    @Override
    public int getMaxConnectionIdleTime() {
        return 0;
    }

    @Override
    public void setMaxConnectionIdleTime(int time) {
    }

    @Override
    public void addCommandListener(CommandListener cmd) {
    }

    @Override
    public void removeCommandListener(CommandListener cmd) {
    }

    @Override
    public void addClusterListener(ClusterListener cl) {
    }

    @Override
    public void removeClusterListener(ClusterListener cl) {
    }

    @Override
    public void addConnectionPoolListener(ConnectionPoolListener cpl) {
    }

    @Override
    public void removeConnectionPoolListener(ConnectionPoolListener cpl) {
    }

    @Override
    public int getConnectionTimeout() {
        return 0;
    }

    @Override
    public void setConnectionTimeout(int timeout) {
    }

    @Override
    public int getDefaultW() {
        return 0;
    }

    @Override
    public void setDefaultW(int w) {
    }

    @Override
    public int getHeartbeatFrequency() {
        return 0;
    }

    @Override
    public void setHeartbeatFrequency(int heartbeatFrequency) {
    }

    @Override
    public void setDefaultBatchSize(int defaultBatchSize) {
    }

    @Override
    public void setCredentials(Map<String, String[]> credentials) {
    }

    @Override
    public boolean isRetryReads() {
        return false;
    }

    @Override
    public void setRetryReads(boolean retryReads) {
    }

    @Override
    public boolean isRetryWrites() {
        return false;
    }

    @Override
    public void setRetryWrites(boolean retryWrites) {
    }

    @Override
    public String getUuidRepresentation() {
        return null;
    }

    @Override
    public void setUuidRepresentation(String uuidRepresentation) {
    }

    @Override
    public boolean isUseSSL() {
        return false;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
    }

    @Override
    public boolean isDefaultJ() {
        return false;
    }

    @Override
    public void setDefaultJ(boolean j) {
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
    }

    @Override
    public int getLocalThreshold() {
        return 0;
    }

    @Override
    public void setLocalThreshold(int thr) {
    }

    @Override
    public void heartBeatFrequency(int t) {
    }

    @Override
    public void useSsl(boolean ssl) {
    }

    @Override
    public void connect() {
        if (this.exec.isShutdown()) {
            this.exec = new ScheduledThreadPoolExecutor(1);
        }
        Runnable r = () -> {
            List<Runnable> current = this.eventQueue;
            this.eventQueue = new CopyOnWriteArrayList<Runnable>();
            Collections.shuffle(current);
            for (Runnable r1 : current) {
                try {
                    r1.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.exec.scheduleWithFixedDelay(r, 100L, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setDefaultReadPreference(ReadPreference rp) {
    }

    @Override
    public void connect(String replicasetName) {
        this.connect();
    }

    @Override
    public Maximums getMaximums() {
        Maximums ret = new Maximums();
        ret.setMaxBsonSize(10000);
        ret.setMaxMessageSize(10000);
        ret.setMaxWriteBatchSize(100);
        return ret;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public int getRetriesOnNetworkError() {
        return 0;
    }

    @Override
    public void setRetriesOnNetworkError(int r) {
    }

    @Override
    public int getSleepBetweenErrorRetries() {
        return 0;
    }

    @Override
    public void setSleepBetweenErrorRetries(int s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.exec.shutdownNow();
        Iterator<Object> iterator = this.monitors.iterator();
        while (iterator.hasNext()) {
            Object m;
            Object object = m = iterator.next();
            synchronized (object) {
                m.notifyAll();
            }
        }
        this.database.clear();
    }

    @Override
    public Map<String, Object> getReplsetStatus() {
        return new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Map<String, Object> getDBStats(String db) {
        ConcurrentHashMap<String, Object> ret = new ConcurrentHashMap<String, Object>();
        ret.put("collections", this.getDB(db).size());
        return ret;
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        ConcurrentHashMap<String, Integer> ret = new ConcurrentHashMap<String, Integer>();
        ret.put("entries", this.getDB(db).get(coll).size());
        return null;
    }

    @Override
    public Map<String, Object> getOps(long threshold) {
        this.log.warn("getOpts not working on memory");
        return new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Map<String, Object> runCommand(String db, Map<String, Object> cmd) {
        this.log.warn("Runcommand not working on memory");
        return new ConcurrentHashMap<String, Object>();
    }

    @Override
    public MorphiumCursor initAggregationIteration(String db, String collection, List<Map<String, Object>> aggregationPipeline, ReadPreference readPreference, Collation collation, int batchSize, Map<String, Object> findMetaData) throws MorphiumDriverException {
        this.log.warn("aggregation not possible in mem");
        return new MorphiumCursor();
    }

    @Override
    public MorphiumCursor initIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, Collation coll, Map<String, Object> findMetaData) throws MorphiumDriverException {
        MorphiumCursor crs = new MorphiumCursor();
        crs.setBatchSize(batchSize);
        crs.setCursorId(System.currentTimeMillis());
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.skip = skip;
        inCrs.limit = limit;
        inCrs.batchSize = batchSize;
        if (batchSize == 0) {
            inCrs.batchSize = 1000;
        }
        inCrs.setCollection(collection);
        inCrs.setDb(db);
        inCrs.setProjection(projection);
        inCrs.setQuery(query);
        inCrs.setFindMetaData(findMetaData);
        inCrs.setReadPreference(readPreference);
        inCrs.setSort(sort);
        crs.setInternalCursorObject(inCrs);
        int l = batchSize;
        if (limit != 0 && limit < batchSize) {
            l = limit;
        }
        List<Map<String, Object>> res = this.find(db, collection, query, sort, projection, skip, l, batchSize, readPreference, coll, findMetaData);
        crs.setBatch(Collections.synchronizedList(new CopyOnWriteArrayList<Map<String, Object>>(res)));
        if (res.size() < batchSize) {
            crs.setInternalCursorObject(null);
        } else {
            inCrs.dataRead = res.size();
        }
        return crs;
    }

    @Override
    public void watch(String db, int timeout, boolean fullDocumentOnUpdate, List<Map<String, Object>> pipeline, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        this.watch(db, null, timeout, fullDocumentOnUpdate, pipeline, cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(String db, String collection, int timeout, boolean fullDocumentOnUpdate, List<Map<String, Object>> pipeline, final DriverTailableIterationCallback cb) throws MorphiumDriverException {
        final Object monitor = new Object();
        this.monitors.add(monitor);
        DriverTailableIterationCallback cback = new DriverTailableIterationCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void incomingData(Map<String, Object> data, long dur) {
                cb.incomingData(data, dur);
                if (!cb.isContinued()) {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notifyAll();
                    }
                }
            }

            @Override
            public boolean isContinued() {
                return cb.isContinued();
            }
        };
        if (collection != null) {
            String key = db + "." + collection;
            this.watchersByDb.putIfAbsent(key, new CopyOnWriteArrayList());
            this.watchersByDb.get(key).add(cback);
        } else {
            this.watchersByDb.putIfAbsent(db, new CopyOnWriteArrayList());
            this.watchersByDb.get(db).add(cback);
        }
        try {
            Object object = monitor;
            synchronized (object) {
                monitor.wait();
                this.monitors.remove(monitor);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.watchersByDb.remove(db);
        this.log.debug("Exiting");
    }

    @Override
    public MorphiumCursor nextIteration(MorphiumCursor crs) throws MorphiumDriverException {
        MorphiumCursor next = new MorphiumCursor();
        next.setCursorId(crs.getCursorId());
        InMemoryCursor oldCrs = (InMemoryCursor)crs.getInternalCursorObject();
        if (oldCrs == null) {
            return null;
        }
        InMemoryCursor inCrs = new InMemoryCursor();
        inCrs.setReadPreference(oldCrs.getReadPreference());
        inCrs.setFindMetaData(oldCrs.getFindMetaData());
        inCrs.setDb(oldCrs.getDb());
        inCrs.setQuery(oldCrs.getQuery());
        inCrs.setCollection(oldCrs.getCollection());
        inCrs.setProjection(oldCrs.getProjection());
        inCrs.setBatchSize(oldCrs.getBatchSize());
        inCrs.setCollation(oldCrs.getCollation());
        inCrs.setLimit(oldCrs.getLimit());
        inCrs.setSort(oldCrs.getSort());
        inCrs.skip = oldCrs.getDataRead() + 1;
        int limit = oldCrs.getBatchSize();
        if (oldCrs.getLimit() != 0 && oldCrs.getDataRead() + oldCrs.getBatchSize() > oldCrs.getLimit()) {
            limit = oldCrs.getLimit() - oldCrs.getDataRead();
        }
        List<Map<String, Object>> res = this.find(inCrs.getDb(), inCrs.getCollection(), inCrs.getQuery(), inCrs.getSort(), inCrs.getProjection(), inCrs.getSkip(), limit, inCrs.getBatchSize(), inCrs.getReadPreference(), inCrs.getCollation(), inCrs.getFindMetaData());
        next.setBatch(Collections.synchronizedList(new CopyOnWriteArrayList<Map<String, Object>>(res)));
        if (res.size() < inCrs.getBatchSize() || oldCrs.limit != 0 && res.size() + oldCrs.getDataRead() > oldCrs.limit) {
            next.setInternalCursorObject(null);
        } else {
            inCrs.setDataRead(oldCrs.getDataRead() + res.size());
            next.setInternalCursorObject(inCrs);
        }
        return next;
    }

    @Override
    public List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference rp, Collation col, Map<String, Object> findMetaData) throws MorphiumDriverException {
        return this.find(db, collection, query, sort, projection, skip, limit, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> find(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, boolean internal) throws MorphiumDriverException {
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(this.getCollection(db, collection));
        CopyOnWriteArrayList ret = new CopyOnWriteArrayList();
        int count = 0;
        if (sort != null) {
            data.sort((o1, o2) -> {
                for (String f : sort.keySet()) {
                    if (o1.get(f).equals(o2.get(f))) continue;
                    return ((Comparable)o1.get(f)).compareTo(o2.get(f)) * (Integer)sort.get(f);
                }
                return 0;
            });
        }
        int i = 0;
        while (i < data.size()) {
            HashMap o = (HashMap)data.get(i);
            if (++count >= skip) {
                if (QueryHelper.matchesQuery(query, o)) {
                    if (o == null) {
                        o = new HashMap();
                    }
                    InMemoryDriver inMemoryDriver = this;
                    synchronized (inMemoryDriver) {
                        while (true) {
                            try {
                                ret.add(internal ? o : new HashMap(o));
                            }
                            catch (ConcurrentModificationException e) {
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            break;
                        }
                    }
                }
                if (limit > 0 && ret.size() >= limit) {
                    return Collections.synchronizedList(new CopyOnWriteArrayList(ret));
                }
            }
            ++i;
        }
        return Collections.synchronizedList(new CopyOnWriteArrayList(ret));
    }

    @Override
    public long count(String db, String collection, Map<String, Object> query, Collation collation, ReadPreference rp) {
        List<Map<String, Object>> d = this.getCollection(db, collection);
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(d);
        if (query.isEmpty()) {
            return data.size();
        }
        long cnt = 0L;
        for (Map map : data) {
            if (!QueryHelper.matchesQuery(query, map)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public long estimatedDocumentCount(String db, String collection, ReadPreference rp) {
        return this.getCollection(db, collection).size();
    }

    public List<Map<String, Object>> findByFieldValue(String db, String coll, String field, Object value) {
        CopyOnWriteArrayList ret = new CopyOnWriteArrayList();
        CopyOnWriteArrayList<Map<String, Object>> data = new CopyOnWriteArrayList<Map<String, Object>>(this.getCollection(db, coll));
        for (Map map : data) {
            if (map.get(field) == null && value != null || (map.get(field) != null || value != null) && !map.get(field).equals(value)) continue;
            ret.add(new ConcurrentHashMap(map));
        }
        return Collections.synchronizedList(new CopyOnWriteArrayList(ret));
    }

    @Override
    public void insert(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) throws MorphiumDriverException {
        for (Map<String, Object> o : objs) {
            if (o.get("_id") != null && !this.findByFieldValue(db, collection, "_id", o.get("_id")).isEmpty()) {
                throw new MorphiumDriverException("Duplicate _id! " + o.get("_id"), null);
            }
            o.putIfAbsent("_id", new MorphiumId());
        }
        this.getCollection(db, collection).addAll(objs);
        for (Map<String, Object> o : objs) {
            this.notifyWatchers(db, collection, "insert", o);
        }
    }

    @Override
    public Map<String, Integer> store(String db, String collection, List<Map<String, Object>> objs, WriteConcern wc) {
        ConcurrentHashMap<String, Integer> ret = new ConcurrentHashMap<String, Integer>();
        int upd = 0;
        int total = objs.size();
        for (Map<String, Object> o : objs) {
            if (o.get("_id") == null) {
                o.put("_id", new MorphiumId());
                this.getCollection(db, collection).add(o);
                continue;
            }
            List<Map<String, Object>> srch = this.findByFieldValue(db, collection, "_id", o.get("_id"));
            if (!srch.isEmpty()) {
                this.getCollection(db, collection).remove(srch.get(0));
                ++upd;
                this.notifyWatchers(db, collection, "replace", o);
            } else {
                this.notifyWatchers(db, collection, "insert", o);
            }
            this.getCollection(db, collection).add(o);
        }
        ret.put("matched", upd);
        ret.put("updated", upd);
        return ret;
    }

    private Map<String, List<Map<String, Object>>> getDB(String db) {
        if (this.currentTransaction.get() == null) {
            this.database.putIfAbsent(db, new ConcurrentHashMap());
            return this.database.get(db);
        }
        this.currentTransaction.get().getDatabase().putIfAbsent(db, new ConcurrentHashMap());
        return (Map)this.currentTransaction.get().getDatabase().get(db);
    }

    @Override
    public void closeIteration(MorphiumCursor crs) {
    }

    @Override
    public Map<String, Object> update(String db, String collection, Map<String, Object> query, Map<String, Object> op, boolean multiple, boolean upsert, Collation collation, WriteConcern wc) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.find(db, collection, query, null, null, 0, multiple ? 0 : 1, true);
        boolean insert = false;
        if (lst == null) {
            lst = new CopyOnWriteArrayList<Map<String, Object>>();
        }
        if (upsert && lst.isEmpty()) {
            lst.add(new ConcurrentHashMap());
            for (String k : query.keySet()) {
                if (k.startsWith("$")) continue;
                if (query.get(k) != null) {
                    lst.get(0).put(k, query.get(k));
                    continue;
                }
                lst.get(0).remove(k);
            }
            insert = true;
        }
        for (Map<String, Object> obj : lst) {
            block22: for (String operand : op.keySet()) {
                Map cmd = (Map)op.get(operand);
                switch (operand) {
                    case "$set": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            if (entry.getValue() != null) {
                                obj.put((String)entry.getKey(), entry.getValue());
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$unset": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$inc": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Integer)value + (Integer)entry.getValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Integer)value).intValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Integer)value).intValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (long)((Integer)value).intValue() + (Long)entry.getValue();
                                }
                            } else if (value instanceof Double) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Double)value + (double)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = (Double)value + (double)((Float)entry.getValue()).floatValue();
                                } else if (entry.getValue() instanceof Double) {
                                    value = (Double)value + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Double)value + (double)((Long)entry.getValue()).longValue();
                                }
                            } else if (value instanceof Float) {
                                if (entry.getValue() instanceof Integer) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Integer)entry.getValue()).intValue());
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf(((Float)value).floatValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Float)value).floatValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = Float.valueOf(((Float)value).floatValue() + (float)((Long)entry.getValue()).longValue());
                                }
                            } else if (value instanceof Long) {
                                if (entry.getValue() instanceof Integer) {
                                    value = (Long)value + (long)((Integer)entry.getValue()).intValue();
                                } else if (entry.getValue() instanceof Float) {
                                    value = Float.valueOf((float)((Long)value).longValue() + ((Float)entry.getValue()).floatValue());
                                } else if (entry.getValue() instanceof Double) {
                                    value = (double)((Long)value).longValue() + (Double)entry.getValue();
                                } else if (entry.getValue() instanceof Long) {
                                    value = (Long)value + (Long)entry.getValue();
                                }
                            }
                            if (value != null) {
                                obj.put((String)entry.getKey(), value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$mul": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = obj.get(entry.getKey());
                            if (value instanceof Integer) {
                                value = (Integer)value * (Integer)entry.getValue();
                            } else if (value instanceof Double) {
                                value = (Double)value * (Double)entry.getValue();
                            } else if (value instanceof Float) {
                                value = Float.valueOf(((Float)value).floatValue() * ((Float)entry.getValue()).floatValue());
                            } else if (value instanceof Long) {
                                value = (Long)value * (Long)entry.getValue();
                            }
                            if (value != null) {
                                obj.put((String)entry.getKey(), value);
                                continue;
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$rename": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            if (obj.get(entry.getKey()) != null) {
                                obj.put((String)entry.getValue(), obj.get(entry.getKey()));
                            } else {
                                obj.remove(entry.getValue());
                            }
                            obj.remove(entry.getKey());
                        }
                        continue block22;
                    }
                    case "$min": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) <= 0 || entry.getValue() == null) continue;
                            obj.put((String)entry.getKey(), entry.getValue());
                        }
                        continue block22;
                    }
                    case "$max": {
                        Object value;
                        for (Map.Entry entry : cmd.entrySet()) {
                            value = (Comparable)obj.get(entry.getKey());
                            if (value.compareTo(entry.getValue()) >= 0 || entry.getValue() == null) continue;
                            obj.put((String)entry.getKey(), entry.getValue());
                        }
                        continue block22;
                    }
                    case "$push": {
                        for (Map.Entry entry : cmd.entrySet()) {
                            CopyOnWriteArrayList v = (CopyOnWriteArrayList)obj.get(entry.getKey());
                            if (v == null) {
                                v = new CopyOnWriteArrayList();
                                obj.put((String)entry.getKey(), v);
                            }
                            if (entry.getValue() instanceof Map) {
                                if (((Map)entry.getValue()).get("$each") != null) {
                                    v.addAll((List)((Map)entry.getValue()).get("$each"));
                                    continue;
                                }
                                v.add(entry.getValue());
                                continue;
                            }
                            v.add(entry.getValue());
                        }
                        continue block22;
                    }
                    default: {
                        throw new RuntimeException("unknown operand " + operand);
                    }
                }
            }
            this.notifyWatchers(db, collection, "update", obj);
        }
        if (insert) {
            this.store(db, collection, lst, wc);
        }
        return new ConcurrentHashMap<String, Object>();
    }

    private void notifyWatchers(String db, String collection, String op, Map doc) {
        Runnable r = () -> {
            List<DriverTailableIterationCallback> w = null;
            if (this.watchersByDb.containsKey(db)) {
                w = Collections.synchronizedList(new CopyOnWriteArrayList(this.watchersByDb.get(db)));
            } else if (collection != null && this.watchersByDb.containsKey(db + "." + collection)) {
                w = Collections.synchronizedList(new CopyOnWriteArrayList(this.watchersByDb.get(db + "." + collection)));
            }
            if (w == null || w.isEmpty()) {
                return;
            }
            long tx = this.txn.incrementAndGet();
            Collections.shuffle(w);
            for (DriverTailableIterationCallback cb : w) {
                ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
                if (doc != null) {
                    data.put("fullDocument", doc);
                }
                if (op != null) {
                    data.put("operationType", op);
                }
                Map<String, String> m = Collections.synchronizedMap(Utils.getMap("db", db));
                m.put("coll", collection);
                data.put("ns", m);
                data.put("txnNumber", tx);
                data.put("clusterTime", System.currentTimeMillis());
                if (doc != null && doc.get("_id") != null) {
                    data.put("documentKey", doc.get("_id"));
                }
                try {
                    cb.incomingData(data, System.currentTimeMillis());
                }
                catch (Exception e) {
                    this.log.error("Error calling watcher", (Throwable)e);
                }
            }
        };
        this.eventQueue.add(r);
    }

    @Override
    public Map<String, Object> delete(String db, String collection, Map<String, Object> query, boolean multiple, Collation collation, WriteConcern wc) throws MorphiumDriverException {
        List<Map<String, Object>> toDel = this.find(db, collection, query, null, null, 0, multiple ? 0 : 1, 10000, null, collation, null);
        for (Map<String, Object> o : toDel) {
            this.getCollection(db, collection).remove(o);
            this.notifyWatchers(db, collection, "delete", o);
        }
        return new ConcurrentHashMap<String, Object>();
    }

    private List<Map<String, Object>> getCollection(String db, String collection) {
        this.getDB(db).putIfAbsent(collection, Collections.synchronizedList(new CopyOnWriteArrayList()));
        return this.getDB(db).get(collection);
    }

    @Override
    public void drop(String db, String collection, WriteConcern wc) {
        this.getDB(db).remove(collection);
        this.notifyWatchers(db, collection, "drop", null);
    }

    @Override
    public void drop(String db, WriteConcern wc) {
        this.database.remove(db);
        this.notifyWatchers(db, null, "drop", null);
    }

    @Override
    public boolean exists(String db) {
        return this.database.containsKey(db);
    }

    @Override
    public List<Object> distinct(String db, String collection, String field, Map<String, Object> filter, Collation collation, ReadPreference rp) {
        List<Map<String, Object>> list = this.getDB(db).get(collection);
        HashSet<Object> distinctValues = new HashSet<Object>();
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> doc : list) {
                if (doc == null || doc.isEmpty() || doc.get(field) == null) continue;
                distinctValues.add(doc.get(field));
            }
        }
        return Collections.synchronizedList(new CopyOnWriteArrayList(distinctValues));
    }

    @Override
    public boolean exists(String db, String collection) {
        return this.getDB(db) != null && this.getDB(db).containsKey(collection);
    }

    @Override
    public List<Map<String, Object>> getIndexes(String db, String collection) {
        return new CopyOnWriteArrayList<Map<String, Object>>();
    }

    @Override
    public List<String> getCollectionNames(String db) {
        return null;
    }

    @Override
    public Map<String, Object> findAndOneAndDelete(String db, String col, Map<String, Object> query, Map<String, Integer> sort, Collation collation) throws MorphiumDriverException {
        List<Map<String, Object>> r = this.find(db, col, query, sort, null, 0, 1, 1000, null, collation, null);
        if (r.size() == 0) {
            return null;
        }
        this.delete(db, col, Utils.getMap("_id", r.get(0).get("_id")), false, collation, null);
        return r.get(0);
    }

    @Override
    public Map<String, Object> findAndOneAndUpdate(String db, String col, Map<String, Object> query, Map<String, Object> update, Map<String, Integer> sort, Collation collation) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.find(db, col, query, sort, null, 0, 1, 1, null, collation, new ConcurrentHashMap<String, Object>());
        this.update(db, col, query, update, false, false, collation, null);
        return ret.get(0);
    }

    @Override
    public Map<String, Object> findAndOneAndReplace(String db, String col, Map<String, Object> query, Map<String, Object> replacement, Map<String, Integer> sort, Collation collation) throws MorphiumDriverException {
        List<Map<String, Object>> ret = this.find(db, col, query, sort, null, 0, 1, 1, null, collation, new ConcurrentHashMap<String, Object>());
        if (ret.get(0).get("_id") != null) {
            replacement.put("_id", ret.get(0).get("_id"));
        } else {
            replacement.remove("_id");
        }
        this.store(db, col, Collections.singletonList(replacement), null);
        return replacement;
    }

    @Override
    public List<Map<String, Object>> aggregate(String db, String collection, List<Map<String, Object>> pipeline, boolean explain, boolean allowDiskUse, Collation collation, ReadPreference readPreference) throws MorphiumDriverException {
        this.log.warn("Aggregate not possible yet in memory!");
        return new CopyOnWriteArrayList<Map<String, Object>>();
    }

    @Override
    public void tailableIteration(String db, String collection, Map<String, Object> query, Map<String, Integer> sort, Map<String, Object> projection, int skip, int limit, int batchSize, ReadPreference readPreference, int timeout, DriverTailableIterationCallback cb) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("not possible in Mem yet");
    }

    @Override
    public int getMaxWaitTime() {
        return 0;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
    }

    @Override
    public int getServerSelectionTimeout() {
        return 0;
    }

    @Override
    public void setServerSelectionTimeout(int serverSelectionTimeout) {
    }

    @Override
    public boolean isCapped(String db, String coll) {
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new CopyOnWriteArrayList<BulkRequest>();
            }

            @Override
            public Map<String, Object> execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InMemoryDriver.this.insert(db, collection, ((InsertBulkRequest)r).getToInsert(), null);
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            InMemoryDriver.this.update(db, collection, up.getQuery(), up.getCmd(), up.isMultiple(), up.isUpsert(), null, null);
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            InMemoryDriver.this.delete(db, collection, ((DeleteBulkRequest)r).getQuery(), ((DeleteBulkRequest)r).isMultiple(), null, null);
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    InMemoryDriver.this.log.error("Got exception: ", (Throwable)e);
                }
                return new ConcurrentHashMap<String, Object>();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    @Override
    public void createIndex(String db, String collection, Map<String, Object> index, Map<String, Object> options) {
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public List<Map<String, Object>> mapReduce(String db, String collection, String mapping, String reducing, Map<String, Object> query, Map<String, Object> sorting, Collation collation) throws MorphiumDriverException {
        throw new FunctionNotSupportedException("no map reduce in memory");
    }

    @Override
    public void startTransaction() {
        if (this.currentTransaction.get() != null) {
            throw new IllegalArgumentException("transaction in progress");
        }
        InMemTransactionContext ctx = new InMemTransactionContext();
        Cloner cloner = new Cloner();
        ctx.setDatabase((Map)cloner.deepClone(this.database));
        this.currentTransaction.set(ctx);
    }

    @Override
    public void commitTransaction() {
        if (this.currentTransaction.get() == null) {
            throw new IllegalArgumentException("No transaction in progress");
        }
        InMemTransactionContext ctx = this.currentTransaction.get();
        this.database.putAll(ctx.getDatabase());
        this.currentTransaction.set(null);
    }

    @Override
    public MorphiumTransactionContext getTransactionContext() {
        return this.currentTransaction.get();
    }

    @Override
    public void abortTransaction() {
        this.currentTransaction.set(null);
    }

    @Override
    public void setTransactionContext(MorphiumTransactionContext ctx) {
        this.currentTransaction.set((InMemTransactionContext)ctx);
    }

    public void writeDump(File f) {
    }

    @Override
    public SSLContext getSslContext() {
        return null;
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
    }

    @Override
    public boolean isSslInvalidHostNameAllowed() {
        return false;
    }

    @Override
    public void setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
    }

    private static class InMemoryCursor {
        private int skip;
        private int limit;
        private int batchSize;
        private int dataRead = 0;
        private String db;
        private String collection;
        private Map<String, Object> query;
        private Map<String, Integer> sort;
        private Map<String, Object> projection;
        private ReadPreference readPreference;
        private Map<String, Object> findMetaData;
        private Collation collation;

        private InMemoryCursor() {
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public Map<String, Object> getQuery() {
            return this.query;
        }

        public void setQuery(Map<String, Object> query) {
            this.query = query;
        }

        public Map<String, Integer> getSort() {
            return this.sort;
        }

        public void setSort(Map<String, Integer> sort) {
            this.sort = sort;
        }

        public Map<String, Object> getProjection() {
            return this.projection;
        }

        public void setProjection(Map<String, Object> projection) {
            this.projection = projection;
        }

        public ReadPreference getReadPreference() {
            return this.readPreference;
        }

        public void setReadPreference(ReadPreference readPreference) {
            this.readPreference = readPreference;
        }

        public Map<String, Object> getFindMetaData() {
            return this.findMetaData;
        }

        public void setFindMetaData(Map<String, Object> findMetaData) {
            this.findMetaData = findMetaData;
        }

        public int getDataRead() {
            return this.dataRead;
        }

        public void setDataRead(int dataRead) {
            this.dataRead = dataRead;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(int batchSize) {
            this.batchSize = batchSize;
        }

        public int getSkip() {
            return this.skip;
        }

        public void setSkip(int skip) {
            this.skip = skip;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public Collation getCollation() {
            return this.collation;
        }

        public void setCollation(Collation collation) {
            this.collation = collation;
        }
    }
}

