/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.BinarySerializedObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.ReadOnly;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.annotations.encryption.Encrypted;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.mapping.BigIntegerTypeMapper;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

public class ObjectMapperImpl
implements MorphiumObjectMapper {
    private final Logger log = LoggerFactory.getLogger(ObjectMapperImpl.class);
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final Map<Class<?>, NameProvider> nameProviders;
    private final JSONParser jsonParser = new JSONParser();
    private final List<Class<?>> mongoTypes;
    private final ContainerFactory containerFactory;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper(true);
    private final Map<Class<?>, MorphiumTypeMapper> customMappers = new ConcurrentHashMap();
    private Morphium morphium;

    public ObjectMapperImpl() {
        this.nameProviders = new ConcurrentHashMap();
        this.mongoTypes = Collections.synchronizedList(new ArrayList());
        this.mongoTypes.add(String.class);
        this.mongoTypes.add(Character.class);
        this.mongoTypes.add(Integer.class);
        this.mongoTypes.add(Long.class);
        this.mongoTypes.add(Float.class);
        this.mongoTypes.add(Double.class);
        this.mongoTypes.add(Date.class);
        this.mongoTypes.add(Boolean.class);
        this.mongoTypes.add(Byte.class);
        this.containerFactory = new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
        this.customMappers.put(BigInteger.class, new BigIntegerTypeMapper());
    }

    @Override
    public void setAnnotationHelper(AnnotationAndReflectionHelper an) {
        this.annotationHelper = an;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper(true);
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public <T> void registerCustomMapperFor(Class<T> cls, MorphiumTypeMapper<T> map) {
        this.customMappers.put(cls, map);
    }

    @Override
    public void deregisterCustomMapperFor(Class cls) {
        this.customMappers.remove(cls);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            this.log.error("Error getting nameProvider", (Throwable)ex);
            throw new IllegalArgumentException("could not get name provider", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviders.get(cls) == null) {
            NameProvider np = p.nameProvider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setNameProviderForClass(cls, np);
        }
        return this.nameProviders.get(cls);
    }

    @Override
    public String getCollectionName(Class cls) {
        Entity p = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.annotationHelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            this.log.error("Could not instanciate NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.log.error("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    public Object marshallIfNecessary(Object o) {
        if (o == null) {
            return null;
        }
        if (this.annotationHelper.isEntity(o) || this.customMappers.containsKey(o.getClass())) {
            return this.serialize(o);
        }
        if (o.getClass().isPrimitive()) {
            return o;
        }
        if (o.getClass().isArray()) {
            if (o.getClass().getComponentType().equals(Byte.TYPE)) {
                return o;
            }
            ArrayList<Object> lst = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(o); ++i) {
                lst.add(this.marshallIfNecessary(Array.get(o, i)));
            }
            return this.serializeList(lst);
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            ArrayList lst = new ArrayList((Collection)o);
            return this.serializeList(lst);
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return this.serializeMap((Map)o);
        }
        return o;
    }

    @Override
    public Map<String, Object> serialize(Object o) {
        if (o == null) {
            return new HashMap<String, Object>();
        }
        Class<?> c = this.annotationHelper.getRealClass(o.getClass());
        if (this.customMappers.containsKey(c)) {
            Object ret = this.customMappers.get(c).marshall(o);
            if (ret instanceof Map) {
                ((Map)ret).put("class_name", o.getClass().getName());
                return (Map)ret;
            }
            return Utils.getMap("value", ret);
        }
        if (!this.annotationHelper.isEntity(o) && !this.morphium.getConfig().isWarnOnNoEntitySerialization()) {
            if (this.morphium == null || this.morphium.getConfig().isObjectSerializationEnabled()) {
                if (o instanceof Serializable) {
                    try {
                        BinarySerializedObject obj = new BinarySerializedObject();
                        obj.setOriginalClassName(o.getClass().getName());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(out);
                        oout.writeObject(o);
                        oout.flush();
                        Base64.Encoder enc = Base64.getMimeEncoder();
                        String str = new String(enc.encode(out.toByteArray()));
                        obj.setB64Data(str);
                        return this.serialize(obj);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Binary serialization failed! " + o.getClass().getName(), e);
                    }
                }
                throw new IllegalArgumentException("Cannot write object to db that is neither entity, embedded nor serializable! ObjectType: " + o.getClass().getName());
            }
            throw new IllegalArgumentException("Object is no entity: " + o.getClass().getSimpleName());
        }
        if (!this.annotationHelper.isEntity(o) && this.morphium.getConfig().isWarnOnNoEntitySerialization()) {
            this.log.warn("Serializing non-entity of type " + o.getClass().getName());
        }
        HashMap<String, Object> dbo = new HashMap<String, Object>();
        if (o == null) {
            return dbo;
        }
        Class<?> cls = this.annotationHelper.getRealClass(o.getClass());
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.annotationHelper.getRealObject(o);
        List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
        String cn = cls.getName();
        if (e != null && !e.typeId().equals(".")) {
            cn = e.typeId();
        }
        if (emb != null && !emb.typeId().equals(".")) {
            cn = emb.typeId();
        }
        if (e != null && e.polymorph()) {
            dbo.put("class_name", cn);
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", cn);
        }
        Iterator<String> iterator = flds.iterator();
        while (iterator.hasNext()) {
            String f;
            String fName = f = iterator.next();
            try {
                ArrayList<Object> lst;
                Field fld = this.annotationHelper.getField(cls, f);
                if (fld == null) {
                    this.log.error("Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers()) || fld.isAnnotationPresent(ReadOnly.class)) continue;
                if (fld.isAnnotationPresent(Encrypted.class)) {
                    try {
                        Encrypted enc = fld.getAnnotation(Encrypted.class);
                        ValueEncryptionProvider encP = enc.provider().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        byte[] encKey = this.morphium.getEncryptionKeyProvider().getEncryptionKey(enc.keyName());
                        encP.setEncryptionKey(encKey);
                        byte[] encrypted = encP.encrypt(Utils.toJsonString(this.marshallIfNecessary(fld.get(o))).getBytes());
                        dbo.put(fName, encrypted);
                        continue;
                    }
                    catch (Exception exc) {
                        throw new RuntimeException("Ecryption failed. Field: " + fName + " class: " + o.getClass().getName(), exc);
                    }
                }
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly() || fld.get(o) == null) continue;
                    dbo.putAll(this.serializeMap((Map)fld.get(o)));
                    continue;
                }
                if (dbo.containsKey(fName)) {
                    this.log.warn("Field " + fName + " is shadowed - inherited values?");
                    continue;
                }
                Object v = null;
                Map<String, Object> value = fld.get(o);
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (Collection.class.isAssignableFrom(fld.getType())) {
                        lst = new ArrayList<Object>();
                        for (Object rec2 : (Collection)((Object)value)) {
                            if (rec2 != null) {
                                Object id = this.annotationHelper.getId(rec2);
                                if (id == null) {
                                    id = this.automaticStore(r, rec2);
                                }
                                if (this.morphium == null) {
                                    throw new RuntimeException("cannot set dbRef - morphium is not set");
                                }
                                MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec2.getClass()).getName(), id);
                                lst.add(this.serialize(ref));
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else if (Map.class.isAssignableFrom(fld.getType())) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        ((Map)value).forEach((key, rec) -> {
                            Object id = this.annotationHelper.getId(rec);
                            if (id == null) {
                                id = this.automaticStore(r, rec);
                            }
                            if (this.morphium == null) {
                                throw new RuntimeException("cannot set dbRef - morphium is not set");
                            }
                            MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec.getClass()).getName(), id);
                            map.put((String)key, this.serialize(ref));
                        });
                        v = map;
                    } else {
                        if (this.annotationHelper.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    this.log.error("Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.annotationHelper.getId(value);
                    }
                } else {
                    Class<?> valueClass = value == null ? fld.getType() : value.getClass();
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Entity.class)) {
                        if (value != null) {
                            Map<String, Object> obj = this.serialize(value);
                            obj.remove("_id");
                            v = obj;
                        }
                    } else if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Embedded.class)) {
                        if (value != null) {
                            v = this.serialize(value);
                        }
                    } else {
                        v = value;
                        if (v != null) {
                            if (v instanceof Map) {
                                v = this.serializeMap((Map)v);
                            } else if (v.getClass().isArray()) {
                                if (!v.getClass().getComponentType().equals(Byte.TYPE)) {
                                    lst = new ArrayList();
                                    for (int i = 0; i < Array.getLength(v); ++i) {
                                        lst.add(this.marshallIfNecessary(Array.get(v, i)));
                                    }
                                    v = this.serializeList(lst);
                                }
                            } else if (v instanceof List) {
                                v = this.serializeList((List)v);
                            } else if (v instanceof Iterable) {
                                lst = new ArrayList();
                                for (Object i : (Iterable)v) {
                                    lst.add(i);
                                }
                                v = this.serializeList(lst);
                            } else if (v.getClass().equals(GregorianCalendar.class)) {
                                v = ((GregorianCalendar)v).getTime();
                            } else if (v.getClass().equals(MorphiumId.class)) {
                                v = new ObjectId(((MorphiumId)v).getBytes());
                            } else if (this.customMappers.containsKey(v.getClass())) {
                                v = this.customMappers.get(v.getClass()).marshall(v);
                            } else if (v.getClass().isEnum()) {
                                v = ((Enum)v).name();
                            }
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                this.log.error("Illegal Access to field " + f);
            }
        }
        return dbo;
    }

    private Object automaticStore(Reference r, Object rec) {
        String coll;
        if (r.automaticStore()) {
            if (this.morphium == null) {
                throw new RuntimeException("Could not automagically store references as morphium is not set!");
            }
            coll = r.targetCollection();
            if (coll.equals(".")) {
                coll = null;
            }
        } else {
            throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
        }
        this.morphium.storeNoCache(rec, coll);
        Object id = this.annotationHelper.getId(rec);
        return id;
    }

    public List<Object> serializeList(List v) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object lo : v) {
            if (lo != null) {
                if (this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Embedded.class)) {
                    Map<String, Object> marshall = this.serialize(lo);
                    String cn = this.getTypeId(lo);
                    marshall.put("class_name", cn);
                    lst.add(marshall);
                    continue;
                }
                if (lo instanceof List) {
                    lst.add(this.serializeList((List)lo));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add(this.serializeMap((Map)lo));
                    continue;
                }
                if (lo instanceof MorphiumId) {
                    lst.add(new ObjectId(((MorphiumId)lo).getBytes()));
                    continue;
                }
                if (lo.getClass().isEnum()) {
                    HashMap<String, String> obj = new HashMap<String, String>();
                    obj.put("class_name", this.getTypeId(lo));
                    obj.put("name", ((Enum)lo).name());
                    lst.add(obj);
                    continue;
                }
                if (lo.getClass().isPrimitive() || this.mongoTypes.contains(lo.getClass())) {
                    lst.add(lo);
                    continue;
                }
                if (lo.getClass().isArray()) {
                    if (lo.getClass().getComponentType().equals(Byte.TYPE)) {
                        lst.add(lo);
                        continue;
                    }
                    for (int i = 0; i < Array.getLength(lo); ++i) {
                        try {
                            lst.add(this.marshallIfNecessary(Array.get(lo, i)));
                            continue;
                        }
                        catch (Exception e) {
                            lst.add(this.marshallIfNecessary(((Integer)Array.get(lo, i)).byteValue()));
                        }
                    }
                    continue;
                }
                lst.add(this.serialize(lo));
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private String getTypeId(Object lo) {
        String cn = lo.getClass().getName();
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(lo.getClass(), Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(this.log.getClass(), Embedded.class);
        if (e != null && !e.typeId().equals(".")) {
            cn = e.typeId();
        } else if (emb != null && !emb.typeId().equals(".")) {
            cn = emb.typeId();
        }
        return cn;
    }

    public Map<String, Object> serializeMap(Map v) {
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                this.log.warn("Map in Mongodb needs to have String as keys - using toString");
                k = k.toString();
                if (((String)k).contains(".")) {
                    this.log.warn(". not allowed as Key in Maps - converting to _");
                    k = ((String)k).replaceAll("\\.", "_");
                }
            }
            if ((mval = es.getValue()) != null) {
                Map<String, Object> obj;
                if (this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Embedded.class)) {
                    obj = this.serialize(mval);
                    obj.put("class_name", this.getTypeId(mval));
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.serializeMap((Map)mval);
                } else if (mval instanceof List) {
                    mval = this.serializeList((List)mval);
                } else if (mval.getClass().isArray()) {
                    if (!mval.getClass().getComponentType().equals(Byte.TYPE)) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        for (int i = 0; i < Array.getLength(mval); ++i) {
                            lst.add(this.marshallIfNecessary(Array.get(mval, i)));
                        }
                        mval = this.serializeList(lst);
                    }
                } else if (mval.getClass().isEnum()) {
                    obj = new HashMap<String, Object>();
                    obj.put("class_name", this.getTypeId(mval));
                    obj.put("name", ((Enum)mval).name());
                } else if (mval instanceof MorphiumId) {
                    mval = new ObjectId(((MorphiumId)mval).getBytes());
                } else if (!mval.getClass().isPrimitive() && !this.mongoTypes.contains(mval.getClass())) {
                    mval = this.serialize(mval);
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    @Override
    public <T> T deserialize(Class<? extends T> cls, String jsonString) throws ParseException {
        if (jsonString.startsWith("{")) {
            HashMap obj = (HashMap)this.jsonParser.parse(jsonString, this.containerFactory);
            return this.deserialize(cls, obj);
        }
        return (T)((HashMap)this.jsonParser.parse("{\"value\":" + jsonString + "}", this.containerFactory)).get("value");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(Class<? extends T> theClass, Map<String, Object> o) {
        if (o == null) {
            return null;
        }
        Class<BinarySerializedObject> cls = theClass;
        if (this.customMappers.containsKey(cls)) {
            return this.customMappers.get(cls).unmarshall(o);
        }
        try {
            if (this.morphium != null && !this.morphium.getConfig().isWarnOnNoEntitySerialization() && this.morphium.getConfig().isObjectSerializationEnabled() && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Embedded.class)) {
                cls = BinarySerializedObject.class;
            }
            if (o.get("class_name") != null || o.get("className") != null) {
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = this.annotationHelper.getClassForTypeId(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                T[] en = cls.getEnumConstants();
                for (Enum e : (Enum[])en) {
                    if (!e.name().equals(o.get("name"))) continue;
                    return (T)e;
                }
            }
            Object ret = null;
            try {
                ret = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    Constructor<?> constructor = this.reflection.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    ret = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.log.error("Exception", (Throwable)e);
                }
            }
            if (ret == null) {
                throw new IllegalArgumentException("Could not instanciate " + cls.getName());
            }
            List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
            Iterator<String> e = flds.iterator();
            while (true) {
                Object value;
                String f;
                block120: {
                    Object arr;
                    ArrayList<Serializable> lst;
                    Field fld;
                    block142: {
                        Iterator decKey2;
                        HashMap v;
                        MorphiumReference r;
                        Reference reference;
                        block127: {
                            Iterator<String> iterator;
                            HashMap<String, Object> data;
                            block123: {
                                block121: {
                                    Object valueFromDb;
                                    block144: {
                                        block145: {
                                            block143: {
                                                block132: {
                                                    block141: {
                                                        block136: {
                                                            block133: {
                                                                block134: {
                                                                    block140: {
                                                                        block139: {
                                                                            block138: {
                                                                                block137: {
                                                                                    block135: {
                                                                                        block131: {
                                                                                            block130: {
                                                                                                block128: {
                                                                                                    block129: {
                                                                                                        block124: {
                                                                                                            Object id;
                                                                                                            block126: {
                                                                                                                block125: {
                                                                                                                    block122: {
                                                                                                                        if (!e.hasNext()) break block121;
                                                                                                                        f = e.next();
                                                                                                                        valueFromDb = o.get(f);
                                                                                                                        fld = this.annotationHelper.getField(cls, f);
                                                                                                                        if (Modifier.isStatic(fld.getModifiers())) continue;
                                                                                                                        if (this.customMappers.containsKey(fld.getType())) {
                                                                                                                            fld.set(ret, this.customMappers.get(fld.getType()).unmarshall(valueFromDb));
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        if (!fld.isAnnotationPresent(AdditionalData.class)) break block122;
                                                                                                                        if (!Map.class.isAssignableFrom(fld.getType())) {
                                                                                                                            this.log.error("Could not deserialize additional data into fld of type " + fld.getType().toString());
                                                                                                                            continue;
                                                                                                                        }
                                                                                                                        Set<String> keys = o.keySet();
                                                                                                                        data = new HashMap<String, Object>();
                                                                                                                        iterator = keys.iterator();
                                                                                                                        break block123;
                                                                                                                    }
                                                                                                                    if (valueFromDb == null) {
                                                                                                                        if (fld.getType().isPrimitive()) continue;
                                                                                                                        fld.set(ret, null);
                                                                                                                        continue;
                                                                                                                    }
                                                                                                                    if (fld.isAnnotationPresent(Encrypted.class)) {
                                                                                                                        Encrypted enc = fld.getAnnotation(Encrypted.class);
                                                                                                                        Class<? extends ValueEncryptionProvider> encCls = enc.provider();
                                                                                                                        ValueEncryptionProvider ep = encCls.newInstance();
                                                                                                                        String key = enc.keyName();
                                                                                                                        if (key.equals(".")) {
                                                                                                                            key = theClass.getName();
                                                                                                                        }
                                                                                                                        byte[] decKey2 = this.morphium.getEncryptionKeyProvider().getDecryptionKey(key);
                                                                                                                        ep.setDecryptionKey(decKey2);
                                                                                                                        if (valueFromDb instanceof byte[]) {
                                                                                                                            valueFromDb = new String(ep.decrypt((byte[])valueFromDb));
                                                                                                                        } else {
                                                                                                                            if (!(valueFromDb instanceof String)) {
                                                                                                                                throw new RuntimeException("Decryption not possible, value is no byte array or base64 string!");
                                                                                                                            }
                                                                                                                            valueFromDb = new String(ep.decrypt(Base64.getDecoder().decode(valueFromDb.toString())));
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            valueFromDb = this.deserialize(fld.getType(), (String)valueFromDb);
                                                                                                                        }
                                                                                                                        catch (Exception e2) {
                                                                                                                            this.log.debug("Not a json string, cannot deserialize further");
                                                                                                                        }
                                                                                                                        this.annotationHelper.setValue(ret, valueFromDb, f);
                                                                                                                        continue;
                                                                                                                    }
                                                                                                                    value = null;
                                                                                                                    if (Collection.class.isAssignableFrom(fld.getType()) || !fld.isAnnotationPresent(Reference.class)) break block124;
                                                                                                                    reference = fld.getAnnotation(Reference.class);
                                                                                                                    r = null;
                                                                                                                    if (this.morphium != null) break block125;
                                                                                                                    this.log.error("Morphium not set - could not de-reference!");
                                                                                                                    break block120;
                                                                                                                }
                                                                                                                if (!Map.class.isAssignableFrom(fld.getType())) break block126;
                                                                                                                v = new HashMap();
                                                                                                                decKey2 = ((Map)valueFromDb).entrySet().iterator();
                                                                                                                break block127;
                                                                                                            }
                                                                                                            if (!(valueFromDb instanceof Map)) {
                                                                                                                id = valueFromDb;
                                                                                                            } else {
                                                                                                                Map ref = (Map)valueFromDb;
                                                                                                                r = this.deserialize(MorphiumReference.class, ref);
                                                                                                                id = r.getId();
                                                                                                            }
                                                                                                            String collection = this.getCollectionName(fld.getType());
                                                                                                            if (r != null && r.getCollectionName() != null) {
                                                                                                                collection = r.getCollectionName();
                                                                                                            }
                                                                                                            if (id != null) {
                                                                                                                if (reference.lazyLoading()) {
                                                                                                                    List<String> lst2 = this.annotationHelper.getFields(fld.getType(), Id.class);
                                                                                                                    if (lst2.isEmpty()) {
                                                                                                                        throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                                                                                                    }
                                                                                                                    if (id instanceof String && this.annotationHelper.getField(fld.getType(), lst2.get(0)).getType().equals(MorphiumId.class)) {
                                                                                                                        id = new MorphiumId(id.toString());
                                                                                                                    }
                                                                                                                    value = this.morphium.createLazyLoadedEntity(fld.getType(), id, collection);
                                                                                                                    break block120;
                                                                                                                } else {
                                                                                                                    try {
                                                                                                                        value = this.morphium.findById(fld.getType(), id, collection);
                                                                                                                    }
                                                                                                                    catch (MorphiumAccessVetoException e3) {
                                                                                                                        this.log.info("not dereferencing due to veto from listener", (Throwable)e3);
                                                                                                                    }
                                                                                                                }
                                                                                                                break block120;
                                                                                                            } else {
                                                                                                                value = null;
                                                                                                            }
                                                                                                            break block120;
                                                                                                        }
                                                                                                        if (!fld.isAnnotationPresent(Id.class)) break block128;
                                                                                                        value = o.get("_id");
                                                                                                        if (value == null || value.getClass().equals(fld.getType())) break block120;
                                                                                                        this.log.debug("read value and field type differ...");
                                                                                                        if (!fld.getType().equals(MorphiumId.class)) break block129;
                                                                                                        this.log.debug("trying objectID conversion");
                                                                                                        if (value.getClass().equals(String.class)) {
                                                                                                            try {
                                                                                                                value = new MorphiumId((String)value);
                                                                                                            }
                                                                                                            catch (Exception e4) {
                                                                                                                this.log.error("Value and field type differ - Id conversion failed - setting returning null", (Throwable)e4);
                                                                                                                return null;
                                                                                                            }
                                                                                                        }
                                                                                                        break block120;
                                                                                                    }
                                                                                                    if (value.getClass().equals(MorphiumId.class)) {
                                                                                                        if (fld.getType().equals(String.class)) {
                                                                                                            value = value.toString();
                                                                                                            break block120;
                                                                                                        } else {
                                                                                                            if (!fld.getType().equals(Long.class) && !fld.getType().equals(Long.TYPE)) {
                                                                                                                this.log.error("cannot convert - ID IS SET TO NULL. Type read from db is " + value.getClass().getName() + " - expected value is " + fld.getType().getName());
                                                                                                                return null;
                                                                                                            }
                                                                                                            value = ((MorphiumId)value).getTime();
                                                                                                        }
                                                                                                    }
                                                                                                    break block120;
                                                                                                }
                                                                                                if (!this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) break block130;
                                                                                                value = this.deserialize(fld.getType(), (HashMap)valueFromDb);
                                                                                                break block120;
                                                                                            }
                                                                                            if (!Map.class.isAssignableFrom(fld.getType())) break block131;
                                                                                            Map map = (Map)valueFromDb;
                                                                                            HashMap toFill = new HashMap();
                                                                                            if (map != null) {
                                                                                                this.fillMap((ParameterizedType)fld.getGenericType(), map, toFill, ret);
                                                                                            }
                                                                                            value = toFill;
                                                                                            break block120;
                                                                                        }
                                                                                        if (!Collection.class.isAssignableFrom(fld.getType()) && !fld.getType().isArray()) break block132;
                                                                                        lst = new ArrayList<Serializable>();
                                                                                        if (!valueFromDb.getClass().isArray()) break block133;
                                                                                        if (!valueFromDb.getClass().getComponentType().isPrimitive()) break block134;
                                                                                        if (!valueFromDb.getClass().getComponentType().equals(Integer.TYPE)) break block135;
                                                                                        for (Object i : (HashMap)((int[])valueFromDb)) {
                                                                                            lst.add(Integer.valueOf((int)i));
                                                                                        }
                                                                                        break block136;
                                                                                    }
                                                                                    if (!valueFromDb.getClass().getComponentType().equals(Double.TYPE)) break block137;
                                                                                    for (Object i : (HashMap)((double[])valueFromDb)) {
                                                                                        lst.add(Double.valueOf((double)i));
                                                                                    }
                                                                                    break block136;
                                                                                }
                                                                                if (!valueFromDb.getClass().getComponentType().equals(Float.TYPE)) break block138;
                                                                                for (Object i : (HashMap)((float[])valueFromDb)) {
                                                                                    lst.add(Float.valueOf((float)i));
                                                                                }
                                                                                break block136;
                                                                            }
                                                                            if (!valueFromDb.getClass().getComponentType().equals(Boolean.TYPE)) break block139;
                                                                            for (Object i : (HashMap)((boolean[])valueFromDb)) {
                                                                                lst.add(Boolean.valueOf((boolean)i));
                                                                            }
                                                                            break block136;
                                                                        }
                                                                        if (!valueFromDb.getClass().getComponentType().equals(Byte.TYPE)) break block140;
                                                                        for (Object i : (HashMap)((byte[])valueFromDb)) {
                                                                            lst.add(Byte.valueOf((byte)i));
                                                                        }
                                                                        break block136;
                                                                    }
                                                                    if (valueFromDb.getClass().getComponentType().equals(Character.TYPE)) {
                                                                        for (Object i : (HashMap)((char[])valueFromDb)) {
                                                                            lst.add(Character.valueOf((char)i));
                                                                        }
                                                                        break block136;
                                                                    } else if (valueFromDb.getClass().getComponentType().equals(Long.TYPE)) {
                                                                        for (Object i : (HashMap)((long[])valueFromDb)) {
                                                                            lst.add(Long.valueOf((long)i));
                                                                        }
                                                                    }
                                                                    break block136;
                                                                }
                                                                Collections.addAll(lst, (Object[])valueFromDb);
                                                                break block136;
                                                            }
                                                            List l = (List)valueFromDb;
                                                            if (l != null) {
                                                                ParameterizedType type = fld.getGenericType() instanceof ParameterizedType ? (ParameterizedType)fld.getGenericType() : new ParameterizedType(){

                                                                    @Override
                                                                    public Type getRawType() {
                                                                        return Array.class;
                                                                    }

                                                                    @Override
                                                                    public Type getOwnerType() {
                                                                        return null;
                                                                    }

                                                                    @Override
                                                                    public Type[] getActualTypeArguments() {
                                                                        return new Type[]{fld.getType().getComponentType()};
                                                                    }
                                                                };
                                                                this.fillList(fld, fld.getAnnotation(Reference.class), type, l, lst, ret);
                                                            }
                                                        }
                                                        if (!fld.getType().isArray()) break block141;
                                                        arr = Array.newInstance(fld.getType().getComponentType(), lst.size());
                                                        break block142;
                                                    }
                                                    value = lst;
                                                    break block120;
                                                }
                                                if (!fld.getType().isEnum()) break block143;
                                                value = Enum.valueOf(fld.getType(), (String)valueFromDb);
                                                break block120;
                                            }
                                            if (!(valueFromDb instanceof ObjectId)) break block144;
                                            if (!fld.getType().equals(MorphiumId.class)) break block145;
                                            if (valueFromDb instanceof ObjectId) {
                                                value = new MorphiumId(((ObjectId)valueFromDb).toHexString());
                                                break block120;
                                            } else if (valueFromDb instanceof String) {
                                                value = new MorphiumId((String)valueFromDb);
                                                break block120;
                                            } else {
                                                this.log.error("Could not deserialize Value from DB of type " + valueFromDb.getClass().getName() + " and set it to morphiumId");
                                            }
                                            break block120;
                                        }
                                        value = new MorphiumId(((ObjectId)valueFromDb).toByteArray());
                                        break block120;
                                    }
                                    value = valueFromDb;
                                    break block120;
                                }
                                if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                                    flds = this.annotationHelper.getFields(cls, Id.class);
                                    if (flds.isEmpty()) {
                                        throw new RuntimeException("Error - class does not have an ID field!");
                                    }
                                    Field field = this.annotationHelper.getField(cls, flds.get(0));
                                    if (o.get("_id") != null) {
                                        if (o.get("_id").getClass().equals(field.getType())) {
                                            field.set(ret, o.get("_id"));
                                        } else if (field.getType().equals(String.class) && o.get("_id").getClass().equals(MorphiumId.class)) {
                                            this.log.warn("ID type missmatch - field is string but got objectId from mongo - converting");
                                            field.set(ret, o.get("_id").toString());
                                        } else if (field.getType().equals(MorphiumId.class) && o.get("_id").getClass().equals(ObjectId.class)) {
                                            field.set(ret, new MorphiumId(((ObjectId)o.get("_id")).toByteArray()));
                                        } else if (field.getType().equals(ObjectId.class) && o.get("_id").getClass().equals(MorphiumId.class)) {
                                            field.set(ret, new ObjectId(((MorphiumId)o.get("_id")).getBytes()));
                                        } else if (field.getType().equals(ObjectId.class) && o.get("_id").getClass().equals(String.class)) {
                                            field.set(ret, new ObjectId(((ObjectId)o.get("_id")).toString()));
                                        } else if (field.getType().equals(MorphiumId.class) && o.get("_id").getClass().equals(String.class)) {
                                            field.set(ret, new MorphiumId((String)o.get("_id")));
                                        } else {
                                            this.log.error("ID type missmatch");
                                            throw new IllegalArgumentException("ID type missmatch. Field in '" + ret.getClass().toString() + "' is '" + field.getType().toString() + "' but we got '" + o.get("_id").getClass().toString() + "' from Mongo!");
                                        }
                                    }
                                }
                                if (ret instanceof BinarySerializedObject) {
                                    BinarySerializedObject bso = (BinarySerializedObject)ret;
                                    Base64.Decoder dec = Base64.getMimeDecoder();
                                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(bso.getB64Data())));
                                    return (T)in.readObject();
                                }
                                return (T)ret;
                            }
                            while (iterator.hasNext()) {
                                String k = iterator.next();
                                if (flds.contains(k) || k.equals("_id")) continue;
                                if (o.get(k) instanceof Map) {
                                    if (((Map)o.get(k)).get("class_name") != null) {
                                        data.put(k, this.deserialize(this.annotationHelper.getClassForTypeId((String)((Map)o.get(k)).get("class_name")), (Map)o.get(k)));
                                        continue;
                                    }
                                    data.put(k, this.deserializeMap((Map)o.get(k)));
                                    continue;
                                }
                                if (o.get(k) instanceof List && !((List)o.get(k)).isEmpty() && ((List)o.get(k)).get(0) instanceof Map) {
                                    data.put(k, this.deserializeList((List)o.get(k)));
                                    continue;
                                }
                                data.put(k, o.get(k));
                            }
                            fld.set(ret, data);
                            continue;
                        }
                        while (decKey2.hasNext()) {
                            Object id;
                            Map.Entry e5 = decKey2.next();
                            if (!(e5.getValue() instanceof Map)) {
                                id = e5.getValue();
                                r = null;
                            } else {
                                Map ref = (Map)e5.getValue();
                                r = this.deserialize(MorphiumReference.class, ref);
                                id = r.getId();
                            }
                            String collectionName = null;
                            Class type = fld.getType();
                            if (r != null) {
                                collectionName = r.getCollectionName() != null ? r.getCollectionName() : this.getCollectionName(this.annotationHelper.getClassForTypeId(r.getClassName()));
                                type = this.annotationHelper.getClassForTypeId(r.getClassName());
                            } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class)) {
                                collectionName = this.getCollectionName(fld.getType());
                            }
                            if (collectionName == null) {
                                throw new IllegalArgumentException("Could not create reference!");
                            }
                            if (reference.lazyLoading()) {
                                List<String> lst3 = this.annotationHelper.getFields(fld.getType(), Id.class);
                                if (lst3.isEmpty()) {
                                    throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                }
                                if (id instanceof String && this.annotationHelper.getField(fld.getType(), lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(id.toString());
                                } else if (id instanceof ObjectId && this.annotationHelper.getField(fld.getType(), lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(((ObjectId)id).toByteArray());
                                }
                                value = this.morphium.createLazyLoadedEntity(fld.getType(), id, collectionName);
                            } else {
                                try {
                                    value = this.morphium.findById(type, id, collectionName);
                                }
                                catch (MorphiumAccessVetoException ex) {
                                    this.log.info("not dereferencing due to veto from listener", (Throwable)ex);
                                }
                            }
                            v.put(e5.getKey(), value);
                        }
                        value = v;
                        break block120;
                    }
                    for (int i = 0; i < lst.size(); ++i) {
                        if (fld.getType().getComponentType().isPrimitive()) {
                            if (fld.getType().getComponentType().equals(Integer.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).intValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, (Integer)lst.get(i));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).intValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Long.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, (Long)lst.get(i));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Float.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, Float.valueOf(((Double)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, Float.valueOf(((Integer)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, Float.valueOf(((Long)lst.get(i)).floatValue()));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Double.TYPE)) {
                                if (lst.get(i) instanceof Float) {
                                    Array.set(arr, i, ((Float)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).doubleValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Byte.TYPE)) {
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).byteValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).byteValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (!fld.getType().getComponentType().equals(Boolean.TYPE)) continue;
                            if (lst.get(i) instanceof String) {
                                Array.set(arr, i, lst.get(i).toString().equalsIgnoreCase("true"));
                                continue;
                            }
                            if (lst.get(i) instanceof Integer) {
                                Array.set(arr, i, (Integer)lst.get(i) == 1);
                                continue;
                            }
                            Array.set(arr, i, lst.get(i));
                            continue;
                        }
                        Array.set(arr, i, lst.get(i));
                    }
                    value = arr;
                }
                this.annotationHelper.setValue(ret, value, f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map deserializeMap(Map<String, Object> dbObject) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(dbObject);
        if (dbObject != null) {
            for (String n : dbObject.keySet()) {
                retMap.put(n, this.unmarshallInternal(dbObject.get(n)));
            }
        } else {
            retMap = null;
        }
        return retMap;
    }

    private Object unmarshallInternal(Object val) {
        block13: {
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                if (mapVal.containsKey("class_name") || mapVal.containsKey("className")) {
                    String cn = (String)mapVal.get("class_name");
                    if (cn == null) {
                        cn = (String)mapVal.get("className");
                    }
                    try {
                        Class ecls = this.annotationHelper.getClassForTypeId(cn);
                        Object obj = this.deserialize(ecls, mapVal);
                        if (obj != null) {
                            return obj;
                        }
                        break block13;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (mapVal.containsKey("_b64data") || mapVal.containsKey("b64Data")) {
                    String d = (String)mapVal.get("_b64data");
                    if (d == null) {
                        d = (String)mapVal.get("b64Data");
                    }
                    Base64.Decoder dec = Base64.getMimeDecoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decode(d)));
                        return in.readObject();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.deserializeMap(mapVal);
            }
            if (val instanceof ObjectId) {
                val = new MorphiumId(((ObjectId)val).toByteArray());
            } else if (val instanceof List) {
                List lst = (List)val;
                return this.deserializeList(lst);
            }
        }
        return val;
    }

    public List deserializeList(List<Map<String, Object>> lst) {
        return lst.stream().map(this::unmarshallInternal).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void fillList(Field forField, Reference ref, ParameterizedType listType, List<Map<String, Object>> fromDB, List toFillIn, Object containerEntity) {
        fromDB = new ArrayList<Map<String, Object>>(fromDB);
        if (ref != null) {
            Iterator<Map<String, Object>> iterator = fromDB.iterator();
            while (iterator.hasNext()) {
                Class type;
                Map<String, Object> obj = iterator.next();
                if (obj == null) {
                    toFillIn.add(null);
                    continue;
                }
                MorphiumReference r = this.deserialize(MorphiumReference.class, obj);
                try {
                    type = this.annotationHelper.getClassForTypeId(r.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (r.getCollectionName() == null) {
                    r.setCollectionName(this.getCollectionName(type));
                }
                if (ref.lazyLoading()) {
                    if (r.getId() instanceof String && this.morphium.getARHelper().getIdField(type).getType().equals(MorphiumId.class)) {
                        r.setId(new MorphiumId(r.getId().toString()));
                    }
                    toFillIn.add(this.morphium.createLazyLoadedEntity(type, r.getId(), r.getCollectionName()));
                    continue;
                }
                toFillIn.add(this.morphium.findById(type, r.getId(), r.getCollectionName()));
            }
            return;
        }
        Iterator<Map<String, Object>> iterator = fromDB.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> val;
            block24: {
                val = iterator.next();
                if (val instanceof Map) {
                    boolean cont = false;
                    if (cont) continue;
                    if (val.containsKey("class_name") || val.containsKey("className")) {
                        String cn = (String)val.get("class_name");
                        if (cn == null) {
                            cn = (String)val.get("className");
                        }
                        try {
                            Class ecls = this.annotationHelper.getClassForTypeId(cn);
                            Object um = this.deserialize(ecls, val);
                            if (um == null) continue;
                            toFillIn.add(um);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not find class", e);
                        }
                    }
                    if (listType != null) {
                        Class cls = this.getElementClass(listType);
                        if (Map.class.isAssignableFrom(cls)) {
                            HashMap mp = new HashMap();
                            this.fillMap((ParameterizedType)listType.getActualTypeArguments()[0], val, mp, containerEntity);
                            toFillIn.add(mp);
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
                        if (entity != null || embedded != null) {
                            toFillIn.add(this.deserialize(cls, val));
                            continue;
                        }
                        break block24;
                    } else {
                        HashMap mp = new HashMap();
                        if (listType != null) {
                            this.fillMap((ParameterizedType)listType.getActualTypeArguments()[0], val, mp, containerEntity);
                            toFillIn.add(mp);
                            continue;
                        }
                        this.log.warn("Cannot de-reference to unknown collection type - trying object instead");
                        toFillIn.add(val);
                        continue;
                    }
                }
                if (val instanceof List) {
                    if (listType != null) {
                        ArrayList lt = new ArrayList();
                        Class lstt = null;
                        try {
                            lstt = this.annotationHelper.getClassForTypeId(listType.getActualTypeArguments()[0].getTypeName());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (lstt == null || lstt.isAssignableFrom(List.class)) {
                            this.fillList(forField, ref, (ParameterizedType)listType.getActualTypeArguments()[0], (List)((Object)val), lt, containerEntity);
                            toFillIn.add(lt);
                            continue;
                        }
                        this.fillList(forField, ref, listType, (List)((Object)val), toFillIn, containerEntity);
                        continue;
                    }
                    this.log.warn("Cannot de-reference to unknown collection - trying to add Object only");
                    toFillIn.add(val);
                    continue;
                }
            }
            toFillIn.add(this.unmarshallInternal(val));
        }
    }

    private Class getElementClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[parameters.length - 1];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return this.annotationHelper.getClassForTypeId(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        this.log.error("Could not determin type of element!");
        return Object.class;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillMap(ParameterizedType mapType, Map<String, Object> fromDB, Map toFillIn, Object containerEntity) {
        Iterator<Map.Entry<String, Object>> iterator = fromDB.entrySet().iterator();
        while (true) {
            Object val;
            String key;
            block10: {
                if (!iterator.hasNext()) {
                    return;
                }
                Map.Entry<String, Object> entry = iterator.next();
                key = entry.getKey();
                val = entry.getValue();
                if (val instanceof Map) {
                    if (mapType != null) {
                        Class cls = this.getElementClass(mapType);
                        if (Map.class.isAssignableFrom(cls)) {
                            HashMap mp = new HashMap();
                            this.fillMap((ParameterizedType)mapType.getActualTypeArguments()[1], (Map)val, mp, containerEntity);
                            toFillIn.put(key, mp);
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
                        if (entity != null || embedded != null) {
                            toFillIn.put(key, this.deserialize(cls, (Map)val));
                            continue;
                        }
                        break block10;
                    } else {
                        HashMap mp = new HashMap();
                        this.fillMap((ParameterizedType)mapType.getActualTypeArguments()[1], (Map)val, mp, containerEntity);
                        toFillIn.put(key, mp);
                        continue;
                    }
                }
                if (val instanceof List) {
                    ArrayList lt = new ArrayList();
                    if (mapType.getActualTypeArguments()[1] instanceof ParameterizedType) {
                        this.fillList(null, null, (ParameterizedType)mapType.getActualTypeArguments()[1], (List)val, lt, containerEntity);
                    } else {
                        this.fillList(null, null, null, (List)val, lt, containerEntity);
                    }
                    toFillIn.put(key, lt);
                    continue;
                }
            }
            toFillIn.put(key, this.unmarshallInternal(val));
        }
    }
}

