/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.jms.Consumer;
import de.caluga.morphium.messaging.jms.Producer;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class Context
implements JMSContext {
    private final int sessionMode;
    private final Morphium morphium;
    private final Messaging messaging;
    private boolean startOnCosumerCreate = true;

    public Context(Morphium morphium, String name, int sessionMode) {
        this.morphium = morphium;
        this.sessionMode = sessionMode;
        this.messaging = new Messaging(morphium, 100, true, true, 10);
        if (name != null) {
            this.messaging.setQueueName(name);
        }
    }

    public Context(Morphium morphium) {
        this(morphium, null, 2);
    }

    public JMSContext createContext(int sessionMode) {
        return new Context(this.morphium, null, sessionMode);
    }

    public JMSProducer createProducer() {
        return new Producer(this.messaging);
    }

    public String getClientID() {
        return null;
    }

    public void setClientID(String clientID) {
        this.messaging.setSenderId(clientID);
    }

    public ConnectionMetaData getMetaData() {
        return null;
    }

    public ExceptionListener getExceptionListener() {
        return null;
    }

    public void setExceptionListener(ExceptionListener listener) {
    }

    public void start() {
        this.messaging.start();
    }

    public void stop() {
        this.messaging.terminate();
    }

    public boolean getAutoStart() {
        return this.startOnCosumerCreate;
    }

    public void setAutoStart(boolean autoStart) {
        this.startOnCosumerCreate = autoStart;
    }

    public void close() {
        this.stop();
    }

    public BytesMessage createBytesMessage() {
        return null;
    }

    public MapMessage createMapMessage() {
        return null;
    }

    public Message createMessage() {
        return null;
    }

    public ObjectMessage createObjectMessage() {
        return null;
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return null;
    }

    public StreamMessage createStreamMessage() {
        return null;
    }

    public TextMessage createTextMessage() {
        return null;
    }

    public TextMessage createTextMessage(String text) {
        return null;
    }

    public boolean getTransacted() {
        return false;
    }

    public int getSessionMode() {
        return 0;
    }

    public void commit() {
    }

    public void rollback() {
    }

    public void recover() {
    }

    public JMSConsumer createConsumer(Destination destination) {
        if (this.startOnCosumerCreate) {
            this.start();
        }
        return new Consumer(this.messaging, destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return null;
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return null;
    }

    public Queue createQueue(String queueName) {
        return null;
    }

    public Topic createTopic(String topicName) {
        return null;
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return null;
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return null;
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return null;
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return null;
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return null;
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return null;
    }

    public QueueBrowser createBrowser(Queue queue) {
        return null;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return null;
    }

    public TemporaryQueue createTemporaryQueue() {
        return null;
    }

    public TemporaryTopic createTemporaryTopic() {
        return null;
    }

    public void unsubscribe(String name) {
    }

    public void acknowledge() {
    }
}

