/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterExpression {
    private String field;
    private Object value;
    private List<FilterExpression> children;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public List<FilterExpression> getChildren() {
        return this.children;
    }

    public void setChildren(List<FilterExpression> children) {
        this.children = children;
    }

    public void addChild(FilterExpression e) {
        if (this.children == null) {
            this.children = new ArrayList<FilterExpression>();
        }
        this.children.add(e);
    }

    public Map<String, Object> dbObject() {
        HashMap<String, Object> o = new HashMap<String, Object>();
        if (this.children != null) {
            HashMap<String, Object> expression = new HashMap<String, Object>();
            for (FilterExpression flt : this.children) {
                expression.put(flt.getField(), flt.getValue());
            }
            o.put(this.field, expression);
        } else if (this.value != null && this.value.getClass().isEnum()) {
            o.put(this.field, ((Enum)this.value).name());
        } else {
            o.put(this.field, this.value);
        }
        return o;
    }

    public String toString() {
        StringBuilder c = new StringBuilder();
        if (this.children != null && !this.children.isEmpty()) {
            c.append("[ ");
            for (FilterExpression fe : this.children) {
                c.append(fe.toString());
                c.append(", ");
            }
            c.deleteCharAt(c.length() - 1);
            c.deleteCharAt(c.length() - 1);
            c.append(" ]");
        }
        return "FilterExpression{field='" + this.field + '\'' + ", value=" + this.value + ", children=" + c.toString() + '}';
    }
}

