/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheListener;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.jcache.CacheEntry;
import de.caluga.morphium.cache.jcache.CachingProviderImpl;
import de.caluga.morphium.cache.jcache.HouseKeepingHelper;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.expiry.EternalExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumCacheJCacheImpl
implements MorphiumCache,
CacheEntryExpiredListener<Object, CacheEntry>,
CacheEntryCreatedListener<Object, CacheEntry>,
CacheEntryRemovedListener<Object, CacheEntry>,
CacheEntryUpdatedListener<Object, CacheEntry> {
    public static final String RESULT_CACHE_NAME = "resultCache";
    public static final String ID_CACHE_NAME = "idCache";
    private CacheManager cacheManager;
    private final Map<Class<?>, javax.cache.Cache> idCaches = new HashMap();
    private final Map<Class<?>, javax.cache.Cache> resultCaches = new HashMap();
    private AnnotationAndReflectionHelper anHelper = new AnnotationAndReflectionHelper(false);
    private final List<CacheListener> cacheListeners = new Vector<CacheListener>();
    private final Logger log = LoggerFactory.getLogger(MorphiumCacheJCacheImpl.class);
    private final ScheduledThreadPoolExecutor housekeeping = new ScheduledThreadPoolExecutor(1);
    private final HouseKeepingHelper hkHelper = new HouseKeepingHelper();
    private final Runnable hkTask;
    private boolean cacheListenerRegistered = false;

    public MorphiumCacheJCacheImpl() {
        MorphiumConfig cfg = new MorphiumConfig();
        this.hkHelper.setGlobalValidCacheTime(cfg.getGlobalCacheValidTime());
        this.hkHelper.setAnnotationHelper(new AnnotationAndReflectionHelper(false));
        this.hkTask = () -> {
            for (String k : this.getCacheManager().getCacheNames()) {
                this.hkHelper.housekeep(this.getCacheManager().getCache(k), this.cacheListeners);
            }
        };
        this.housekeeping.scheduleWithFixedDelay(this.hkTask, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.resultCaches.clear();
        this.idCaches.clear();
    }

    @Override
    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            try {
                this.cacheManager = Caching.getCachingProvider().getCacheManager();
            }
            catch (Exception e) {
                this.log.info("using default cache Manager - " + e.getMessage());
                this.cacheManager = new CachingProviderImpl().getCacheManager();
            }
        }
        return this.cacheManager;
    }

    @Override
    public <T> void addToCache(String k, Class<? extends T> type, List<T> ret) {
        javax.cache.Cache<Object, CacheEntry<? extends T>> idCache = this.getIdCache(type);
        javax.cache.Cache<Object, CacheEntry<List<? extends T>>> resultCache = this.getResultCache(type);
        CacheEntry<List<Object>> v = new CacheEntry<List<T>>(ret, k);
        for (CacheListener cl : this.cacheListeners) {
            v = cl.wouldAddToCache(k, v, false);
            if (v != null) continue;
            this.log.warn("Not adding null entry to cache - veto by listener");
        }
        for (CacheListener obj : ret) {
            Object id = this.anHelper.getId(obj);
            if (idCache.containsKey(id)) continue;
            idCache.put(id, new CacheEntry<CacheListener>(obj, id));
        }
        resultCache.put((Object)k, v);
    }

    @Override
    public Map<String, Integer> getSizes() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String n : this.getCacheManager().getCacheNames()) {
            javax.cache.Cache c = this.getCacheManager().getCache(n);
            try {
                Method m = c.getClass().getMethod("getSize", new Class[0]);
                ret.put(n, (Integer)m.invoke((Object)c, new Object[0]));
            }
            catch (Exception e) {
                Iterator iterator = c.iterator();
                int size = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    ++size;
                }
                ret.put(n, size);
            }
        }
        return ret;
    }

    @Override
    public String getCacheKey(Class type, Map<String, Object> qo, Map<String, Integer> sort, Map<String, Object> projection, String collection, int skip, int limit) {
        return Utils.getCacheKey(type, qo, sort, projection, collection, skip, limit, this.anHelper);
    }

    @Override
    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        javax.cache.Cache<Object, CacheEntry<List<? extends T>>> resultCache = this.getResultCache(type);
        if (resultCache.get((Object)k) != null) {
            return (List)((CacheEntry)resultCache.get((Object)k)).getResult();
        }
        return null;
    }

    @Override
    public Set<Class<?>> getCachedTypes() {
        return this.idCaches.keySet();
    }

    private <T> javax.cache.Cache<Object, CacheEntry<T>> getIdCache(Class<? extends T> type) {
        javax.cache.Cache cache;
        if (this.idCaches.containsKey(type)) {
            return this.idCaches.get(type);
        }
        this.log.info("Creating new cache for " + type.getName());
        MutableConfiguration config = new MutableConfiguration().setTypes(Object.class, Object.class).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf()).setStoreByValue(false).setStatisticsEnabled(false);
        try {
            cache = this.getCacheManager().createCache("idCache|" + type.getName(), (Configuration)config);
        }
        catch (Exception e) {
            cache = this.getCacheManager().getCache("idCache|" + type.getName());
        }
        this.idCaches.put(type, cache);
        return cache;
    }

    private <T> javax.cache.Cache<Object, CacheEntry<List<T>>> getResultCache(Class<? extends T> type) {
        javax.cache.Cache cache;
        if (this.resultCaches.containsKey(type)) {
            return this.resultCaches.get(type);
        }
        this.log.info("Creating new cache for " + type.getName());
        MutableConfiguration config = new MutableConfiguration().setTypes(Object.class, Object.class).setStoreByValue(false).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf()).setStatisticsEnabled(false);
        try {
            cache = this.getCacheManager().createCache("resultCache|" + type.getName(), (Configuration)config);
        }
        catch (Exception e) {
            cache = this.getCacheManager().getCache("resultCache|" + type.getName());
        }
        this.resultCaches.put(type, cache);
        return cache;
    }

    @Override
    public void clearCachefor(Class<?> cls) {
        for (CacheListener cl : this.cacheListeners) {
            if (cl.wouldClearCache(cls)) continue;
            this.log.warn("Veto from listener for clearing cache for " + cls.getName());
            return;
        }
        this.getIdCache(cls).clear();
        this.getResultCache(cls).clear();
    }

    @Override
    public void resetCache() {
        this.getCacheManager().close();
    }

    @Override
    public void removeEntryFromIdCache(Class cls, Object id) {
        for (CacheListener cl : this.cacheListeners) {
            if (cl.wouldRemoveEntryFromCache(id, (CacheEntry)this.getIdCache(cls).get(id), false)) continue;
            this.log.info("Veto from listener for ID " + id);
        }
        this.getIdCache(cls).remove(id);
    }

    @Override
    public void removeEntryFromCache(Class cls, Object id) {
        Object obj = this.getIdCache(cls).get(id);
        if (obj != null) {
            this.getIdCache(cls).remove(id);
        }
        HashSet<Object> toRemove = new HashSet<Object>();
        for (Cache.Entry entry : this.getResultCache(cls)) {
            for (Object el : (List)((CacheEntry)entry.getValue()).getResult()) {
                Object lid = this.anHelper.getId(el);
                for (CacheListener cl : this.cacheListeners) {
                    if (cl.wouldRemoveEntryFromCache(entry.getKey(), (CacheEntry)entry.getValue(), false)) continue;
                    this.log.warn("Veto from listener for ID " + id);
                }
                if (lid == null) {
                    this.log.error("Null id in CACHE?");
                    toRemove.add(entry.getKey());
                }
                if (lid == null || !lid.equals(id)) continue;
                toRemove.add(entry.getKey());
            }
        }
        this.getResultCache(cls).removeAll(toRemove);
    }

    @Override
    public <T> T getFromIDCache(Class<? extends T> type, Object id) {
        javax.cache.Cache<Object, CacheEntry<? extends T>> c = this.getIdCache(type);
        if (!c.containsKey(id)) {
            return null;
        }
        return ((CacheEntry)c.get(id)).getResult();
    }

    @Override
    public String getCacheKey(Query q) {
        return this.getCacheKey(q.getType(), q.toQueryObject(), q.getSort(), q.getFieldListForQuery(), q.getCollectionName(), q.getSkip(), q.getLimit());
    }

    @Override
    public boolean isCached(Class<?> type, String k) {
        return this.getResultCache(type).containsKey((Object)k);
    }

    @Override
    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.anHelper.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            for (CacheListener cl : this.cacheListeners) {
                if (cl.wouldClearCache(cls)) continue;
                this.log.warn("Veto from listener for clearing cache for " + cls.getName());
            }
            this.clearCachefor(cls);
        }
    }

    @Override
    public void addCacheListener(CacheListener cl) {
        this.cacheListeners.add(cl);
    }

    @Override
    public void removeCacheListener(CacheListener cl) {
        this.cacheListeners.remove(cl);
    }

    @Override
    public boolean isListenerRegistered(CacheListener cl) {
        return this.cacheListeners.contains(cl);
    }

    @Override
    public void setGlobalCacheTimeout(int tm) {
        this.hkHelper.setGlobalValidCacheTime(tm);
    }

    @Override
    public void setAnnotationAndReflectionHelper(AnnotationAndReflectionHelper hlp) {
        this.anHelper = hlp;
    }

    @Override
    public void setHouskeepingIntervalPause(int p) {
        this.housekeeping.remove(this.hkTask);
        this.housekeeping.scheduleAtFixedRate(this.hkTask, p, p, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setValidCacheTime(Class type, int time) {
        this.hkHelper.setValidCacheTime(type, time);
    }

    @Override
    public void setDefaultCacheTime(Class type) {
        this.hkHelper.setDefaultValidCacheTime(type);
    }

    public void onCreated(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldAddToCache(evt.getKey(), (CacheEntry)evt.getValue(), false);
            });
        }
    }

    public void onExpired(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldRemoveEntryFromCache(evt.getKey(), (CacheEntry)evt.getValue(), true);
            });
        }
    }

    public void onRemoved(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                if (evt.getKey() == null) {
                    try {
                        cl.wouldClearCache(Class.forName(evt.getSource().getCacheManager().getURI().toString()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheEntryListenerException("Could not get type", (Throwable)e);
                    }
                } else {
                    cl.wouldRemoveEntryFromCache(evt.getKey(), (CacheEntry)evt.getValue(), false);
                }
            });
        }
    }

    public void onUpdated(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldAddToCache(evt.getKey(), (CacheEntry)evt.getValue(), true);
            });
        }
    }
}

