/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.AbstractCacheSynchronizer;
import de.caluga.morphium.cache.CacheSyncVetoException;
import de.caluga.morphium.cache.MessagingCacheSyncListener;
import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.Msg;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;

public class MessagingCacheSynchronizer
extends AbstractCacheSynchronizer<MessagingCacheSyncListener>
implements MessageListener,
MorphiumStorageListener<Object> {
    public static final String CACHE_SYNC_TYPE = "cacheSyncType";
    public static final String CACHE_SYNC_RECORD = "cacheSyncRecord";
    private Messaging messaging;
    private boolean attached;
    private AnnotationAndReflectionHelper annotationHelper;
    private boolean commitMessage = false;

    public MessagingCacheSynchronizer(Messaging msg, Morphium morphium) {
        super(morphium);
        this.messaging = msg;
        this.annotationHelper = morphium.getARHelper();
        morphium.addListener(this);
        this.messaging.addListenerForMessageNamed(CACHE_SYNC_TYPE, this);
        this.messaging.addListenerForMessageNamed(CACHE_SYNC_RECORD, this);
        this.attached = true;
    }

    public void sendClearMessage(String reason, Map<Object, Boolean> isNew) {
        Cache c;
        HashMap sorted = new HashMap();
        for (Object record2 : isNew.keySet()) {
            c = this.annotationHelper.getAnnotationFromHierarchy(record2.getClass(), Cache.class);
            if (c == null || !c.readCache() || !c.clearOnWrite()) continue;
            if (sorted.get(record2.getClass()) == null) {
                sorted.put(record2.getClass(), new HashMap());
                ((Map)sorted.get(record2.getClass())).put(true, new ArrayList());
                ((Map)sorted.get(record2.getClass())).put(false, new ArrayList());
            }
            ((List)((Map)sorted.get(record2.getClass())).get(isNew.get(record2))).add(record2);
        }
        for (Class cls : sorted.keySet()) {
            c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class);
            ArrayList toUpdate = new ArrayList();
            ArrayList toClrCachee = new ArrayList();
            for (Object record3 : (List)((Map)sorted.get(cls)).get(false)) {
                if (c.syncCache().equals((Object)Cache.SyncCacheStrategy.UPDATE_ENTRY) || c.syncCache().equals((Object)Cache.SyncCacheStrategy.REMOVE_ENTRY_FROM_TYPE_CACHE)) {
                    toUpdate.add(record3);
                    continue;
                }
                if (!c.syncCache().equals((Object)Cache.SyncCacheStrategy.CLEAR_TYPE_CACHE)) continue;
                toClrCachee.add(record3);
            }
            toClrCachee.addAll(((List)((Map)sorted.get(cls)).get(true)).stream().filter(record -> c.syncCache().equals((Object)Cache.SyncCacheStrategy.CLEAR_TYPE_CACHE)).collect(Collectors.toList()));
            Msg m = null;
            if (!toUpdate.isEmpty()) {
                m = new Msg(CACHE_SYNC_RECORD, reason, cls.getName(), 30000L);
            } else if (!toClrCachee.isEmpty()) {
                m = new Msg(CACHE_SYNC_TYPE, reason, cls.getName(), 30000L);
            }
            if (m == null) continue;
            Msg finalM = m;
            toUpdate.stream().filter(k -> !k.getClass().equals(Msg.class)).forEach(k -> {
                Object id = this.morphium.getId(k);
                if (id != null) {
                    finalM.addAdditional(id.toString());
                }
            });
            try {
                this.firePreSendEvent(cls, m);
                this.messaging.queueMessage(m);
                this.firePostSendEvent(cls, m);
            }
            catch (CacheSyncVetoException e) {
                log.warn("could not send clear cache message: Veto by listener!", (Throwable)e);
            }
        }
    }

    public void sendClearMessage(Class type, String reason) {
        this.sendClearMessage(type, reason, false);
    }

    public void sendClearMessage(Class type, String reason, boolean force) {
        if (type.equals(Msg.class)) {
            return;
        }
        Msg m = new Msg(CACHE_SYNC_TYPE, reason, type.getName(), 30000L);
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(type, Cache.class);
        if (c == null) {
            return;
        }
        if (c.readCache() && c.clearOnWrite() && !c.syncCache().equals((Object)Cache.SyncCacheStrategy.NONE) || force) {
            try {
                this.firePreSendEvent(type, m);
                this.messaging.queueMessage(m);
                this.firePostSendEvent(type, m);
            }
            catch (CacheSyncVetoException e) {
                log.error("could not send clear message: Veto!", (Throwable)e);
            }
        }
    }

    public void detach() {
        this.attached = false;
        this.morphium.removeListener(this);
        this.messaging.removeListenerForMessageNamed(CACHE_SYNC_TYPE, this);
        this.messaging.removeListenerForMessageNamed(CACHE_SYNC_RECORD, this);
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void sendClearAllMessage(String reason) {
        Msg m = new Msg(CACHE_SYNC_TYPE, reason, "ALL", 30000L);
        try {
            this.firePreSendEvent(null, m);
            this.messaging.queueMessage(m);
            this.firePostSendEvent(null, m);
        }
        catch (CacheSyncVetoException e) {
            log.error("Got veto before clearing cache", (Throwable)e);
        }
    }

    @Override
    public void preStore(Morphium m, Object r, boolean isNew) throws MorphiumAccessVetoException {
    }

    @Override
    public void preStore(Morphium m, Map<Object, Boolean> isNew) throws MorphiumAccessVetoException {
    }

    @Override
    public void postStore(Morphium m, Object r, boolean isNew) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
        map.put(r, isNew);
        this.sendClearMessage("store", map);
    }

    @Override
    public void postStore(Morphium m, Map<Object, Boolean> isNew) throws MorphiumAccessVetoException {
        this.sendClearMessage("storeBulk", isNew);
    }

    @Override
    public void postDrop(Morphium m, Class cls) {
        this.sendClearMessage(cls, "drop");
    }

    @Override
    public void preDrop(Morphium m, Class cls) {
        this.sendClearMessage(cls, "remove");
    }

    @Override
    public void postRemove(Morphium m, Object r) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
        map.put(r, false);
        this.sendClearMessage("remove", map);
    }

    @Override
    public void postRemove(Morphium m, List<Object> lst) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
        for (Object r : lst) {
            map.put(r, false);
        }
        this.sendClearMessage("remove", map);
    }

    public void firePostSendEvent(Class type, Msg m) {
        for (MessagingCacheSyncListener cl : this.listeners) {
            cl.postSendClearMsg(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (MessagingCacheSyncListener cl : (Vector)this.listenerForType.get(type)) {
                cl.postSendClearMsg(type, m);
            }
        }
    }

    public void firePreSendEvent(Class type, Msg m) throws CacheSyncVetoException {
        for (MessagingCacheSyncListener cl : this.listeners) {
            cl.preSendClearMsg(type, m);
        }
        if (type == null) {
            return;
        }
        if (this.listenerForType.get(type) != null) {
            for (MessagingCacheSyncListener cl : (Vector)this.listenerForType.get(type)) {
                cl.preSendClearMsg(type, m);
            }
        }
    }

    @Override
    public void preRemove(Morphium m, Query<Object> q) throws MorphiumAccessVetoException {
    }

    @Override
    public void preRemove(Morphium m, Object r) throws MorphiumAccessVetoException {
    }

    @Override
    public void postLoad(Morphium m, Object o) throws MorphiumAccessVetoException {
    }

    @Override
    public void postLoad(Morphium m, List<Object> o) throws MorphiumAccessVetoException {
    }

    @Override
    public void preUpdate(Morphium m, Class<?> cls, Enum updateType) throws MorphiumAccessVetoException {
    }

    @Override
    public void postRemove(Morphium m, Query q) {
        this.sendClearMessage(q.getType(), "remove");
    }

    @Override
    public void postUpdate(Morphium m, Class cls, Enum updateType) {
        this.sendClearMessage(cls, "Update: " + updateType.name());
    }

    public Msg onMessage(Messaging msg, Msg m) {
        Msg answer;
        block23: {
            answer = new Msg("clearCacheAnswer", "processed", this.messaging.getSenderId());
            try {
                Cache c;
                Class<?> cls;
                if (log.isDebugEnabled()) {
                    String action = m.getMsg();
                    String sender = m.getSender();
                    log.debug("Got message " + m.getName() + " from " + sender + " - Action: " + action + " Class: " + m.getValue());
                }
                if (m.getName().equals(CACHE_SYNC_TYPE)) {
                    if (m.getValue().equals("ALL")) {
                        try {
                            this.firePreClearEvent(null);
                            this.morphium.getCache().resetCache();
                            this.firePostClearEvent(null);
                            answer.setMsg("cache completely cleared");
                            log.info("Cache completely cleared");
                        }
                        catch (CacheSyncVetoException e) {
                            log.error("Could not clear whole cache - Veto!", (Throwable)e);
                        }
                        return answer;
                    }
                    cls = Class.forName(m.getValue());
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                        c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class);
                        if (c != null) {
                            if (c.readCache()) {
                                try {
                                    this.firePreClearEvent(cls);
                                    this.morphium.clearCachefor(cls);
                                    answer.setMsg("cache cleared for type: " + m.getValue());
                                    this.firePostClearEvent(cls);
                                }
                                catch (CacheSyncVetoException e) {
                                    log.error("Could not clear cache! Got Veto", (Throwable)e);
                                }
                            } else {
                                log.warn("trying to clear cache for uncached enitity or one where clearOnWrite is false");
                                answer.setMsg("type is uncached or clearOnWrite is false: " + m.getValue());
                            }
                        }
                    } else {
                        log.warn("Trying to clear cache for none-Entity?????");
                        answer.setMsg("cannot clear cache for non-entyty type: " + m.getValue());
                    }
                    break block23;
                }
                cls = Class.forName(m.getValue());
                if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class) && (c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class)) != null) {
                    if (c.readCache()) {
                        try {
                            this.firePreClearEvent(cls);
                            for (Object id : m.getAdditional()) {
                                Object toUpdate = this.morphium.getCache().getFromIDCache(cls, id);
                                if (toUpdate == null) continue;
                                if (c.syncCache().equals((Object)Cache.SyncCacheStrategy.REMOVE_ENTRY_FROM_TYPE_CACHE)) {
                                    this.morphium.getCache().removeEntryFromCache(cls, id);
                                    continue;
                                }
                                this.morphium.reread(this.morphium.getCache().getFromIDCache(cls, id));
                            }
                            answer.setMsg("cache cleared for type: " + m.getValue());
                            this.firePostClearEvent(cls);
                        }
                        catch (CacheSyncVetoException e) {
                            log.error("Not clearing id cache: Veto", (Throwable)e);
                        }
                    } else {
                        log.warn("trying to clear cache for uncached enitity or one where clearOnWrite is false");
                        answer.setMsg("type is uncached or clearOnWrite is false: " + m.getValue());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                log.warn("Could not process message for class " + m.getValue() + " - not found!");
                answer.setMsg("class not found: " + m.getValue());
            }
            catch (Throwable MessagingCacheSyncListener2) {
                log.error("Could not process message: ", MessagingCacheSyncListener2);
                answer.setMsg("Error processing message: " + MessagingCacheSyncListener2.getMessage());
            }
        }
        if (!this.commitMessage) {
            return null;
        }
        return answer;
    }

    public void disableCommitMessages() {
        this.commitMessage = false;
    }

    public void enableCommitMessages() {
        this.commitMessage = true;
    }

    public void setCommitMessage(boolean msg) {
        this.commitMessage = msg;
    }

    public boolean isCommitMessages() {
        return this.commitMessage;
    }
}

