/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchingDriverIterator<T>
implements MorphiumIterator<T> {
    private final Logger log = LoggerFactory.getLogger(PrefetchingDriverIterator.class);
    private long lastAccess = System.currentTimeMillis();
    private List<List<T>> prefetchBuffer = new CopyOnWriteArrayList<List<T>>();
    private Query<T> query;
    private int batchsize;
    private MorphiumCursor cursor;
    private int numPrefetchBuffers;
    private volatile int cursorPos;
    private boolean startedAlready = false;

    public List<List<T>> getPrefetchBuffer() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer;
    }

    public void setPrefetchBuffer(List<List<T>> prefetchBuffer) {
        this.checkAndUpdateLastAccess();
        this.prefetchBuffer = prefetchBuffer;
    }

    @Override
    public int getWindowSize() {
        this.checkAndUpdateLastAccess();
        return this.batchsize;
    }

    @Override
    public void setWindowSize(int sz) {
        this.checkAndUpdateLastAccess();
        this.batchsize = sz;
    }

    @Override
    public Query<T> getQuery() {
        this.checkAndUpdateLastAccess();
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        this.checkAndUpdateLastAccess();
        this.query = q;
    }

    @Override
    public int getCurrentBufferSize() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer.size();
    }

    @Override
    public List<T> getCurrentBuffer() {
        this.checkAndUpdateLastAccess();
        return this.prefetchBuffer.get(0);
    }

    @Override
    public long getCount() {
        this.checkAndUpdateLastAccess();
        return this.query.countAll();
    }

    @Override
    public int getCursor() {
        this.checkAndUpdateLastAccess();
        return this.cursorPos;
    }

    @Override
    public void ahead(int jump) {
        for (int i = 0; i < jump; ++i) {
            this.next();
        }
    }

    @Override
    public void back(int jump) {
        if (jump < this.cursorPos % this.getWindowSize()) {
            this.cursorPos -= jump;
        } else {
            throw new IllegalArgumentException("Cannot jump back past window boundaries");
        }
    }

    @Override
    public void setNumberOfPrefetchWindows(int n) {
        this.checkAndUpdateLastAccess();
        if (n <= 1) {
            n = 2;
            this.log.error("Prefetching only makes sense with at least 2 prefetchwindows... setting to 2");
        }
        this.numPrefetchBuffers = n;
    }

    @Override
    public int getNumberOfAvailableThreads() {
        this.checkAndUpdateLastAccess();
        return this.numPrefetchBuffers;
    }

    @Override
    public int getNumberOfThreads() {
        this.checkAndUpdateLastAccess();
        return 0;
    }

    @Override
    public boolean isMultithreaddedAccess() {
        this.checkAndUpdateLastAccess();
        return true;
    }

    @Override
    public void setMultithreaddedAccess(boolean mu) {
        this.checkAndUpdateLastAccess();
    }

    @Override
    public Iterator<T> iterator() {
        this.checkAndUpdateLastAccess();
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready) {
            this.startedAlready = true;
            try {
                this.cursor = this.query.getMorphium().getDriver().initIteration(this.query.getMorphium().getConfig().getDatabase(), this.query.getCollectionName(), this.query.toQueryObject(), this.query.getSort(), this.query.getFieldListForQuery(), this.query.getSkip(), this.query.getLimit(), this.batchsize, this.query.getMorphium().getReadPreferenceForClass(this.query.getType()), null);
                if (this.cursor == null) {
                    return false;
                }
                if (this.cursor.getBatch() == null) {
                    return false;
                }
                this.prefetchBuffer.add(this.getBatch(this.cursor));
                this.startPrefetch();
                if (!this.prefetchBuffer.get(0).isEmpty()) {
                    return true;
                }
            }
            catch (MorphiumDriverException e) {
                e.printStackTrace();
            }
        }
        while (this.prefetchBuffer.size() <= 1 && this.cursor != null) {
            Thread.yield();
        }
        if (this.prefetchBuffer.isEmpty() && this.cursor == null) {
            return false;
        }
        return (this.cursorPos % this.getWindowSize() != 0 || this.prefetchBuffer.size() != 1 || this.cursor != null) && this.cursorPos % this.getWindowSize() < this.prefetchBuffer.get(0).size();
    }

    private List<T> getBatch(MorphiumCursor crs) {
        List<Map<String, Object>> batch = crs.getBatch();
        ArrayList<T> ret = new ArrayList<T>();
        if (batch == null) {
            return ret;
        }
        for (Map<String, Object> obj : batch) {
            T unmarshall = this.query.getMorphium().getMapper().deserialize(this.query.getType(), obj);
            ret.add(unmarshall);
        }
        this.query.getMorphium().firePostLoad(ret);
        return ret;
    }

    private void startPrefetch() {
        this.query.getMorphium().queueTask(() -> {
            this.log.info("Starting prefetching...");
            block6: while (this.cursor != null) {
                while (this.prefetchBuffer.size() >= this.numPrefetchBuffers && this.cursor != null) {
                    try {
                        int socketTimeout = this.query.getMorphium().getConfig().getSocketTimeout();
                        if (socketTimeout > 0 && System.currentTimeMillis() - this.lastAccess > (long)socketTimeout) {
                            this.log.error("Cursor timeout... closing");
                            try {
                                this.query.getMorphium().getDriver().closeIteration(this.cursor);
                            }
                            catch (MorphiumDriverException morphiumDriverException) {
                                // empty catch block
                            }
                            this.cursor = null;
                            return;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        this.log.debug("got interrupted - ignore");
                    }
                }
                while (this.prefetchBuffer.size() < this.numPrefetchBuffers) {
                    try {
                        if (this.cursor == null) continue block6;
                        MorphiumCursor crs = this.query.getMorphium().getDriver().nextIteration(this.cursor);
                        if (crs == null || crs.getBatch() == null || crs.getBatch().isEmpty()) {
                            this.cursor = null;
                            continue block6;
                        }
                        this.prefetchBuffer.add(this.getBatch(crs));
                        this.cursor = crs;
                    }
                    catch (MorphiumDriverException e) {
                        this.cursor = null;
                        e.printStackTrace();
                        continue block6;
                    }
                }
            }
            this.log.info("Prefetch finished");
        });
    }

    @Override
    public T next() {
        this.checkAndUpdateLastAccess();
        if (this.cursor == null && !this.startedAlready && !this.hasNext()) {
            return null;
        }
        if (this.prefetchBuffer.isEmpty()) {
            this.log.error("Prefetchbuffer is empty!");
            return null;
        }
        if (this.cursorPos != 0 && this.cursorPos % this.getWindowSize() == 0) {
            this.prefetchBuffer.remove(0);
        }
        while (this.prefetchBuffer.isEmpty() && this.cursor != null) {
            Thread.yield();
        }
        return this.prefetchBuffer.get(0).get(this.cursorPos++ % this.getWindowSize());
    }

    private void checkAndUpdateLastAccess() {
        if (this.query == null) {
            return;
        }
        long l = System.currentTimeMillis() - this.lastAccess;
        if (l > (long)this.query.getMorphium().getConfig().getMaxWaitTime()) {
            throw new RuntimeException("Cursor timeout - max wait time of " + this.query.getMorphium().getConfig().getMaxWaitTime() + "ms reached (duration is " + l + ")");
        }
        this.lastAccess = System.currentTimeMillis();
    }
}

