/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.objectmapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.mapping.BigIntegerTypeMapper;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import de.caluga.morphium.objectmapper.MorphiumDeserializer;
import de.caluga.morphium.objectmapper.MorphiumSerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapperImplNG
implements MorphiumObjectMapper {
    private Morphium morphium;
    private AnnotationAndReflectionHelper anhelper;
    private Map<Class<?>, NameProvider> nameProviderByClass;
    private final ContainerFactory containerFactory;
    private final JSONParser jsonParser = new JSONParser();
    private Logger log = LoggerFactory.getLogger(ObjectMapperImplNG.class);
    private MorphiumSerializer marshaller;
    private MorphiumDeserializer unmarshaller;
    private Map<Class, MorphiumTypeMapper> typeMappers;

    public ObjectMapperImplNG() {
        this.nameProviderByClass = new ConcurrentHashMap();
        this.typeMappers = new ConcurrentHashMap<Class, MorphiumTypeMapper>();
        this.typeMappers.put(BigInteger.class, new BigIntegerTypeMapper());
        this.containerFactory = new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
        this.anhelper = new AnnotationAndReflectionHelper(true);
    }

    public MorphiumSerializer getSerializer() {
        if (this.marshaller == null) {
            this.marshaller = new MorphiumSerializer(this.anhelper, this.nameProviderByClass, this.morphium, this, this.typeMappers);
        }
        return this.marshaller;
    }

    public MorphiumDeserializer getDeserializer() {
        if (this.unmarshaller == null) {
            this.unmarshaller = new MorphiumDeserializer(this.anhelper, this.nameProviderByClass, this.morphium, this.typeMappers);
        }
        return this.unmarshaller;
    }

    @Override
    public Map<String, Object> serialize(Object o) {
        return this.getSerializer().serialize(o);
    }

    @Override
    public String getCollectionName(Class cls) {
        return this.getSerializer().getCollectionName(cls);
    }

    @Override
    public <T> T deserialize(Class<? extends T> theClass, Map<String, Object> o) {
        if (o == null) {
            return null;
        }
        if (o.containsKey("class_name")) {
            try {
                theClass = this.anhelper.getClassForTypeId(o.get("class_name").toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not get class", e);
            }
        }
        return this.getDeserializer().deserialize(theClass, o);
    }

    @Override
    public <T> T deserialize(Class<? extends T> cls, String json) throws IOException {
        Map obj = (Map)new ObjectMapper().readValue(json, Map.class);
        if (obj.containsKey("class_name")) {
            try {
                cls = this.anhelper.getClassForTypeId(obj.get("class_name").toString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not get class", e);
            }
        }
        return this.getDeserializer().deserialize(cls, obj);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        return this.nameProviderByClass.get(cls);
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviderByClass.put(cls, np);
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.anhelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper(true);
    }

    public Map<Class, MorphiumTypeMapper> getTypeMappers() {
        return this.typeMappers;
    }

    @Override
    public <T> void registerCustomMapperFor(Class<T> cls, MorphiumTypeMapper<T> map) {
        this.typeMappers.put(cls, map);
    }

    @Override
    public void deregisterCustomMapperFor(Class cls) {
        this.typeMappers.remove(cls);
    }

    @Override
    public void setAnnotationHelper(AnnotationAndReflectionHelper an) {
        this.anhelper = an;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }
}

