/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.objectmapper;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumObjectMapper;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.ReadOnly;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.mapping.MorphiumTypeMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumSerializer {
    private final List<Class> mongoTypes;
    private final AnnotationAndReflectionHelper anhelper;
    private final Map<Class<?>, NameProvider> nameProviderByClass;
    private final Morphium morphium;
    private final MorphiumObjectMapper objectMapper;
    private final Logger log = LoggerFactory.getLogger(MorphiumSerializer.class);
    private final ObjectMapper jackson;
    private final SimpleModule module;
    private final Map<Class, MorphiumTypeMapper> typeMapper;

    public MorphiumSerializer(AnnotationAndReflectionHelper ar, Map<Class<?>, NameProvider> np, Morphium m, MorphiumObjectMapper om, final Map<Class, MorphiumTypeMapper> typeMapper) {
        this.mongoTypes = Collections.synchronizedList(new ArrayList());
        this.anhelper = ar;
        this.nameProviderByClass = np;
        this.morphium = m;
        this.typeMapper = typeMapper;
        this.objectMapper = om;
        this.module = new SimpleModule();
        this.mongoTypes.add(String.class);
        this.mongoTypes.add(Character.class);
        this.mongoTypes.add(Integer.class);
        this.mongoTypes.add(Long.class);
        this.mongoTypes.add(Float.class);
        this.mongoTypes.add(Double.class);
        this.mongoTypes.add(Date.class);
        this.mongoTypes.add(Boolean.class);
        this.mongoTypes.add(Byte.class);
        this.module.addSerializer(MorphiumId.class, (JsonSerializer)new JsonSerializer<MorphiumId>(){

            public void serialize(MorphiumId morphiumId, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName("morphium id");
                jsonGenerator.writeObject((Object)morphiumId.toString());
                jsonGenerator.writeEndObject();
            }
        });
        this.module.addSerializer(Date.class, (JsonSerializer)new JsonSerializer<Date>(){

            public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("date field", (Object)date.getTime());
                jsonGenerator.writeEndObject();
            }
        });
        this.module.addSerializer(Collection.class, (JsonSerializer)new JsonSerializer<Collection>(){

            public void serialize(Collection list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeStartArray();
                for (Object o : list) {
                    Map<String, String> m = null;
                    if (o == null) {
                        jsonGenerator.writeNull();
                        continue;
                    }
                    if (o instanceof Enum) {
                        m = new HashMap<String, String>();
                        m.put("name", ((Enum)o).name());
                    } else if (MorphiumSerializer.this.mongoTypes.contains(o.getClass())) {
                        jsonGenerator.writeObject(o);
                        continue;
                    }
                    if (o instanceof Collection) {
                        this.serialize((Collection)o, jsonGenerator, serializerProvider);
                        continue;
                    }
                    if (o instanceof Map) {
                        jsonGenerator.writeStartObject();
                        for (Map.Entry e : ((Map)o).entrySet()) {
                            if (MorphiumSerializer.this.mongoTypes.contains(e.getValue().getClass())) {
                                jsonGenerator.writeObjectField((String)e.getKey(), e.getValue());
                                continue;
                            }
                            if (e.getValue() instanceof Collection) {
                                jsonGenerator.writeFieldName((String)e.getKey());
                                this.serialize((Collection)e.getValue(), jsonGenerator, serializerProvider);
                                continue;
                            }
                            Map value = (Map)MorphiumSerializer.this.jackson.convertValue(e.getValue(), Map.class);
                            value.put("class_name", MorphiumSerializer.this.anhelper.getTypeIdForClass(e.getValue().getClass()));
                            jsonGenerator.writeObjectField((String)e.getKey(), (Object)value);
                        }
                        jsonGenerator.writeEndObject();
                        continue;
                    }
                    m = (Map)MorphiumSerializer.this.jackson.convertValue(o, Map.class);
                    m.put("class_name", MorphiumSerializer.this.anhelper.getTypeIdForClass(o.getClass()));
                    jsonGenerator.writeObject(m);
                }
                jsonGenerator.writeEndArray();
            }
        });
        this.module.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (MorphiumSerializer.this.anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Entity.class) || MorphiumSerializer.this.anhelper.isAnnotationPresentInHierarchy(beanDesc.getBeanClass(), Embedded.class)) {
                    return new EntitySerializer(serializer, MorphiumSerializer.this.anhelper);
                }
                if (beanDesc.getBeanClass().isEnum()) {
                    return new CustomEnumSerializer();
                }
                if (typeMapper.containsKey(beanDesc.getBeanClass())) {
                    return new JsonSerializer<Object>(){

                        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                            gen.writeObject(((MorphiumTypeMapper)typeMapper.get(value.getClass())).marshall(value));
                        }
                    };
                }
                if (Map.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new JsonSerializer<Map>(){

                        public void serialize(Map value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                            LinkedHashMap ret = new LinkedHashMap();
                            for (Map.Entry e : value.entrySet()) {
                                if (MorphiumSerializer.this.anhelper.isEntity(e.getValue())) {
                                    Map value1 = (Map)MorphiumSerializer.this.jackson.convertValue(e.getValue(), Map.class);
                                    value1.put("class_name", MorphiumSerializer.this.anhelper.getTypeIdForClass(e.getValue().getClass()));
                                    ret.put(e.getKey(), value1);
                                    continue;
                                }
                                if (e.getValue() instanceof Map) {
                                    gen.writeFieldName((String)e.getKey());
                                    this.serialize((Map)e.getValue(), gen, serializers);
                                    continue;
                                }
                                ret.put(e.getKey(), MorphiumSerializer.this.jackson.convertValue(e.getValue(), Map.class));
                            }
                            gen.writeObject(ret);
                        }
                    };
                }
                return serializer;
            }
        });
        this.jackson = new ObjectMapper();
        this.jackson.registerModule((Module)this.module);
        this.jackson.setVisibility(this.jackson.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public Map<String, Object> serialize(Object o) {
        Map m = (Map)this.jackson.convertValue(o, Map.class);
        m = (Map)Utils.replaceMorphiumIds(m);
        return m;
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviderByClass.get(cls) == null) {
            NameProvider np = p.nameProvider().newInstance();
            this.objectMapper.setNameProviderForClass(cls, np);
        }
        return this.nameProviderByClass.get(cls);
    }

    public String getCollectionName(Class cls) {
        Entity p = this.anhelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.anhelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this.objectMapper, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            this.log.error("Could not instanciate NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName(), (Throwable)e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    private Map serializeMap(Map value) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Map.Entry e : value.entrySet()) {
            if (this.anhelper.isEntity(e.getValue())) {
                Map value1 = (Map)this.jackson.convertValue(e.getValue(), Map.class);
                value1.put("class_name", this.anhelper.getTypeIdForClass(e.getValue().getClass()));
                ret.put(e.getKey(), value1);
                continue;
            }
            if (e.getValue() instanceof Map) {
                ret.put(e.getKey(), this.serializeMap((Map)e.getValue()));
                continue;
            }
            if (e.getValue() == null) {
                ret.put(e.getKey(), null);
                continue;
            }
            if (this.mongoTypes.contains(e.getValue().getClass())) {
                ret.put(e.getKey(), e.getValue());
                continue;
            }
            ret.put(e.getKey(), this.jackson.convertValue(e.getValue(), Map.class));
        }
        return ret;
    }

    public class EntitySerializer
    extends JsonSerializer<Object> {
        private final AnnotationAndReflectionHelper an;
        private JsonSerializer<Object> def;

        public EntitySerializer(JsonSerializer<Object> def, AnnotationAndReflectionHelper an) {
            this.def = def;
            this.an = an;
        }

        public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            if (o == null) {
                jsonGenerator.writeNull();
                jsonGenerator.writeEndObject();
                return;
            }
            Entity entity = MorphiumSerializer.this.anhelper.getAnnotationFromHierarchy(o.getClass(), Entity.class);
            Embedded embedded = MorphiumSerializer.this.anhelper.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
            for (Field fld : this.an.getAllFields(o.getClass())) {
                try {
                    Cloneable ret;
                    ReadOnly ro;
                    fld.setAccessible(true);
                    Object value = fld.get(o);
                    Transient tr = fld.getAnnotation(Transient.class);
                    if (tr != null || (ro = fld.getAnnotation(ReadOnly.class)) != null) continue;
                    AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                    if (ad != null) {
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            Object v = entry.getValue();
                            if (!MorphiumSerializer.this.mongoTypes.contains(v.getClass())) {
                                v = MorphiumSerializer.this.jackson.convertValue(v, Map.class);
                            }
                            jsonGenerator.writeObjectField((String)entry.getKey(), v);
                        }
                        continue;
                    }
                    Reference r = fld.getAnnotation(Reference.class);
                    if (r != null && value != null) {
                        MorphiumReference ref;
                        Object id;
                        if (value instanceof List) {
                            ret = new ArrayList();
                            for (Object e : (List)value) {
                                if (e == null) {
                                    ret.add(null);
                                    continue;
                                }
                                id = MorphiumSerializer.this.anhelper.getId(e);
                                if (id == null && r.automaticStore()) {
                                    MorphiumSerializer.this.morphium.storeNoCache(e);
                                    id = MorphiumSerializer.this.anhelper.getId(e);
                                }
                                ref = new MorphiumReference(MorphiumSerializer.this.anhelper.getTypeIdForClass(e.getClass()), id);
                                ref.setLazy(r.lazyLoading());
                                ret.add(ref);
                            }
                            value = ret;
                        } else if (value instanceof Map) {
                            ret = new LinkedHashMap();
                            for (Map.Entry entry : ((Map)value).entrySet()) {
                                if (entry.getValue() == null) {
                                    ret.put(entry.getKey(), entry.getValue());
                                    continue;
                                }
                                id = MorphiumSerializer.this.anhelper.getId(entry.getValue());
                                if (id == null && r.automaticStore()) {
                                    MorphiumSerializer.this.morphium.storeNoCache(entry.getValue());
                                    id = MorphiumSerializer.this.anhelper.getId(entry.getValue());
                                }
                                ref = new MorphiumReference(entry.getValue().getClass().getName(), id);
                                ref.setLazy(r.lazyLoading());
                                ret.put(entry.getKey(), ref);
                            }
                            value = ret;
                        } else {
                            Object id2 = MorphiumSerializer.this.anhelper.getId(value);
                            if (id2 == null && r.automaticStore()) {
                                MorphiumSerializer.this.morphium.storeNoCache(value);
                                id2 = MorphiumSerializer.this.anhelper.getId(value);
                            }
                            MorphiumReference ref2 = new MorphiumReference(value.getClass().getName(), id2);
                            ref2.setLazy(r.lazyLoading());
                            ref2.setCollectionName(MorphiumSerializer.this.getCollectionName(value.getClass()));
                            value = ref2;
                        }
                    }
                    if (value instanceof Map) {
                        ret = new LinkedHashMap();
                        for (Map.Entry entry : ((Map)value).entrySet()) {
                            if (entry.getValue() instanceof Map) {
                                ret.put(entry.getKey(), MorphiumSerializer.this.serializeMap((Map)entry.getValue()));
                                continue;
                            }
                            if (MorphiumSerializer.this.anhelper.isEntity(entry.getValue())) {
                                ret.put(entry.getKey(), MorphiumSerializer.this.jackson.convertValue(entry.getValue(), Map.class));
                                ((Map)ret.get(entry.getKey())).put("class_name", MorphiumSerializer.this.anhelper.getTypeIdForClass(entry.getValue().getClass()));
                                ((Map)ret.get(entry.getKey())).remove("_id");
                                continue;
                            }
                            ret.put(entry.getKey(), entry.getValue());
                        }
                        value = ret;
                    }
                    UseIfnull un = fld.getAnnotation(UseIfnull.class);
                    if (value == null && un == null) continue;
                    String fldName = this.an.getFieldName(o.getClass(), fld.getName());
                    if (MorphiumSerializer.this.anhelper.isEntity(value)) {
                        Map map = (Map)MorphiumSerializer.this.jackson.convertValue(value, Map.class);
                        map.remove("_id");
                        value = map;
                    }
                    jsonGenerator.writeObjectField(fldName, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (entity != null && entity.polymorph() || embedded != null && embedded.polymorph()) {
                String n = o.getClass().getName();
                if (entity != null && !entity.typeId().equals(".")) {
                    n = entity.typeId();
                } else if (embedded != null && !embedded.typeId().equals(".")) {
                    n = embedded.typeId();
                }
                jsonGenerator.writeObjectField("class_name", (Object)MorphiumSerializer.this.anhelper.getTypeIdForClass(o.getClass()));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public class CustomEnumSerializer
    extends JsonSerializer<Enum> {
        public void serialize(Enum anEnum, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("name", anEnum.name());
            obj.put("class_name", MorphiumSerializer.this.anhelper.getTypeIdForClass(anEnum.getClass()));
            jsonGenerator.writeObject(obj);
        }
    }
}

