/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.Capped;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedMorphiumWriterImpl
implements MorphiumWriter,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(BufferedMorphiumWriterImpl.class);
    private final Map<Class<?>, List<WriteBufferEntry>> opLog = new ConcurrentHashMap();
    private final Map<Class<?>, Long> lastRun = new ConcurrentHashMap();
    private Morphium morphium;
    private MorphiumWriter directWriter;
    private Thread housekeeping;
    private boolean running = true;
    private boolean orderedExecution = false;

    @Override
    public void close() {
        this.running = false;
        try {
            long start = System.currentTimeMillis();
            while (this.housekeeping.isAlive()) {
                if (System.currentTimeMillis() - start > 1000L) {
                    this.housekeeping.stop();
                    break;
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOrderedExecution() {
        return this.orderedExecution;
    }

    public void setOrderedExecution(boolean orderedExecution) {
        this.orderedExecution = orderedExecution;
    }

    private void createCappedColl(Class c) {
        this.createCappedColl(c, null);
    }

    private void createCappedColl(Class c, String n) {
        if (logger.isDebugEnabled()) {
            logger.debug("Collection does not exist - ensuring indices / capped status");
        }
        LinkedHashMap<String, Object> cmd = new LinkedHashMap<String, Object>();
        cmd.put("create", n != null ? n : this.morphium.getMapper().getCollectionName(c));
        Capped capped = this.morphium.getARHelper().getAnnotationFromHierarchy(c, Capped.class);
        if (capped == null) {
            return;
        }
        cmd.put("capped", true);
        cmd.put("size", capped.maxSize());
        cmd.put("max", capped.maxEntries());
        cmd.put("autoIndexId", this.morphium.getARHelper().getIdField(c).getType().equals(MorphiumId.class));
        try {
            this.morphium.getDriver().runCommand(this.morphium.getConfig().getDatabase(), cmd);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    private void flushQueueToMongo(List<WriteBufferEntry> q) {
        if (q == null) {
            return;
        }
        ArrayList<WriteBufferEntry> localQueue = new ArrayList<WriteBufferEntry>(q);
        ArrayList<WriteBufferEntry> didNotWrite = new ArrayList<WriteBufferEntry>();
        HashMap<String, BulkRequestContext> bulkByCollectionName = new HashMap<String, BulkRequestContext>();
        try {
            for (WriteBufferEntry entry : localQueue) {
                if (this.morphium.getConfig().isAutoIndexAndCappedCreationOnWrite() && !this.morphium.getDriver().exists(this.morphium.getConfig().getDatabase(), entry.getCollectionName())) {
                    this.createCappedColl(entry.getEntityType(), entry.getCollectionName());
                    this.morphium.ensureIndicesFor(entry.getEntityType(), entry.getCollectionName(), entry.getCb(), this.directWriter);
                }
                try {
                    if (bulkByCollectionName.get(entry.getCollectionName()) == null) {
                        WriteBuffer w = this.morphium.getARHelper().getAnnotationFromHierarchy(entry.getEntityType(), WriteBuffer.class);
                        bulkByCollectionName.put(entry.getCollectionName(), this.morphium.getDriver().createBulkContext(this.morphium, this.morphium.getConfig().getDatabase(), entry.getCollectionName(), w.ordered(), this.morphium.getWriteConcernForClass(entry.getEntityType())));
                    }
                    entry.getToRun().queue((BulkRequestContext)bulkByCollectionName.get(entry.getCollectionName()));
                    entry.getCb().onOperationSucceeded(entry.getType(), null, 0L, null, null, new Object[0]);
                }
                catch (RejectedExecutionException e) {
                    logger.info("too much load - add write to next run");
                    didNotWrite.add(entry);
                }
                catch (Exception e) {
                    logger.error("could not write", (Throwable)e);
                }
            }
        }
        catch (MorphiumDriverException ex) {
            logger.error("Got error during write!", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        try {
            for (BulkRequestContext ctx : bulkByCollectionName.values()) {
                if (ctx == null) continue;
                ctx.execute();
            }
        }
        catch (Exception e) {
            logger.error("Error during exeecution of unordered bulk", (Throwable)e);
        }
        for (WriteBufferEntry entry : localQueue) {
            this.morphium.clearCacheforClassIfNecessary(entry.getEntityType());
            if (didNotWrite.contains(entry)) continue;
            q.remove(entry);
        }
    }

    /*
     * Exception decompiling
     */
    public void addToWriteQueue(Class<?> type, String collectionName, BufferedBulkOp r, AsyncOperationCallback c, AsyncOperationType t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T> void insert(T o, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), collection, ctx -> {
            this.morphium.firePreStore(o, true);
            ArrayList<Map<String, Object>> objToInsert = new ArrayList<Map<String, Object>>();
            try {
                this.setIdIfNull(o);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            objToInsert.add(this.morphium.getMapper().serialize(o));
            InsertBulkRequest ins = ctx.addInsertBulkRequest(objToInsert);
            this.morphium.firePostStore(o, true);
        }, c, AsyncOperationType.WRITE);
    }

    private <T> void setIdIfNull(T o) throws IllegalAccessException {
        Field idf = this.morphium.getARHelper().getIdField(o);
        if (idf.get(o) != null) {
            return;
        }
        if (idf.get(o) == null && idf.getType().equals(MorphiumId.class)) {
            idf.set(o, new MorphiumId());
        } else if (idf.get(o) == null && idf.getType().equals(String.class)) {
            idf.set(o, new MorphiumId().toString());
        } else {
            throw new RuntimeException("Cannot set ID");
        }
    }

    @Override
    public <T> void insert(List<T> o, AsyncOperationCallback<T> callback) {
        this.store(o, (String)null, callback);
    }

    @Override
    public <T> void insert(List<T> lst, String collectionName, AsyncOperationCallback<T> c) {
        if (lst == null || lst.isEmpty()) {
            if (c != null) {
                c.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, lst, null, new Object[0]);
            }
            return;
        }
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        if (this.morphium.isAutoValuesEnabledForThread()) {
            for (T obj : lst) {
                try {
                    this.morphium.setAutoValues(obj);
                }
                catch (IllegalAccessException e) {
                    logger.error("Could not set auto variables", (Throwable)e);
                }
            }
        }
        AsyncOperationCallback<Object> finalC = c;
        this.addToWriteQueue(lst.get(0).getClass(), collectionName, ctx -> {
            HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
            ArrayList<Map<String, Object>> marshalled = new ArrayList<Map<String, Object>>();
            for (Object o : lst) {
                map.put(o, true);
                try {
                    this.setIdIfNull(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                marshalled.add(this.morphium.getMapper().serialize(o));
            }
            this.morphium.firePreStore(map);
            ctx.addInsertBulkRequest(marshalled);
            this.morphium.firePostStore(map);
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public <T> void store(T o, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), collection, ctx -> {
            boolean isNew;
            boolean bl = isNew = this.morphium.getARHelper().getId(o) == null;
            if (!isNew && !this.morphium.getARHelper().getIdField(o).getType().equals(MorphiumId.class)) {
                isNew = this.morphium.createQueryFor(o.getClass()).f("_id").eq(this.morphium.getId(o)).countAll() == 0L;
            }
            this.morphium.firePreStore(o, isNew);
            if (isNew) {
                ArrayList<Map<String, Object>> objToInsert = new ArrayList<Map<String, Object>>();
                try {
                    this.setIdIfNull(o);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                objToInsert.add(this.morphium.getMapper().serialize(o));
                InsertBulkRequest e = ctx.addInsertBulkRequest(objToInsert);
            } else {
                UpdateBulkRequest up = ctx.addUpdateBulkRequest();
                up.setMultiple(false);
                up.setUpsert(true);
                up.setQuery(this.morphium.createQueryFor(o.getClass()).f(this.morphium.getARHelper().getIdFieldName(o)).eq(this.morphium.getARHelper().getId(o)).toQueryObject());
                HashMap<String, Map<String, Object>> cmd = new HashMap<String, Map<String, Object>>();
                up.setCmd(Utils.getMap("$set", cmd));
                for (String f : this.morphium.getARHelper().getFields(o.getClass(), new Class[0])) {
                    try {
                        Object serialize = null;
                        Field field = this.morphium.getARHelper().getField(o.getClass(), f);
                        if ((field.getType().getName().startsWith("java.lang") || field.getType().isPrimitive() || MorphiumId.class.isAssignableFrom(field.getType())) && !Map.class.isAssignableFrom(field.getType()) && !Map.class.isAssignableFrom(field.getType()) && !field.getType().isArray()) {
                            serialize = field.get(o);
                        }
                        if (serialize == null) {
                            serialize = this.morphium.getMapper().serialize(field.get(o));
                        }
                        cmd.put(this.morphium.getARHelper().getFieldName(o.getClass(), f), (Map<String, Object>)serialize);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.morphium.firePostStore(o, isNew);
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public <T> void store(List<T> lst, String collectionName, AsyncOperationCallback<T> c) {
        if (lst == null || lst.isEmpty()) {
            if (c != null) {
                c.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, lst, null, new Object[0]);
            }
            return;
        }
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        if (this.morphium.isAutoValuesEnabledForThread()) {
            for (T obj : lst) {
                try {
                    this.morphium.setAutoValues(obj);
                }
                catch (IllegalAccessException e) {
                    logger.error("Could not set auto variables", (Throwable)e);
                }
            }
        }
        AsyncOperationCallback<Object> finalC = c;
        this.addToWriteQueue(lst.get(0).getClass(), collectionName, ctx -> {
            HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
            for (Object o : lst) {
                map.put(o, this.morphium.getARHelper().getId(o) == null);
            }
            this.morphium.firePreStore(map);
            ArrayList<Map<String, Object>> toInsert = new ArrayList<Map<String, Object>>();
            for (Map.Entry entry : map.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    try {
                        this.setIdIfNull(entry.getKey());
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    toInsert.add(this.morphium.getMapper().serialize(entry.getKey()));
                    continue;
                }
                this.store(entry.getKey(), this.morphium.getMapper().getCollectionName(entry.getKey().getClass()), finalC);
            }
            ctx.addInsertBulkRequest(toInsert);
            this.morphium.firePostStore(map);
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> c, String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(ent.getClass(), collection, ctx -> {
            String[] flds;
            this.morphium.firePreUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            Query<?> query = this.morphium.createQueryFor(ent.getClass()).f(this.morphium.getARHelper().getIdFieldName(ent)).eq(this.morphium.getARHelper().getId(ent));
            if (collection != null) {
                query.setCollectionName(collection);
            }
            if ((flds = fields).length == 0) {
                Stream stream = this.morphium.getARHelper().getAllFields(ent.getClass()).stream();
                Stream<String> m = stream.map(Field::getName);
                flds = (String[])m.toArray(String[]::new);
            }
            UpdateBulkRequest r = new UpdateBulkRequest();
            r.setMultiple(false);
            r.setUpsert(false);
            r.setQuery(query.toQueryObject());
            HashMap<String, Object> set = new HashMap<String, Object>();
            r.setCmd(Utils.getMap("$set", set));
            for (String f : flds) {
                String fld = this.morphium.getARHelper().getFieldName(query.getType(), f);
                set.put(fld, this.morphium.getARHelper().getValue(ent, f));
            }
            this.morphium.getCache().clearCacheIfNecessary(ent.getClass());
            this.morphium.firePostUpdateEvent(ent.getClass(), MorphiumStorageListener.UpdateTypes.SET);
        }, c, AsyncOperationType.UPDATE);
    }

    @Override
    public <T> void set(T toSet, String collection, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), collection, ctx -> {
            this.morphium.firePreUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
            Query<?> query = this.morphium.createQueryFor(toSet.getClass()).f(this.morphium.getARHelper().getIdFieldName(toSet)).eq(this.morphium.getARHelper().getId(toSet));
            if (collection != null) {
                query.setCollectionName(collection);
            }
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            wr.setUpsert(upsert);
            wr.setMultiple(multiple);
            wr.setQuery(query.toQueryObject());
            this.morphium.getCache().clearCacheIfNecessary(toSet.getClass());
            String fld = this.morphium.getARHelper().getFieldName(query.getType(), field);
            wr.setCmd(Utils.getMap("$set", Utils.getMap(fld, value)));
            this.morphium.firePostUpdateEvent(toSet.getClass(), MorphiumStorageListener.UpdateTypes.SET);
        }, c, AsyncOperationType.SET);
    }

    @Override
    public <T> void set(Query<T> query, Map<String, Object> values, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), query.getCollectionName(), ctx -> {
            this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            wr.setUpsert(upsert);
            wr.setMultiple(multiple);
            this.morphium.getCache().clearCacheIfNecessary(query.getType());
            wr.setQuery(query.toQueryObject());
            HashMap set = new HashMap();
            wr.setCmd(Utils.getMap("$set", set));
            for (Map.Entry kv : values.entrySet()) {
                String fld = this.morphium.getARHelper().getFieldName(query.getType(), kv.getKey().toString());
                set.put(fld, kv.getValue());
            }
            this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
        }, c, AsyncOperationType.SET);
    }

    @Override
    public <T> void inc(Query<T> query, Map<String, Number> fieldsToInc, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), query.getCollectionName(), ctx -> {
            this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            UpdateBulkRequest wr = new UpdateBulkRequest();
            wr.setQuery(query.toQueryObject());
            wr.setUpsert(upsert);
            HashMap inc = new HashMap();
            wr.setCmd(Utils.getMap("$inc", inc));
            this.morphium.getCache().clearCacheIfNecessary(query.getType());
            for (Map.Entry kv : fieldsToInc.entrySet()) {
                String fld = this.morphium.getARHelper().getFieldName(query.getType(), kv.getKey().toString());
                inc.put(fld, kv.getValue());
            }
            this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void inc(Query<T> query, String field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), query.getCollectionName(), ctx -> {
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            String fieldName = this.morphium.getARHelper().getFieldName(query.getType(), field);
            wr.setCmd(Utils.getMap("$inc", Utils.getMap(fieldName, amount)));
            wr.setUpsert(upsert);
            wr.setMultiple(multiple);
            wr.setQuery(query.toQueryObject());
            this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
            this.morphium.getCache().clearCacheIfNecessary(query.getType());
            this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void inc(T obj, String collection, String field, Number amount, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), collection, ctx -> {
            this.morphium.firePreUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.INC);
            Query<?> q = this.morphium.createQueryFor(obj.getClass()).f(this.morphium.getARHelper().getIdFieldName(obj)).eq(this.morphium.getARHelper().getId(obj));
            q.setCollectionName(collection);
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            String fieldName = this.morphium.getARHelper().getFieldName(obj.getClass(), field);
            wr.setCmd(Utils.getMap("$inc", Utils.getMap(fieldName, amount)));
            wr.setUpsert(false);
            wr.setMultiple(false);
            wr.setQuery(q.toQueryObject());
            this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
            this.morphium.firePostUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.INC);
        }, c, AsyncOperationType.INC);
    }

    @Override
    public <T> void pop(T obj, String collection, String field, boolean first, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), collection, ctx -> {
            this.morphium.firePreUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.POP);
            Query<?> q = this.morphium.createQueryFor(obj.getClass()).f(this.morphium.getARHelper().getIdFieldName(obj)).eq(this.morphium.getARHelper().getId(obj));
            UpdateBulkRequest wr = new UpdateBulkRequest();
            wr.setQuery(q.toQueryObject());
            wr.setUpsert(false);
            wr.setMultiple(false);
            this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
            String fld = this.morphium.getARHelper().getFieldName(obj.getClass(), field);
            wr.setCmd(Utils.getMap("$pop", Utils.getMap(fld, first)));
            this.morphium.firePostUpdateEvent(obj.getClass(), MorphiumStorageListener.UpdateTypes.POP);
        }, c, AsyncOperationType.WRITE);
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.directWriter = m.getConfig().getWriter();
        this.housekeeping = new Thread(){

            @Override
            public void run() {
                this.setName("BufferedWriter_thread");
                while (BufferedMorphiumWriterImpl.this.running) {
                    try {
                        ArrayList localBuffer = new ArrayList(BufferedMorphiumWriterImpl.this.opLog.keySet());
                        for (Class clz : localBuffer) {
                            if (BufferedMorphiumWriterImpl.this.opLog.get(clz) == null || ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).isEmpty()) continue;
                            WriteBuffer w = BufferedMorphiumWriterImpl.this.morphium.getARHelper().getAnnotationFromHierarchy(clz, WriteBuffer.class);
                            int size = 0;
                            int timeout = BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTime();
                            if (w != null) {
                                size = w.size();
                                timeout = w.timeout();
                            }
                            if (BufferedMorphiumWriterImpl.this.lastRun.get(clz) != null && System.currentTimeMillis() - (Long)BufferedMorphiumWriterImpl.this.lastRun.get(clz) > (long)timeout) {
                                this.runIt(clz);
                                continue;
                            }
                            if (size > 0 && ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() >= size) {
                                this.runIt(clz);
                                continue;
                            }
                            BufferedMorphiumWriterImpl.this.lastRun.putIfAbsent(clz, System.currentTimeMillis());
                        }
                    }
                    catch (Exception e) {
                        logger.info("Got exception during write buffer handling!", (Throwable)e);
                    }
                    try {
                        if (BufferedMorphiumWriterImpl.this.morphium != null) {
                            if (BufferedMorphiumWriterImpl.this.morphium.getConfig() == null) {
                                BufferedMorphiumWriterImpl.this.running = false;
                                break;
                            }
                            Thread.sleep(BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTimeGranularity());
                            continue;
                        }
                        logger.warn("Morphium not set - assuming timeout of 1sec");
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void runIt(Class<?> clz) {
                BufferedMorphiumWriterImpl.this.lastRun.put(clz, System.currentTimeMillis());
                List localQueue = (List)BufferedMorphiumWriterImpl.this.opLog.remove(clz);
                BufferedMorphiumWriterImpl.this.flushQueueToMongo(localQueue);
                if (!localQueue.isEmpty()) {
                    if (BufferedMorphiumWriterImpl.this.opLog.get(clz) == null) {
                        Map map = BufferedMorphiumWriterImpl.this.opLog;
                        synchronized (map) {
                            BufferedMorphiumWriterImpl.this.opLog.putIfAbsent(clz, Collections.synchronizedList(new ArrayList()));
                        }
                    }
                    ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).addAll(localQueue);
                }
            }
        };
        this.housekeeping.setDaemon(true);
        this.housekeeping.start();
        m.addShutdownListener(m1 -> this.close());
    }

    @Override
    public <T> void remove(List<T> lst, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        for (T obj : lst) {
            this.remove(obj, null, c);
        }
    }

    @Override
    public <T> void remove(Query<T> q, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), q.getCollectionName(), ctx -> {
            this.morphium.firePreRemoveEvent(q);
            DeleteBulkRequest r = ctx.addDeleteBulkRequest();
            r.setQuery(q.toQueryObject());
            this.morphium.firePostRemoveEvent(q);
        }, c, AsyncOperationType.REMOVE);
    }

    @Override
    public <T> void remove(T o, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), collection, ctx -> {
            Query<?> q = this.morphium.createQueryFor(o.getClass()).f(this.morphium.getARHelper().getIdFieldName(o)).eq(this.morphium.getARHelper().getId(o));
            if (collection != null) {
                q.setCollectionName(collection);
            }
            this.morphium.firePreRemoveEvent(q);
            DeleteBulkRequest r = ctx.addDeleteBulkRequest();
            r.setQuery(q.toQueryObject());
            this.morphium.firePostRemoveEvent(q);
        }, c, AsyncOperationType.REMOVE);
    }

    @Override
    public <T> void remove(Query<T> q, AsyncOperationCallback<T> c) {
        this.remove(q, true, c);
    }

    @Override
    public <T> void pushPull(boolean push, Query<T> q, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), q.getCollectionName(), ctx -> {
            UpdateBulkRequest r = ctx.addUpdateBulkRequest();
            r.setQuery(q.toQueryObject());
            r.setUpsert(upsert);
            r.setMultiple(multiple);
            this.morphium.getCache().clearCacheIfNecessary(q.getType());
            String fld = this.morphium.getARHelper().getFieldName(q.getType(), field);
            if (push) {
                this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                r.setCmd(Utils.getMap("$push", Utils.getMap(field, value)));
                this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            } else {
                this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
                r.setCmd(Utils.getMap("$pull", Utils.getMap(field, value)));
                this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
            }
        }, c, push ? AsyncOperationType.PUSH : AsyncOperationType.PULL);
    }

    @Override
    public <T> void pushPullAll(boolean push, Query<T> q, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), q.getCollectionName(), ctx -> {
            this.morphium.getCache().clearCacheIfNecessary(q.getType());
            String fld = this.morphium.getARHelper().getFieldName(q.getType(), field);
            String cmd = "";
            if (push) {
                this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            } else {
                this.morphium.firePreUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
            }
            for (Object o : value) {
                UpdateBulkRequest r = ctx.addUpdateBulkRequest();
                r.setQuery(q.toQueryObject());
                r.setUpsert(upsert);
                r.setMultiple(multiple);
                r.setCmd(Utils.getMap("$push", Utils.getMap(fld, o)));
            }
            if (push) {
                this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
            } else {
                this.morphium.firePostUpdateEvent(q.getType(), MorphiumStorageListener.UpdateTypes.PULL);
            }
        }, c, push ? AsyncOperationType.PUSH : AsyncOperationType.PULL);
    }

    @Override
    public <T> void unset(T obj, String collection, String field, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(obj.getClass(), collection, ctx -> {
            Query<?> q = this.morphium.createQueryFor(obj.getClass()).f(this.morphium.getARHelper().getIdFieldName(obj)).eq(this.morphium.getARHelper().getId(obj));
            if (collection != null) {
                q.setCollectionName(collection);
            }
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            wr.setQuery(q.toQueryObject());
            wr.setMultiple(false);
            wr.setUpsert(false);
            String fld = this.morphium.getARHelper().getFieldName(obj.getClass(), field);
            wr.setCmd(Utils.getMap("$unset", Utils.getMap(fld, "")));
            this.morphium.getCache().clearCacheIfNecessary(obj.getClass());
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(Query<T> query, String field, boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), query.getCollectionName(), ctx -> {
            this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            wr.setQuery(query.toQueryObject());
            wr.setMultiple(false);
            wr.setUpsert(false);
            String fld = this.morphium.getARHelper().getFieldName(query.getType(), field);
            wr.setCmd(Utils.getMap("$unset", Utils.getMap(fld, "")));
            this.morphium.getCache().clearCacheIfNecessary(query.getType());
            this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(Query<T> query, AsyncOperationCallback<T> c, boolean multiple, String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), query.getCollectionName(), ctx -> {
            this.morphium.firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
            UpdateBulkRequest wr = ctx.addUpdateBulkRequest();
            wr.setQuery(query.toQueryObject());
            wr.setMultiple(false);
            wr.setUpsert(false);
            HashMap<String, String> unset = new HashMap<String, String>();
            wr.setCmd(Utils.getMap("$unset", unset));
            for (String f : fields) {
                String fld = this.morphium.getARHelper().getFieldName(query.getType(), f);
                unset.put(fld, "");
            }
            this.morphium.getCache().clearCacheIfNecessary(query.getType());
            this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
        }, c, AsyncOperationType.UNSET);
    }

    @Override
    public <T> void unset(Query<T> query, AsyncOperationCallback<T> c, boolean multiple, Enum ... fields) {
        String[] flds = new String[fields.length];
        int i = 0;
        for (Enum e : fields) {
            flds[i++] = e.name();
        }
        this.unset(query, c, multiple, flds);
    }

    @Override
    public <T> void dropCollection(Class<T> cls, String collection, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, collection, ctx -> {
            this.directWriter.dropCollection(cls, collection, callback);
            this.morphium.getCache().clearCacheIfNecessary(cls);
        }, c, AsyncOperationType.REMOVE);
    }

    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> c) {
        this.ensureIndex(cls, collection, index, null, c);
    }

    @Override
    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, Map<String, Object> options, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        AsyncOperationCallback callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, collection, ctx -> this.directWriter.ensureIndex(cls, collection, index, options, callback), c, AsyncOperationType.ENSURE_INDICES);
    }

    @Override
    public int writeBufferCount() {
        int cnt = 0;
        for (List<WriteBufferEntry> lst : this.opLog.values()) {
            cnt += lst.size();
        }
        return cnt;
    }

    @Override
    public <T> void store(List<T> lst, AsyncOperationCallback<T> c) {
        this.store(lst, (String)null, c);
    }

    @Override
    public void flush() {
        ArrayList localBuffer = new ArrayList();
        localBuffer.addAll(this.opLog.keySet());
        for (Class clazz : localBuffer) {
            if (this.opLog.get(clazz) == null || this.opLog.get(clazz).isEmpty()) continue;
            this.flushQueueToMongo(this.opLog.get(clazz));
        }
    }

    @Override
    public void flush(Class type) {
        if (this.opLog.get(type) == null || this.opLog.get(type).isEmpty()) {
            return;
        }
        this.flushQueueToMongo(this.opLog.get(type));
    }

    @Override
    public void onShutdown(Morphium m) {
        logger.debug("Stopping housekeeping thread");
        this.running = false;
        this.flush();
        try {
            Thread.sleep(this.morphium.getConfig().getWriteBufferTimeGranularity());
            if (this.housekeeping != null) {
                this.housekeeping.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMaximumQueingTries(int n) {
        this.directWriter.setMaximumQueingTries(n);
    }

    @Override
    public void setPauseBetweenTries(int p) {
        this.directWriter.setPauseBetweenTries(p);
    }

    private static /* synthetic */ int lambda$addToWriteQueue$1(WriteBufferEntry o1, WriteBufferEntry o2) {
        return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
    }

    private static /* synthetic */ int lambda$addToWriteQueue$0(WriteBufferEntry o1, WriteBufferEntry o2) {
        return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
    }

    private class AsyncOpAdapter<T>
    implements AsyncOperationCallback<T> {
        private AsyncOpAdapter() {
        }

        @Override
        public void onOperationSucceeded(AsyncOperationType type, Query<T> q, long duration, List<T> result, T entity, Object ... param) {
        }

        @Override
        public void onOperationError(AsyncOperationType type, Query<T> q, long duration, String error, Throwable t, T entity, Object ... param) {
        }
    }

    private class WriteBufferEntry {
        private final String collection;
        private BufferedBulkOp toRun;
        private AsyncOperationCallback cb;
        private AsyncOperationType type;
        private long timestamp;
        private Class entityType;

        private WriteBufferEntry(Class entitiyType, String collectionName, BufferedBulkOp toRun, long timestamp, AsyncOperationCallback c, AsyncOperationType t) {
            this.toRun = toRun;
            this.timestamp = timestamp;
            this.cb = c;
            this.type = t;
            this.entityType = entitiyType;
            this.collection = collectionName;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public Class getEntityType() {
            return this.entityType;
        }

        public void setEntityType(Class entityType) {
            this.entityType = entityType;
        }

        public AsyncOperationType getType() {
            return this.type;
        }

        public void setType(AsyncOperationType type) {
            this.type = type;
        }

        public AsyncOperationCallback getCb() {
            return this.cb;
        }

        public void setCb(AsyncOperationCallback cb) {
            this.cb = cb;
        }

        public BufferedBulkOp getToRun() {
            return this.toRun;
        }

        public void setToRun(BufferedBulkOp toRun) {
            this.toRun = toRun;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    private static interface BufferedBulkOp {
        public void queue(BulkRequestContext var1);
    }
}

