/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.SafetyLevel;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.messaging.Messaging;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

@Entity(polymorph=true)
@NoCache
@WriteSafety(level=SafetyLevel.NORMAL)
@DefaultReadPreference(value=ReadPreferenceLevel.PRIMARY)
@Lifecycle
@Index(value={"sender,locked_by,processed_by,recipient,priority,timestamp", "locked_by,processed_by,recipient,priority,timestamp", "sender,locked_by,processed_by,recipient,name,priority,timestamp"})
public class Msg {
    @Index
    private List<String> processedBy;
    @Id
    private MorphiumId msgId;
    @Index
    @UseIfnull
    private String lockedBy = "ALL";
    @Index
    private long locked;
    private long ttl;
    private String sender;
    private String senderHost;
    private String recipient;
    @Transient
    private List<String> to;
    private Object inAnswerTo;
    private String name;
    private String msg;
    private List<Object> additional;
    private Map<String, Object> mapValue;
    private String value;
    @Index
    private long timestamp;
    @Index(options={"expireAfterSeconds:0"})
    private Date deleteAt;
    private int priority = 1000;

    public Msg() {
    }

    public Msg(String name, String msg, String value) {
        this(name, msg, value, 30000L, false);
    }

    public Msg(String name, String msg, String value, long ttl) {
        this(name, msg, value, ttl, false);
    }

    public Msg(String name, String msg, String value, long ttl, boolean exclusive) {
        this();
        this.name = name;
        this.msg = msg;
        this.value = value;
        this.ttl = ttl;
        this.setExclusive(exclusive);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isExclusive() {
        return this.getLockedBy() == null || !this.getLockedBy().equals("ALL");
    }

    public void setExclusive(boolean exclusive) {
        this.lockedBy = !exclusive ? "ALL" : null;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getSenderHost() {
        return this.senderHost;
    }

    public void setSenderHost(String senderHost) {
        this.senderHost = senderHost;
    }

    public Date getDeleteAt() {
        return this.deleteAt;
    }

    public void setDeleteAt(Date deleteAt) {
        this.deleteAt = deleteAt;
    }

    public void addRecipient(String id) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        if (!this.to.contains(id)) {
            this.to.add(id);
        }
    }

    public void removeRecipient(String id) {
        if (this.to != null) {
            this.to.remove(id);
        }
    }

    public void addValue(String key, Object value) {
        if (this.mapValue == null) {
            this.mapValue = new HashMap<String, Object>();
        }
        this.mapValue.put(key, value);
    }

    public void removeValue(String key) {
        if (this.mapValue == null) {
            return;
        }
        this.mapValue.remove(key);
    }

    public Map<String, Object> getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(Map<String, Object> mapValue) {
        this.mapValue = mapValue;
    }

    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public Object getInAnswerTo() {
        return this.inAnswerTo;
    }

    public void setInAnswerTo(Object inAnswerTo) {
        this.inAnswerTo = inAnswerTo;
    }

    public MorphiumId getMsgId() {
        return this.msgId;
    }

    public void setMsgId(MorphiumId msgId) {
        this.msgId = msgId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public List<String> getProcessedBy() {
        return this.processedBy;
    }

    public void setProcessedBy(List<String> processedBy) {
        this.processedBy = processedBy;
    }

    public void addProcessedId(String id) {
        if (this.processedBy == null) {
            this.processedBy = new ArrayList<String>();
        }
        this.processedBy.add(id);
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public long getLocked() {
        return this.locked;
    }

    public void setLocked(long locked) {
        this.locked = locked;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<Object> getAdditional() {
        return this.additional;
    }

    public void setAdditional(List<Object> additional) {
        this.additional = additional;
    }

    public void addAdditional(String value) {
        if (this.additional == null) {
            this.additional = new ArrayList<Object>();
        }
        this.additional.add(value);
    }

    public void removeAdditional(String value) {
        if (this.additional == null) {
            return;
        }
        this.additional.remove(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "Msg{ msgId='" + this.msgId + '\'' + ", inAnswerTo='" + this.inAnswerTo + '\'' + ", lockedBy='" + this.lockedBy + '\'' + ", locked=" + this.locked + ", ttl=" + this.ttl + ", sender='" + this.sender + '\'' + ", name='" + this.name + '\'' + ", msg='" + this.msg + '\'' + ", value='" + this.value + '\'' + ", timestamp=" + this.timestamp + ", additional='" + this.additional + '\'' + ", mapValue='" + this.mapValue + '\'' + ", recipient='" + this.recipient + '\'' + ", to_list='" + this.to + '\'' + ", processedBy=" + this.processedBy + '}';
    }

    @PreStore
    public void preStore() {
        if (this.sender == null) {
            throw new RuntimeException("Cannot send msg anonymously - set Sender first!");
        }
        if (this.name == null) {
            throw new RuntimeException("Cannot send a message without name!");
        }
        if (this.ttl == 0L) {
            LoggerFactory.getLogger(Msg.class).warn("Defaulting msg ttl to 30sec");
            this.ttl = 30000L;
        }
        if (this.deleteAt == null) {
            this.deleteAt = new Date(System.currentTimeMillis() + this.ttl);
        }
        this.timestamp = System.currentTimeMillis();
    }

    public Msg createAnswerMsg() {
        Msg ret = new Msg(this.name, this.msg, this.value, this.ttl);
        ret.setInAnswerTo(this.msgId);
        ret.addRecipient(this.sender);
        return ret;
    }

    public void sendAnswer(Messaging messaging, Msg m) {
        m.setInAnswerTo(this.msgId);
        m.addRecipient(this.getSender());
        m.setDeleteAt(new Date(System.currentTimeMillis() + m.getTtl()));
        messaging.queueMessage(m);
    }

    public static enum Fields {
        msgId,
        lockedBy,
        locked,
        ttl,
        sender,
        senderHost,
        recipient,
        to,
        inAnswerTo,
        name,
        msg,
        additional,
        mapValue,
        value,
        timestamp,
        deleteAt,
        priority,
        processedBy;

    }
}

