/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.validation;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumStorageAdapter;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.slf4j.LoggerFactory;

public class JavaxValidationStorageListener
extends MorphiumStorageAdapter<Object> {
    private final Validator validator;

    public JavaxValidationStorageListener() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
    }

    @Override
    public void preStore(Morphium m, Map<Object, Boolean> isNew) throws MorphiumAccessVetoException {
        for (Map.Entry<Object, Boolean> e : isNew.entrySet()) {
            this.preStore(m, e.getKey(), (boolean)e.getValue());
        }
    }

    @Override
    public void preStore(Morphium m, Object r, boolean isNew) {
        if (r == null) {
            return;
        }
        AnnotationAndReflectionHelper annotationHelper = m.getARHelper();
        if (!annotationHelper.isAnnotationPresentInHierarchy(r.getClass(), Entity.class) && !annotationHelper.isAnnotationPresentInHierarchy(r.getClass(), Embedded.class)) {
            return;
        }
        Set violations = this.validator.validate(r, new Class[0]);
        List<String> flds = annotationHelper.getFields(r.getClass(), new Class[0]);
        for (String f : flds) {
            Field field = annotationHelper.getField(r.getClass(), f);
            if (annotationHelper.isAnnotationPresentInHierarchy(field.getType(), Embedded.class) || annotationHelper.isAnnotationPresentInHierarchy(field.getType(), Entity.class)) {
                try {
                    if (field.get(r) == null) continue;
                    Set v = this.validator.validate(field.get(r), new Class[0]);
                    violations.addAll(v);
                }
                catch (IllegalAccessException e) {
                    LoggerFactory.getLogger(JavaxValidationStorageListener.class).error("Could not access Field: " + f);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                try {
                    List lst = (List)field.get(r);
                    if (lst == null) continue;
                    HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
                    for (Object o : lst) {
                        map.put(o, isNew);
                    }
                    this.validatePrestor(m, violations, map);
                }
                catch (IllegalAccessException e) {
                    LoggerFactory.getLogger(JavaxValidationStorageListener.class).error("Could not access list field: " + f);
                }
                continue;
            }
            if (!Map.class.isAssignableFrom(field.getType())) continue;
            try {
                Map map = (Map)field.get(r);
                if (map == null) continue;
                HashMap<Object, Boolean> lst = new HashMap<Object, Boolean>();
                for (Object val : map.values()) {
                    lst.put(val, isNew);
                }
                this.validatePrestor(m, violations, lst);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
    }

    private void validatePrestor(Morphium m, Set<ConstraintViolation<Object>> violations, Map<Object, Boolean> map) {
        try {
            this.preStore(m, map);
        }
        catch (ConstraintViolationException e) {
            Set constraintViolations = e.getConstraintViolations();
            for (ConstraintViolation v : constraintViolations) {
                violations.add((ConstraintViolation<Object>)v);
            }
        }
    }
}

