/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.annotations.PartialUpdate;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class PartiallyUpdateableProxy<T>
implements MethodInterceptor,
PartiallyUpdateable,
Serializable {
    private static final long serialVersionUID = -1277417045334974980L;
    private final AnnotationAndReflectionHelper ah;
    private final List<String> updateableFields = Collections.synchronizedList(new ArrayList());
    private final T reference;

    public PartiallyUpdateableProxy(Morphium m, T o) {
        this.reference = o;
        this.ah = m.getARHelper();
    }

    public T __getDeref() {
        return this.reference;
    }

    public T __getPureDeref() {
        return this.reference;
    }

    @Override
    public List<String> getAlteredFields() {
        return this.updateableFields;
    }

    @Override
    public void clearAlteredFields() {
        this.updateableFields.clear();
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        if (method.getName().startsWith("set") || method.isAnnotationPresent(PartialUpdate.class)) {
            PartialUpdate up = method.getAnnotation(PartialUpdate.class);
            if (up != null) {
                if (!this.ah.getFields(o.getClass(), new Class[0]).contains(up.value())) {
                    throw new IllegalArgumentException("Field " + up.value() + " is not known to Type " + o.getClass().getName());
                }
                this.updateableFields.add(up.value());
            } else {
                String n = method.getName().substring(3);
                n = n.substring(0, 1).toLowerCase() + n.substring(1);
                this.updateableFields.add(n);
            }
        }
        if (method.getName().equals("getAlteredFields")) {
            return this.getAlteredFields();
        }
        if (method.getName().equals("clearAlteredFields")) {
            this.clearAlteredFields();
            return null;
        }
        if (method.getName().equals("__getType")) {
            return this.reference.getClass();
        }
        if (method.getName().equals("__getDeref")) {
            return this.reference;
        }
        return method.invoke(this.reference, objects);
    }
}

