/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache.jcache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.jcache.CacheEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HouseKeepingHelper {
    private Map<Class<?>, Integer> validTimeForClass = new ConcurrentHashMap();
    private int gcTimeout = 5000;
    private Logger log = LoggerFactory.getLogger(HouseKeepingHelper.class);
    private AnnotationAndReflectionHelper annotationHelper;

    public void setGlobalValidCacheTime(int gc) {
        this.gcTimeout = gc;
    }

    public void setAnnotationHelper(AnnotationAndReflectionHelper hlp) {
        this.annotationHelper = hlp;
    }

    public void setValidCacheTime(Class<?> cls, int timeout) {
        this.validTimeForClass.put(cls, timeout);
    }

    public void setDefaultValidCacheTime(Class cls) {
        this.validTimeForClass.remove(cls);
    }

    public Integer getValidCacheTime(Class<?> cls) {
        return this.validTimeForClass.get(cls);
    }

    public void housekeep(javax.cache.Cache cache) {
        try {
            Class<?> clz = Class.forName(cache.getName().substring(cache.getName().indexOf("|") + 1));
            ArrayList<Object> toDelete = new ArrayList<Object>();
            int maxEntries = -1;
            Cache cacheSettings = this.getAnnotationHelper().getAnnotationFromHierarchy(clz, Cache.class);
            Cache.ClearStrategy strategy = null;
            int time = this.gcTimeout;
            HashMap lruTime = new HashMap();
            HashMap fifoTime = new HashMap();
            if (this.validTimeForClass.get(clz) != null) {
                time = this.validTimeForClass.get(clz);
            }
            int del = 0;
            if (cacheSettings != null) {
                if (cacheSettings.timeout() != -1) {
                    time = cacheSettings.timeout();
                }
                maxEntries = cacheSettings.maxEntries();
                strategy = cacheSettings.strategy();
                this.validTimeForClass.putIfAbsent(clz, time);
            }
            Iterator it = cache.iterator();
            int size = 0;
            while (it.hasNext()) {
                ++size;
                Cache.Entry es = (Cache.Entry)it.next();
                CacheEntry ch = (CacheEntry)es.getValue();
                if (ch == null || ch.getResult() == null || System.currentTimeMillis() - ch.getCreated() > (long)time) {
                    toDelete.add(ch.getKey());
                    ++del;
                    continue;
                }
                lruTime.putIfAbsent(ch.getLru(), new ArrayList());
                ((List)lruTime.get(ch.getLru())).add(ch.getKey());
                long fifo = System.currentTimeMillis() - ch.getCreated();
                fifoTime.putIfAbsent(fifo, new ArrayList());
                ((List)fifoTime.get(fifo)).add(ch.getKey());
            }
            if (maxEntries > 0 && size - del > maxEntries) {
                switch (strategy) {
                    case LRU: {
                        Object[] array = lruTime.keySet().toArray(new Long[0]);
                        Arrays.sort(array);
                        int idx = 0;
                        while (size - del > maxEntries) {
                            if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).isEmpty()) continue;
                            toDelete.add(((List)lruTime.get(array[idx])).get(0));
                            ((List)lruTime.get(array[idx])).remove(0);
                            ++del;
                            if (!((List)lruTime.get(array[idx])).isEmpty()) continue;
                            ++idx;
                        }
                        break;
                    }
                    case FIFO: {
                        Object[] array = fifoTime.keySet().toArray(new Long[0]);
                        Arrays.sort(array);
                        int idx = 0;
                        while (size - del > maxEntries) {
                            if (fifoTime.get(array[array.length - 1 - idx]) == null || ((List)fifoTime.get(array[array.length - 1 - idx])).isEmpty()) continue;
                            toDelete.add(((List)fifoTime.get(array[array.length - 1 - idx])).get(0));
                            ((List)fifoTime.get(array[array.length - 1 - idx])).remove(0);
                            ++del;
                            if (!((List)fifoTime.get(array[array.length - 1 - idx])).isEmpty()) continue;
                            ++idx;
                        }
                        break;
                    }
                    case RANDOM: {
                        Object[] array = fifoTime.keySet().toArray(new Long[0]);
                        List<Object> lst = Arrays.asList(array);
                        Collections.shuffle(lst);
                        array = lst.toArray(new Long[0]);
                        int idx = 0;
                        while (size - del > maxEntries) {
                            if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).isEmpty()) continue;
                            toDelete.add(((List)lruTime.get(array[idx])).get(0));
                            ++del;
                            if (!((List)lruTime.get(array[idx])).isEmpty()) continue;
                            ++idx;
                        }
                        break;
                    }
                }
                for (Object e : toDelete) {
                    cache.remove(e);
                }
            }
        }
        catch (Throwable e) {
            this.log.warn("Error:" + e.getMessage(), e);
        }
    }

    private AnnotationAndReflectionHelper getAnnotationHelper() {
        if (this.annotationHelper == null) {
            this.annotationHelper = new AnnotationAndReflectionHelper(false);
        }
        return this.annotationHelper;
    }
}

