/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache.jcache;

import de.caluga.morphium.cache.jcache.CacheEntry;
import de.caluga.morphium.cache.jcache.CacheEventVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl<K, CE>
implements Cache<K, CacheEntry<CE>> {
    private Map<K, CacheEntry<CE>> theCache = new ConcurrentHashMap<K, CacheEntry<CE>>();
    private Map<CacheEntryEventFilter<? super K, ? super CacheEntry<CE>>, CacheEntryListener<K, CacheEntry<CE>>> listeners = new ConcurrentHashMap<CacheEntryEventFilter<? super K, ? super CacheEntry<CE>>, CacheEntryListener<K, CacheEntry<CE>>>();
    private CacheManager cacheManager;
    private String name = "";
    private Logger log = LoggerFactory.getLogger(CacheImpl.class);

    public void setCacheManager(CacheManager cm) {
        this.cacheManager = cm;
    }

    public CacheEntry<CE> get(K key) {
        return this.theCache.get(key);
    }

    public Map<K, CacheEntry<CE>> getAll(Set<? extends K> keys) {
        HashMap<K, CacheEntry<CE>> ret = new HashMap<K, CacheEntry<CE>>();
        for (K k : keys) {
            ret.put(k, this.theCache.get(k));
        }
        return ret;
    }

    public boolean containsKey(K key) {
        return this.theCache.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        throw new RuntimeException("not implemented yet,sorry");
    }

    public void put(K key, CacheEntry<CE> value) {
        if (!this.fireEvent(new CEvent(this, EventType.CREATED, key, value, null))) {
            this.log.info("Not adding element to cache " + key.toString());
        } else {
            this.theCache.put(key, value);
        }
    }

    public CacheEntry<CE> getAndPut(K key, CacheEntry<CE> value) {
        CacheEntry<CE> ret = this.theCache.get(key);
        EventType evtType = EventType.UPDATED;
        if (ret == null) {
            evtType = EventType.CREATED;
        }
        if (!this.fireEvent(new CEvent(this, evtType, key, value, ret))) {
            this.log.info("not updateing element " + key);
            return ret;
        }
        this.theCache.put(key, value);
        return ret;
    }

    public void putAll(Map<? extends K, ? extends CacheEntry<CE>> map) {
        this.theCache.putAll(map);
    }

    public boolean putIfAbsent(K key, CacheEntry<CE> value) {
        if (!this.theCache.containsKey(key)) {
            this.theCache.put(key, value);
            this.fireEvent(new CEvent(this, EventType.CREATED, key, value, null));
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        if (!this.theCache.containsKey(key)) {
            return false;
        }
        if (!this.fireEvent(new CEvent(this, EventType.REMOVED, key, null, null))) {
            this.log.info("aborting cache operation");
            return false;
        }
        this.theCache.remove(key);
        return true;
    }

    public boolean remove(K key, CacheEntry<CE> oldValue) {
        if (!this.theCache.containsKey(key) || !this.theCache.get(key).equals(oldValue)) {
            return false;
        }
        if (!this.fireEvent(new CEvent(this, EventType.REMOVED, key, oldValue, null))) {
            this.log.info("aborting cache operation");
            return false;
        }
        this.theCache.remove(key, oldValue);
        return true;
    }

    public CacheEntry<CE> getAndRemove(K key) {
        CacheEntry<CE> ret = this.theCache.get(key);
        if (!this.fireEvent(new CEvent(this, EventType.REMOVED, key, null, null))) {
            this.log.info("aborting cache operation");
            return null;
        }
        this.theCache.remove(key);
        return ret;
    }

    public boolean replace(K key, CacheEntry<CE> oldValue, CacheEntry<CE> newValue) {
        if (!this.theCache.containsKey(key)) {
            return false;
        }
        if (!this.theCache.get(key).equals(oldValue)) {
            return false;
        }
        if (!this.fireEvent(new CEvent(this, EventType.UPDATED, key, newValue, oldValue))) {
            this.log.info("aborting cache operation");
            return false;
        }
        this.theCache.put(key, newValue);
        return true;
    }

    public boolean replace(K key, CacheEntry<CE> value) {
        if (!this.theCache.containsKey(key)) {
            return false;
        }
        if (!this.fireEvent(new CEvent(this, EventType.UPDATED, key, value, null))) {
            this.log.info("aborting cache operation");
            return false;
        }
        this.theCache.put(key, value);
        return true;
    }

    public CacheEntry<CE> getAndReplace(K key, CacheEntry<CE> value) {
        if (this.theCache.containsKey(key)) {
            CacheEntry<CE> oldValue = this.theCache.get(key);
            if (!this.fireEvent(new CEvent(this, EventType.UPDATED, key, value, oldValue))) {
                this.log.info("aborting cache operation");
                return oldValue;
            }
            this.theCache.put(key, value);
            return oldValue;
        }
        return null;
    }

    public void removeAll(Set<? extends K> keys) {
        for (K k : keys) {
            if (!this.fireEvent(new CEvent(this, EventType.REMOVED, k, null, null))) {
                this.log.info("aborting cache operation");
                continue;
            }
            this.theCache.remove(k);
        }
    }

    public void removeAll() {
        if (!this.fireEvent(new CEvent(this, EventType.REMOVED, null, null, null))) {
            this.log.info("aborting cache clear operation");
            return;
        }
        this.theCache.clear();
    }

    public void clear() {
        if (!this.fireEvent(new CEvent(this, EventType.REMOVED, null, null, null))) {
            this.log.info("aborting cache clear operation");
            return;
        }
        this.theCache.clear();
    }

    public <C extends Configuration<K, CacheEntry<CE>>> C getConfiguration(Class<C> clazz) {
        return null;
    }

    public <T> T invoke(K key, EntryProcessor<K, CacheEntry<CE>, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        throw new RuntimeException("not implemented yet, sorry");
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, CacheEntry<CE>, T> entryProcessor, Object ... arguments) {
        throw new RuntimeException("not implemented yet, sorry");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, CacheEntry<CE>> cacheEntryListenerConfiguration) {
        CacheEntryEventFilter ef = (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create();
        this.listeners.put(ef, (CacheEntryListener)cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create());
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, CacheEntry<CE>> cacheEntryListenerConfiguration) {
        CacheEntryEventFilter ef = (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create();
        this.listeners.remove(ef, cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create());
    }

    public Iterator<Cache.Entry<K, CacheEntry<CE>>> iterator() {
        return new Iterator<Cache.Entry<K, CacheEntry<CE>>>(){
            Iterator<Map.Entry<K, CacheEntry<CE>>> it;
            {
                this.it = CacheImpl.this.theCache.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Cache.Entry<K, CacheEntry<CE>> next() {
                final Map.Entry entry = this.it.next();
                Cache.Entry ret = new Cache.Entry<K, CacheEntry<CE>>(){

                    public K getKey() {
                        return entry.getKey();
                    }

                    public CacheEntry<CE> getValue() {
                        return (CacheEntry)entry.getValue();
                    }

                    public <T> T unwrap(Class<T> clazz) {
                        return clazz.cast(this);
                    }
                };
                return ret;
            }
        };
    }

    public int getSize() {
        return this.theCache.size();
    }

    public void expire(Object k) {
        this.theCache.remove(k);
    }

    private boolean fireEvent(CacheEntryEvent<K, CacheEntry<CE>> evt) {
        EventType type = evt.getEventType();
        boolean ret = true;
        for (CacheEntryEventFilter<? super K, ? super CacheEntry<CE>> cacheEntryEventFilter : this.listeners.keySet()) {
            try {
                if (!cacheEntryEventFilter.evaluate(evt)) continue;
                switch (type) {
                    case CREATED: {
                        if (!(this.listeners.get(cacheEntryEventFilter) instanceof CacheEntryCreatedListener)) break;
                        CacheEntryCreatedListener l = (CacheEntryCreatedListener)this.listeners.get(cacheEntryEventFilter);
                        ArrayList<CacheEntryEvent<K, CacheEntry<CE>>> lst = new ArrayList<CacheEntryEvent<K, CacheEntry<CE>>>();
                        lst.add(evt);
                        l.onCreated(lst::listIterator);
                        break;
                    }
                    case EXPIRED: {
                        if (!(this.listeners.get(cacheEntryEventFilter) instanceof CacheEntryExpiredListener)) break;
                        CacheEntryCreatedListener l = (CacheEntryExpiredListener)this.listeners.get(cacheEntryEventFilter);
                        ArrayList<CacheEntryEvent<K, CacheEntry<CE>>> lst = new ArrayList();
                        lst.add(evt);
                        l.onExpired(lst::listIterator);
                        break;
                    }
                    case REMOVED: {
                        if (!(this.listeners.get(cacheEntryEventFilter) instanceof CacheEntryRemovedListener)) break;
                        CacheEntryCreatedListener l = (CacheEntryRemovedListener)this.listeners.get(cacheEntryEventFilter);
                        ArrayList<CacheEntryEvent<K, CacheEntry<CE>>> lst = new ArrayList();
                        lst.add(evt);
                        l.onRemoved(lst::listIterator);
                        break;
                    }
                    case UPDATED: {
                        if (!(this.listeners.get(cacheEntryEventFilter) instanceof CacheEntryUpdatedListener)) break;
                        CacheEntryCreatedListener l = (CacheEntryUpdatedListener)this.listeners.get(cacheEntryEventFilter);
                        ArrayList<CacheEntryEvent<K, CacheEntry<CE>>> lst = new ArrayList();
                        lst.add(evt);
                        l.onUpdated(lst::listIterator);
                    }
                }
            }
            catch (CacheEventVetoException cev) {
                ret = false;
            }
        }
        return ret;
    }

    public class CEvent
    extends CacheEntryEvent<K, CacheEntry<CE>> {
        private CacheEntry<CE> value;
        private CacheEntry<CE> oldValue;
        private K key;

        public CEvent(Cache source, EventType t, K k, CacheEntry<CE> v, CacheEntry<CE> ov) {
            super(source, t);
            this.value = v;
            this.oldValue = ov;
            this.key = k;
        }

        public CacheEntry<CE> getValue() {
            return this.value;
        }

        public CacheEntry<CE> getOldValue() {
            return this.oldValue;
        }

        public boolean isOldValueAvailable() {
            return this.oldValue != null;
        }

        public K getKey() {
            return this.key;
        }

        public <T> T unwrap(Class<T> clazz) {
            return clazz.cast((Object)this);
        }
    }
}

