/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheListener;
import de.caluga.morphium.cache.CacheObject;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.jcache.CacheEntry;
import de.caluga.morphium.cache.jcache.CachingProviderImpl;
import de.caluga.morphium.cache.jcache.HouseKeepingHelper;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.expiry.EternalExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumCacheJCacheImpl
implements MorphiumCache,
CacheEntryExpiredListener,
CacheEntryCreatedListener,
CacheEntryRemovedListener,
CacheEntryUpdatedListener {
    public static final String RESULT_CACHE_NAME = "resultCache";
    public static final String ID_CACHE_NAME = "idCache";
    private CacheManager cacheManager;
    private MorphiumConfig cfg;
    private Map<Class, javax.cache.Cache> idCaches = new HashMap<Class, javax.cache.Cache>();
    private Map<Class, javax.cache.Cache> resultCaches = new HashMap<Class, javax.cache.Cache>();
    private AnnotationAndReflectionHelper anHelper = new AnnotationAndReflectionHelper(false);
    private List<CacheListener> cacheListeners = new Vector<CacheListener>();
    private Logger log = LoggerFactory.getLogger(MorphiumCacheJCacheImpl.class);
    private ScheduledThreadPoolExecutor housekeeping = new ScheduledThreadPoolExecutor(1);
    private HouseKeepingHelper hkHelper = new HouseKeepingHelper();
    private final Runnable hkTask;

    public MorphiumCacheJCacheImpl() {
        this.cfg = new MorphiumConfig();
        this.hkHelper.setGlobalValidCacheTime(this.cfg.getGlobalCacheValidTime());
        this.hkHelper.setAnnotationHelper(new AnnotationAndReflectionHelper(false));
        this.hkTask = () -> {
            for (String k : this.getCacheManager().getCacheNames()) {
                this.hkHelper.housekeep(this.getCacheManager().getCache(k));
            }
        };
        this.housekeeping.scheduleWithFixedDelay(this.hkTask, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.resultCaches.clear();
        this.idCaches.clear();
    }

    @Override
    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            try {
                this.cacheManager = Caching.getCachingProvider().getCacheManager();
            }
            catch (Exception e) {
                this.log.info("using default cache Manager - " + e.getMessage());
                this.cacheManager = new CachingProviderImpl().getCacheManager();
            }
        }
        return this.cacheManager;
    }

    @Override
    public <T> void addToCache(String k, Class<? extends T> type, List<T> ret) {
        javax.cache.Cache<Object, CacheEntry<? extends T>> idCache = this.getIdCache(type);
        javax.cache.Cache<Object, CacheEntry<List<? extends T>>> resultCache = this.getResultCache(type);
        for (T obj : ret) {
            Object id = this.anHelper.getId(obj);
            if (idCache.containsKey(id)) continue;
            idCache.put(id, new CacheEntry<T>(obj, id));
        }
        resultCache.put((Object)k, new CacheEntry<List<T>>(ret, k));
    }

    @Override
    public Map<String, Integer> getSizes() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String n : this.getCacheManager().getCacheNames()) {
            javax.cache.Cache c = this.getCacheManager().getCache(n);
            try {
                Method m = c.getClass().getMethod("getSize", new Class[0]);
                ret.put(n, (Integer)m.invoke((Object)c, new Object[0]));
            }
            catch (Exception e) {
                Iterator iterator = c.iterator();
                int size = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    ++size;
                }
                ret.put(n, size);
            }
        }
        return ret;
    }

    @Override
    public String getCacheKey(Class type, Map<String, Object> qo, Map<String, Integer> sort, Map<String, Object> projection, String collection, int skip, int limit) {
        return Utils.getCacheKey(type, qo, sort, projection, collection, skip, limit, this.anHelper);
    }

    @Override
    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        javax.cache.Cache<Object, CacheEntry<List<? extends T>>> resultCache = this.getResultCache(type);
        if (resultCache.get((Object)k) != null) {
            return (List)((CacheEntry)resultCache.get((Object)k)).getResult();
        }
        return null;
    }

    private <T> javax.cache.Cache<Object, CacheEntry<T>> getIdCache(Class<? extends T> type) {
        javax.cache.Cache cache;
        if (this.idCaches.containsKey(type)) {
            return this.idCaches.get(type);
        }
        this.log.info("Creating new cache for " + type.getName());
        MutableConfiguration config = new MutableConfiguration().setTypes(Object.class, Object.class).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf()).setStoreByValue(false).setStatisticsEnabled(false);
        try {
            cache = this.getCacheManager().createCache("idCache|" + type.getName(), (Configuration)config);
        }
        catch (Exception e) {
            cache = this.getCacheManager().getCache("idCache|" + type.getName());
        }
        this.idCaches.put(type, cache);
        return cache;
    }

    private <T> javax.cache.Cache<Object, CacheEntry<List<T>>> getResultCache(Class<? extends T> type) {
        if (this.resultCaches.containsKey(type)) {
            return this.resultCaches.get(type);
        }
        javax.cache.Cache cache = null;
        this.log.info("Creating new cache for " + type.getName());
        MutableConfiguration config = new MutableConfiguration().setTypes(Object.class, Object.class).setStoreByValue(false).setExpiryPolicyFactory(EternalExpiryPolicy.factoryOf()).setStatisticsEnabled(false);
        try {
            cache = this.getCacheManager().createCache("resultCache|" + type.getName(), (Configuration)config);
        }
        catch (Exception e) {
            cache = this.getCacheManager().getCache("resultCache|" + type.getName());
        }
        this.resultCaches.put(type, cache);
        return cache;
    }

    @Override
    public void clearCachefor(Class<?> cls) {
        this.getIdCache(cls).clear();
        this.getResultCache(cls).clear();
    }

    @Override
    public void resetCache() {
        this.getCacheManager().close();
    }

    @Override
    public void removeEntryFromIdCache(Class cls, Object id) {
        this.getIdCache(cls).remove(id);
    }

    @Override
    public void removeEntryFromCache(Class cls, Object id) {
        Object obj = this.getIdCache(cls).get(id);
        if (obj != null) {
            this.getIdCache(cls).remove(id);
        }
        HashSet<Object> toRemove = new HashSet<Object>();
        for (Cache.Entry entry : this.getResultCache(cls)) {
            for (Object el : (List)((CacheEntry)entry.getValue()).getResult()) {
                Object lid = this.anHelper.getId(el);
                if (lid == null) {
                    this.log.error("Null id in CACHE?");
                    toRemove.add(entry.getKey());
                }
                if (lid == null || !lid.equals(id)) continue;
                toRemove.add(entry.getKey());
            }
        }
        this.getResultCache(cls).removeAll(toRemove);
    }

    @Override
    public <T> T getFromIDCache(Class<? extends T> type, Object id) {
        javax.cache.Cache<Object, CacheEntry<? extends T>> c = this.getIdCache(type);
        if (!c.containsKey(id)) {
            return null;
        }
        return ((CacheEntry)c.get(id)).getResult();
    }

    @Override
    public String getCacheKey(Query q) {
        return this.getCacheKey(q.getType(), q.toQueryObject(), q.getSort(), q.getFieldListForQuery(), q.getCollectionName(), q.getSkip(), q.getLimit());
    }

    @Override
    public boolean isCached(Class<?> type, String k) {
        return this.getResultCache(type).containsKey((Object)k);
    }

    @Override
    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.anHelper.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            this.clearCachefor(cls);
        }
    }

    @Override
    public void addCacheListener(CacheListener cl) {
        this.cacheListeners.add(cl);
    }

    @Override
    public void removeCacheListener(CacheListener cl) {
        this.cacheListeners.remove(cl);
    }

    @Override
    public boolean isListenerRegistered(CacheListener cl) {
        return this.cacheListeners.contains(cl);
    }

    @Override
    public void setGlobalCacheTimeout(int tm) {
        this.hkHelper.setGlobalValidCacheTime(tm);
    }

    @Override
    public void setAnnotationAndReflectionHelper(AnnotationAndReflectionHelper hlp) {
        this.anHelper = hlp;
    }

    @Override
    public void setHouskeepingIntervalPause(int p) {
        this.housekeeping.remove(this.hkTask);
        this.housekeeping.scheduleAtFixedRate(this.hkTask, p, p, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setValidCacheTime(Class type, int time) {
        this.hkHelper.setValidCacheTime(type, time);
    }

    @Override
    public void setDefaultCacheTime(Class type) {
        this.hkHelper.setDefaultValidCacheTime(type);
    }

    public void onCreated(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldAddToCache(evt.getKey(), (CacheObject)evt.getValue(), false);
            });
        }
    }

    public void onExpired(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldRemoveEntryFromCache(evt.getKey(), (CacheObject)evt.getValue(), true);
            });
        }
    }

    public void onRemoved(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                if (evt.getKey() == null) {
                    try {
                        cl.wouldClearCache(Class.forName(evt.getSource().getCacheManager().getURI().toString()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheEntryListenerException("Could not get type", (Throwable)e);
                    }
                } else {
                    cl.wouldRemoveEntryFromCache(evt.getKey(), (CacheObject)evt.getValue(), false);
                }
            });
        }
    }

    public void onUpdated(Iterable iterable) throws CacheEntryListenerException {
        for (CacheListener cl : this.cacheListeners) {
            iterable.forEach(o -> {
                CacheEntryEvent evt = (CacheEntryEvent)o;
                cl.wouldAddToCache(evt.getKey(), (CacheObject)evt.getValue(), true);
            });
        }
    }
}

