/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.cache.CacheObject;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.MorphiumCacheImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHousekeeper
extends Thread
implements ShutdownListener {
    private int housekeepingIntervalPause = 500;
    private Map<Class<?>, Integer> validTimeForClass;
    private int gcTimeout = 5000;
    private boolean running = true;
    private Logger log = LoggerFactory.getLogger(CacheHousekeeper.class);
    private AnnotationAndReflectionHelper annotationHelper;
    private MorphiumCache morphiumCache;

    public CacheHousekeeper(MorphiumCache m) {
        this.validTimeForClass = new ConcurrentHashMap();
        this.setDaemon(true);
        this.morphiumCache = m;
    }

    public void setGlobalValidCacheTime(int gc) {
        this.gcTimeout = gc;
    }

    public void setHouskeepingPause(int p) {
        this.housekeepingIntervalPause = p;
    }

    public void setAnnotationHelper(AnnotationAndReflectionHelper hlp) {
        this.annotationHelper = hlp;
    }

    public void setValidCacheTime(Class<?> cls, int timeout) {
        this.validTimeForClass.put(cls, timeout);
    }

    public void setDefaultValidCacheTime(Class cls) {
        this.validTimeForClass.remove(cls);
    }

    public Integer getValidCacheTime(Class<?> cls) {
        return this.validTimeForClass.get(cls);
    }

    public void end() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.annotationHelper == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                HashMap toDelete = new HashMap();
                Map<Class<?>, Map<String, CacheObject>> cache = ((MorphiumCacheImpl)this.morphiumCache).getCache();
                for (Map.Entry<Class<?>, Map<String, CacheObject>> entry : cache.entrySet()) {
                    Class<?> clz = entry.getKey();
                    Map<String, CacheObject> ch = entry.getValue();
                    int maxEntries = -1;
                    Cache cacheSettings = this.annotationHelper.getAnnotationFromHierarchy(clz, Cache.class);
                    NoCache noCache = this.annotationHelper.getAnnotationFromHierarchy(clz, NoCache.class);
                    int time = this.gcTimeout;
                    HashMap lruTime = new HashMap();
                    HashMap fifoTime = new HashMap();
                    Cache.ClearStrategy strategy = null;
                    if (noCache == null && cacheSettings != null) {
                        if (cacheSettings.timeout() != -1) {
                            time = cacheSettings.timeout();
                        }
                        maxEntries = cacheSettings.maxEntries();
                        strategy = cacheSettings.strategy();
                        this.validTimeForClass.putIfAbsent(clz, time);
                    }
                    if (this.validTimeForClass.get(clz) != null) {
                        time = this.validTimeForClass.get(clz);
                    }
                    int del = 0;
                    for (Map.Entry<String, CacheObject> est : ch.entrySet()) {
                        String k = est.getKey();
                        CacheObject e = est.getValue();
                        if (e == null || e.getResult() == null || System.currentTimeMillis() - e.getCreated() > (long)time) {
                            toDelete.putIfAbsent(clz, new ArrayList());
                            ((List)toDelete.get(clz)).add(k);
                            ++del;
                            continue;
                        }
                        lruTime.putIfAbsent(e.getLru(), new ArrayList());
                        ((List)lruTime.get(e.getLru())).add(k);
                        long fifo = System.currentTimeMillis() - e.getCreated();
                        fifoTime.putIfAbsent(fifo, new ArrayList());
                        ((List)fifoTime.get(fifo)).add(k);
                    }
                    if (maxEntries <= 0 || cache.get(clz).size() - del <= maxEntries) continue;
                    switch (strategy) {
                        case LRU: {
                            Object[] array = lruTime.keySet().toArray(new Long[0]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).isEmpty()) continue;
                                toDelete.putIfAbsent(clz, new ArrayList());
                                ((List)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ((List)lruTime.get(array[idx])).remove(0);
                                ++del;
                                if (!((List)lruTime.get(array[idx])).isEmpty()) continue;
                                ++idx;
                            }
                            break;
                        }
                        case FIFO: {
                            Object[] array = fifoTime.keySet().toArray(new Long[0]);
                            Arrays.sort(array);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (fifoTime.get(array[array.length - 1 - idx]) == null || ((List)fifoTime.get(array[array.length - 1 - idx])).isEmpty()) continue;
                                toDelete.putIfAbsent(clz, new ArrayList());
                                ((List)toDelete.get(clz)).add(((List)fifoTime.get(array[array.length - 1 - idx])).get(0));
                                ((List)fifoTime.get(array[array.length - 1 - idx])).remove(0);
                                ++del;
                                if (!((List)fifoTime.get(array[array.length - 1 - idx])).isEmpty()) continue;
                                ++idx;
                            }
                            break;
                        }
                        case RANDOM: {
                            Object[] array = fifoTime.keySet().toArray(new Long[0]);
                            List<Object> lst = Arrays.asList(array);
                            Collections.shuffle(lst);
                            array = lst.toArray(new Long[0]);
                            int idx = 0;
                            while (cache.get(clz).size() - del > maxEntries) {
                                if (lruTime.get(array[idx]) == null || ((List)lruTime.get(array[idx])).isEmpty()) continue;
                                toDelete.putIfAbsent(clz, new ArrayList());
                                ((List)toDelete.get(clz)).add(((List)lruTime.get(array[idx])).get(0));
                                ++del;
                                if (!((List)lruTime.get(array[idx])).isEmpty()) continue;
                                ++idx;
                            }
                            break;
                        }
                    }
                }
                for (Map.Entry<Class<Object>, Map<String, CacheObject<Object>>> entry : toDelete.entrySet()) {
                    Class<Object> cls = entry.getKey();
                    for (String k : (List)((Object)entry.getValue())) {
                        if (k.endsWith("idlist")) continue;
                        for (Object f : (List)cache.get(cls).get(k).getResult()) {
                            this.morphiumCache.removeEntryFromIdCache(cls, this.annotationHelper.getId(f));
                        }
                        cache.get(cls).remove(k);
                    }
                }
            }
            catch (Throwable e) {
                this.log.warn("Error:" + e.getMessage(), e);
            }
            try {
                CacheHousekeeper.sleep(this.housekeepingIntervalPause);
            }
            catch (InterruptedException e) {
                this.log.info("Ignoring InterruptedException");
            }
        }
    }

    @Override
    public void onShutdown(Morphium m) {
        this.end();
    }
}

