/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.aggregation.Aggregator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group<T, R> {
    private Logger log = LoggerFactory.getLogger(Group.class);
    private Aggregator<T, R> aggregator;
    private Map<String, Object> id;
    private boolean ended = false;
    private List<Map<String, Object>> operators = new ArrayList<Map<String, Object>>();

    public Group(Aggregator<T, R> ag, String id) {
        this.aggregator = ag;
        this.id = this.getMap("_id", id);
    }

    public Group(Aggregator<T, R> ag, Map<String, Object> id) {
        this.aggregator = ag;
        this.id = this.getMap("_id", id);
    }

    private Map<String, Object> getMap(String key, Object value) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(key, value);
        return ret;
    }

    public Group<T, R> addToSet(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$addToSet", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> addToSet(String name, Map<String, Object> param) {
        Map<String, Object> o = this.getMap(name, this.getMap("$addToSet", param));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> first(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$first", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> last(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$last", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> max(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$max", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> min(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$min", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> avg(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$avg", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> push(String name, Object o) {
        Map<String, Object> jp = this.getMap(name, this.getMap("$push", o));
        this.operators.add(jp);
        return this;
    }

    public Group<T, R> push(String name, String vn, String value) {
        Map<String, Object> o = this.getMap(name, this.getMap("$push", this.getMap(vn, value)));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, int p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, long p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> sum(String name, Object p) {
        Map<String, Object> o = this.getMap(name, this.getMap("$sum", p));
        this.operators.add(o);
        return this;
    }

    public Group<T, R> sum(String name, String p) {
        return this.sum(name, (Object)p);
    }

    public Group<T, R> stdDevPop(String name, Object value) {
        this.operators.add(this.getMap(name, this.getMap("$stdDevPop", value)));
        return this;
    }

    public Group<T, R> stdDevSamp(String name, Object value) {
        this.operators.add(this.getMap(name, this.getMap("stdDevSamp", value)));
        return this;
    }

    public Aggregator<T, R> end() {
        if (this.ended) {
            this.log.error("Group.end() already called!");
            return this.aggregator;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.id);
        this.operators.forEach(params::putAll);
        Map<String, Object> obj = this.getMap("$group", params);
        this.aggregator.addOperator(obj);
        this.ended = true;
        return this.aggregator;
    }

    public List<Map<String, Object>> getOperators() {
        return this.operators;
    }
}

