/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.BinarySerializedObject;
import de.caluga.morphium.Logger;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.MorphiumReference;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.ObjectMapper;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.TypeMapper;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.ReadOnly;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.UseIfnull;
import de.caluga.morphium.annotations.WriteOnly;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.mapping.BigIntegerTypeMapper;
import de.caluga.morphium.query.Query;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.reflect.ReflectionFactory;

public class ObjectMapperImpl
implements ObjectMapper {
    private static final Logger log = new Logger(ObjectMapperImpl.class);
    private final ReflectionFactory reflection = ReflectionFactory.getReflectionFactory();
    private final Map<Class<?>, NameProvider> nameProviders;
    private final JSONParser jsonParser = new JSONParser();
    private final Map<Class, TypeMapper> customMapper;
    private final List<Class<?>> mongoTypes;
    private final ContainerFactory containerFactory;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper(true);
    private Morphium morphium;

    public ObjectMapperImpl() {
        this.nameProviders = new Hashtable();
        this.mongoTypes = Collections.synchronizedList(new ArrayList());
        this.mongoTypes.add(String.class);
        this.mongoTypes.add(Character.class);
        this.mongoTypes.add(Integer.class);
        this.mongoTypes.add(Long.class);
        this.mongoTypes.add(Float.class);
        this.mongoTypes.add(Double.class);
        this.mongoTypes.add(Date.class);
        this.mongoTypes.add(Boolean.class);
        this.mongoTypes.add(Byte.class);
        this.customMapper = new Hashtable<Class, TypeMapper>();
        this.customMapper.put(BigInteger.class, new BigIntegerTypeMapper());
        this.containerFactory = new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        };
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m != null ? m.getARHelper() : new AnnotationAndReflectionHelper(true);
    }

    @Override
    public void setNameProviderForClass(Class<?> cls, NameProvider np) {
        this.nameProviders.put(cls, np);
    }

    @Override
    public NameProvider getNameProviderForClass(Class<?> cls) {
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (e == null) {
            throw new IllegalArgumentException("no entity annotation found");
        }
        try {
            return this.getNameProviderForClass(cls, e);
        }
        catch (Exception ex) {
            log.error("Error getting nameProvider", ex);
            throw new IllegalArgumentException("could not get name provicer", ex);
        }
    }

    private NameProvider getNameProviderForClass(Class<?> cls, Entity p) throws IllegalAccessException, InstantiationException {
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        if (this.nameProviders.get(cls) == null) {
            NameProvider np = p.nameProvider().newInstance();
            this.setNameProviderForClass(cls, np);
        }
        return this.nameProviders.get(cls);
    }

    @Override
    public String getCollectionName(Class cls) {
        Entity p = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
        if (p == null) {
            throw new IllegalArgumentException("No Entity " + cls.getSimpleName());
        }
        try {
            cls = this.annotationHelper.getRealClass(cls);
            NameProvider np = this.getNameProviderForClass(cls, p);
            return np.getCollectionName(cls, this, p.translateCamelCase(), p.useFQN(), p.collectionName().equals(".") ? null : p.collectionName(), this.morphium);
        }
        catch (InstantiationException e) {
            log.error("Could not instanciate NameProvider: " + p.nameProvider().getName(), e);
            throw new RuntimeException("Could not Instaciate NameProvider", e);
        }
        catch (IllegalAccessException e) {
            log.error("Illegal Access during instanciation of NameProvider: " + p.nameProvider().getName(), e);
            throw new RuntimeException("Illegal Access during instanciation", e);
        }
    }

    @Override
    public Object marshallIfNecessary(Object o) {
        if (o == null) {
            return null;
        }
        if (this.annotationHelper.isEntity(o)) {
            return this.marshall(o);
        }
        if (o.getClass().isPrimitive()) {
            return o;
        }
        if (o.getClass().isArray()) {
            if (o.getClass().getComponentType().equals(Byte.TYPE)) {
                return o;
            }
            ArrayList<Object> lst = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(o); ++i) {
                lst.add(this.marshallIfNecessary(Array.get(o, i)));
            }
            return this.createDBList(lst);
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            ArrayList lst = new ArrayList((Collection)o);
            return this.createDBList(lst);
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            return this.createDBMap((Map)o);
        }
        if (o instanceof MorphiumId) {
            o = new ObjectId(((MorphiumId)o).getBytes());
        }
        return o;
    }

    @Override
    public void registerCustomTypeMapper(Class c, TypeMapper m) {
        this.customMapper.put(c, m);
    }

    @Override
    public void deregisterTypeMapper(Class c) {
        this.customMapper.remove(c);
    }

    private boolean hasCustomMapper(Class c) {
        return this.customMapper.get(c) != null;
    }

    @Override
    public Map<String, Object> marshall(Object o) {
        Class<?> c = this.annotationHelper.getRealClass(o.getClass());
        if (this.hasCustomMapper(c)) {
            Object ret = this.customMapper.get(c).marshall(o);
            if (!(ret instanceof Map)) {
                return Utils.getMap("value", ret);
            }
            return (Map)ret;
        }
        if (!this.annotationHelper.isEntity(o)) {
            if (this.morphium.getConfig().isObjectSerializationEnabled()) {
                if (o instanceof Serializable) {
                    try {
                        BinarySerializedObject obj = new BinarySerializedObject();
                        obj.setOriginalClassName(o.getClass().getName());
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream oout = new ObjectOutputStream(out);
                        oout.writeObject(o);
                        oout.flush();
                        BASE64Encoder enc = new BASE64Encoder();
                        String str = enc.encode(out.toByteArray());
                        obj.setB64Data(str);
                        return this.marshall(obj);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Binary serialization failed! " + o.getClass().getName(), e);
                    }
                }
                throw new IllegalArgumentException("Cannot write object to db that is neither entity, embedded nor serializable!");
            }
            throw new IllegalArgumentException("Object is no entity: " + o.getClass().getSimpleName());
        }
        HashMap<String, Object> dbo = new HashMap<String, Object>();
        if (o == null) {
            return dbo;
        }
        Class<?> cls = this.annotationHelper.getRealClass(o.getClass());
        if (cls == null) {
            throw new IllegalArgumentException("No real class?");
        }
        o = this.annotationHelper.getRealObject(o);
        List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
        if (flds == null) {
            throw new IllegalArgumentException("Fields not found? " + cls.getName());
        }
        Entity e = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Entity.class);
        Embedded emb = this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Embedded.class);
        if (e != null && e.polymorph()) {
            dbo.put("class_name", cls.getName());
        }
        if (emb != null && emb.polymorph()) {
            dbo.put("class_name", cls.getName());
        }
        Iterator<String> iterator = flds.iterator();
        while (iterator.hasNext()) {
            String f;
            String fName = f = iterator.next();
            try {
                ArrayList<Object> lst;
                Field fld = this.annotationHelper.getField(cls, f);
                if (fld == null) {
                    log.error("Field not found");
                    continue;
                }
                if (Modifier.isStatic(fld.getModifiers()) || fld.isAnnotationPresent(ReadOnly.class)) continue;
                AdditionalData ad = fld.getAnnotation(AdditionalData.class);
                if (ad != null) {
                    if (ad.readOnly() || fld.get(o) == null) continue;
                    dbo.putAll(this.createDBMap((Map)fld.get(o)));
                    continue;
                }
                if (dbo.containsKey(fName)) {
                    log.warn("Field " + fName + " is shadowed - inherited values?");
                    continue;
                }
                if (fld.isAnnotationPresent(Id.class)) {
                    fName = "_id";
                }
                Object v = null;
                Object value = fld.get(o);
                if (fld.isAnnotationPresent(Reference.class)) {
                    Reference r = fld.getAnnotation(Reference.class);
                    if (value == null) {
                        v = null;
                    } else if (Collection.class.isAssignableFrom(fld.getType())) {
                        lst = new ArrayList<Object>();
                        for (Object rec2 : (Collection)value) {
                            if (rec2 != null) {
                                Object id = this.annotationHelper.getId(rec2);
                                if (id == null) {
                                    id = this.automaticStore(r, rec2);
                                }
                                if (this.morphium == null) {
                                    throw new RuntimeException("cannot set dbRef - morphium is not set");
                                }
                                MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec2.getClass()).getName(), id);
                                lst.add(this.marshall(ref));
                                continue;
                            }
                            lst.add(null);
                        }
                        v = lst;
                    } else if (Map.class.isAssignableFrom(fld.getType())) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        ((Map)value).forEach((key, rec) -> {
                            Object id = this.annotationHelper.getId(rec);
                            if (id == null) {
                                id = this.automaticStore(r, rec);
                            }
                            if (this.morphium == null) {
                                throw new RuntimeException("cannot set dbRef - morphium is not set");
                            }
                            MorphiumReference ref = new MorphiumReference(this.annotationHelper.getRealClass(rec.getClass()).getName(), id);
                            map.put((String)key, this.marshall(ref));
                        });
                        v = map;
                    } else {
                        if (this.annotationHelper.getId(value) == null) {
                            if (r.automaticStore()) {
                                if (this.morphium == null) {
                                    log.fatal("Could not store - no Morphium set!");
                                } else {
                                    this.morphium.storeNoCache(value);
                                }
                            } else {
                                throw new IllegalArgumentException("Reference to be stored, that is null!");
                            }
                        }
                        v = this.annotationHelper.getId(value);
                    }
                } else {
                    Class<?> valueClass = value == null ? fld.getType() : value.getClass();
                    if (this.hasCustomMapper(valueClass)) {
                        v = this.customMapper.get(valueClass).marshall(value);
                    } else if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Entity.class)) {
                        if (value != null) {
                            Map<String, Object> obj = this.marshall(value);
                            obj.remove("_id");
                            v = obj;
                        }
                    } else if (this.annotationHelper.isAnnotationPresentInHierarchy(valueClass, Embedded.class)) {
                        if (value != null) {
                            v = this.marshall(value);
                        }
                    } else {
                        v = value;
                        if (v != null) {
                            if (v instanceof Map) {
                                v = this.createDBMap((Map)v);
                            } else if (v.getClass().isArray()) {
                                if (!v.getClass().getComponentType().equals(Byte.TYPE)) {
                                    lst = new ArrayList();
                                    for (int i = 0; i < Array.getLength(v); ++i) {
                                        lst.add(this.marshallIfNecessary(Array.get(v, i)));
                                    }
                                    v = this.createDBList(lst);
                                }
                            } else if (v instanceof List) {
                                v = this.createDBList((List)v);
                            } else if (v instanceof Iterable) {
                                lst = new ArrayList();
                                for (Object i : (Iterable)v) {
                                    lst.add(i);
                                }
                                v = this.createDBList(lst);
                            } else if (v.getClass().equals(GregorianCalendar.class)) {
                                v = ((GregorianCalendar)v).getTime();
                            } else if (v.getClass().equals(MorphiumId.class)) {
                                v = new ObjectId(((MorphiumId)v).getBytes());
                            } else if (v.getClass().isEnum()) {
                                v = ((Enum)v).name();
                            }
                        }
                    }
                }
                if (v == null && !fld.isAnnotationPresent(UseIfnull.class)) continue;
                dbo.put(fName, v);
            }
            catch (IllegalAccessException exc) {
                log.fatal("Illegal Access to field " + f);
            }
        }
        return dbo;
    }

    private Object automaticStore(Reference r, Object rec) {
        String coll;
        if (r.automaticStore()) {
            if (this.morphium == null) {
                throw new RuntimeException("Could not automagically store references as morphium is not set!");
            }
            coll = r.targetCollection();
            if (coll.equals(".")) {
                coll = null;
            }
        } else {
            throw new IllegalArgumentException("Cannot store reference to unstored entity if automaticStore in @Reference is set to false!");
        }
        this.morphium.storeNoCache(rec, coll);
        Object id = this.annotationHelper.getId(rec);
        return id;
    }

    private List<Object> createDBList(List v) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object lo : v) {
            if (lo != null) {
                if (this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(lo.getClass(), Embedded.class)) {
                    Map<String, Object> marshall = this.marshall(lo);
                    marshall.put("class_name", lo.getClass().getName());
                    lst.add(marshall);
                    continue;
                }
                if (lo instanceof List) {
                    lst.add(this.createDBList((List)lo));
                    continue;
                }
                if (lo instanceof Map) {
                    lst.add(this.createDBMap((Map)lo));
                    continue;
                }
                if (lo instanceof MorphiumId) {
                    lst.add(new ObjectId(((MorphiumId)lo).getBytes()));
                    continue;
                }
                if (lo.getClass().isEnum()) {
                    HashMap<String, String> obj = new HashMap<String, String>();
                    obj.put("class_name", lo.getClass().getName());
                    obj.put("name", ((Enum)lo).name());
                    lst.add(obj);
                    continue;
                }
                if (lo.getClass().isPrimitive() || this.mongoTypes.contains(lo.getClass())) {
                    lst.add(lo);
                    continue;
                }
                if (lo.getClass().isArray()) {
                    if (lo.getClass().getComponentType().equals(Byte.TYPE)) {
                        lst.add(lo);
                        continue;
                    }
                    for (int i = 0; i < Array.getLength(lo); ++i) {
                        try {
                            lst.add(this.marshallIfNecessary(Array.get(lo, i)));
                            continue;
                        }
                        catch (Exception e) {
                            lst.add(this.marshallIfNecessary(((Integer)Array.get(lo, i)).byteValue()));
                        }
                    }
                    continue;
                }
                lst.add(this.marshall(lo));
                continue;
            }
            lst.add(null);
        }
        return lst;
    }

    private Map<String, Object> createDBMap(Map v) {
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Map.Entry es : v.entrySet()) {
            Object mval;
            Object k = es.getKey();
            if (!(k instanceof String)) {
                log.warn("Map in Mongodb needs to have String as keys - using toString");
                k = k.toString();
                if (((String)k).contains(".")) {
                    log.warn(". not allowed as Key in Maps - converting to _");
                    k = ((String)k).replaceAll("\\.", "_");
                }
            }
            if ((mval = es.getValue()) != null) {
                Map<String, Object> obj;
                if (this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(mval.getClass(), Embedded.class)) {
                    obj = this.marshall(mval);
                    obj.put("class_name", mval.getClass().getName());
                    mval = obj;
                } else if (mval instanceof Map) {
                    mval = this.createDBMap((Map)mval);
                } else if (mval instanceof List) {
                    mval = this.createDBList((List)mval);
                } else if (mval.getClass().isArray()) {
                    if (!mval.getClass().getComponentType().equals(Byte.TYPE)) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        for (int i = 0; i < Array.getLength(mval); ++i) {
                            lst.add(this.marshallIfNecessary(Array.get(mval, i)));
                        }
                        mval = this.createDBList(lst);
                    }
                } else if (mval.getClass().isEnum()) {
                    obj = new HashMap<String, Object>();
                    obj.put("class_name", mval.getClass().getName());
                    obj.put("name", ((Enum)mval).name());
                } else if (mval instanceof MorphiumId) {
                    mval = new ObjectId(((MorphiumId)mval).getBytes());
                } else if (!mval.getClass().isPrimitive() && !this.mongoTypes.contains(mval.getClass())) {
                    mval = this.marshall(mval);
                }
            }
            dbMap.put((String)k, mval);
        }
        return dbMap;
    }

    @Override
    public <T> T unmarshall(Class<? extends T> cls, String jsonString) throws ParseException {
        HashMap obj = (HashMap)this.jsonParser.parse(jsonString, this.containerFactory);
        return this.unmarshall(cls, obj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T unmarshall(Class<? extends T> theClass, Map<String, Object> o) {
        if (o == null) {
            return null;
        }
        Class<Object> cls = theClass;
        try {
            if (this.hasCustomMapper(cls)) {
                return this.customMapper.get(cls).unmarshall(o.get("value"));
            }
            if (this.morphium != null && this.morphium.getConfig().isObjectSerializationEnabled() && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(cls, Embedded.class)) {
                cls = BinarySerializedObject.class;
            }
            if (o.get("class_name") != null || o.get("className") != null) {
                try {
                    String cN = (String)o.get("class_name");
                    if (cN == null) {
                        cN = (String)o.get("className");
                    }
                    cls = Class.forName(cN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (cls.isEnum()) {
                T[] en = cls.getEnumConstants();
                for (Enum e : (Enum[])en) {
                    if (!e.name().equals(o.get("name"))) continue;
                    return (T)e;
                }
            }
            Object ret = null;
            try {
                ret = cls.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret == null) {
                try {
                    Constructor<?> constructor = this.reflection.newConstructorForSerialization(cls, Object.class.getDeclaredConstructor(new Class[0]));
                    ret = constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            if (ret == null) {
                throw new IllegalArgumentException("Could not instanciate " + cls.getName());
            }
            List<String> flds = this.annotationHelper.getFields(cls, new Class[0]);
            Iterator<String> e = flds.iterator();
            while (true) {
                Object value;
                String f;
                block104: {
                    Object arr;
                    ArrayList<Serializable> lst;
                    Field fld;
                    block127: {
                        Iterator iterator;
                        HashMap v;
                        MorphiumReference r;
                        Reference reference;
                        block111: {
                            Iterator<String> iterator2;
                            HashMap<String, Object> data;
                            block107: {
                                block105: {
                                    Object valueFromDb;
                                    block117: {
                                        block126: {
                                            block121: {
                                                block118: {
                                                    block119: {
                                                        block125: {
                                                            block124: {
                                                                block123: {
                                                                    block122: {
                                                                        block120: {
                                                                            block116: {
                                                                                block115: {
                                                                                    block114: {
                                                                                        block112: {
                                                                                            block113: {
                                                                                                block108: {
                                                                                                    Object id;
                                                                                                    block110: {
                                                                                                        block109: {
                                                                                                            block106: {
                                                                                                                if (!e.hasNext()) break block105;
                                                                                                                f = e.next();
                                                                                                                valueFromDb = o.get(f);
                                                                                                                fld = this.annotationHelper.getField(cls, f);
                                                                                                                if (Modifier.isStatic(fld.getModifiers()) || fld.isAnnotationPresent(WriteOnly.class)) continue;
                                                                                                                if (!fld.isAnnotationPresent(AdditionalData.class)) break block106;
                                                                                                                if (!Map.class.isAssignableFrom(fld.getType())) {
                                                                                                                    log.error("Could not unmarshall additional data into fld of type " + fld.getType().toString());
                                                                                                                    continue;
                                                                                                                }
                                                                                                                Set<String> keys = o.keySet();
                                                                                                                data = new HashMap<String, Object>();
                                                                                                                iterator2 = keys.iterator();
                                                                                                                break block107;
                                                                                                            }
                                                                                                            if (valueFromDb == null) continue;
                                                                                                            value = null;
                                                                                                            if (Collection.class.isAssignableFrom(fld.getType()) || !fld.isAnnotationPresent(Reference.class)) break block108;
                                                                                                            reference = fld.getAnnotation(Reference.class);
                                                                                                            r = null;
                                                                                                            if (this.morphium != null) break block109;
                                                                                                            log.fatal("Morphium not set - could not de-reference!");
                                                                                                            break block104;
                                                                                                        }
                                                                                                        if (!Map.class.isAssignableFrom(fld.getType())) break block110;
                                                                                                        v = new HashMap();
                                                                                                        iterator = ((Map)valueFromDb).entrySet().iterator();
                                                                                                        break block111;
                                                                                                    }
                                                                                                    if (!(valueFromDb instanceof Map)) {
                                                                                                        id = valueFromDb;
                                                                                                    } else {
                                                                                                        Map ref = (Map)valueFromDb;
                                                                                                        r = this.unmarshall(MorphiumReference.class, ref);
                                                                                                        id = r.getId();
                                                                                                    }
                                                                                                    String collection = this.getCollectionName(fld.getType());
                                                                                                    if (r != null && r.getCollectionName() != null) {
                                                                                                        collection = r.getCollectionName();
                                                                                                    }
                                                                                                    if (id != null) {
                                                                                                        if (reference.lazyLoading()) {
                                                                                                            List<String> lst2 = this.annotationHelper.getFields(fld.getType(), Id.class);
                                                                                                            if (lst2.isEmpty()) {
                                                                                                                throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                                                                                            }
                                                                                                            if (id instanceof String && this.annotationHelper.getField(fld.getType(), lst2.get(0)).getType().equals(MorphiumId.class)) {
                                                                                                                id = new MorphiumId(id.toString());
                                                                                                            }
                                                                                                            value = this.morphium.createLazyLoadedEntity(fld.getType(), id, ret, f, collection);
                                                                                                            break block104;
                                                                                                        } else {
                                                                                                            try {
                                                                                                                this.morphium.fireWouldDereference(ret, f, id, fld.getType(), false);
                                                                                                                value = this.morphium.findById(fld.getType(), id, collection);
                                                                                                                this.morphium.fireDidDereference(ret, f, value, false);
                                                                                                            }
                                                                                                            catch (MorphiumAccessVetoException e2) {
                                                                                                                log.info("not dereferencing due to veto from listener", e2);
                                                                                                            }
                                                                                                        }
                                                                                                        break block104;
                                                                                                    } else {
                                                                                                        value = null;
                                                                                                    }
                                                                                                    break block104;
                                                                                                }
                                                                                                if (!fld.isAnnotationPresent(Id.class)) break block112;
                                                                                                value = o.get("_id");
                                                                                                if (value == null || value.getClass().equals(fld.getType())) break block104;
                                                                                                log.debug("read value and field type differ...");
                                                                                                if (!fld.getType().equals(MorphiumId.class)) break block113;
                                                                                                log.debug("trying objectID conversion");
                                                                                                if (value.getClass().equals(String.class)) {
                                                                                                    try {
                                                                                                        value = new MorphiumId((String)value);
                                                                                                    }
                                                                                                    catch (Exception e3) {
                                                                                                        log.error("Value and field type differ - Id conversion failed - setting returning null", e3);
                                                                                                        return null;
                                                                                                    }
                                                                                                }
                                                                                                break block104;
                                                                                            }
                                                                                            if (value.getClass().equals(MorphiumId.class)) {
                                                                                                if (fld.getType().equals(String.class)) {
                                                                                                    value = value.toString();
                                                                                                    break block104;
                                                                                                } else {
                                                                                                    if (!fld.getType().equals(Long.class) && !fld.getType().equals(Long.TYPE)) {
                                                                                                        log.error("cannot convert - ID IS SET TO NULL. Type read from db is " + value.getClass().getName() + " - expected value is " + fld.getType().getName());
                                                                                                        return null;
                                                                                                    }
                                                                                                    value = ((MorphiumId)value).getTime();
                                                                                                }
                                                                                            }
                                                                                            break block104;
                                                                                        }
                                                                                        if (!this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Embedded.class)) break block114;
                                                                                        value = this.unmarshall(fld.getType(), (HashMap)valueFromDb);
                                                                                        break block104;
                                                                                    }
                                                                                    if (!this.hasCustomMapper(fld.getType())) break block115;
                                                                                    value = valueFromDb instanceof Map ? this.unmarshall(fld.getType(), (HashMap)valueFromDb) : this.customMapper.get(fld.getType()).unmarshall(valueFromDb);
                                                                                    break block104;
                                                                                }
                                                                                if (!Map.class.isAssignableFrom(fld.getType())) break block116;
                                                                                Map map = (Map)valueFromDb;
                                                                                HashMap toFill = new HashMap();
                                                                                if (map != null) {
                                                                                    this.fillMap((ParameterizedType)fld.getGenericType(), map, toFill, ret, false);
                                                                                }
                                                                                value = toFill;
                                                                                break block104;
                                                                            }
                                                                            if (!Collection.class.isAssignableFrom(fld.getType()) && !fld.getType().isArray()) break block117;
                                                                            lst = new ArrayList<Serializable>();
                                                                            if (!valueFromDb.getClass().isArray()) break block118;
                                                                            if (!valueFromDb.getClass().getComponentType().isPrimitive()) break block119;
                                                                            if (!valueFromDb.getClass().getComponentType().equals(Integer.TYPE)) break block120;
                                                                            for (Object i : (HashMap)((int[])valueFromDb)) {
                                                                                lst.add(Integer.valueOf((int)i));
                                                                            }
                                                                            break block121;
                                                                        }
                                                                        if (!valueFromDb.getClass().getComponentType().equals(Double.TYPE)) break block122;
                                                                        for (Object i : (HashMap)((double[])valueFromDb)) {
                                                                            lst.add(Double.valueOf((double)i));
                                                                        }
                                                                        break block121;
                                                                    }
                                                                    if (!valueFromDb.getClass().getComponentType().equals(Float.TYPE)) break block123;
                                                                    for (Object i : (HashMap)((float[])valueFromDb)) {
                                                                        lst.add(Float.valueOf((float)i));
                                                                    }
                                                                    break block121;
                                                                }
                                                                if (!valueFromDb.getClass().getComponentType().equals(Boolean.TYPE)) break block124;
                                                                for (Object i : (HashMap)((boolean[])valueFromDb)) {
                                                                    lst.add(Boolean.valueOf((boolean)i));
                                                                }
                                                                break block121;
                                                            }
                                                            if (!valueFromDb.getClass().getComponentType().equals(Byte.TYPE)) break block125;
                                                            for (Object i : (HashMap)((byte[])valueFromDb)) {
                                                                lst.add(Byte.valueOf((byte)i));
                                                            }
                                                            break block121;
                                                        }
                                                        if (valueFromDb.getClass().getComponentType().equals(Character.TYPE)) {
                                                            for (Object i : (HashMap)((char[])valueFromDb)) {
                                                                lst.add(Character.valueOf((char)i));
                                                            }
                                                            break block121;
                                                        } else if (valueFromDb.getClass().getComponentType().equals(Long.TYPE)) {
                                                            for (Object i : (HashMap)((long[])valueFromDb)) {
                                                                lst.add(Long.valueOf((long)i));
                                                            }
                                                        }
                                                        break block121;
                                                    }
                                                    Collections.addAll(lst, (Object[])valueFromDb);
                                                    break block121;
                                                }
                                                List l = (List)valueFromDb;
                                                if (l != null) {
                                                    ParameterizedType type = fld.getGenericType() instanceof ParameterizedType ? (ParameterizedType)fld.getGenericType() : new ParameterizedType(){

                                                        @Override
                                                        public Type getRawType() {
                                                            return Array.class;
                                                        }

                                                        @Override
                                                        public Type getOwnerType() {
                                                            return null;
                                                        }

                                                        @Override
                                                        public Type[] getActualTypeArguments() {
                                                            return new Type[]{fld.getType().getComponentType()};
                                                        }
                                                    };
                                                    this.fillList(fld, fld.getAnnotation(Reference.class), type, l, lst, ret);
                                                }
                                            }
                                            if (!fld.getType().isArray()) break block126;
                                            arr = Array.newInstance(fld.getType().getComponentType(), lst.size());
                                            break block127;
                                        }
                                        value = lst;
                                        break block104;
                                    }
                                    value = fld.getType().isEnum() ? Enum.valueOf(fld.getType(), (String)valueFromDb) : valueFromDb;
                                    break block104;
                                }
                                if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
                                    flds = this.annotationHelper.getFields(cls, Id.class);
                                    if (flds.isEmpty()) {
                                        throw new RuntimeException("Error - class does not have an ID field!");
                                    }
                                    Field field = this.annotationHelper.getField(cls, flds.get(0));
                                    if (o.get("_id") != null) {
                                        if (o.get("_id").getClass().equals(field.getType())) {
                                            field.set(ret, o.get("_id"));
                                        } else if (field.getType().equals(String.class) && o.get("_id").getClass().equals(MorphiumId.class)) {
                                            log.warn("ID type missmatch - field is string but got objectId from mongo - converting");
                                            field.set(ret, o.get("_id").toString());
                                        } else if (field.getType().equals(MorphiumId.class) && o.get("_id").getClass().equals(ObjectId.class)) {
                                            field.set(ret, new MorphiumId(((ObjectId)o.get("_id")).toByteArray()));
                                        } else if (field.getType().equals(MorphiumId.class) && o.get("_id").getClass().equals(String.class)) {
                                            field.set(ret, new MorphiumId((String)o.get("_id")));
                                        } else {
                                            log.error("ID type missmatch");
                                            throw new IllegalArgumentException("ID type missmatch. Field in '" + ret.getClass().toString() + "' is '" + field.getType().toString() + "' but we got '" + o.get("_id").getClass().toString() + "' from Mongo!");
                                        }
                                    }
                                }
                                if (this.annotationHelper.isAnnotationPresentInHierarchy(cls, PartialUpdate.class) || cls.isInstance(PartiallyUpdateable.class)) {
                                    return this.morphium.createPartiallyUpdateableEntity(ret);
                                }
                                if (ret instanceof BinarySerializedObject) {
                                    BinarySerializedObject bso = (BinarySerializedObject)ret;
                                    BASE64Decoder dec = new BASE64Decoder();
                                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decodeBuffer(bso.getB64Data())));
                                    return (T)in.readObject();
                                }
                                return (T)ret;
                            }
                            while (iterator2.hasNext()) {
                                String k = iterator2.next();
                                if (flds.contains(k) || k.equals("_id")) continue;
                                if (o.get(k) instanceof Map) {
                                    if (((Map)o.get(k)).get("class_name") != null) {
                                        data.put(k, this.unmarshall(Class.forName((String)((Map)o.get(k)).get("class_name")), (Map)o.get(k)));
                                        continue;
                                    }
                                    data.put(k, this.createMap((Map)o.get(k)));
                                    continue;
                                }
                                if (o.get(k) instanceof List && !((List)o.get(k)).isEmpty() && ((List)o.get(k)).get(0) instanceof Map) {
                                    data.put(k, this.createList((List)o.get(k)));
                                    continue;
                                }
                                data.put(k, o.get(k));
                            }
                            fld.set(ret, data);
                            continue;
                        }
                        while (iterator.hasNext()) {
                            Object id;
                            Map.Entry e4 = iterator.next();
                            if (!(e4.getValue() instanceof Map)) {
                                id = e4.getValue();
                                r = null;
                            } else {
                                Map ref = (Map)e4.getValue();
                                r = this.unmarshall(MorphiumReference.class, ref);
                                id = r.getId();
                            }
                            String collectionName = null;
                            Class<?> type = fld.getType();
                            if (r != null) {
                                collectionName = r.getCollectionName() != null ? r.getCollectionName() : this.getCollectionName(Class.forName(r.getClassName()));
                                type = Class.forName(r.getClassName());
                            } else if (this.annotationHelper.isAnnotationPresentInHierarchy(fld.getType(), Entity.class)) {
                                collectionName = this.getCollectionName(fld.getType());
                            }
                            if (collectionName == null) {
                                throw new IllegalArgumentException("Could not create reference!");
                            }
                            if (reference.lazyLoading()) {
                                List<String> lst3 = this.annotationHelper.getFields(fld.getType(), Id.class);
                                if (lst3.isEmpty()) {
                                    throw new IllegalArgumentException("Referenced object does not have an ID? Is it an Entity?");
                                }
                                if (id instanceof String && this.annotationHelper.getField(fld.getType(), lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(id.toString());
                                } else if (id instanceof ObjectId && this.annotationHelper.getField(fld.getType(), lst3.get(0)).getType().equals(MorphiumId.class)) {
                                    id = new MorphiumId(((ObjectId)id).toByteArray());
                                }
                                value = this.morphium.createLazyLoadedEntity(fld.getType(), id, ret, f, collectionName);
                            } else {
                                try {
                                    this.morphium.fireWouldDereference(ret, f, id, type, false);
                                    value = this.morphium.findById(type, id, collectionName);
                                    this.morphium.fireDidDereference(ret, f, value, false);
                                }
                                catch (MorphiumAccessVetoException ex) {
                                    log.info("not dereferencing due to veto from listener", ex);
                                }
                            }
                            v.put(e4.getKey(), value);
                        }
                        value = v;
                        break block104;
                    }
                    for (int i = 0; i < lst.size(); ++i) {
                        if (fld.getType().getComponentType().isPrimitive()) {
                            if (fld.getType().getComponentType().equals(Integer.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).intValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, (Integer)lst.get(i));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).intValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Long.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, ((Double)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).longValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, (Long)lst.get(i));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Float.TYPE)) {
                                if (lst.get(i) instanceof Double) {
                                    Array.set(arr, i, Float.valueOf(((Double)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, Float.valueOf(((Integer)lst.get(i)).floatValue()));
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, Float.valueOf(((Long)lst.get(i)).floatValue()));
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Double.TYPE)) {
                                if (lst.get(i) instanceof Float) {
                                    Array.set(arr, i, ((Float)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).doubleValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).doubleValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (fld.getType().getComponentType().equals(Byte.TYPE)) {
                                if (lst.get(i) instanceof Integer) {
                                    Array.set(arr, i, ((Integer)lst.get(i)).byteValue());
                                    continue;
                                }
                                if (lst.get(i) instanceof Long) {
                                    Array.set(arr, i, ((Long)lst.get(i)).byteValue());
                                    continue;
                                }
                                Array.set(arr, i, lst.get(i));
                                continue;
                            }
                            if (!fld.getType().getComponentType().equals(Boolean.TYPE)) continue;
                            if (lst.get(i) instanceof String) {
                                Array.set(arr, i, lst.get(i).toString().equalsIgnoreCase("true"));
                                continue;
                            }
                            if (lst.get(i) instanceof Integer) {
                                Array.set(arr, i, (Integer)lst.get(i) == 1);
                                continue;
                            }
                            Array.set(arr, i, lst.get(i));
                            continue;
                        }
                        Array.set(arr, i, lst.get(i));
                    }
                    value = arr;
                }
                this.annotationHelper.setValue(ret, value, f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map createMap(Map<String, Object> dbObject) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(dbObject);
        if (dbObject != null) {
            for (String n : dbObject.keySet()) {
                retMap.put(n, this.unmarshallInternal(dbObject.get(n)));
            }
        } else {
            retMap = null;
        }
        return retMap;
    }

    private Object unmarshallInternal(Object val) {
        block13: {
            if (val instanceof Map) {
                Map mapVal = (Map)val;
                if (mapVal.containsKey("class_name") || mapVal.containsKey("className")) {
                    String cn = (String)mapVal.get("class_name");
                    if (cn == null) {
                        cn = (String)mapVal.get("className");
                    }
                    try {
                        Class<?> ecls = Class.forName(cn);
                        Object obj = this.unmarshall(ecls, mapVal);
                        if (obj != null) {
                            return obj;
                        }
                        break block13;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (mapVal.containsKey("_b64data") || mapVal.containsKey("b64Data")) {
                    String d = (String)mapVal.get("_b64data");
                    if (d == null) {
                        d = (String)mapVal.get("b64Data");
                    }
                    BASE64Decoder dec = new BASE64Decoder();
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(dec.decodeBuffer(d)));
                        return in.readObject();
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.createMap(mapVal);
            }
            if (val instanceof ObjectId) {
                val = new MorphiumId(((ObjectId)val).toByteArray());
            } else if (val instanceof List) {
                List lst = (List)val;
                return this.createList(lst);
            }
        }
        return val;
    }

    private List createList(List<Map<String, Object>> lst) {
        return lst.stream().map(this::unmarshallInternal).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void fillList(Field forField, Reference ref, ParameterizedType listType, List<Map<String, Object>> fromDB, List toFillIn, Object containerEntity) {
        if (ref != null) {
            Iterator<Map<String, Object>> iterator = fromDB.iterator();
            while (iterator.hasNext()) {
                Class<?> type;
                Map<String, Object> obj = iterator.next();
                if (obj == null) {
                    toFillIn.add(null);
                    continue;
                }
                MorphiumReference r = this.unmarshall(MorphiumReference.class, obj);
                try {
                    type = Class.forName(r.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                if (r.getCollectionName() == null) {
                    r.setCollectionName(this.getCollectionName(type));
                }
                if (ref.lazyLoading()) {
                    if (r.getId() instanceof String && this.morphium.getARHelper().getIdField(type).getType().equals(MorphiumId.class)) {
                        r.setId(new MorphiumId(r.getId().toString()));
                    }
                    toFillIn.add(this.morphium.createLazyLoadedEntity(type, r.getId(), containerEntity, forField.getName(), r.getCollectionName()));
                    continue;
                }
                toFillIn.add(this.morphium.findById(type, r.getId(), r.getCollectionName()));
            }
            return;
        }
        Iterator<Map<String, Object>> iterator = fromDB.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> val;
            block23: {
                Class cls;
                val = iterator.next();
                if (val instanceof Map) {
                    if (val.containsKey("class_name") || val.containsKey("className")) {
                        String cn = (String)val.get("class_name");
                        if (cn == null) {
                            cn = (String)val.get("className");
                        }
                        try {
                            Class<?> ecls = Class.forName(cn);
                            Object um = this.unmarshall(ecls, (HashMap)val);
                            if (um == null) continue;
                            toFillIn.add(um);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not find class", e);
                        }
                    }
                    if (listType != null) {
                        cls = this.getElementClass(listType);
                        if (Map.class.isAssignableFrom(cls)) {
                            HashMap mp = new HashMap();
                            this.fillMap((ParameterizedType)listType.getActualTypeArguments()[0], val, mp, containerEntity, false);
                            toFillIn.add(mp);
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
                        if (entity != null || embedded != null || this.hasCustomMapper(cls)) {
                            toFillIn.add(this.unmarshall(cls, val));
                            continue;
                        }
                        break block23;
                    } else {
                        HashMap mp = new HashMap();
                        if (listType != null) {
                            this.fillMap((ParameterizedType)listType.getActualTypeArguments()[0], val, mp, containerEntity, false);
                            toFillIn.add(mp);
                            continue;
                        }
                        log.warn("Cannot de-reference to unknown collection type - trying object instead");
                        toFillIn.add(val);
                        continue;
                    }
                }
                if (val instanceof MorphiumId) {
                    if (listType != null) {
                        cls = listType.getActualTypeArguments()[0] instanceof ParameterizedType ? (Class)((ParameterizedType)listType.getActualTypeArguments()[0]).getRawType() : (Class)listType.getActualTypeArguments()[0];
                        Query q = this.morphium.createQueryFor(cls);
                        q = q.f(this.annotationHelper.getFields(cls, Id.class).get(0)).eq(val);
                        toFillIn.add(q.get());
                        continue;
                    }
                    log.warn("Cannot de-reference to unknown collection - trying to add Object only");
                    toFillIn.add(val);
                    continue;
                }
                if (val instanceof List) {
                    ArrayList lt = new ArrayList();
                    if (listType != null) {
                        this.fillList(forField, ref, (ParameterizedType)listType.getActualTypeArguments()[0], (List)((Object)val), lt, containerEntity);
                        toFillIn.add(lt);
                        continue;
                    }
                    log.warn("Cannot de-reference to unknown collection - trying to add Object only");
                    toFillIn.add(val);
                    continue;
                }
            }
            toFillIn.add(this.unmarshallInternal(val));
        }
    }

    private Class getElementClass(ParameterizedType parameterizedType) {
        Type[] parameters = parameterizedType.getActualTypeArguments();
        Type relevantParameter = parameters[parameters.length - 1];
        if (relevantParameter instanceof Class) {
            return (Class)relevantParameter;
        }
        if (relevantParameter instanceof ParameterizedType) {
            ParameterizedType parameterType = (ParameterizedType)relevantParameter;
            if (parameterType.getRawType() instanceof Class) {
                return (Class)parameterType.getRawType();
            }
            try {
                return Class.forName(parameterType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                log.error("Could not determin class for type " + parameterType.getRawType().getTypeName());
                return Object.class;
            }
        }
        if (relevantParameter instanceof WildcardType) {
            return ((WildcardType)relevantParameter).getClass();
        }
        log.error("Could not determin type of element!");
        return Object.class;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillMap(ParameterizedType mapType, Map<String, Object> fromDB, Map toFillIn, Object containerEntity, boolean dereference) {
        Iterator<Map.Entry<String, Object>> iterator = fromDB.entrySet().iterator();
        while (true) {
            Object val;
            String key;
            block11: {
                Class cls;
                if (!iterator.hasNext()) {
                    return;
                }
                Map.Entry<String, Object> entry = iterator.next();
                key = entry.getKey();
                val = entry.getValue();
                if (val instanceof Map) {
                    if (mapType != null) {
                        cls = this.getElementClass(mapType);
                        if (Map.class.isAssignableFrom(cls)) {
                            HashMap mp = new HashMap();
                            this.fillMap((ParameterizedType)mapType.getActualTypeArguments()[1], (Map)val, mp, containerEntity, dereference);
                            toFillIn.put(key, mp);
                            continue;
                        }
                        Entity entity = this.annotationHelper.getAnnotationFromHierarchy(cls, Entity.class);
                        Embedded embedded = this.annotationHelper.getAnnotationFromHierarchy(cls, Embedded.class);
                        if (entity != null || embedded != null || this.hasCustomMapper(cls)) {
                            toFillIn.put(key, this.unmarshall(cls, (Map)val));
                            continue;
                        }
                        break block11;
                    } else {
                        HashMap mp = new HashMap();
                        this.fillMap((ParameterizedType)mapType.getActualTypeArguments()[1], (Map)val, mp, containerEntity, dereference);
                        toFillIn.put(key, mp);
                        continue;
                    }
                }
                if (val instanceof MorphiumId && !dereference) {
                    toFillIn.put(key, val);
                    continue;
                }
                if (val instanceof MorphiumId && dereference) {
                    if (mapType != null) {
                        cls = mapType.getActualTypeArguments()[1] instanceof ParameterizedType ? (Class)((ParameterizedType)mapType.getActualTypeArguments()[1]).getRawType() : (Class)mapType.getActualTypeArguments()[1];
                        Query q = this.morphium.createQueryFor(cls);
                        q = q.f(this.annotationHelper.getFields(cls, Id.class).get(0)).eq(val);
                        toFillIn.put(key, q.get());
                        continue;
                    }
                    log.warn("Cannot de-reference to unknown collection - trying to add Object only");
                    toFillIn.put(key, val);
                    continue;
                }
                if (val instanceof List) {
                    ArrayList lt = new ArrayList();
                    this.fillList(null, null, (ParameterizedType)mapType.getActualTypeArguments()[1], (List)val, lt, containerEntity);
                    toFillIn.put(key, lt);
                    continue;
                }
            }
            toFillIn.put(key, this.unmarshallInternal(val));
        }
    }
}

